/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.util.LinkedList;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsProjectionModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQuerySelectionResultModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQuerySelectionResultSublistSpec;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQuerySelectionResultColumnSpec
extends SQLQuerySelectionResultSublistSpec {
    @NotNull
    private final SQLQueryValueExpression valueExpression;
    @Nullable
    private final SQLQuerySymbolEntry alias;

    public SQLQuerySelectionResultColumnSpec(@NotNull SQLQuerySelectionResultModel resultModel, @NotNull STMTreeNode syntaxNode, @NotNull SQLQueryValueExpression valueExpression) {
        this(resultModel, syntaxNode, valueExpression, null);
    }

    public SQLQuerySelectionResultColumnSpec(@NotNull SQLQuerySelectionResultModel resultModel, @NotNull STMTreeNode syntaxNode, @NotNull SQLQueryValueExpression valueExpression, @Nullable SQLQuerySymbolEntry alias) {
        super(resultModel, syntaxNode);
        this.valueExpression = valueExpression;
        this.alias = alias;
        this.registerSubnode(valueExpression);
    }

    @NotNull
    public SQLQueryValueExpression getValueExpression() {
        return this.valueExpression;
    }

    @Nullable
    public SQLQuerySymbolEntry getAlias() {
        return this.alias;
    }

    @Override
    @NotNull
    protected void collectColumns(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRowsProjectionModel rowsSourceModel, @NotNull SQLQueryRecognitionContext statistics, @NotNull LinkedList<SQLQueryResultColumn> resultColumns) {
        SQLQueryResultColumn underlyingColumn;
        SQLQuerySymbol columnName;
        this.valueExpression.propagateContext(context, statistics);
        if (this.alias != null) {
            if (!this.alias.isNotClassified()) {
                return;
            }
            columnName = this.alias.getSymbol();
            columnName.setDefinition(this.alias);
            columnName.setSymbolClass(SQLQuerySymbolClass.COLUMN_DERIVED);
            underlyingColumn = null;
        } else {
            columnName = this.valueExpression.getColumnNameIfTrivialExpression();
            underlyingColumn = this.valueExpression.getColumnIfTrivialExpression();
            if (columnName == null) {
                columnName = new SQLQuerySymbol("?");
            }
        }
        SQLQueryExprType type = this.valueExpression.getValueType();
        resultColumns.add(underlyingColumn == null ? new SQLQueryResultColumn(resultColumns.size(), columnName, rowsSourceModel, null, null, type) : new SQLQueryResultColumn(resultColumns.size(), columnName, rowsSourceModel, underlyingColumn.realSource, underlyingColumn.realAttr, type));
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T node) {
        return visitor.visitSelectColumnSpec(this, node);
    }
}

