/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSavepoint;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.DataSourceContextProvider;
import org.jkiss.dbeaver.model.meta.DBSerializable;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.data.SQLQueryDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTaskUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNodePrimary;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseProducerSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.serialize.DTObjectSerializer;
import org.jkiss.dbeaver.tools.transfer.serialize.SerializerContext;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

@DBSerializable(value="databaseTransferProducer")
public class DatabaseTransferProducer
implements IDataTransferProducer<DatabaseProducerSettings>,
IDataTransferNodePrimary {
    private static final Log log = Log.getLog(DatabaseTransferProducer.class);
    private final DBCStatistics producerStatistics = new DBCStatistics();
    private DBPDataSourceContainer dataSourceContainer;
    private DBSDataContainer dataContainer;
    private String objectId;
    @Nullable
    private DBDDataFilter dataFilter;
    @Nullable
    private String defaultCatalog;
    @Nullable
    private String defaultSchema;

    public DatabaseTransferProducer() {
    }

    public DatabaseTransferProducer(@NotNull DBSDataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    public DatabaseTransferProducer(@NotNull DBSDataContainer dataContainer, @Nullable DBDDataFilter dataFilter) {
        this.dataContainer = dataContainer;
        this.dataFilter = dataFilter;
    }

    public void setDataContainer(@NotNull DBSDataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    public DBSDataContainer getDatabaseObject() {
        return this.dataContainer;
    }

    @Override
    @Nullable
    public DBPProject getProject() {
        return this.dataContainer == null ? null : DBUtils.getObjectOwnerProject((DBSObject)this.dataContainer);
    }

    @Override
    public String getObjectName() {
        SQLQueryContainer queryContainer = (SQLQueryContainer)GeneralUtils.adapt((Object)this.dataContainer, SQLQueryContainer.class);
        if (queryContainer != null) {
            return CommonUtils.getSingleLineString((String)queryContainer.getQuery().toString());
        }
        return this.dataContainer == null ? this.objectId : DBUtils.getObjectFullName((DBPNamedObject)this.dataContainer, (DBPEvaluationContext)DBPEvaluationContext.DML);
    }

    @Override
    public DBPImage getObjectIcon() {
        if (this.dataContainer instanceof DBPImageProvider) {
            return DBValueFormatting.getObjectImage((DBPObject)this.dataContainer);
        }
        return DBIcon.TREE_TABLE;
    }

    @Override
    public String getObjectContainerName() {
        DBPDataSourceContainer container = this.getDataSourceContainer();
        return container != null ? container.getName() : this.objectId;
    }

    @Override
    public DBPImage getObjectContainerIcon() {
        DBPDataSourceContainer container = this.getDataSourceContainer();
        return container != null ? container.getDriver().getIcon() : null;
    }

    @Override
    public boolean isConfigurationComplete() {
        return this.dataContainer != null;
    }

    @Override
    public DBPDataSourceContainer getDataSourceContainer() {
        if (this.dataContainer != null) {
            return this.dataContainer.getDataSource().getContainer();
        }
        return this.dataSourceContainer;
    }

    @Nullable
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(@Nullable String defaultCatalog) {
        this.defaultCatalog = defaultCatalog;
    }

    @Nullable
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(@Nullable String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    @Override
    public void transferData(@NotNull DBRProgressMonitor monitor1, @NotNull IDataTransferConsumer consumer, @Nullable IDataTransferProcessor processor, @NotNull DatabaseProducerSettings settings, @Nullable DBTTask task) throws DBException {
        String contextTask = DTMessages.data_transfer_wizard_job_task_export;
        DBSDataContainer databaseObject = this.getDatabaseObject();
        if (databaseObject == null) {
            throw new DBException("No input database object found");
        }
        DBPDataSource dataSource = databaseObject.getDataSource();
        assert (dataSource != null);
        DBExecUtils.tryExecuteRecover((Object)monitor1, (DBPDataSource)dataSource, monitor -> {
            long readFlags = 0L;
            if (settings.isSelectedColumnsOnly()) {
                readFlags |= 8L;
            }
            if (settings.isSelectedRowsOnly()) {
                readFlags |= 4L;
            }
            boolean newConnection = settings.isOpenNewConnections() && !this.getDatabaseObject().getDataSource().getContainer().getDriver().isEmbedded();
            boolean forceDataReadTransactions = Boolean.TRUE.equals(dataSource.getDataSourceFeature("datasource.lob-require-transactions"));
            boolean selectiveExportFromUI = settings.isSelectedColumnsOnly() || settings.isSelectedRowsOnly();
            try {
                DBCExecutionContext context = this.dataContainer instanceof DBPContextProvider ? ((DBPContextProvider)this.dataContainer).getExecutionContext() : DBUtils.getDefaultContext((DBSObject)this.dataContainer, (boolean)false);
                if (context == null) {
                    throw new DBCException("Can't retrieve execution context from data container " + String.valueOf(this.dataContainer));
                }
                if (!selectiveExportFromUI && newConnection) {
                    context = DBUtils.getObjectOwnerInstance((DBSObject)this.getDatabaseObject()).openIsolatedContext(monitor, "Data transfer producer", context);
                    DBExecUtils.setExecutionContextDefaults((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (DBCExecutionContext)context, (String)this.defaultCatalog, null, (String)this.defaultSchema);
                }
                if (task != null) {
                    DBTaskUtils.initFromContext((DBRProgressMonitor)monitor, (DBTTask)task, (DBCExecutionContext)context);
                }
                Throwable throwable = null;
                Object var14_15 = null;
                try (DBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, contextTask);){
                    DBCTransactionManager txnManager;
                    DBCSavepoint savepoint;
                    Boolean oldAutoCommit;
                    block49: {
                        oldAutoCommit = null;
                        savepoint = null;
                        try {
                            long totalRows;
                            AbstractExecutionSource transferSource;
                            block48: {
                                transferSource = new AbstractExecutionSource(this.dataContainer, context, (Object)consumer);
                                session.enableLogging(false);
                                if (!selectiveExportFromUI && (newConnection || forceDataReadTransactions)) {
                                    try {
                                        DBCTransactionManager txnManager2 = DBUtils.getTransactionManager((DBCExecutionContext)context);
                                        if (txnManager2 != null && txnManager2.isSupportsTransactions()) {
                                            oldAutoCommit = txnManager2.isAutoCommit();
                                            txnManager2.setAutoCommit(monitor, false);
                                            if (txnManager2.supportsSavepoints()) {
                                                savepoint = txnManager2.setSavepoint(monitor, "Data transfer start");
                                            }
                                        }
                                    }
                                    catch (DBCException e) {
                                        log.warn((Object)"Can't change auto-commit", (Throwable)e);
                                    }
                                }
                                totalRows = 0L;
                                if (settings.isQueryRowCount() && this.dataContainer.isFeatureSupported("data.count")) {
                                    monitor.beginTask(DTMessages.data_transfer_wizard_job_task_retrieve, 1);
                                    try {
                                        try {
                                            totalRows = this.dataContainer.countData((DBCExecutionSource)transferSource, session, this.dataFilter, readFlags);
                                        }
                                        catch (Throwable e) {
                                            log.warn((Object)("Can't retrieve row count from '" + this.dataContainer.getName() + "'"), e);
                                            try {
                                                DBCTransactionManager txnManager3 = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
                                                if (txnManager3 != null && !txnManager3.isAutoCommit()) {
                                                    txnManager3.rollback(session, savepoint);
                                                }
                                            }
                                            catch (Throwable e1) {
                                                log.warn((Object)"Error rolling back transaction", e1);
                                            }
                                            monitor.done();
                                            break block48;
                                        }
                                    }
                                    catch (Throwable throwable2) {
                                        monitor.done();
                                        throw throwable2;
                                    }
                                    monitor.done();
                                }
                            }
                            monitor.beginTask(DTMessages.data_transfer_wizard_job_task_export_table_data, (int)totalRows);
                            try {
                                DBCStatistics statistics;
                                monitor.subTask("Read data");
                                if (settings.getExtractType() == DatabaseProducerSettings.ExtractType.SINGLE_QUERY) {
                                    this.producerStatistics.accumulate(this.dataContainer.readData((DBCExecutionSource)transferSource, session, (DBDDataReceiver)consumer, this.dataFilter, -1L, -1L, readFlags, settings.getFetchSize()));
                                    break block49;
                                }
                                long offset = 0L;
                                int segmentSize = settings.getSegmentSize();
                                while ((statistics = this.dataContainer.readData((DBCExecutionSource)transferSource, session, (DBDDataReceiver)consumer, this.dataFilter, offset, (long)segmentSize, readFlags, settings.getFetchSize())) != null) {
                                    if (statistics.getRowsFetched() < (long)segmentSize) {
                                        break;
                                    }
                                    this.producerStatistics.accumulate(statistics);
                                    offset += statistics.getRowsFetched();
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }
                        catch (Throwable throwable3) {
                            DBCTransactionManager txnManager4;
                            if (!selectiveExportFromUI && (newConnection || forceDataReadTransactions) && (txnManager4 = DBUtils.getTransactionManager((DBCExecutionContext)context)) != null && txnManager4.isSupportsTransactions()) {
                                if (!txnManager4.isAutoCommit()) {
                                    txnManager4.rollback(session, savepoint);
                                }
                                if (savepoint != null) {
                                    txnManager4.releaseSavepoint(monitor, savepoint);
                                }
                                if (oldAutoCommit != null) {
                                    txnManager4.setAutoCommit(monitor, oldAutoCommit.booleanValue());
                                }
                            }
                            if (!selectiveExportFromUI && newConnection) {
                                context.close();
                            }
                            throw throwable3;
                        }
                    }
                    if (!selectiveExportFromUI && (newConnection || forceDataReadTransactions) && (txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context)) != null && txnManager.isSupportsTransactions()) {
                        if (!txnManager.isAutoCommit()) {
                            txnManager.rollback(session, savepoint);
                        }
                        if (savepoint != null) {
                            txnManager.releaseSavepoint(monitor, savepoint);
                        }
                        if (oldAutoCommit != null) {
                            txnManager.setAutoCommit(monitor, oldAutoCommit.booleanValue());
                        }
                    }
                    if (!selectiveExportFromUI && newConnection) {
                        context.close();
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (DBException e) {
                throw new InvocationTargetException(e);
            }
        });
    }

    public boolean equals(Object obj) {
        return obj instanceof DatabaseTransferProducer && CommonUtils.equalObjects((Object)this.dataContainer, (Object)((DatabaseTransferProducer)obj).dataContainer) && CommonUtils.equalObjects((Object)this.dataFilter, (Object)((DatabaseTransferProducer)obj).dataFilter);
    }

    @Override
    @NotNull
    public DBCStatistics getStatistics() {
        return this.producerStatistics;
    }

    public static class ObjectSerializer
    implements DTObjectSerializer<DBTTask, DatabaseTransferProducer> {
        @Override
        public void serializeObject(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask context, @NotNull DatabaseTransferProducer object, @NotNull Map<String, Object> state) {
            DBSDataContainer nestedDataContainer;
            DBSDataContainer dataContainer = object.dataContainer;
            if (dataContainer instanceof IAdaptable && (nestedDataContainer = (DBSDataContainer)((IAdaptable)dataContainer).getAdapter(DBSDataContainer.class)) != null) {
                dataContainer = nestedDataContainer;
            }
            if (dataContainer instanceof DBSEntity) {
                state.put("type", "entity");
                if (dataContainer.getDataSource() != null) {
                    state.put("project", dataContainer.getDataSource().getContainer().getProject().getName());
                }
                state.put("entityId", DBUtils.getObjectFullId((DBSObject)dataContainer));
            } else if (dataContainer instanceof SQLQueryContainer) {
                state.put("type", "query");
                SQLQueryContainer queryContainer = (SQLQueryContainer)dataContainer;
                DBPDataSourceContainer dataSource = queryContainer.getDataSourceContainer();
                if (dataSource != null) {
                    state.put("project", dataSource.getProject().getName());
                    state.put("dataSource", dataSource.getId());
                    if (object.defaultCatalog != null) {
                        state.put("defaultCatalog", object.defaultCatalog);
                    }
                    if (object.defaultSchema != null) {
                        state.put("defaultSchema", object.defaultSchema);
                    }
                }
                SQLScriptElement query = queryContainer.getQuery();
                state.put("query", query.getOriginalText());
            } else {
                state.put("type", "unknown");
                log.error((Object)("Unsupported producer data container: " + String.valueOf(dataContainer)));
            }
            if (object.dataFilter != null) {
                LinkedHashMap dataFilterState = new LinkedHashMap();
                object.dataFilter.serialize(dataFilterState);
                state.put("dataFilter", dataFilterState);
            }
        }

        @Override
        public DatabaseTransferProducer deserializeObject(@NotNull DBRRunnableContext runnableContext, @NotNull SerializerContext serializeContext, @NotNull DBTTask objectContext, @NotNull Map<String, Object> state) throws DBException {
            DatabaseTransferProducer producer = new DatabaseTransferProducer();
            try {
                runnableContext.run(true, true, monitor -> {
                    try {
                        DBPProject project;
                        String selType = CommonUtils.toString(state.get("type"));
                        String projectName = CommonUtils.toString(state.get("project"));
                        DBPProject dBPProject = project = CommonUtils.isEmpty((String)projectName) ? null : DBWorkbench.getPlatform().getWorkspace().getProject(projectName);
                        if (project == null) {
                            project = objectContext.getProject();
                        }
                        switch (selType) {
                            case "entity": {
                                String id = CommonUtils.toString(state.get("entityId"));
                                String[] pathItems = id.split("/");
                                databaseTransferProducer.objectId = pathItems.length > 2 ? String.join((CharSequence)"/", List.of(pathItems).subList(2, pathItems.length)) : id;
                                databaseTransferProducer.dataSourceContainer = DBUtils.findDataSourceByObjectId((DBPProject)project, (String)id);
                                if (databaseTransferProducer.dataSourceContainer != null && !serializeContext.isDataSourceFailed(databaseTransferProducer.dataSourceContainer)) {
                                    try {
                                        databaseTransferProducer.dataContainer = (DBSDataContainer)DBUtils.findObjectById((DBRProgressMonitor)monitor, (DBPProject)project, (String)id);
                                    }
                                    catch (DBException e) {
                                        serializeContext.addError(e);
                                        serializeContext.addDataSourceFail(databaseTransferProducer.dataSourceContainer);
                                    }
                                }
                                break;
                            }
                            case "query": {
                                String dsId = CommonUtils.toString(state.get("dataSource"));
                                String queryText = CommonUtils.toString(state.get("query"));
                                DBPDataSourceContainer ds = project.getDataSourceRegistry().getDataSource(dsId);
                                if (ds == null) {
                                    throw new DBCException("Can't find datasource " + dsId);
                                }
                                if (!ds.isConnected()) {
                                    ds.connect(monitor, true, true);
                                }
                                DBPDataSource dataSource = ds.getDataSource();
                                SQLQuery query = new SQLQuery(dataSource, queryText);
                                DataSourceContextProvider taskContextProvider = new DataSourceContextProvider((DBSObject)dataSource);
                                SQLScriptContext scriptContext = new SQLScriptContext(null, (DBPContextProvider)taskContextProvider, null, (Writer)new PrintWriter(System.err, true), null);
                                scriptContext.setVariables(DBTaskUtils.getVariables((DBTTask)objectContext));
                                databaseTransferProducer.defaultCatalog = CommonUtils.toString(state.get("defaultCatalog"), null);
                                databaseTransferProducer.defaultSchema = CommonUtils.toString(state.get("defaultSchema"), null);
                                databaseTransferProducer.dataContainer = new SQLQueryDataContainer((DBPContextProvider)taskContextProvider, query, scriptContext, log);
                                break;
                            }
                            default: {
                                serializeContext.addError(new DBException("Unsupported selector type: " + selType));
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                throw new DBCException("Error instantiating data producer", e.getTargetException());
            }
            catch (InterruptedException e) {
                throw new DBCException("Deserialization canceled", (Throwable)e);
            }
            return producer;
        }
    }
}

