#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 dhall
version:              1.41.2
visibility:           public
id:                   dhall-1.41.2-FF1MAIfSxjSLs7q9DrLpFq
key:                  dhall-1.41.2-FF1MAIfSxjSLs7q9DrLpFq
license:              BSD-3-Clause
copyright:            2017 Gabriel Gonzalez
maintainer:           Gabriel439@gmail.com
author:               Gabriel Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  34ad9029097ad85c057f799137e2a4dc
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics Dhall.Parser
    Dhall.Parser.Expression Dhall.Parser.Token Dhall.Pretty Dhall.Repl
    Dhall.Schemas Dhall.Set Dhall.Src Dhall.Substitution Dhall.TH
    Dhall.Tags Dhall.Tutorial Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.Eval Dhall.Import.Types Dhall.Import.Headers
    Dhall.Marshal.Internal Dhall.Normalize Dhall.Parser.Combinators
    Dhall.Pretty.Internal Dhall.Syntax Dhall.URL Paths_dhall
    Dhall.Import.HTTP Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.2.8/site-local/dhall-1.41.2
library-dirs:         /usr/lib/ghc-9.2.8/site-local/dhall-1.41.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.41.2-FF1MAIfSxjSLs7q9DrLpFq
depends:
    Diff-0.4.1-B9thiVs2y2uAiqx3tkly0v
    aeson-2.1.2.1-3hy4hA3togDsVnwRqQAZI
    aeson-pretty-0.8.10-EHbhnR4q86z8KHGoK5kE27
    ansi-terminal-0.11.4-EPVjDSBhsFM2RMZf92XUfK
    atomic-write-0.2.0.7-3GMghaY0tclCGRC8JkIsOu base-4.16.4.0
    base16-bytestring-1.0.2.0-2zrcaj2dASWLOg7ed8DTQL
    bytestring-0.11.4.0 case-insensitive-1.2.1.0-GWeOjNQL6o11YPoz7mZGER
    cborg-0.2.9.0-LYoFFSkVrWn8qiOwGMP9r3
    cborg-json-0.2.5.0-ETRi5v29PTBDuB2sujbNRz containers-0.6.5.1
    contravariant-1.5.5-6oWUjmJNxDBFhugVD5s9dq
    cryptohash-sha256-0.11.102.1-371Jt5DwAMz5e6UHJQG3Qm
    data-fix-0.3.2-JeLT2b5tMLZJ0S1cVDwyn1 deepseq-1.4.6.1
    directory-1.3.6.2 dotgen-0.4.3-GrGnAzxXk0NF0mUN2K7zar
    either-5.0.2-Kad6WPd2dto1urkQ7yKKVk exceptions-0.10.4
    filepath-1.4.2.2 half-0.3.1-3d34mZqOasEDojiioSdIMj
    hashable-1.4.3.0-4gqtyFKn8Wu9OwsZtyYGdt haskeline-0.8.2
    http-client-0.7.15-1GC6b5Bmyn71sLeqrm25Gs
    http-client-tls-0.3.6.3-Cu35gZGVC8nBMMXS4AX6Fr
    http-types-0.12.4-BQQx2t2WRPFKonJRzK2pM8
    indexed-traversable-0.1.3-cDxCqXMKkpJLEkpY6C7Mq
    lens-family-core-2.1.3-1OBIJmYHsnQ2CJGGRserxu
    megaparsec-9.5.0-7z3AThgMzs3rnIZVIvVtE
    mmorph-1.2.0-86rQZSuTSAZIoeBosVXsFi mtl-2.2.2
    network-uri-2.6.4.2-BteEq2hoHgh9OCrkgJDHXL
    optparse-applicative-0.17.1.0-Jx8WaQbsFK9BJBRr9ePa2T
    parser-combinators-1.3.0-G0J7GFw9FY9Cgw8HeD2oK5
    parsers-0.12.11-9meE7NauUFTEfbHdqhNtA5
    pretty-simple-4.1.2.0-Kln7lmU7uGKHkV4FWTYrfF
    prettyprinter-1.7.1-1GpgcfSKvbVDLlexa0B7T5
    prettyprinter-ansi-terminal-1.1.3-Bk17MJ24jKO9mtEtdKdzwP
    profunctors-5.6.2-GpDaCOOY8ar8rCckMV8A0H
    repline-0.4.2.0-8F4hfQj1tzA4brx66W1hS8
    scientific-0.3.7.0-72r9rPpXaeUjwM4XNBSJR
    serialise-0.2.6.1-3vWvFC0t9PN51rPaBcgzGW template-haskell-2.18.0.0
    text-1.2.5.0 text-manipulate-0.3.1.0-HC5XwyjMNl5JbJDxytK6M
    text-short-0.1.5-8dLWJFFEGVP8HA4xSxInYR
    th-lift-instances-0.1.20-7md2lkWNOf8FA0lQCdfq6w time-1.11.1.1
    transformers-0.5.6.2
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
    uri-encode-1.5.0.7-7ReBNo0MSzP4cmsgh43EyC
    vector-0.13.1.0-FuSYSqJEiCU51oStZmHlCe

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

