define(["exports","./../layoutmanager.js","./../common/datetime.js","./../mediainfo/mediainfo.js","./../common/playback/playbackmanager.js","./../dom.js","./../emby-apiclient/connectionmanager.js","./../common/inputmanager.js","./../common/usersettings/usersettings.js","./../input/keyboard.js","./../emby-apiclient/events.js"],function(_exports,_layoutmanager,_datetime,_mediainfo,_playbackmanager,_dom,_connectionmanager,_inputmanager,_usersettings,_keyboard,_events){function updateDurationText(elem,enableProgressByTimeOfDay,durationTicks,displayItem,enableTimeRemaining){var html;null==durationTicks||isNaN(durationTicks)?elem.innerHTML="":(html=_datetime.default.getDisplayRunningTime(durationTicks),enableTimeRemaining&&(html="-"+html,enableProgressByTimeOfDay||"Video"!==(null==displayItem?void 0:displayItem.MediaType)||(html+='<span class="osd-endsat"><span class="osd-endsat-dot">/</span>'+_mediainfo.default.getEndsAtFromPosition(durationTicks,0,!1).toLowerCase()+"</span>")),elem.innerHTML=html)}function getDisplayTimeWithoutAmPm(date,showSeconds){return function(date,showSeconds){return(showSeconds?_datetime.default.toLocaleTimeString(date,{hour:"numeric",minute:"2-digit",second:"2-digit"}):_datetime.default.getDisplayTime(date)).toLowerCase()}(date,showSeconds).replace("am","").replace("pm","").trim()}function setDisplayTime(elem,ms){var html;ms&&(html=getDisplayTimeWithoutAmPm(new Date(ms))),elem.innerHTML=html||""}function getDisplayPercentByTimeOfDay(startDateMs,programRuntimeMs,currentTimeMs){return(currentTimeMs-startDateMs)/programRuntimeMs*100}function getStep(runtimeTicks){runtimeTicks=(runtimeTicks=1e7*(_layoutmanager.default.tv?10:1)/runtimeTicks*100).toFixed(3);return runtimeTicks=Math.max(.01,runtimeTicks),runtimeTicks=Math.min(1,runtimeTicks)}function updateTimeText(instance,elem,ticks){if(null==ticks)elem.innerHTML="";else if(isNaN(ticks))elem.innerHTML="";else{var html=_datetime.default.getDisplayRunningTime(ticks),ticks=instance.repeatingPositionSliderKey,speed=instance.repeatingPositionSliderKeySpeed;switch(ticks){case"stepdown":html='<i class="md-icon md-icon-fill autortl button-icon-left" style="font-size:170%;">&#xe020;</i>'+html,1!==speed&&(html='<div class="button-icon-left">'+speed+"</div>"+html);break;case"stepup":html='<div style="min-width:3.5ch;">'+html+"</div>",html+='<i class="md-icon md-icon-fill autortl button-icon-right" style="font-size:170%;">&#xe01f;</i>',1!==speed&&(html+='<div class="button-icon-right">'+speed+"</div>")}elem.innerHTML=html}}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var DefaultSpeed=1;function setDefaultSpeed(instance){instance.repeatingPositionSliderKeySpeed=DefaultSpeed}function convertMsToNowPlayingSliderStep(instance,ms){var runtimeTicks=instance.nowPlayingSliderRunTimeTicks;return runtimeTicks?1e4*ms/runtimeTicks*100:(ms=instance.options.nowPlayingPositionSlider,parseFloat(ms.step))}function cancelPositionSliderEditing(instance){instance.options.nowPlayingPositionSlider.cancelEditing()}function onPositionSliderBeginEditing(e){console.log("onPositionSliderBeginEditing");this.ignoreStepKeyUp=!1,function(instance){instance.intervalForPositionSlider||(setDefaultSpeed(instance),instance.intervalForPositionSlider=setInterval(instance.bound_intervalForPositionSlider,100))}(this)}function onPositionSliderEndEditing(e){console.log("onPositionSliderEndEditing");this.repeatingPositionSliderKey=null,setDefaultSpeed(this),function(instance){instance.intervalForPositionSlider&&(clearInterval(instance.intervalForPositionSlider),instance.intervalForPositionSlider=null)}(this)}function changeSpeed(instance,slider,direction){var currentDirection;slider.dragging&&(currentDirection=instance.repeatingPositionSliderKey)&&(currentDirection=currentDirection===direction?1:-1,direction=instance.repeatingPositionSliderKeySpeed,(currentDirection=Math.max(0,Math.min(4,direction+currentDirection)))<=DefaultSpeed-1&&currentDirection!==direction?(instance.ignoreStepKeyUp=!0,slider.endEditing(!0,instance.nowPlayingSliderValue)):instance.repeatingPositionSliderKeySpeed=currentDirection)}function beginOrEndEditing(instance,slider,newValue,positionSliderKey){var sliderMin=slider.min,sliderMax=slider.max;newValue<=sliderMin?(instance.nowPlayingSliderValue=sliderMin,slider.endEditing(!0,sliderMin)):sliderMax<=newValue?(instance.nowPlayingSliderValue=sliderMax,slider.endEditing(!0,sliderMax)):(instance.repeatingPositionSliderKey!==positionSliderKey&&setDefaultSpeed(instance),instance.repeatingPositionSliderKey=positionSliderKey,slider.beginEditing(instance.nowPlayingSliderValue))}function OsdController(options){this.options=options,this.visualStartDateMs=0,this.visualEndDateMs=0,this.wallClockStartTimeMs=0,this.nowPlayingSliderValue=0;var nowPlayingPositionSlider=options.nowPlayingPositionSlider,nowPlayingPositionSlider=(_inputmanager.default.on(nowPlayingPositionSlider,function(e){var stepUpCommand,sliderMin,sliderMax,slider=e.target,stepDownCommand="rtl"===document.dir?(stepUpCommand="left","right"):(stepUpCommand="right","left");switch(e.detail.command){case stepDownCommand:case"rewind":e.preventDefault(),e.detail.repeat?(sliderMin=slider.min,sliderMax=slider.max,beginOrEndEditing(this,slider,Math.min(Math.max(this.nowPlayingSliderValue-convertMsToNowPlayingSliderStep(this,1e3),sliderMin),sliderMax),"stepdown")):changeSpeed(this,slider,"stepdown");break;case stepUpCommand:case"fastforward":e.preventDefault(),e.detail.repeat?(sliderMin=slider.min,sliderMax=slider.max,beginOrEndEditing(this,slider,Math.min(Math.max(this.nowPlayingSliderValue+convertMsToNowPlayingSliderStep(this,1e3),sliderMin),sliderMax),"stepup")):changeSpeed(this,slider,"stepup");break;case"pageup":e.preventDefault(),_playbackmanager.default.nextChapter(this.currentPlayer);break;case"pagedown":e.preventDefault(),_playbackmanager.default.previousChapter(this.currentPlayer);break;case"back":slider.dragging&&e.preventDefault(),cancelPositionSliderEditing(this);break;case"play":case"playpause":slider.dragging&&(e.preventDefault(),e.stopPropagation(),slider.endEditing(!0,this.nowPlayingSliderValue));break;case"select":slider.dragging?(e.preventDefault(),e.stopPropagation(),slider.endEditing(!0,this.nowPlayingSliderValue)):_playbackmanager.default.playPause(this.currentPlayer)}}.bind(this)),nowPlayingPositionSlider.addEventListener("keydown",function(e){var slider=e.target;switch(_keyboard.default.normalizeKeyFromEvent(e)){case" ":case"Enter":slider.dragging&&(e.preventDefault(),e.stopPropagation(),slider.endEditing(!0,this.nowPlayingSliderValue))}}.bind(this)),nowPlayingPositionSlider.addEventListener("keyup",function(e){var stepUpCommand,slider=e.target,e=_keyboard.default.normalizeKeyFromEvent(e),stepDownCommand="rtl"===document.dir?(stepUpCommand="ArrowLeft","ArrowRight"):(stepUpCommand="ArrowRight","ArrowLeft"),ignoreStepKeyUp=this.ignoreStepKeyUp,wasRepeating=(console.log("onPositionSliderKeyUp, repeatingPositionSliderKey: "+this.repeatingPositionSliderKey+", ignoreStepKeyUp: "+ignoreStepKeyUp),this.repeatingPositionSliderKey);switch(e){case"MediaRewind":case stepDownCommand:wasRepeating||ignoreStepKeyUp||(this.nowPlayingSliderValue=Math.min(Math.max(this.nowPlayingSliderValue-convertMsToNowPlayingSliderStep(this,_usersettings.default.skipBackLength()),slider.min),slider.max),slider.endEditing(!0,this.nowPlayingSliderValue)),this.ignoreStepKeyUp=!1;break;case"MediaFastForward":case stepUpCommand:wasRepeating||ignoreStepKeyUp||(this.nowPlayingSliderValue=Math.min(Math.max(this.nowPlayingSliderValue+convertMsToNowPlayingSliderStep(this,_usersettings.default.skipForwardLength()),slider.min),slider.max),slider.endEditing(!0,this.nowPlayingSliderValue)),this.ignoreStepKeyUp=!1}}.bind(this)),nowPlayingPositionSlider.addEventListener("input",function(e){onPositionSliderEndEditing.call(this,e)}.bind(this)),nowPlayingPositionSlider.addEventListener("beginediting",onPositionSliderBeginEditing.bind(this)),nowPlayingPositionSlider.addEventListener("endediting",onPositionSliderEndEditing.bind(this)),nowPlayingPositionSlider.addEventListener("displayvaluechange",function(e){var currentRuntimeTicks,e=e.detail.value;this.enableProgressByTimeOfDay||(currentRuntimeTicks=this.nowPlayingSliderRunTimeTicks)&&updateTimeText(this,this.options.positionTextElem,currentRuntimeTicks/100*e)}.bind(this)),_dom.default.addEventListener(nowPlayingPositionSlider,"change",function(e){var startDateMs,e=e.target,player=this.currentPlayer,e=parseFloat(e.value);this.enableProgressByTimeOfDay?(startDateMs=this.visualStartDateMs,startDateMs=1e4*((this.visualEndDateMs-startDateMs)*(e/100)+startDateMs-this.wallClockStartTimeMs),_playbackmanager.default.seek(startDateMs,player)):_playbackmanager.default.seekPercent(e,player)}.bind(this),{passive:!0}),this.bound_intervalForPositionSlider=function(){var slider=this.options.nowPlayingPositionSlider,key=this.repeatingPositionSliderKey,speed=this.repeatingPositionSliderKeySpeed,sliderMin=slider.min,sliderMax=slider.max,stepMultiplier=[1,3,6,12,18][speed-1];switch(key){case"stepdown":this.nowPlayingSliderValue=Math.min(Math.max(this.nowPlayingSliderValue-stepMultiplier*convertMsToNowPlayingSliderStep(this,1e3),sliderMin),sliderMax);break;case"stepup":this.nowPlayingSliderValue=Math.min(Math.max(this.nowPlayingSliderValue+stepMultiplier*convertMsToNowPlayingSliderStep(this,1e3),sliderMin),sliderMax);break;default:return}console.log("onIntervalPositionSlider, key: "+key+", speed: "+speed),this.nowPlayingSliderValue<=sliderMin?(this.nowPlayingSliderValue=sliderMin,slider.endEditing(!0,sliderMin)):this.nowPlayingSliderValue>=sliderMax?(this.nowPlayingSliderValue=sliderMax,slider.endEditing(!0,sliderMax)):slider.beginEditing(this.nowPlayingSliderValue)}.bind(this),setDefaultSpeed(this),options.positionTextElem);nowPlayingPositionSlider&&(nowPlayingPositionSlider.style.height="1.7em")}function updatePositionSliderDisabled(instance,state){var playState,nowPlayingPositionSlider=instance.options.nowPlayingPositionSlider;nowPlayingPositionSlider&&!nowPlayingPositionSlider.dragging&&(playState=state.PlayState||{},nowPlayingPositionSlider.disabled=!0===state.IsInitialRequest||!playState.CanSeek||instance.disablePositionSlider)}function getThumbnailBubbleHtml(nowPlayingPositionSlider,enableProgressByTimeOfDay,apiClient,itemId,mediaSourceId,thumbnailSet,chapters,positionTicks,maxThumbnailWidth){var thumbnail,thumbnails=(thumbnailSet=thumbnailSet||{}).Thumbnails||{},bubbleElement=nowPlayingPositionSlider.getBubbleElement();thumbnails.length?(bubbleElement.classList.add("chapterThumbImageContainer"),thumbnailSet.AspectRatio&&thumbnailSet.AspectRatio<1.4?bubbleElement.classList.add("chapterThumbImageContainer-fourthree"):bubbleElement.classList.remove("chapterThumbImageContainer-fourthree"),bubbleElement.classList.remove("chapterThumbImageContainer-noimg")):(bubbleElement.classList.remove("chapterThumbImageContainer","chapterThumbImageContainer-fourthree"),bubbleElement.classList.add("chapterThumbImageContainer-noimg")),_layoutmanager.default.tv?bubbleElement.classList.add("chapterThumbImageContainer-tv"):bubbleElement.classList.remove("chapterThumbImageContainer-tv");for(var i=0,length=thumbnails.length;i<length;i++){var currentThumbnail=thumbnails[i];if(positionTicks>=currentThumbnail.PositionTicks)thumbnail=currentThumbnail;else if(thumbnail)break}for(var _i=0,_length=chapters.length;_i<_length;_i++){var currentChapter=chapters[_i];if(positionTicks>=currentChapter.StartPositionTicks)chapter=currentChapter;else if(chapter)break}var chapter=chapter||{Name:"&nbsp;"},thumbnailSet=thumbnail?function(itemId,thumbnail,maxWidth,apiClient){return thumbnail.ImageTag?apiClient.getImageUrl(itemId,{maxWidth:maxWidth,tag:thumbnail.ImageTag,type:"Thumbnail",PositionTicks:thumbnail.PositionTicks}):null}(itemId,thumbnail,maxThumbnailWidth,apiClient):null,bubbleElement="",itemId="chapterThumbTextContainer",maxThumbnailWidth=(thumbnailSet||(itemId+=" chapterThumbTextContainer-noimg"),nowPlayingPositionSlider.getBubbleElement().style.backgroundImage=thumbnailSet?"url('"+thumbnailSet+"')":null,enableProgressByTimeOfDay||!_layoutmanager.default.tv),bubbleElement=(bubbleElement=bubbleElement+('<div class="'+itemId+'">')+'<div class="chapterThumbText">')+(chapter?_dom.default.htmlEncode(chapter.Name):"&nbsp;")+"</div>";return maxThumbnailWidth&&(bubbleElement=(bubbleElement+=thumbnailSet?'<div class="chapterThumbText">':'<div class="chapterThumbText secondaryText">')+_datetime.default.getDisplayRunningTime(positionTicks)+"</div>"),bubbleElement+="</div>"}function refreshThumbnailsIfNeeded(instance,item,mediaSourceId,apiClient,maxThumbnailWidth){!item.Id||"Audio"===item.MediaType||instance.currentItemThumbnails||instance.currentItemThumbnailsPromise||!function(instance,itemId,mediaSourceId,apiClient,maxThumbnailWidth){if(instance.currentItemThumbnailsPromise)return instance.currentItemThumbnailsPromise;apiClient=apiClient.getThumbnails(itemId,{MediaSourceId:mediaSourceId,Width:maxThumbnailWidth}).then(function(result){return instance.currentItemThumbnails=result,Promise.resolve(result)},function(){instance.currentItemThumbnailsPromise=null}),instance.currentItemThumbnailsPromise=apiClient}(instance,item.Id,mediaSourceId,apiClient,maxThumbnailWidth)}OsdController.prototype.updatePlayerState=function(event,player,state){var nowPlayingPositionSlider=this.options.nowPlayingPositionSlider,isProgressClear=(updatePositionSliderDisabled(this,state),state.MediaSource&&null==state.MediaSource.RunTimeTicks);nowPlayingPositionSlider.setIsClear(isProgressClear),null!=(nowPlayingPositionSlider=state.MediaSource)&&nowPlayingPositionSlider.WallClockStart&&(isProgressClear=_datetime.default.parseISO8601Date(state.MediaSource.WallClockStart),console.log("wall clock start: "+isProgressClear),this.wallClockStartTimeMs=isProgressClear.getTime(),this.visualStartDateMs=Math.min(this.visualStartDateMs||this.wallClockStartTimeMs,this.wallClockStartTimeMs||this.visualStartDateMs)),this.updateNowPlayingInfo(event,player,state)},OsdController.prototype.updateNowPlayingInfo=function(event,player,state){this.currentItemThumbnailsPromise=null,this.currentItemThumbnails=null;var item=state.NowPlayingItem;this.currentItem=item;var instance,nowPlayingPositionSlider=this.options.nowPlayingPositionSlider;item?(this.currentMediaSource=state.MediaSource,this.enableProgressByTimeOfDay=function(item,mediaSource){return!("TvChannel"!==item.Type||!item.CurrentProgram||!mediaSource||mediaSource.RunTimeTicks)||!(!("Recording"===item.Type&&item.StartDate&&item.EndDate&&mediaSource)||mediaSource.RunTimeTicks)}(item,state.MediaSource),nowPlayingPositionSlider.setForceDisplayThumb(this.enableProgressByTimeOfDay),this.enableProgressByTimeOfDay?nowPlayingPositionSlider.getTrackBackgroundUpper().classList.add("emby-slider-background-upper-accent"):nowPlayingPositionSlider.getTrackBackgroundUpper().classList.remove("emby-slider-background-upper-accent"),function(item,currentDisplayItem){return item.Id?currentDisplayItem&&currentDisplayItem.Id===item.Id?Promise.resolve({originalItem:currentDisplayItem,displayItem:currentDisplayItem.CurrentProgram||currentDisplayItem}):(currentDisplayItem=_connectionmanager.default.getApiClient(item.ServerId)).getItem(currentDisplayItem.getCurrentUserId(),item.Id).then(function(refreshedItem){return{originalItem:refreshedItem,displayItem:refreshedItem.CurrentProgram||refreshedItem}}):Promise.resolve({originalItem:item})}(item,(instance=this).currentDisplayItem).then(function(itemInfo){var item=itemInfo.originalItem,itemInfo=(instance.currentItem=item,itemInfo.displayItem||item);instance.currentDisplayItem=itemInfo,_events.default.trigger(instance,"displayitemupdated",[item,itemInfo,state]),instance.updateDisplayItem(state,itemInfo)})):(nowPlayingPositionSlider.disabled=!0,this.enableProgressByTimeOfDay=!1,this.currentDisplayChapters=null,this.currentDisplayItem=null,this.currentMediaSource=null,_events.default.trigger(this,"displayitemupdated",[item,null,state]))},OsdController.prototype.updateDisplayItem=function(state,displayItem){this.currentDisplayChapters=function(chapters){for(var list=[],i=0,length=chapters.length;i<length;i++){var chapter=chapters[i];chapter.MarkerType&&"Chapter"!==chapter.MarkerType||list.push(chapter)}return list}(displayItem.Chapters||[]),this.currentItemThumbnailsPromise=null,this.currentItemThumbnails=null,updatePositionSliderDisabled(this,state),this.enableProgressByTimeOfDay?(state=displayItem.StartDate?_datetime.default.parseISO8601Date(displayItem.StartDate).getTime():0,this.visualStartDateMs=Math.min(state||this.wallClockStartTimeMs,this.wallClockStartTimeMs||state),this.visualEndDateMs=displayItem.EndDate?_datetime.default.parseISO8601Date(displayItem.EndDate).getTime():0):(this.visualStartDateMs=0,this.visualEndDateMs=0)},OsdController.prototype.onPlayerTimeUpdate=function(positionTicks,runtimeTicks,seekableRanges){var wallClockStartTimeMs,visualEndDateMs,currentTimeMs,visualStartDateMs,seekRuntimeMs,options=this.options,nowPlayingPositionSlider=options.nowPlayingPositionSlider,enableProgressByTimeOfDay=this.enableProgressByTimeOfDay,positionTextElem=options.positionTextElem,options=options.durationTextElem;enableProgressByTimeOfDay?nowPlayingPositionSlider&&!nowPlayingPositionSlider.dragging&&(wallClockStartTimeMs=this.wallClockStartTimeMs,visualStartDateMs=this.visualStartDateMs,visualEndDateMs=this.visualEndDateMs,(visualStartDateMs=visualStartDateMs)&&visualEndDateMs?(currentTimeMs=wallClockStartTimeMs+(positionTicks||0)/1e4,seekRuntimeMs=visualEndDateMs-visualStartDateMs,setDisplayTime(positionTextElem,visualStartDateMs),options&&setDisplayTime(options,visualEndDateMs),this.nowPlayingSliderRunTimeTicks=1e4*seekRuntimeMs,nowPlayingPositionSlider.step=getStep(this.nowPlayingSliderRunTimeTicks),this.nowPlayingSliderValue=(currentTimeMs-visualStartDateMs)/seekRuntimeMs*100,nowPlayingPositionSlider.setValue(this.nowPlayingSliderValue),seekableRanges.length?(visualEndDateMs=getDisplayPercentByTimeOfDay(visualStartDateMs,seekRuntimeMs,wallClockStartTimeMs+(seekableRanges[0].start||0)/1e4),currentTimeMs=getDisplayPercentByTimeOfDay(visualStartDateMs,seekRuntimeMs,wallClockStartTimeMs+(seekableRanges[0].end||0)/1e4),nowPlayingPositionSlider.setSeekRanges([{start:visualEndDateMs,end:currentTimeMs}])):nowPlayingPositionSlider.setSeekRanges([])):(nowPlayingPositionSlider.step=.01,this.nowPlayingSliderRunTimeTicks=null,this.nowPlayingSliderValue=0,nowPlayingPositionSlider.setValue(0),nowPlayingPositionSlider.setSeekRanges([]))):(this.nowPlayingSliderRunTimeTicks=runtimeTicks,nowPlayingPositionSlider&&!nowPlayingPositionSlider.dragging&&(runtimeTicks?(visualStartDateMs=positionTicks/runtimeTicks,visualStartDateMs*=100,nowPlayingPositionSlider.step=getStep(runtimeTicks),this.nowPlayingSliderValue=visualStartDateMs,nowPlayingPositionSlider.setValue(visualStartDateMs),options&&(!(seekRuntimeMs=this.currentMediaSource)||seekRuntimeMs.RunTimeTicks?updateDurationText(options,enableProgressByTimeOfDay,runtimeTicks-positionTicks,this.currentDisplayItem,!0):updateDurationText(options,enableProgressByTimeOfDay,runtimeTicks,this.currentDisplayItem,!1))):(nowPlayingPositionSlider.step=.01,this.nowPlayingSliderValue=0,nowPlayingPositionSlider.setValue(0),options&&updateDurationText(options,enableProgressByTimeOfDay,runtimeTicks,this.currentDisplayItem))),nowPlayingPositionSlider&&nowPlayingPositionSlider.setSeekRanges([]),null!=nowPlayingPositionSlider&&nowPlayingPositionSlider.dragging&&runtimeTicks||updateTimeText(this,positionTextElem,positionTicks))},OsdController.prototype.getPositionBubbleHtml=function(value,currentRuntimeTicks){var enableProgressByTimeOfDay=this.enableProgressByTimeOfDay;if(enableProgressByTimeOfDay)return(startDateMs=this.visualStartDateMs)&&this.visualEndDateMs?(ms=this.visualEndDateMs-startDateMs,ms=(ms/=100)*value+startDateMs,'<h3 class="sliderBubbleText">'+getDisplayTimeWithoutAmPm(new Date(parseInt(ms)),!0)+"</h3>"):"--:--";if(!currentRuntimeTicks)return"--:--";var startDateMs=currentRuntimeTicks,ms=(startDateMs=startDateMs/100*value,this.currentItem);if(ms&&this.options.enableSeekThumbnails){var currentRuntimeTicks=_connectionmanager.default.getApiClient(ms.ServerId),value=(refreshThumbnailsIfNeeded(this,ms,"",currentRuntimeTicks,400),this.currentItemThumbnails),chapters=this.currentDisplayChapters||[],nowPlayingPositionSlider=this.options.nowPlayingPositionSlider;if(chapters.length){nowPlayingPositionSlider=getThumbnailBubbleHtml(nowPlayingPositionSlider,enableProgressByTimeOfDay,currentRuntimeTicks,ms.Id,0,value,chapters,startDateMs,400);if(nowPlayingPositionSlider)return nowPlayingPositionSlider}}return'<h2 class="sliderBubbleText">'+_datetime.default.getDisplayRunningTime(startDateMs)+"</h2>"},OsdController.prototype.onPlaybackStart=function(e,state){cancelPositionSliderEditing(this)},OsdController.prototype.onPlaybackStopped=function(e,state){cancelPositionSliderEditing(this)},OsdController.prototype.bindToPlayer=function(player){this.currentPlayer=player},OsdController.prototype.releaseCurrentPlayer=function(){cancelPositionSliderEditing(this),this.currentPlayer=null},OsdController.prototype.destroy=function(){this.releaseCurrentPlayer(),this.currentItemThumbnailsPromise=null,this.currentItemThumbnails=null,this.currentDisplayChapters=null,this.currentItem=null,this.currentDisplayItem=null,this.currentMediaSource=null,this.options=null};_exports.default=OsdController});