/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.configurator;

import com.tngtech.archunit.core.domain.JavaClass;
import java.awt.Graphics2D;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.SetBooleanPropertyAction;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.highlight.HighlightController;
import org.freeplane.features.highlight.NodeHighlighter;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.plugin.codeexplorer.archunit.ArchUnitServer;
import org.freeplane.plugin.codeexplorer.archunit.ArchitectureViolationsConfiguration;
import org.freeplane.plugin.codeexplorer.configurator.AddConfigurationAction;
import org.freeplane.plugin.codeexplorer.configurator.AddFoldersRecursivelyAction;
import org.freeplane.plugin.codeexplorer.configurator.AddLocationsAction;
import org.freeplane.plugin.codeexplorer.configurator.ArchitectureViolationsPanel;
import org.freeplane.plugin.codeexplorer.configurator.CodeDependenciesPanel;
import org.freeplane.plugin.codeexplorer.configurator.CodeExplorerConfigurator;
import org.freeplane.plugin.codeexplorer.configurator.DeleteConfigurationsAction;
import org.freeplane.plugin.codeexplorer.configurator.DeleteLocationsAction;
import org.freeplane.plugin.codeexplorer.configurator.RunAnalysisAction;
import org.freeplane.plugin.codeexplorer.map.DependencySelection;
import org.freeplane.plugin.codeexplorer.task.CodeExplorer;
import org.freeplane.plugin.codeexplorer.task.CodeExplorerConfigurations;
import org.freeplane.plugin.codeexplorer.task.UserDefinedCodeExplorerConfiguration;

public class CodeProjectController
implements IExtension {
    private CodeDependenciesPanel codeDependenciesPanel;
    private ModeController modeController;
    private JTabbedPane informationPanel;
    private Set<JavaClass> selectedClasses;
    private CodeExplorerConfigurator configurator;
    private CodeExplorerConfigurations explorerConfigurations;
    private final ArchUnitServer archUnitServer;
    private ArchitectureViolationsPanel architectureViolationsPanel;

    public CodeProjectController(final ModeController modeController, ArchUnitServer archUnitServer) {
        this.modeController = modeController;
        this.archUnitServer = archUnitServer;
        this.explorerConfigurations = CodeExplorerConfigurations.loadConfigurations();
        Controller controller = modeController.getController();
        ((HighlightController)controller.getExtension(HighlightController.class)).addNodeHighlighter(new NodeHighlighter(){

            public boolean isNodeHighlighted(NodeModel node, boolean isPrinting) {
                return !isPrinting && modeController == Controller.getCurrentModeController() && CodeProjectController.this.isDependencySelectedForNode(node);
            }

            public void configure(NodeModel node, Graphics2D g, boolean isPrinting) {
                g.setColor(FilterController.HIGHLIGHT_COLOR);
            }
        });
        modeController.addAction((AFreeplaneAction)new AddConfigurationAction(this));
        modeController.addAction((AFreeplaneAction)new DeleteConfigurationsAction(this));
        modeController.addAction((AFreeplaneAction)new AddLocationsAction(this));
        modeController.addAction((AFreeplaneAction)new AddFoldersRecursivelyAction(this));
        modeController.addAction((AFreeplaneAction)new DeleteLocationsAction(this));
        modeController.addAction((AFreeplaneAction)new RunAnalysisAction(this));
        modeController.addAction((AFreeplaneAction)new SetBooleanPropertyAction("code.archunit.server.enabled"));
    }

    private void showControlPanel() {
        this.informationPanel = new JTabbedPane();
        this.configurator = new CodeExplorerConfigurator(this);
        this.informationPanel.addTab(TextUtils.getText((String)"code.configurations"), this.configurator);
        this.codeDependenciesPanel = new CodeDependenciesPanel();
        this.codeDependenciesPanel.addDependencySelectionCallback(this::updateSelectedDependency);
        this.informationPanel.addTab(TextUtils.getText((String)"code.dependencies"), this.codeDependenciesPanel);
        AFreeplaneAction enableServerAction = this.modeController.getAction(SetBooleanPropertyAction.actionKey((String)"code.archunit.server.enabled"));
        this.architectureViolationsPanel = new ArchitectureViolationsPanel(this, this.archUnitServer, enableServerAction);
        this.architectureViolationsPanel.addDependencySelectionCallback(this::updateSelectedDependency);
        this.informationPanel.addTab(TextUtils.getText((String)"code.architectureViolations"), this.architectureViolationsPanel);
        Controller controller = this.modeController.getController();
        controller.getViewController().insertComponentIntoSplitPane((JComponent)this.informationPanel);
        this.informationPanel.setVisible(true);
        this.informationPanel.revalidate();
        controller.getMapViewManager().addMapSelectionListener((IMapSelectionListener)this.configurator);
    }

    private void hideControlPanel() {
        Controller controller = this.modeController.getController();
        controller.getMapViewManager().removeMapSelectionListener((IMapSelectionListener)this.configurator);
        this.modeController.getController().getViewController().removeSplitPane();
        this.informationPanel = null;
        this.configurator = null;
        this.codeDependenciesPanel = null;
        this.selectedClasses = null;
    }

    public void startupController() {
        this.showControlPanel();
        MapController mapController = this.modeController.getMapController();
        mapController.addNodeSelectionListener((INodeSelectionListener)this.codeDependenciesPanel);
        mapController.addMapChangeListener((IMapChangeListener)this.codeDependenciesPanel);
        Controller.getCurrentController().getMapViewManager().addMapSelectionListener((IMapSelectionListener)this.codeDependenciesPanel);
        ResourceController.getResourceController().addPropertyChangeListener((IFreeplanePropertyListener)this.codeDependenciesPanel);
        this.codeDependenciesPanel.update();
    }

    public void shutdownController() {
        MapController mapController = this.modeController.getMapController();
        mapController.removeNodeSelectionListener((INodeSelectionListener)this.codeDependenciesPanel);
        mapController.removeMapChangeListener((IMapChangeListener)this.codeDependenciesPanel);
        Controller.getCurrentController().getMapViewManager().removeMapSelectionListener((IMapSelectionListener)this.codeDependenciesPanel);
        ResourceController.getResourceController().removePropertyChangeListener((IFreeplanePropertyListener)this.codeDependenciesPanel);
        this.hideControlPanel();
    }

    private boolean isDependencySelectedForNode(NodeModel node) {
        if (this.selectedClasses == null) {
            return false;
        }
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection == null || node.getMap() != selection.getMap()) {
            return false;
        }
        DependencySelection dependencySelection = new DependencySelection(selection);
        return this.selectedClasses.stream().anyMatch(javaClass -> node.equals((Object)dependencySelection.getVisibleNode((JavaClass)javaClass)));
    }

    public void updateSelectedDependency(Set<JavaClass> selectedClasses) {
        this.selectedClasses = selectedClasses;
        this.modeController.getController().getMapViewManager().getMapViewComponent().repaint();
    }

    void exploreSelectedConfiguration() {
        UserDefinedCodeExplorerConfiguration selectedConfiguration;
        if (this.configurator != null && (selectedConfiguration = this.configurator.getSelectedConfiguration()) != null) {
            this.exploreConfiguration(selectedConfiguration, true);
        }
    }

    public void exploreConfiguration(ArchitectureViolationsConfiguration configuration) {
        CodeExplorer codeExplorer = (CodeExplorer)Controller.getCurrentModeController().getMapController();
        codeExplorer.explore(configuration, true);
    }

    void exploreConfiguration(UserDefinedCodeExplorerConfiguration selectedConfiguration, boolean reloadCodebase) {
        CodeExplorer codeExplorer = (CodeExplorer)Controller.getCurrentModeController().getMapController();
        codeExplorer.explore(selectedConfiguration, reloadCodebase);
    }

    public void saveConfiguration() {
        this.explorerConfigurations.saveConfiguration();
    }

    public CodeExplorerConfigurations explorerConfigurations() {
        return this.explorerConfigurations;
    }

    public void updateProjectConfiguration() {
        if (this.configurator != null) {
            UserDefinedCodeExplorerConfiguration selectedConfiguration = this.configurator.getSelectedConfiguration();
            CodeExplorer codeExplorer = (CodeExplorer)Controller.getCurrentModeController().getMapController();
            codeExplorer.setProjectConfiguration(selectedConfiguration.getDependencyJudge(), selectedConfiguration.getAnnotationMatcher());
            this.codeDependenciesPanel.update();
        }
    }

    public void cancelAnalysis() {
        CodeExplorer codeExplorer = (CodeExplorer)Controller.getCurrentModeController().getMapController();
        codeExplorer.cancelAnalysis();
    }

    void addNewConfiguration() {
        this.informationPanel.setSelectedComponent(this.configurator);
        this.configurator.addNewConfiguration();
    }

    void deleteSelectedConfigurations() {
        this.informationPanel.setSelectedComponent(this.configurator);
        this.configurator.deleteSelectedConfigurations();
    }

    void addFoldersRecursivelyAction() {
        this.informationPanel.setSelectedComponent(this.configurator);
        this.configurator.addFoldersRecursively();
    }

    void addNewLocations() {
        this.informationPanel.setSelectedComponent(this.configurator);
        this.configurator.addJarsAndFolders();
    }

    void deleteSelectedLocations() {
        this.informationPanel.setSelectedComponent(this.configurator);
        this.configurator.removeSelectedLocations();
    }
}

