/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.JavaClasses;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.swing.UIManager;
import org.freeplane.api.HorizontalTextAlignment;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.core.undo.UndoHandler;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeMapPersistenceManager;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.map.CodeNodeStream;
import org.freeplane.plugin.codeexplorer.map.CopyQualifiedNameAction;
import org.freeplane.plugin.codeexplorer.map.DeletedContentNode;
import org.freeplane.plugin.codeexplorer.map.EmptyNodeModel;
import org.freeplane.plugin.codeexplorer.map.FilterClassesByDependencies;
import org.freeplane.plugin.codeexplorer.map.FilterCyclesAction;
import org.freeplane.plugin.codeexplorer.map.NewCodeMapAction;
import org.freeplane.plugin.codeexplorer.map.ProjectRootNode;
import org.freeplane.plugin.codeexplorer.map.PurgeAction;
import org.freeplane.plugin.codeexplorer.map.SelectCyclesAction;
import org.freeplane.plugin.codeexplorer.map.ShowAllClassesAction;
import org.freeplane.plugin.codeexplorer.map.ShowDependingNodesAction;
import org.freeplane.plugin.codeexplorer.task.AnnotationMatcher;
import org.freeplane.plugin.codeexplorer.task.CodeExplorer;
import org.freeplane.plugin.codeexplorer.task.CodeExplorerConfiguration;
import org.freeplane.plugin.codeexplorer.task.DependencyJudge;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;

public class CodeMapController
extends MapController
implements CodeExplorer {
    private final ExecutorService classImportService;

    public CodeMapController(ModeController modeController, ExecutorService classImportService) {
        super(modeController);
        this.classImportService = classImportService;
        modeController.addAction((AFreeplaneAction)new FilterClassesByDependencies());
        for (ShowDependingNodesAction.DependencyDirection direction : ShowDependingNodesAction.DependencyDirection.values()) {
            for (ShowDependingNodesAction.Depth maximumDepth : ShowDependingNodesAction.Depth.values()) {
                modeController.addAction((AFreeplaneAction)new ShowDependingNodesAction(direction, maximumDepth));
            }
        }
        modeController.addAction((AFreeplaneAction)new CopyQualifiedNameAction());
        modeController.addAction((AFreeplaneAction)new ShowAllClassesAction());
        modeController.addAction((AFreeplaneAction)new SelectCyclesAction());
        modeController.addAction((AFreeplaneAction)new FilterCyclesAction());
        modeController.addAction((AFreeplaneAction)new NewCodeMapAction());
        modeController.addAction((AFreeplaneAction)new PurgeAction());
    }

    public CodeMap newCodeMap(boolean canBeSaved) {
        CodeMap codeMap = new CodeMap(this.getModeController().getMapController().duplicator());
        codeMap.setCanBeSaved(canBeSaved);
        this.fireMapCreated((MapModel)codeMap);
        Color background = UIManager.getColor("Panel.background");
        Color foreground = UIManager.getColor("Panel.foreground");
        MapStyleModel mapStyleModel = MapStyleModel.getExtension((MapModel)codeMap);
        NodeModel defaultStyleNode = mapStyleModel.getDefaultStyleNode();
        NodeStyleModel nodeStyle = NodeStyleModel.createNodeStyleModel((NodeModel)defaultStyleNode);
        nodeStyle.setFontSize(Integer.valueOf(10));
        nodeStyle.setHorizontalTextAlignment(HorizontalTextAlignment.LEFT);
        if (background != null && foreground != null) {
            mapStyleModel.setBackgroundColor(background.darker());
            nodeStyle.setColor(foreground);
        } else {
            mapStyleModel.setBackgroundColor(Color.WHITE);
            nodeStyle.setColor(Color.BLACK);
        }
        NodeSizeModel nodeSizeModel = NodeSizeModel.createNodeSizeModel((NodeModel)defaultStyleNode);
        nodeSizeModel.setMinNodeWidth(Quantity.fromString((String)"6", (Enum)LengthUnit.cm));
        nodeSizeModel.setMaxNodeWidth(Quantity.fromString((String)"30", (Enum)LengthUnit.cm));
        MapStyleModel.getExtension((MapModel)codeMap).setProperty("attribute_table_width_fits_content", "true");
        return codeMap;
    }

    protected void fireFoldingChanged(NodeModel node) {
    }

    @Override
    public void explore(CodeExplorerConfiguration codeExplorerConfiguration, boolean reloadCodebase) {
        Controller currentController = Controller.getCurrentController();
        IMapSelection selection = currentController.getSelection();
        CodeMap oldMap = (CodeMap)selection.getMap();
        if (!currentController.getMapViewManager().saveModifiedIfNotCancelled((MapModel)oldMap)) {
            return;
        }
        List orderedSelectionIds = selection.getOrderedSelectionIds();
        IMapViewManager mapViewManager = currentController.getMapViewManager();
        MapView mapView = (MapView)mapViewManager.getMapViewComponent();
        List unfoldedNodeIDs = CodeNodeStream.nodeViews(mapView).filter(nv -> !nv.isFolded()).map(NodeView::getNode).map(NodeModel::getID).collect(Collectors.toList());
        CodeMap loadingHintMap = this.newCodeMap(false);
        EmptyNodeModel emptyRoot = new EmptyNodeModel(loadingHintMap, "Analyzing" + (codeExplorerConfiguration != null ? " " + codeExplorerConfiguration.countLocations() : "") + " locations ...");
        loadingHintMap.setRoot(emptyRoot);
        mapViewManager.setMap((Component)mapView, (MapModel)loadingHintMap);
        Controller.getCurrentController().getMapViewManager().setMapTitles();
        Controller.getCurrentController().getViewController().setWaitingCursor(true);
        CodeMap projectMap = this.newCodeMap(codeExplorerConfiguration.canBeSaved());
        projectMap.setConfiguration(codeExplorerConfiguration);
        loadingHintMap.addExtension(new LoadedMap(projectMap));
        WeakReference<CodeMap> oldMapReference = new WeakReference<CodeMap>(oldMap);
        JavaClasses oldImportedClasses = !reloadCodebase && oldMap.getRootNode() instanceof ProjectRootNode ? ((ProjectRootNode)oldMap.getRootNode()).getImportedClasses() : null;
        oldMap = null;
        this.classImportService.execute(() -> {
            ProjectRootNode projectRoot = null;
            CodeMap nextMap = null;
            try {
                JavaClasses importedClasses;
                JavaClasses javaClasses = importedClasses = oldImportedClasses != null ? oldImportedClasses : codeExplorerConfiguration.importClasses();
                if (LoadedMap.containsProjectMap((MapModel)loadingHintMap, projectMap)) {
                    projectRoot = ProjectRootNode.asMapRoot(codeExplorerConfiguration.getProjectName(), projectMap, importedClasses, codeExplorerConfiguration.createGroupMatcher());
                    projectMap.setJudge(codeExplorerConfiguration.getDependencyJudge());
                    CodeMapPersistenceManager.getCodeMapPersistenceManager(this.getModeController()).restoreUserContent(projectMap);
                    AttributeRegistry.getRegistry((MapModel)projectMap);
                }
                LogUtils.info((String)"Code map prepared");
                if (projectRoot != null && LoadedMap.containsProjectMap((MapModel)loadingHintMap, projectMap)) {
                    projectRoot.setFolded(false);
                    nextMap = projectMap;
                }
            }
            catch (Exception e) {
                LogUtils.warn((String)"Loading classes failed", (Throwable)e);
                UITools.errorMessage((Object)("Loading classes failed, " + e.getMessage()));
            }
            if (nextMap == null) {
                nextMap = (CodeMap)((Object)((Object)oldMapReference.get()));
            }
            if (nextMap == null) {
                nextMap = this.newCodeMap(false);
            }
            CodeMap viewedMap = nextMap;
            EventQueue.invokeLater(() -> {
                loadingHintMap.removeExtension(LoadedMap.class);
                if (!viewedMap.containsExtension(IUndoHandler.class)) {
                    viewedMap.addExtension(IUndoHandler.class, (IExtension)new UndoHandler((MapModel)viewedMap));
                }
                mapViewManager.setMap((Component)mapView, (MapModel)viewedMap);
                unfoldedNodeIDs.stream().map(id -> this.getExistingAncestorOrSelfNode((MapModel)viewedMap, (String)id)).filter(x -> x != null).forEach(node -> node.setFolded(false));
                NodeModel[] newSelection = (NodeModel[])orderedSelectionIds.stream().map(id -> this.getExistingAncestorOrSelfNode((MapModel)viewedMap, (String)id)).filter(x -> x != null).distinct().toArray(NodeModel[]::new);
                if (newSelection.length > 0) {
                    selection.replaceSelection(newSelection);
                }
                if (codeExplorerConfiguration != null) {
                    projectMap.updateAnnotations(codeExplorerConfiguration.getAnnotationMatcher());
                }
                FilterController.getCurrentFilterController().mapRootNodeChanged((MapModel)viewedMap);
                Controller.getCurrentController().getMapViewManager().setMapTitles();
                EventQueue.invokeLater(() -> Controller.getCurrentController().getViewController().setWaitingCursor(false));
            });
        });
    }

    private CodeNode getExistingAncestorOrSelfNode(MapModel map, String id) {
        NodeModel node = map.getNodeForID(id);
        if (node != null) {
            return (CodeNode)node;
        }
        int lastDelimiterPosition = id.lastIndexOf(46);
        if (lastDelimiterPosition > 0) {
            return this.getExistingAncestorOrSelfNode(map, id.substring(0, lastDelimiterPosition));
        }
        return null;
    }

    @Override
    public void setProjectConfiguration(DependencyJudge judge, AnnotationMatcher annotationMatcher) {
        Controller currentController = Controller.getCurrentController();
        IMapSelection selection = currentController.getSelection();
        CodeMap map = (CodeMap)selection.getMap();
        map.setJudge(judge);
        map.updateAnnotations(annotationMatcher);
        IMapViewManager mapViewManager = currentController.getMapViewManager();
        MapView mapView = (MapView)mapViewManager.getMapViewComponent();
        mapView.repaint();
    }

    @Override
    public void cancelAnalysis() {
        Controller.getCurrentController().getMap().removeExtension(LoadedMap.class);
    }

    public void mapSaved(MapModel mapModel, boolean saved) {
        mapModel.setSaved(saved);
    }

    void purge(NodeModel node) {
        if (node instanceof DeletedContentNode) {
            this.deleteNode(node);
        } else {
            new ArrayList<NodeModel>(node.getChildren()).forEach(this::purge);
        }
    }

    private void deleteNode(final NodeModel node) {
        final NodeModel parentNode = node.getParentNode();
        if (parentNode == null) {
            return;
        }
        final int index = parentNode.getIndex(node);
        IActor actor = new IActor(){

            public void act() {
                CodeMapController.this.deleteWithoutUndo(parentNode, index);
            }

            public String getDescription() {
                return "delete";
            }

            public void undo() {
                CodeMapController.this.insertNodeIntoWithoutUndo(node, parentNode, index);
            }
        };
        Controller.getCurrentModeController().execute(actor, parentNode.getMap());
    }

    private void deleteWithoutUndo(NodeModel parent, int index) {
        NodeModel child = parent.getChildAt(index);
        NodeDeletionEvent nodeDeletionEvent = new NodeDeletionEvent(parent, child, index);
        this.firePreNodeDelete(nodeDeletionEvent);
        MapModel map = parent.getMap();
        this.mapSaved(map, false);
        parent.remove(index);
        this.fireNodeDeleted(nodeDeletionEvent);
    }

    private static class LoadedMap
    implements IExtension {
        CodeMap projectMap;

        static boolean containsProjectMap(MapModel map, CodeMap projectMap) {
            LoadedMap loadedMap = (LoadedMap)map.getExtension(LoadedMap.class);
            return loadedMap != null && loadedMap.projectMap == projectMap;
        }

        LoadedMap(CodeMap projectMap) {
            this.projectMap = projectMap;
        }
    }
}

