/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.map.AncestorRemover;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeNode;

public class DependencySelection {
    private final IMapSelection selection;
    private CodeMap map;
    private Set<NodeModel> selectedNodeSet;
    private final boolean showsOutsideDependencies;

    public DependencySelection(IMapSelection selection) {
        this(selection, ResourceController.getResourceController().getBooleanProperty("code_showOutsideDependencies", true));
    }

    public DependencySelection(IMapSelection selection, boolean showsOutsideDependencies) {
        this.selection = selection;
        this.showsOutsideDependencies = showsOutsideDependencies;
    }

    public Stream<Dependency> getSelectedDependencies() {
        Set nodes = AncestorRemover.removeAncestors(this.getSelectedNodeSet());
        Stream<Dependency> allDependencies = nodes.stream().flatMap(node -> Stream.concat(this.getOutgoingDependencies((CodeNode)((Object)node)), this.getIncomingDependencies((CodeNode)((Object)node)))).distinct();
        return allDependencies;
    }

    List<JavaClass> getSelectedClasses() {
        Set nodes = AncestorRemover.removeAncestors(this.getSelectedNodeSet());
        List allClasses = nodes.stream().flatMap(node -> Stream.concat(this.getOutgoingDependencies((CodeNode)((Object)node)).map(Dependency::getOriginClass), this.getIncomingDependencies((CodeNode)((Object)node)).map(Dependency::getTargetClass))).distinct().collect(Collectors.toCollection(ArrayList::new));
        return allClasses;
    }

    public CodeNode getVisibleNode(JavaClass javaClass) {
        CodeMap map = this.getMap();
        for (CodeNode node = map.getNodeByClass(javaClass); node != null; node = node.getParentNode()) {
            switch (this.visibility(node).ordinal()) {
                case 0: {
                    return node;
                }
                case 1: {
                    return null;
                }
            }
        }
        return null;
    }

    private Stream<Dependency> getOutgoingDependencies(CodeNode node) {
        Stream<Dependency> dependencies = node.getOutgoingDependenciesWithKnownTargets();
        return this.dependenciesBetweenDifferentElements(dependencies);
    }

    private Stream<Dependency> getIncomingDependencies(CodeNode node) {
        Stream<Dependency> dependencies = node.getIncomingDependenciesWithKnownOrigins();
        return this.dependenciesBetweenDifferentElements(dependencies);
    }

    private Stream<Dependency> dependenciesBetweenDifferentElements(Stream<Dependency> dependencies) {
        Stream<Dependency> filteredDependencies = dependencies.filter(dependency -> this.connectsDifferentVisibleNodes((Dependency)dependency));
        return filteredDependencies;
    }

    private NodeModel findSelectedAncestorOrSelf(NodeModel node) {
        while (node != null && !this.selectionContains(node)) {
            node = node.getParentNode();
        }
        return node;
    }

    NodeModel findVisibleAncestorOrSelf(NodeModel node) {
        while (node != null && !this.selection.isVisible(node)) {
            node = node.getParentNode();
        }
        return node;
    }

    private boolean selectionContains(NodeModel node) {
        return this.getSelectedNodeSet().contains(node);
    }

    private Set<NodeModel> getSelectedNodeSet() {
        if (this.selectedNodeSet == null) {
            this.selectedNodeSet = this.selection.getSelection();
        }
        return this.selectedNodeSet;
    }

    public CodeMap getMap() {
        if (this.map == null) {
            this.map = (CodeMap)this.selection.getMap();
        }
        return this.map;
    }

    private Visibility visibility(NodeModel node) {
        if (node == null) {
            return Visibility.UNKNOWN;
        }
        if (this.selection.isVisible(node)) {
            return Visibility.VISIBLE;
        }
        if (!node.isVisible(this.selection.getFilter())) {
            return Visibility.HIDDEN_BY_FILTER;
        }
        return Visibility.HIDDEN_BY_FOLDING;
    }

    private boolean connectsDifferentVisibleNodes(Dependency dependency) {
        CodeNode visibleOrigin = this.getVisibleNode(dependency.getOriginClass());
        CodeNode visibleTarget = this.getVisibleNode(dependency.getTargetClass());
        return visibleOrigin != null && visibleTarget != null && visibleOrigin != visibleTarget && this.isConnectorSelected(visibleOrigin, visibleTarget);
    }

    public boolean isConnectorSelected(CodeNode origin, CodeNode target) {
        boolean areOriginAndTargetSelected;
        boolean isTargetSelected;
        boolean filterAcceptsConnector;
        Set<NodeModel> selectedNodes = this.getSelectedNodeSet();
        boolean isOnlyOneNodeSelected = selectedNodes.size() == 1;
        Filter filter = this.selection.getFilter();
        boolean bl = filterAcceptsConnector = filter.getFilteredElement() != Filter.FilteredElement.CONNECTOR || filter.accepts((NodeModel)origin) && filter.accepts((NodeModel)target);
        if (filter.getFilteredElement() == Filter.FilteredElement.CONNECTOR && filter.getCondition() != null && isOnlyOneNodeSelected || !filterAcceptsConnector) {
            return filterAcceptsConnector;
        }
        NodeModel selectionRoot = this.selection.getSelectionRoot();
        if (origin == selectionRoot || target == selectionRoot) {
            return false;
        }
        if (isOnlyOneNodeSelected && this.selection.getSelected() == selectionRoot) {
            return false;
        }
        NodeModel selectedOriginAncestorOrOrigin = this.findSelectedAncestorOrSelf(origin);
        boolean isOriginSelected = selectedOriginAncestorOrOrigin != null;
        NodeModel selectedTargetAncestorOrTarget = this.findSelectedAncestorOrSelf(target);
        boolean bl2 = isTargetSelected = selectedTargetAncestorOrTarget != null;
        if (!isOriginSelected && !isTargetSelected) {
            return false;
        }
        boolean bl3 = areOriginAndTargetSelected = isOriginSelected && isTargetSelected;
        if (isOnlyOneNodeSelected || this.showsOutsideDependencies) {
            return !areOriginAndTargetSelected;
        }
        if (areOriginAndTargetSelected) {
            return selectedOriginAncestorOrOrigin != selectedTargetAncestorOrTarget;
        }
        return false;
    }

    private static enum Visibility {
        VISIBLE,
        HIDDEN_BY_FILTER,
        HIDDEN_BY_FOLDING,
        UNKNOWN;

    }
}

