/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaCall;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.core.domain.properties.HasParameterTypes;
import com.tngtech.archunit.core.domain.properties.HasType;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.conditions.ArchConditions;
import com.tngtech.archunit.lang.conditions.ArchPredicates;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class GeneralCodingRules {
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchCondition<JavaClass> ACCESS_STANDARD_STREAMS = GeneralCodingRules.accessStandardStreams();
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchRule NO_CLASSES_SHOULD_ACCESS_STANDARD_STREAMS = ArchRuleDefinition.noClasses().should(ACCESS_STANDARD_STREAMS);
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchCondition<JavaClass> THROW_GENERIC_EXCEPTIONS = GeneralCodingRules.throwGenericExceptions();
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchRule NO_CLASSES_SHOULD_THROW_GENERIC_EXCEPTIONS = ArchRuleDefinition.noClasses().should(THROW_GENERIC_EXCEPTIONS);
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchCondition<JavaClass> USE_JAVA_UTIL_LOGGING = ArchConditions.setFieldWhere(JavaClass.Predicates.resideInAPackage("java.util.logging..").onResultOf(JavaAccess.Functions.Get.target().then(HasType.Functions.GET_RAW_TYPE))).as("use java.util.logging", new Object[0]);
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchRule NO_CLASSES_SHOULD_USE_JAVA_UTIL_LOGGING = ArchRuleDefinition.noClasses().should(USE_JAVA_UTIL_LOGGING);
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchCondition<JavaClass> USE_JODATIME = ArchConditions.dependOnClassesThat(JavaClass.Predicates.resideInAPackage("org.joda.time")).as("use JodaTime", new Object[0]);
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchRule NO_CLASSES_SHOULD_USE_JODATIME = ArchRuleDefinition.noClasses().should(USE_JODATIME).because("modern Java projects use the [java.time] API instead");
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchCondition<JavaField> BE_ANNOTATED_WITH_AN_INJECTION_ANNOTATION = ArchConditions.beAnnotatedWith("org.springframework.beans.factory.annotation.Autowired").or(ArchConditions.beAnnotatedWith("org.springframework.beans.factory.annotation.Value")).or(ArchConditions.beAnnotatedWith("com.google.inject.Inject")).or(ArchConditions.beAnnotatedWith("javax.inject.Inject")).or(ArchConditions.beAnnotatedWith("javax.annotation.Resource")).or(ArchConditions.beAnnotatedWith("jakarta.inject.Inject")).or(ArchConditions.beAnnotatedWith("jakarta.annotation.Resource")).as("be annotated with an injection annotation", new Object[0]);
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchRule NO_CLASSES_SHOULD_USE_FIELD_INJECTION = ((ArchRule)ArchRuleDefinition.noFields().should(BE_ANNOTATED_WITH_AN_INJECTION_ANNOTATION).as("no classes should use field injection")).because("field injection is considered harmful; use constructor injection or setter injection instead; see https://stackoverflow.com/q/39890849 for detailed explanations");
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchRule ASSERTIONS_SHOULD_HAVE_DETAIL_MESSAGE = ArchRuleDefinition.noClasses().should().callConstructor(AssertionError.class, new Class[0]).because("assertions should have a detail message");
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchRule DEPRECATED_API_SHOULD_NOT_BE_USED = ArchRuleDefinition.noClasses().should(ArchConditions.accessTargetWhere(JavaAccess.Predicates.target(CanBeAnnotated.Predicates.annotatedWith(Deprecated.class))).as("access @Deprecated members", new Object[0])).orShould(ArchConditions.dependOnClassesThat(CanBeAnnotated.Predicates.annotatedWith(Deprecated.class)).as("depend on @Deprecated classes", new Object[0])).because("there should be a better alternative");

    private GeneralCodingRules() {
    }

    private static ArchCondition<JavaClass> accessStandardStreams() {
        ArchCondition<JavaClass> accessToSystemOut = ArchConditions.accessField(System.class, "out");
        ArchCondition<JavaClass> accessToSystemErr = ArchConditions.accessField(System.class, "err");
        ArchCondition<JavaClass> callOfPrintStackTrace = ArchConditions.callMethodWhere(JavaCall.Predicates.target(HasName.Predicates.name("printStackTrace")).and(JavaCall.Predicates.target(HasOwner.Predicates.With.owner(JavaClass.Predicates.assignableTo(Throwable.class)))).and(JavaCall.Predicates.target(HasParameterTypes.Predicates.rawParameterTypes(new Class[0]))));
        return accessToSystemOut.or(accessToSystemErr).or(callOfPrintStackTrace).as("access standard streams", new Object[0]);
    }

    private static ArchCondition<JavaClass> throwGenericExceptions() {
        ArchCondition<JavaClass> creationOfThrowable = ArchConditions.callCodeUnitWhere(JavaCall.Predicates.target(ArchPredicates.is(AccessTarget.Predicates.constructor()).and(ArchPredicates.is(AccessTarget.Predicates.declaredIn(Throwable.class)))));
        ArchCondition<JavaClass> creationOfException = ArchConditions.callCodeUnitWhere(JavaCall.Predicates.target(ArchPredicates.is(AccessTarget.Predicates.constructor()).and(ArchPredicates.is(AccessTarget.Predicates.declaredIn(Exception.class)))).and(DescribedPredicate.not(JavaAccess.Predicates.originOwner(ArchPredicates.is(JavaClass.Predicates.assignableTo(Exception.class))))));
        ArchCondition<JavaClass> creationOfRuntimeException = ArchConditions.callCodeUnitWhere(JavaCall.Predicates.target(ArchPredicates.is(AccessTarget.Predicates.constructor()).and(ArchPredicates.is(AccessTarget.Predicates.declaredIn(RuntimeException.class)))).and(DescribedPredicate.not(JavaAccess.Predicates.originOwner(ArchPredicates.is(JavaClass.Predicates.assignableTo(RuntimeException.class))))));
        return creationOfThrowable.or(creationOfException).or(creationOfRuntimeException).as("throw generic exceptions", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchRule testClassesShouldResideInTheSamePackageAsImplementation() {
        return GeneralCodingRules.testClassesShouldResideInTheSamePackageAsImplementation("Test");
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchRule testClassesShouldResideInTheSamePackageAsImplementation(String testClassSuffix) {
        return (ArchRule)ArchRuleDefinition.classes().should(GeneralCodingRules.resideInTheSamePackageAsTheirTestClasses(testClassSuffix)).as("test classes should reside in the same package as their implementation classes");
    }

    private static ArchCondition<JavaClass> resideInTheSamePackageAsTheirTestClasses(final String testClassSuffix) {
        return new ArchCondition<JavaClass>("reside in the same package as their test classes", new Object[0]){
            Map<String, List<JavaClass>> testClassesBySimpleClassName;
            {
                super(description, args);
                this.testClassesBySimpleClassName = new HashMap<String, List<JavaClass>>();
            }

            @Override
            public void init(Collection<JavaClass> allClasses) {
                this.testClassesBySimpleClassName = allClasses.stream().filter(clazz -> clazz.getName().endsWith(testClassSuffix)).collect(Collectors.groupingBy(JavaClass::getSimpleName));
            }

            @Override
            public void check(JavaClass implementationClass, ConditionEvents events) {
                boolean isTestClassInWrongPackage;
                String implementationClassName = implementationClass.getSimpleName();
                String implementationClassPackageName = implementationClass.getPackageName();
                String possibleTestClassName = implementationClassName + testClassSuffix;
                List<JavaClass> possibleTestClasses = this.testClassesBySimpleClassName.getOrDefault(possibleTestClassName, Collections.emptyList());
                boolean bl = isTestClassInWrongPackage = !possibleTestClasses.isEmpty() && possibleTestClasses.stream().noneMatch(clazz -> clazz.getPackageName().equals(implementationClassPackageName));
                if (isTestClassInWrongPackage) {
                    possibleTestClasses.forEach(wrongTestClass -> {
                        String message = ConditionEvent.createMessage(wrongTestClass, String.format("does not reside in same package as implementation class <%s>", implementationClass.getName()));
                        events.add(SimpleConditionEvent.violated(wrongTestClass, message));
                    });
                }
            }
        };
    }
}

