/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.mindmapmode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.basic.BasicIconFactory;
import javax.swing.tree.DefaultMutableTreeNode;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.SetBooleanPropertyAction;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.MenuSplitter;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.components.JAutoScrollBarPane;
import org.freeplane.core.ui.components.TagIcon;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.resizer.CollapseableBoxBuilder;
import org.freeplane.core.ui.components.resizer.JResizer;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.icon.CategorizedTag;
import org.freeplane.features.icon.CategorizedTagForCategoryNode;
import org.freeplane.features.icon.EmojiIcon;
import org.freeplane.features.icon.IconContainedCondition;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconExistsCondition;
import org.freeplane.features.icon.IconGroup;
import org.freeplane.features.icon.IconRegistry;
import org.freeplane.features.icon.IconStore;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagCategories;
import org.freeplane.features.icon.TagReference;
import org.freeplane.features.icon.Tags;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.icon.mindmapmode.EditTagsAction;
import org.freeplane.features.icon.mindmapmode.FastAccessableIcons;
import org.freeplane.features.icon.mindmapmode.IconAction;
import org.freeplane.features.icon.mindmapmode.IconActionRemovesIconIfExistsPropertyAction;
import org.freeplane.features.icon.mindmapmode.ManageTagCategoriesAction;
import org.freeplane.features.icon.mindmapmode.RemoveAllIconsAction;
import org.freeplane.features.icon.mindmapmode.RemoveIconAction;
import org.freeplane.features.icon.mindmapmode.TagEditor;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.styles.ConditionPredicate;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.LogicalStyleKeys;

public class MIconController
extends IconController {
    public static final String ICON_ACTION_REMOVES_ICON_IF_EXISTS_ACTION = SetBooleanPropertyAction.actionKey((String)"iconActionRemovesIconIfExists");
    public static final String REMOVE_FIRST_ICON_ACTION = "RemoveIcon_0_Action";
    public static final String REMOVE_LAST_ICON_ACTION = "RemoveIconAction";
    public static final String REMOVE_ALL_ICONS_ACTION = "RemoveAllIconsAction";
    private static final String RECENTLY_USED_ICONS_PROPERTY = "recently_used_icons";
    private static final String ADD_EMOJIS_TO_MENU = "add_emojis_to_menu";
    private static final String ADD_EMOJIS_TO_ICON_TOOLBAR = "add_emojis_to_icon_toolbar";
    private static final Insets ICON_SUBMENU_INSETS = new Insets(3, 0, 3, 0);
    private static final ConditionPredicate DEPENDS_ON_ICON = new ConditionPredicate(){

        public boolean test(ICondition condition) {
            return condition instanceof IconContainedCondition || condition instanceof IconExistsCondition;
        }
    };
    private final Map<String, AFreeplaneAction> iconActions = new LinkedHashMap<String, AFreeplaneAction>();
    private final IconStore STORE = IconStoreFactory.ICON_STORE;
    private final JToolBar iconToolBar;
    private final Box iconBox;
    private final FastAccessableIcons recentlyUsedIcons;
    private final MModeController modeController;
    private static final Icon SUBMENU_ICON = BasicIconFactory.getMenuArrowIcon();

    public MIconController(MModeController modeController) {
        super((ModeController)modeController);
        this.modeController = modeController;
        modeController.registerExtensionCopier(new ExtensionCopier());
        this.iconToolBar = new FreeplaneToolBar("icon_toolbar", 1);
        JAutoScrollBarPane iconToolBarScrollPane = new JAutoScrollBarPane((Component)this.iconToolBar);
        UITools.setScrollbarIncrement((JScrollPane)iconToolBarScrollPane);
        UITools.addScrollbarIncrementPropertyListener((JScrollPane)iconToolBarScrollPane);
        this.iconBox = new CollapseableBoxBuilder("leftToolbarVisible").createBox((Component)iconToolBarScrollPane, JResizer.Direction.LEFT);
        this.createIconActions();
        modeController.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "icon_actions", new IconMenuBuilder(modeController));
        this.recentlyUsedIcons = new FastAccessableIcons(modeController);
        String freeplaneUserDirectory = ResourceController.getResourceController().getFreeplaneUserDirectory();
        modeController.addAction(new EditTagsAction(this));
        modeController.addAction(new ManageTagCategoriesAction());
    }

    public void install(final ModeController modeController) {
        super.install(modeController);
        modeController.getMapController().addUINodeChangeListener(new INodeChangeListener(){

            public void nodeChanged(NodeChangeEvent event) {
                NodeModel node = event.getNode();
                if (event.getProperty().equals("icon") && LogicalStyleController.getController().conditionalStylesOf(node).dependsOnConditionRecursively(DEPENDS_ON_ICON)) {
                    modeController.getMapController().delayedNodeRefresh(node, NodeModel.UNKNOWN_PROPERTY, null, null);
                }
            }
        });
    }

    public void addIconByUserAction(NodeModel node, IconAction action) {
        this.addIcon(node, (NamedIcon)action.getMindIcon());
        this.recentlyUsedIcons.add(action);
    }

    public void addIcon(final NodeModel node, final NamedIcon icon) {
        IActor actor = new IActor(){

            public void act() {
                node.addIcon(icon);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon", null, (Object)icon);
            }

            public String getDescription() {
                return "addIcon";
            }

            public void undo() {
                node.removeIcon();
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon", (Object)icon, null);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    public void addIcon(final NodeModel node, final MindIcon icon, final int position) {
        IActor actor = new IActor(){

            public void act() {
                node.addIcon((NamedIcon)icon, position);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon", null, (Object)icon);
            }

            public String getDescription() {
                return "addIcon";
            }

            public void undo() {
                node.removeIcon(position);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon", (Object)icon, null);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    public void changeIconSize(final NodeModel node, final Quantity<LengthUnit> iconSize) {
        IActor actor = new IActor(){
            private Quantity<LengthUnit> oldIconSize;

            public void act() {
                this.oldIconSize = node.getSharedData().getIcons().getIconSize();
                node.getSharedData().getIcons().setIconSize(iconSize);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon_size", null, (Object)iconSize);
            }

            public String getDescription() {
                return "changeIconSize";
            }

            public void undo() {
                node.getSharedData().getIcons().setIconSize(this.oldIconSize);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon_size", this.oldIconSize, null);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    private void createIconActions() {
        this.modeController.addAction((AFreeplaneAction)new RemoveIconAction(0));
        this.modeController.addAction((AFreeplaneAction)new RemoveIconAction(-1));
        this.modeController.addAction((AFreeplaneAction)new RemoveAllIconsAction());
        this.modeController.addAction((AFreeplaneAction)new IconActionRemovesIconIfExistsPropertyAction());
        for (MindIcon icon : this.STORE.getMindIcons()) {
            IconAction myAction = new IconAction(icon);
            this.modeController.addActionIfNotAlreadySet((AFreeplaneAction)myAction);
            this.iconActions.put(icon.getName(), (AFreeplaneAction)myAction);
        }
    }

    public Collection<AFreeplaneAction> getIconActions() {
        return Collections.unmodifiableCollection(this.iconActions.values());
    }

    public Collection<AFreeplaneAction> getIconActions(Predicate<MindIcon> filter) {
        return this.iconActions.values().stream().filter(action -> filter.test(((IconAction)((Object)action)).getMindIcon())).collect(Collectors.toList());
    }

    public Map<String, AFreeplaneAction> getAllIconActions() {
        return Collections.unmodifiableMap(this.iconActions);
    }

    public JComponent getIconToolBarScrollPane() {
        return this.iconBox;
    }

    private JMenu getIconSubmenu(IconGroup group) {
        JMenu menu = this.createIconToolbarSubmenu(group);
        this.fillIconSubmenuOnSelect(menu, group);
        return menu;
    }

    private void fillIconSubmenuOnSelect(final JMenu menu, final IconGroup group) {
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                menu.removeMenuListener(this);
                this.fillIconSubmenu(menu, group);
            }

            private void fillIconSubmenu(JMenu menu2, IconGroup group2) {
                for (IconGroup childGroup : group2.getGroups()) {
                    if (childGroup.isLeaf()) {
                        MindIcon groupIcon = childGroup.getGroupIcon();
                        MIconController.this.addActionToIconSubmenu(menu2, groupIcon);
                        continue;
                    }
                    JMenu submenu = new JMenu(childGroup.getDescription());
                    submenu.setIcon(childGroup.getGroupIcon().getIcon());
                    MIconController.this.fillIconSubmenuOnSelect(submenu, childGroup);
                    MIconController.this.addGroupToIconSubmenu(menu2, submenu);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    private JMenu createIconToolbarSubmenu(IconGroup group) {
        JMenu menu = new JMenu(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Point getPopupMenuOrigin() {
                return new Point(this.getWidth(), 0);
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                int x = this.getWidth() - SUBMENU_ICON.getIconWidth();
                int y = (this.getHeight() - SUBMENU_ICON.getIconHeight()) / 2;
                SUBMENU_ICON.paintIcon(this, g, x, y);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension result = super.getPreferredSize();
                result.width += SUBMENU_ICON.getIconWidth();
                return result;
            }
        };
        menu.setMargin(ICON_SUBMENU_INSETS);
        menu.setIcon(group.getGroupIcon().getIcon());
        menu.setToolTipText(group.getDescription());
        return menu;
    }

    private void addGroupToIconSubmenu(JMenu menu, JMenu submenu) {
        new MenuSplitter().addMenuComponent(menu, (Component)submenu, menu.getItemCount());
    }

    private void addActionToIconSubmenu(JMenu menu, MindIcon icon) {
        AFreeplaneAction myAction = this.iconActions.get(icon.getName());
        new MenuSplitter().addMenuComponent(menu, (Component)new JMenuItem((Action)myAction), menu.getItemCount());
    }

    private void insertToolbarIconSubmenus(JToolBar iconToolBar, boolean isStructured) {
        JMenuBar iconMenuBar = new JMenuBar(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMaximumSize() {
                Dimension preferredSize = this.getPreferredSize();
                return new Dimension(Short.MAX_VALUE, preferredSize.height);
            }
        };
        iconMenuBar.setAlignmentX(0.5f);
        iconMenuBar.setLayout(new GridLayout(0, 1));
        for (IconGroup iconGroup : this.STORE.getGroups()) {
            if ((!isStructured || iconGroup.getName().equals("emoji_group") && !this.areEmojisAvailbleOnIconToolbar()) && (!iconGroup.getName().equals("emoji_group") || !this.areEmojisAvailbleOnIconToolbar())) continue;
            iconMenuBar.add(this.getIconSubmenu(iconGroup));
        }
        iconToolBar.add(iconMenuBar);
    }

    boolean areEmojisAvailbleFromMenu() {
        return ResourceController.getResourceController().getBooleanProperty(ADD_EMOJIS_TO_MENU);
    }

    boolean areEmojisAvailbleOnIconToolbar() {
        return ResourceController.getResourceController().getBooleanProperty(ADD_EMOJIS_TO_ICON_TOOLBAR);
    }

    public void removeAllIcons(NodeModel node) {
        int size = node.getIcons().size();
        MIconController iconController = (MIconController)IconController.getController();
        for (int i = 0; i < size; ++i) {
            iconController.removeIcon(node, 0);
        }
    }

    public int removeIcon(NodeModel node) {
        return this.removeIcon(node, -1);
    }

    public boolean removeIcon(NodeModel node, NamedIcon removedIcon) {
        List icons = node.getIcons();
        int iconCount = icons.size();
        for (int i = 0; i < iconCount; ++i) {
            if (!removedIcon.getName().equals(((NamedIcon)icons.get(i)).getName())) continue;
            this.removeIcon(node, i);
            return true;
        }
        return false;
    }

    public int removeIcon(final NodeModel node, int position) {
        int index;
        int size = node.getIcons().size();
        int n = index = position >= 0 ? position : size + position;
        if (size == 0 || size <= index) {
            return size;
        }
        IActor actor = new IActor(){
            private final NamedIcon icon;
            {
                this.icon = node.getIcon(index);
            }

            public void act() {
                node.removeIcon(index);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon", (Object)this.icon, null);
            }

            public String getDescription() {
                return "removeIcon";
            }

            public void undo() {
                node.addIcon(this.icon, index);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon", null, (Object)this.icon);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
        return node.getIcons().size();
    }

    private void updateIconToolbar(ModeController modeController) {
        this.iconToolBar.removeAll();
        AbstractButton[] buttons = new AbstractButton[]{FreeplaneToolBar.createButton((AFreeplaneAction)modeController.getAction(ICON_ACTION_REMOVES_ICON_IF_EXISTS_ACTION)), FreeplaneToolBar.createButton((AFreeplaneAction)modeController.getAction(REMOVE_FIRST_ICON_ACTION)), FreeplaneToolBar.createButton((AFreeplaneAction)modeController.getAction(REMOVE_LAST_ICON_ACTION)), FreeplaneToolBar.createButton((AFreeplaneAction)modeController.getAction(REMOVE_ALL_ICONS_ACTION))};
        FreeplaneToolBar actionPanel = new FreeplaneToolBar(1);
        Stream.of(buttons).forEach(arg_0 -> ((FreeplaneToolBar)actionPanel).add(arg_0));
        this.iconToolBar.add((Component)actionPanel);
        this.iconToolBar.addSeparator();
        this.recentlyUsedIcons.load(ResourceController.getResourceController().getProperty(RECENTLY_USED_ICONS_PROPERTY, ""));
        this.iconToolBar.add((Component)((Object)this.recentlyUsedIcons.createActionPanel(new AFreeplaneAction[0])));
        boolean isStructured = ResourceController.getResourceController().getBooleanProperty("structured_icon_toolbar");
        if (!isStructured && this.areEmojisAvailbleOnIconToolbar()) {
            this.iconToolBar.addSeparator();
        }
        this.insertToolbarIconSubmenus(this.iconToolBar, isStructured);
        if (!isStructured) {
            this.iconToolBar.addSeparator();
            for (MindIcon mindIcon : this.STORE.getMindIcons()) {
                if (mindIcon instanceof EmojiIcon) continue;
                AFreeplaneAction iconAction = this.iconActions.get(mindIcon.getName());
                this.iconToolBar.add((Action)iconAction).setAlignmentX(0.5f);
            }
        }
    }

    public void saveRecentlyUsedActions() {
        String initializer = this.recentlyUsedIcons.getInitializer();
        ResourceController.getResourceController().setProperty(RECENTLY_USED_ICONS_PROPERTY, initializer);
    }

    public FastAccessableIcons.ActionPanel createActionPanelWithControlActions() {
        return this.recentlyUsedIcons.createActionPanel(this.modeController.getAction(ICON_ACTION_REMOVES_ICON_IF_EXISTS_ACTION), this.modeController.getAction(REMOVE_FIRST_ICON_ACTION), this.modeController.getAction(REMOVE_LAST_ICON_ACTION), this.modeController.getAction(REMOVE_ALL_ICONS_ACTION));
    }

    public void setTags(NodeModel node, List<Tag> newTags, boolean overwriteColors) {
        TagCategories tagCategories = this.getTagCategories(node);
        List<TagReference> registeredTags = newTags.stream().map(arg_0 -> ((TagCategories)tagCategories).registerTagReference(arg_0)).collect(Collectors.toList());
        this.setTagReferences(node, registeredTags);
        if (overwriteColors) {
            IntStream.range(0, newTags.size()).filter(tagIndex -> !((Tag)newTags.get(tagIndex)).getColor().equals(((TagReference)registeredTags.get(tagIndex)).getColor())).forEach(tagIndex -> {
                Tag newTag = (Tag)newTags.get(tagIndex);
                Color newColor = newTag.getColor();
                this.setTagColor(node.getMap(), newTag, newColor);
            });
        }
    }

    public void setTagReferences(final NodeModel node, final List<TagReference> registeredTags) {
        final List oldTags = this.getTagReferences(node);
        IActor actor = new IActor(){

            public void undo() {
                Tags.setTagReferences((NodeModel)node, (List)oldTags);
                MIconController.this.modeController.getMapController().nodeChanged(node, Tags.class, (Object)registeredTags, (Object)oldTags);
            }

            public String getDescription() {
                return "setTags";
            }

            public void act() {
                Tags.setTagReferences((NodeModel)node, (List)registeredTags);
                MIconController.this.modeController.getMapController().nodeChanged(node, Tags.class, (Object)oldTags, (Object)registeredTags);
            }
        };
        this.modeController.execute(actor, node.getMap());
    }

    private TagCategories getTagCategories(NodeModel node) {
        return node.getMap().getIconRegistry().getTagCategories();
    }

    private void setTagColor(final MapModel map, final Tag tag, final Color newColor) {
        final TagCategories tagCategories = map.getIconRegistry().getTagCategories();
        final Color oldColor = tagCategories.getTagColor(tag);
        if (oldColor.equals(newColor)) {
            return;
        }
        IActor actor = new IActor(){

            public void undo() {
                this.setTagColorWithoutUndo(map, tag, newColor, oldColor);
            }

            public String getDescription() {
                return "set tag color";
            }

            public void act() {
                this.setTagColorWithoutUndo(map, tag, oldColor, newColor);
            }

            private void setTagColorWithoutUndo(MapModel map2, Tag tag2, Color oldColor2, Color newColor2) {
                tagCategories.setTagColor(tag2.getContent(), newColor2);
                Controller.getCurrentModeController().getMapController().fireMapChanged(new MapChangeEvent((Object)MIconController.this, map2, (Object)tag2, (Object)oldColor2, (Object)newColor2));
            }
        };
        Controller.getCurrentModeController().execute(actor, map);
    }

    public void editTags(NodeModel node) {
        TagEditor.TagEditorHolder extension = (TagEditor.TagEditorHolder)node.getExtension(TagEditor.TagEditorHolder.class);
        if (extension != null) {
            extension.activate();
        } else {
            RootPaneContainer frame = (RootPaneContainer)((Object)UITools.getCurrentRootComponent());
            new TagEditor(this, frame, node).show();
        }
    }

    public JMenu createTagSubmenu(String name, TagCategories tagCategories, Consumer<CategorizedTag> action) {
        JMenu menu = TranslatedElementFactory.createMenu((String)name);
        this.fillTagSubmenuOnSelect(menu, tagCategories, action, tagCategories.getRootNode());
        return menu;
    }

    private void fillTagSubmenuOnSelect(final JMenu menu, final TagCategories tagCategories, final Consumer<CategorizedTag> action, final DefaultMutableTreeNode categoryNode) {
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                this.fillTagSubmenu(menu, categoryNode);
            }

            private void fillTagSubmenu(JMenu menu2, DefaultMutableTreeNode categoryNode2) {
                menu2.removeAll();
                for (int i = 0; i < categoryNode2.getChildCount(); ++i) {
                    DefaultMutableTreeNode itemNode = (DefaultMutableTreeNode)categoryNode2.getChildAt(i);
                    Object userObject = itemNode.getUserObject();
                    if (userObject instanceof Tag) {
                        Tag tag = (Tag)userObject;
                        TagIcon icon = new TagIcon(tag, menu2.getFont());
                        JMenuItem actionItem = new JMenuItem((Icon)icon);
                        actionItem.addActionListener(x -> action.accept(new CategorizedTagForCategoryNode(itemNode, tagCategories.getTag(tag))));
                        menu2.add(actionItem);
                        if (itemNode.isLeaf()) continue;
                        JMenu submenu = new JMenu();
                        submenu.setIcon((Icon)icon);
                        MIconController.this.fillTagSubmenuOnSelect(submenu, tagCategories, action, itemNode);
                        menu2.add(submenu);
                        continue;
                    }
                    if (itemNode.isLeaf()) continue;
                    JMenu submenu = new JMenu(userObject.toString());
                    MIconController.this.fillTagSubmenuOnSelect(submenu, tagCategories, action, itemNode);
                    menu2.add(submenu);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    public void removeSelectedTagsFromSelectedNodes(Set<Tag> selectedTags) {
        if (selectedTags.isEmpty()) {
            return;
        }
        Controller.getCurrentController().getSelection().getSelection().forEach(node -> this.removeTags((NodeModel)node, selectedTags));
    }

    public void insertTagsIntoSelectedNodes(List<Tag> selectedTags) {
        if (selectedTags.isEmpty()) {
            return;
        }
        Controller.getCurrentController().getSelection().getSelection().forEach(node -> this.addTags((NodeModel)node, selectedTags));
    }

    public void removeTags(NodeModel node, Set<Tag> removedTags) {
        List existingTags = this.getTags(node);
        ArrayList<TagReference> newTags = new ArrayList<TagReference>(existingTags.size());
        this.getTagReferences(node).stream().filter(ref -> !removedTags.contains(ref.getTag())).forEach(newTags::add);
        this.setTagReferences(node, newTags);
    }

    public void addTags(NodeModel node, List<Tag> addedTags) {
        List existingTags = this.getTags(node);
        HashSet existingTagSet = new HashSet(existingTags);
        ArrayList<TagReference> newTags = new ArrayList<TagReference>(existingTags.size() + addedTags.size());
        newTags.addAll(this.getTagReferences(node));
        TagCategories tagCategories = this.getTagCategories(node);
        addedTags.stream().filter(tag -> !existingTagSet.contains(tag)).map(arg_0 -> ((TagCategories)tagCategories).registerTagReference(arg_0)).forEach(newTags::add);
        this.setTagReferences(node, newTags);
    }

    public List<CategorizedTag> getCategorizedTags(List<Tag> tags, TagCategories tagCategories) {
        return tagCategories.categorizedTags(tags);
    }

    public void setTagCategories(MapModel map, final TagCategories newCategories) {
        final IconRegistry iconRegistry = map.getIconRegistry();
        final TagCategories oldCategories = iconRegistry.getTagCategories();
        IActor actor = new IActor(){

            public void undo() {
                iconRegistry.setTagCategories(oldCategories);
                oldCategories.updateTagReferences();
                Controller.getCurrentModeController().getMapController().fireMapChanged(new MapChangeEvent((Object)MIconController.this, Controller.getCurrentController().getMap(), TagCategories.class, (Object)newCategories, (Object)oldCategories));
            }

            public String getDescription() {
                return "setTagCategories";
            }

            public void act() {
                iconRegistry.setTagCategories(newCategories);
                newCategories.updateTagReferences();
                Controller.getCurrentModeController().getMapController().fireMapChanged(new MapChangeEvent((Object)MIconController.this, Controller.getCurrentController().getMap(), TagCategories.class, (Object)oldCategories, (Object)newCategories));
            }
        };
        this.modeController.execute(actor, map);
    }

    public void addTagsFromSpec(NodeModel target, String tagSpec) {
        String[] tags = tagSpec.split(System.lineSeparator());
        if (tags == null || tags.length == 0) {
            return;
        }
        List<Tag> addedTagList = Stream.of(tags).map(TagCategories::readTag).collect(Collectors.toList());
        this.addTags(target, addedTagList);
    }

    private static class ExtensionCopier
    implements IExtensionCopier {
        private ExtensionCopier() {
        }

        public void copy(Object key, NodeModel from, NodeModel to) {
            if (key.equals((Object)Keys.ICONS)) {
                this.copyIcons(from, to);
            }
            if (key.equals(LogicalStyleKeys.NODE_STYLE)) {
                this.copyIconSize(from, to);
            }
        }

        private void copyIconSize(NodeModel from, NodeModel to) {
            Quantity iconSize = from.getSharedData().getIcons().getIconSize();
            if (iconSize != null) {
                to.getSharedData().getIcons().setIconSize(iconSize);
            }
        }

        private void copyIcons(NodeModel from, NodeModel to) {
            List sourceIcons = from.getIcons();
            List targetIcons = to.getIcons();
            for (NamedIcon icon : sourceIcons) {
                if (targetIcons.contains(icon)) continue;
                to.addIcon(icon);
            }
        }

        public void remove(Object key, NodeModel from) {
            if (key.equals((Object)Keys.ICONS)) {
                while (from.removeIcon() > 0) {
                }
            }
            if (key.equals(LogicalStyleKeys.NODE_STYLE)) {
                this.removeIconSize(from);
            }
        }

        private void removeIconSize(NodeModel from) {
            from.getSharedData().getIcons().setIconSize(null);
        }

        public void remove(Object key, NodeModel from, NodeModel which) {
            if (key.equals((Object)Keys.ICONS)) {
                this.removeIcons(from, which);
            }
            if (key.equals(LogicalStyleKeys.NODE_STYLE) && which.getSharedData().getIcons().getIconSize() != null) {
                this.removeIconSize(from);
            }
        }

        private void removeIcons(NodeModel from, NodeModel which) {
            List targetIcons = from.getIcons();
            List whichIcons = which.getIcons();
            Iterator targetIconIterator = targetIcons.iterator();
            while (targetIconIterator.hasNext()) {
                NamedIcon icon = (NamedIcon)targetIconIterator.next();
                if (!whichIcons.contains(icon)) continue;
                targetIconIterator.remove();
            }
        }
    }

    private final class IconMenuBuilder
    implements EntryVisitor {
        private final ModeController modeController;

        public IconMenuBuilder(ModeController modeController) {
            this.modeController = modeController;
        }

        public void visit(Entry target) {
            this.addIcons(target);
            MIconController.this.updateIconToolbar(this.modeController);
        }

        private void addIcons(Entry target) {
            for (IconGroup iconGroup : MIconController.this.STORE.getGroups()) {
                this.addIconGroup(target, iconGroup, false);
            }
        }

        private void addIconGroup(Entry target, IconGroup group, boolean isEmoji) {
            if (group.getIcons().size() < 1) {
                return;
            }
            boolean bl = isEmoji = isEmoji || group.getName().equals("emoji_group");
            if (isEmoji && !MIconController.this.areEmojisAvailbleFromMenu()) {
                return;
            }
            Entry item = new Entry();
            item.setName("icons");
            EntryAccessor entryAccessor = new EntryAccessor();
            entryAccessor.drawMenuIconAlways(item);
            entryAccessor.setIcon(item, group.getGroupIcon().getIcon());
            entryAccessor.setText(item, group.getDescription());
            if (isEmoji) {
                entryAccessor.processUiOnPopup(item);
            }
            target.addChild(item);
            List childGroups = group.getGroups();
            for (IconGroup childGroup : childGroups) {
                if (childGroup.isLeaf()) {
                    MindIcon icon = childGroup.getGroupIcon();
                    Entry actionItem = entryAccessor.addChildAction(item, (AFreeplaneAction)MIconController.this.iconActions.get(icon.getName()));
                    entryAccessor.drawMenuIconAlways(actionItem);
                    continue;
                }
                this.addIconGroup(item, childGroup, isEmoji);
            }
            if (childGroups.isEmpty()) {
                Entry noActions = new Entry();
                noActions.setBuilders(new String[]{"noActions"});
                item.addChild(noActions);
            }
        }

        public boolean shouldSkipChildren(Entry entry) {
            return false;
        }
    }

    public static enum Keys {
        ICONS;

    }
}

