/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link.mindmapmode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.FocusManager;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.JComboBoxFactory;
import org.freeplane.core.ui.components.RenderedContent;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.ConnectorArrows;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.ConnectorShape;
import org.freeplane.features.link.HyperTextLinkModel;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.MapLinks;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.link.mindmapmode.AddConnectorAction;
import org.freeplane.features.link.mindmapmode.AddExecutionLinkAction;
import org.freeplane.features.link.mindmapmode.AddLocalLinkAction;
import org.freeplane.features.link.mindmapmode.AddMenuItemLinkAction;
import org.freeplane.features.link.mindmapmode.AddSelfConnectorAction;
import org.freeplane.features.link.mindmapmode.ClearLinkAnchorAction;
import org.freeplane.features.link.mindmapmode.ExtractLinkFromTextAction;
import org.freeplane.features.link.mindmapmode.MakeLinkFromAnchorAction;
import org.freeplane.features.link.mindmapmode.MakeLinkToAnchorAction;
import org.freeplane.features.link.mindmapmode.RemoveConnectorAction;
import org.freeplane.features.link.mindmapmode.RemoveLinkAction;
import org.freeplane.features.link.mindmapmode.SetLinkAnchorAction;
import org.freeplane.features.link.mindmapmode.SetLinkByFileChooserAction;
import org.freeplane.features.link.mindmapmode.SetLinkByTextFieldAction;
import org.freeplane.features.link.mindmapmode.editor.ConnectorEditorPanel;
import org.freeplane.features.map.DocuMapAttribute;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.spellchecker.mindmapmode.SpellCheckerController;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.LogicalStyleKeys;
import org.freeplane.features.styles.LogicalStyleModel;
import org.freeplane.features.styles.MapStyleModel;

public class MLinkController
extends LinkController {
    private static SetLinkByFileChooserAction setLinkByFileChooser;
    private static SetLinkByTextFieldAction setLinkByTextField;
    private String anchorID = "";
    private final MapLinkChanger mapLinkChanger = new MapLinkChanger();

    public MLinkController(ModeController modeController) {
        super(modeController);
    }

    protected void init() {
        super.init();
        this.anchorID = "";
        this.createActions();
        this.modeController.registerExtensionCopier((IExtensionCopier)new StyleCopier());
        this.modeController.getMapController().addUIMapChangeListener((IMapChangeListener)this.mapLinkChanger);
    }

    public ConnectorModel addConnector(NodeModel source, NodeModel target) {
        ConnectorModel connector = this.addConnector(source, target.createID());
        this.setNodeDependantStyle(source, target, connector);
        return connector;
    }

    public void changeArrowsOfArrowLink(final ConnectorModel link, final Optional<ConnectorArrows> arrows) {
        IActor actor = new IActor(){
            private final Optional<ConnectorArrows> oldArrows;
            {
                this.oldArrows = link.getArrows();
            }

            public void act() {
                link.setArrows(arrows);
                MLinkController.this.fireNodeConnectorChange(link);
            }

            public String getDescription() {
                return "changeArrowsOfArrowLink";
            }

            public void undo() {
                link.setArrows(this.oldArrows);
                MLinkController.this.fireNodeConnectorChange(link);
            }
        };
        Controller.getCurrentModeController().execute(actor, link.getSource().getMap());
    }

    private void createActions() {
        setLinkByFileChooser = new SetLinkByFileChooserAction();
        this.modeController.addAction((AFreeplaneAction)setLinkByFileChooser);
        AddConnectorAction addArrowLinkAction = new AddConnectorAction();
        this.modeController.addAction((AFreeplaneAction)addArrowLinkAction);
        setLinkByTextField = new SetLinkByTextFieldAction();
        this.modeController.addAction((AFreeplaneAction)setLinkByTextField);
        this.modeController.addAction((AFreeplaneAction)new RemoveLinkAction());
        this.modeController.addAction((AFreeplaneAction)new AddLocalLinkAction());
        this.modeController.addAction((AFreeplaneAction)new AddMenuItemLinkAction());
        this.modeController.addAction((AFreeplaneAction)new AddExecutionLinkAction());
        this.modeController.addAction((AFreeplaneAction)new ExtractLinkFromTextAction());
        this.modeController.addAction((AFreeplaneAction)new SetLinkAnchorAction());
        this.modeController.addAction((AFreeplaneAction)new MakeLinkToAnchorAction());
        this.modeController.addAction((AFreeplaneAction)new MakeLinkFromAnchorAction());
        this.modeController.addAction((AFreeplaneAction)new ClearLinkAnchorAction());
        this.modeController.addAction((AFreeplaneAction)new AddSelfConnectorAction());
    }

    protected void createArrowLinkPopup(final ConnectorModel link, JComponent arrowLinkPopup) {
        JTextArea targetLabelEditor;
        JTextArea middleLabelEditor;
        JTextArea sourceLabelEditor;
        super.createArrowLinkPopup(link, arrowLinkPopup);
        final boolean isDefault = MapStyleModel.isDefaultStyleNode((NodeModel)link.getSource());
        if (!isDefault) {
            this.addClosingAction(arrowLinkPopup, (Action)((Object)new RemoveConnectorAction(this, link)));
            this.addSeparator(arrowLinkPopup);
        }
        ConnectorEditorPanel comp = new ConnectorEditorPanel(this, link);
        comp.setAlignmentX(0.0f);
        arrowLinkPopup.add(comp);
        this.addSeparator(arrowLinkPopup);
        if (!isDefault) {
            sourceLabelEditor = new JTextArea(link.getSourceLabel().orElse(""));
            this.addTextEditor(arrowLinkPopup, "edit_source_label", sourceLabelEditor);
            middleLabelEditor = new JTextArea(link.getMiddleLabel().orElse(""));
            this.addTextEditor(arrowLinkPopup, "edit_middle_label", middleLabelEditor);
            targetLabelEditor = new JTextArea(link.getTargetLabel().orElse(""));
            this.addTextEditor(arrowLinkPopup, "edit_target_label", targetLabelEditor);
        } else {
            targetLabelEditor = null;
            middleLabelEditor = null;
            sourceLabelEditor = null;
        }
        arrowLinkPopup.addHierarchyListener(new HierarchyListener(){
            private Component focusOwner;
            private Window dialog;

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                final JComponent component = (JComponent)e.getComponent();
                if (component.isShowing()) {
                    if (this.dialog == null) {
                        this.dialog = SwingUtilities.getWindowAncestor(component);
                        this.dialog.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                component.putClientProperty("CANCEL", Boolean.TRUE);
                            }
                        });
                    }
                    if (this.focusOwner == null) {
                        this.focusOwner = FocusManager.getCurrentManager().getFocusOwner();
                    }
                    return;
                }
                if (this.focusOwner == null || !this.focusOwner.isShowing()) {
                    return;
                }
                this.focusOwner.requestFocus();
                if (Boolean.TRUE.equals(component.getClientProperty("CANCEL"))) {
                    return;
                }
                IMapSelection selection = Controller.getCurrentController().getSelection();
                if (selection == null || selection.getSelected() == null) {
                    return;
                }
                if (!isDefault) {
                    MLinkController.this.setSourceLabel(link, sourceLabelEditor.getText());
                    MLinkController.this.setTargetLabel(link, targetLabelEditor.getText());
                    MLinkController.this.setMiddleLabel(link, middleLabelEditor.getText());
                }
            }
        });
    }

    public void setConnectorStyle(final ConnectorModel link, final IStyle style) {
        final IStyle oldStyle = link.getStyle();
        if (style.equals((Object)oldStyle)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                link.setStyle(style);
                NodeModel node = link.getSource();
                MLinkController.this.fireNodeConnectorChange(link);
            }

            public String getDescription() {
                return "setConnectorStyle";
            }

            public void undo() {
                link.setStyle(oldStyle);
                NodeModel node = link.getSource();
                MLinkController.this.fireNodeConnectorChange(link);
            }
        };
        Controller.getCurrentModeController().execute(actor, link.getSource().getMap());
    }

    protected JComboBox createActionBox(AFreeplaneAction[] items) {
        JComboBox box = JComboBoxFactory.create();
        box.setEditable(false);
        Vector renderedContent = RenderedContent.of((Action[])items);
        box.setModel(new DefaultComboBoxModel(renderedContent));
        for (RenderedContent item : renderedContent) {
            if (!((AFreeplaneAction)item.value).isSelected()) continue;
            box.setSelectedItem(item);
            break;
        }
        box.setRenderer(RenderedContent.createRenderer());
        box.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RenderedContent item = (RenderedContent)e.getItem();
                JComboBox box = (JComboBox)e.getSource();
                ((AFreeplaneAction)item.value).actionPerformed(new ActionEvent(box, 1001, null));
            }
        });
        return box;
    }

    private void addSeparator(JComponent arrowLinkPopup) {
    }

    private void addTextEditor(JComponent popup, String label, JTextArea editor) {
        InputMap inputMap = editor.getInputMap();
        ActionMap actionMap = editor.getActionMap();
        KeyStroke close = KeyStroke.getKeyStroke("ENTER");
        inputMap.put(close, "CLOSE");
        actionMap.put("CLOSE", (Action)new LinkController.ClosePopupAction("CLOSE"));
        KeyStroke enter = KeyStroke.getKeyStroke("alt ENTER");
        KeyStroke enter2 = KeyStroke.getKeyStroke("shift ENTER");
        inputMap.put(enter, "INSERT_EOL");
        inputMap.put(enter2, "INSERT_EOL");
        actionMap.put("INSERT_EOL", (Action)new UITools.InsertEolAction());
        editor.setRows(5);
        editor.setColumns(30);
        final JPopupMenu popupMenu = new JPopupMenu();
        SpellCheckerController spellCheckerController = SpellCheckerController.getController();
        spellCheckerController.addSpellCheckerMenu(popupMenu);
        spellCheckerController.enableAutoSpell(editor, true);
        editor.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.handlePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.handlePopup(e);
            }

            private void handlePopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    e.consume();
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(editor, 22, 32);
        UITools.setScrollbarIncrement((JScrollPane)scrollPane);
        this.addPopupComponent(popup, TextUtils.getText((String)label), scrollPane);
    }

    public void setConnectorColor(final ConnectorModel arrowLink, final Optional<Color> color) {
        final Optional oldColor = arrowLink.getColor();
        if (color.equals(oldColor)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                arrowLink.setColor(color);
                NodeModel node = arrowLink.getSource();
                MLinkController.this.fireNodeConnectorChange(arrowLink);
            }

            public String getDescription() {
                return "setConnectorColor";
            }

            public void undo() {
                arrowLink.setColor(oldColor);
                NodeModel node = arrowLink.getSource();
                MLinkController.this.fireNodeConnectorChange(arrowLink);
            }
        };
        Controller.getCurrentModeController().execute(actor, arrowLink.getSource().getMap());
    }

    public void setConnectorDashArray(final ConnectorModel arrowLink, final Optional<int[]> dash) {
        final Optional oldDash = arrowLink.getDash();
        if (dash.equals(oldDash)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                arrowLink.setDash(dash);
                NodeModel node = arrowLink.getSource();
                MLinkController.this.fireNodeConnectorChange(arrowLink);
            }

            public String getDescription() {
                return "setConnectorDash";
            }

            public void undo() {
                arrowLink.setDash(oldDash);
                NodeModel node = arrowLink.getSource();
                MLinkController.this.fireNodeConnectorChange(arrowLink);
            }
        };
        Controller.getCurrentModeController().execute(actor, arrowLink.getSource().getMap());
    }

    public void setArrowLinkEndPoints(final ConnectorModel link, final Point startPoint, final Point endPoint) {
        IActor actor = new IActor(){
            private final Point oldEndPoint;
            private final Point oldStartPoint;
            {
                this.oldEndPoint = link.getEndInclination();
                this.oldStartPoint = link.getStartInclination();
            }

            public void act() {
                link.setStartInclination(startPoint);
                link.setEndInclination(endPoint);
                MLinkController.this.fireNodeConnectorChange(link);
            }

            public String getDescription() {
                return "setArrowLinkEndPoints";
            }

            public void undo() {
                link.setStartInclination(this.oldStartPoint);
                link.setEndInclination(this.oldEndPoint);
                MLinkController.this.fireNodeConnectorChange(link);
            }
        };
        Controller.getCurrentModeController().execute(actor, link.getSource().getMap());
    }

    public void setLink(NodeModel node, String link, int linkType) {
        if (link != null && !"".equals(link)) {
            try {
                URI uri = new URI(link);
                this.setLink(node, uri, linkType);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            return;
        }
        this.setLink(node, (URI)null, 0);
    }

    private URI relativeLink(URI argUri, NodeModel node, int linkType) {
        if (linkType == 1 && "file".equals(argUri.getScheme())) {
            try {
                File mapFile = node.getMap().getFile();
                return this.createRelativeURI(mapFile, argUri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return argUri;
    }

    public void setLinkTypeDependantLink(NodeModel node, URI argUri) {
        this.setLink(node, argUri, MLinkController.getLinkType());
    }

    public void setLinkTypeDependantLink(NodeModel node, File file) {
        this.setLink(node, file.toURI(), MLinkController.getLinkType());
    }

    public void setLinkTypeDependantLink(NodeModel node, String link) {
        this.setLink(node, link, MLinkController.getLinkType());
    }

    public void setLink(NodeModel node, URI argUri, int linkType) {
        Hyperlink hyperlink = argUri != null ? new Hyperlink(this.relativeLink(argUri, node, linkType)) : null;
        this.setLink(node, hyperlink);
    }

    public void setLink(final NodeModel node, final Hyperlink hyperlink) {
        IActor actor = new IActor(){
            private Hyperlink oldlink;
            private String oldTargetID;

            public void act() {
                NodeLinks links = NodeLinks.getLinkExtension((NodeModel)node);
                if (links != null) {
                    this.oldlink = links.getHyperLink(node);
                    this.oldTargetID = links.removeLocalHyperLink(node);
                } else {
                    links = NodeLinks.createLinkExtension((NodeModel)node);
                }
                if (hyperlink != null && hyperlink.toString().startsWith("#")) {
                    links.setLocalHyperlink(node, hyperlink.toString().substring(1));
                } else {
                    links.setHyperLink(hyperlink);
                }
                Controller.getCurrentModeController().getMapController().nodeChanged(node, NodeLinks.HYPERLINK_CHANGED, (Object)this.oldlink, (Object)hyperlink);
            }

            public String getDescription() {
                return "setLink";
            }

            public void undo() {
                NodeLinks links = NodeLinks.getLinkExtension((NodeModel)node);
                Hyperlink undoneLink = links.getHyperLink(node);
                links.setLocalHyperlink(node, this.oldTargetID);
                links.setHyperLink(this.oldlink);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, NodeLinks.HYPERLINK_CHANGED, (Object)undoneLink, (Object)this.oldlink);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    public void setLinkByFileChooser() {
        setLinkByFileChooser.setLinkByFileChooser();
    }

    public void setMiddleLabel(ConnectorModel model, String label) {
        String oldLabel;
        if (label == null) {
            label = "";
        }
        if (label.equals(oldLabel = model.getMiddleLabel().orElse(""))) {
            return;
        }
        MiddleLabelSetter actor = new MiddleLabelSetter(model, oldLabel, label);
        Controller.getCurrentModeController().execute((IActor)actor, model.getSource().getMap());
    }

    public void setSourceLabel(ConnectorModel model, String label) {
        String oldLabel;
        if (label == null) {
            label = "";
        }
        if (label.equals(oldLabel = model.getSourceLabel().orElse(""))) {
            return;
        }
        SourceLabelSetter actor = new SourceLabelSetter(model, label, oldLabel);
        Controller.getCurrentModeController().execute((IActor)actor, model.getSource().getMap());
    }

    public void setTargetLabel(ConnectorModel model, String label) {
        String oldLabel;
        if (label == null) {
            label = "";
        }
        if (label.equals(oldLabel = model.getTargetLabel().orElse(""))) {
            return;
        }
        TargetLabelSetter actor = new TargetLabelSetter(oldLabel, label, model);
        Controller.getCurrentModeController().execute((IActor)actor, model.getSource().getMap());
    }

    public ConnectorModel addConnector(NodeModel source, String targetID) {
        ConnectorModel connector = new ConnectorModel(source, targetID);
        AddArrowLinkActor actor = new AddArrowLinkActor(connector);
        Controller.getCurrentModeController().execute((IActor)actor, source.getMap());
        return connector;
    }

    public void removeArrowLink(final ConnectorModel arrowLink) {
        IActor actor = new IActor(){

            public void act() {
                NodeModel source = arrowLink.getSource();
                NodeLinks nodeLinks = NodeLinks.getLinkExtension((NodeModel)source);
                nodeLinks.removeArrowlink((NodeLinkModel)arrowLink);
                MLinkController.this.fireNodeConnectorChange(arrowLink);
            }

            public String getDescription() {
                return "removeArrowLink";
            }

            public void undo() {
                NodeModel source = arrowLink.getSource();
                NodeLinks nodeLinks = NodeLinks.createLinkExtension((NodeModel)source);
                nodeLinks.addArrowlink((NodeLinkModel)arrowLink);
                MLinkController.this.fireNodeConnectorChange(arrowLink);
            }
        };
        Controller.getCurrentModeController().execute(actor, arrowLink.getSource().getMap());
    }

    public void setShape(final ConnectorModel connector, final Optional<ConnectorShape> shape) {
        final Optional oldShape = connector.getShape();
        if (oldShape.equals(shape)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                connector.setShape(shape);
                NodeModel node = connector.getSource();
                MLinkController.this.fireNodeConnectorChange(connector);
            }

            public String getDescription() {
                return "setConnectorShape";
            }

            public void undo() {
                connector.setShape(oldShape);
                NodeModel node = connector.getSource();
                MLinkController.this.fireNodeConnectorChange(connector);
            }
        };
        Controller.getCurrentModeController().execute(actor, connector.getSource().getMap());
    }

    public void setWidth(final ConnectorModel connector, final Optional<Integer> width) {
        final Optional oldWidth = connector.getWidth();
        if (oldWidth.equals(width)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                connector.setWidth(width);
                NodeModel node = connector.getSource();
                MLinkController.this.fireNodeConnectorChange(connector);
            }

            public String getDescription() {
                return "setConnectorWidth";
            }

            public void undo() {
                connector.setWidth(oldWidth);
                NodeModel node = connector.getSource();
                MLinkController.this.fireNodeConnectorChange(connector);
            }
        };
        Controller.getCurrentModeController().execute(actor, connector.getSource().getMap());
    }

    public void setLabelFontSize(final ConnectorModel connector, final Optional<Integer> width) {
        final Optional oldWidth = connector.getLabelFontSize();
        if (oldWidth.equals(width)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                connector.setLabelFontSize(width);
                NodeModel node = connector.getSource();
                MLinkController.this.fireNodeConnectorChange(connector);
            }

            public String getDescription() {
                return "setConnectorWidth";
            }

            public void undo() {
                connector.setLabelFontSize(oldWidth);
                NodeModel node = connector.getSource();
                MLinkController.this.fireNodeConnectorChange(connector);
            }
        };
        Controller.getCurrentModeController().execute(actor, connector.getSource().getMap());
    }

    public void setLabelFontFamily(final ConnectorModel connector, final Optional<String> family) {
        final Optional oldFamily = connector.getLabelFontFamily();
        if (oldFamily.equals(family)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                connector.setLabelFontFamily(family);
                NodeModel node = connector.getSource();
                MLinkController.this.fireNodeConnectorChange(connector);
            }

            public String getDescription() {
                return "setConnectorWidth";
            }

            public void undo() {
                connector.setLabelFontFamily(oldFamily);
                NodeModel node = connector.getSource();
                MLinkController.this.fireNodeConnectorChange(connector);
            }
        };
        Controller.getCurrentModeController().execute(actor, connector.getSource().getMap());
    }

    public void setOpacity(final ConnectorModel connector, final Optional<Integer> alpha) {
        final Optional oldAlpha = connector.getAlpha();
        if (oldAlpha.equals(alpha)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                connector.setAlpha(alpha);
                NodeModel node = connector.getSource();
                MLinkController.this.fireNodeConnectorChange(connector);
            }

            public String getDescription() {
                return "setConnectorAlpha";
            }

            public void undo() {
                connector.setAlpha(oldAlpha);
                NodeModel node = connector.getSource();
                MLinkController.this.fireNodeConnectorChange(connector);
            }
        };
        Controller.getCurrentModeController().execute(actor, connector.getSource().getMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadURL(NodeModel node, ActionEvent e) {
        boolean addDocuMapAttribute;
        boolean bl = addDocuMapAttribute = node.getMap().containsExtension(DocuMapAttribute.class) && !this.modeController.containsExtension(DocuMapAttribute.class);
        if (addDocuMapAttribute) {
            this.modeController.addExtension(DocuMapAttribute.class, (IExtension)DocuMapAttribute.INSTANCE);
        }
        try {
            super.loadURL(node, e);
        }
        finally {
            if (addDocuMapAttribute) {
                this.modeController.removeExtension(DocuMapAttribute.class);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadURI(NodeModel node, Hyperlink uri) {
        boolean addDocuMapAttribute;
        boolean bl = addDocuMapAttribute = node.getMap().containsExtension(DocuMapAttribute.class) && !this.modeController.containsExtension(DocuMapAttribute.class);
        if (addDocuMapAttribute) {
            this.modeController.addExtension(DocuMapAttribute.class, (IExtension)DocuMapAttribute.INSTANCE);
        }
        try {
            super.loadURI(node, uri);
        }
        finally {
            if (addDocuMapAttribute) {
                this.modeController.removeExtension(DocuMapAttribute.class);
            }
        }
    }

    public String getAnchorID() {
        return this.anchorID;
    }

    public void setAnchorID(String anchorID) {
        this.anchorID = anchorID;
        AFreeplaneAction setLinkAnchorAction = this.modeController.getAction("SetLinkAnchorAction");
        boolean anchored = this.isAnchored();
        String tooltip = anchored ? TextUtils.format((String)(setLinkAnchorAction.getTooltipKey() + "_anchored"), (Object[])new Object[]{anchorID}) : TextUtils.getRawText((String)setLinkAnchorAction.getTooltipKey());
        setLinkAnchorAction.putValue("ShortDescription", (Object)tooltip);
        setLinkAnchorAction.putValue("LongDescription", (Object)tooltip);
        setLinkAnchorAction.setSelected(anchored);
        this.modeController.getAction("ClearLinkAnchorAction").setEnabled(anchored);
        this.modeController.getAction("MakeLinkToAnchorAction").setEnabled(anchored);
        this.modeController.getAction("MakeLinkFromAnchorAction").setEnabled(anchored);
    }

    public boolean isAnchored() {
        return this.anchorID != null && !this.anchorID.isEmpty();
    }

    public String getAnchorIDforNode(NodeModel node) {
        String link;
        String targetID = this.getAnchorID();
        if (this.isAnchored() && !targetID.matches("\\w+://")) {
            String targetMapFileName = targetID.substring(targetID.indexOf("/") + 1, targetID.lastIndexOf("#"));
            File sourceMapFile = node.getMap().getFile();
            if (sourceMapFile == null) {
                UITools.errorMessage((Object)TextUtils.getRawText((String)"map_not_saved"));
                return null;
            }
            String sourceMapFileNameURI = sourceMapFile.toURI().toString();
            link = sourceMapFileNameURI.substring(sourceMapFileNameURI.indexOf("/") + 1).equals(targetMapFileName) ? targetID.substring(targetID.lastIndexOf("#")) : targetID;
        } else {
            link = null;
        }
        return link;
    }

    public void setFormatNodeAsHyperlink(final NodeModel node, final Boolean enabled) {
        final NodeLinks links = NodeLinks.createLinkExtension((NodeModel)node);
        IActor actor = new IActor(){
            final Boolean old;
            {
                this.old = links.formatNodeAsHyperlink();
            }

            public void act() {
                links.setFormatNodeAsHyperlink(enabled);
                MLinkController.this.modeController.getMapController().nodeChanged(node);
            }

            public void undo() {
                links.setFormatNodeAsHyperlink(this.old);
                MLinkController.this.modeController.getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setFormatNodeAsHyperlink";
            }
        };
        this.modeController.execute(actor, node.getMap());
    }

    private void fireNodeConnectorChange(ConnectorModel arrowLink) {
        MapController mapController = Controller.getCurrentModeController().getMapController();
        mapController.nodeChanged(arrowLink.getSource(), NodeLinks.CONNECTOR, (Object)arrowLink, (Object)arrowLink);
        NodeModel target = arrowLink.getTarget();
        if (target != null) {
            mapController.nodeRefresh(target);
        }
    }

    public void deleteMapLinksForClone(final NodeModel model) {
        MapModel map = model.getMap();
        final MapLinks mapLinks = (MapLinks)map.getExtension(MapLinks.class);
        if (mapLinks != null) {
            IActor actor = new IActor(){

                public void undo() {
                    MLinkController.this.mapLinkChanger.insertMapLinks(mapLinks, model);
                }

                public String getDescription() {
                    return "deleteMapLinks";
                }

                public void act() {
                    MLinkController.this.mapLinkChanger.deleteMapLinks(mapLinks, model, model);
                }
            };
            this.modeController.execute(actor, map);
        }
    }

    public void insertMapLinksForClone(final NodeModel model) {
        MapModel map = model.getMap();
        final MapLinks mapLinks = (MapLinks)map.getExtension(MapLinks.class);
        if (mapLinks != null) {
            IActor actor = new IActor(){

                public void undo() {
                    MLinkController.this.mapLinkChanger.deleteMapLinks(mapLinks, model, model);
                }

                public String getDescription() {
                    return "deleteMapLinks";
                }

                public void act() {
                    MLinkController.this.mapLinkChanger.insertMapLinks(mapLinks, model);
                }
            };
            this.modeController.execute(actor, map);
        }
    }

    private void setNodeDependantStyle(NodeModel source, NodeModel target, ConnectorModel connector) {
        boolean nodeStyleWasSetToConnector;
        if (ResourceController.getResourceController().getBooleanProperty("assignsNodeDependantStylesToNewConnectors") && !(nodeStyleWasSetToConnector = this.setConnectorStyleSameAsNodeStyleIfAvailable(connector, source)) && source != target) {
            this.setConnectorStyleSameAsNodeStyleIfAvailable(connector, target);
        }
    }

    private boolean setConnectorStyleSameAsNodeStyleIfAvailable(ConnectorModel connector, NodeModel node) {
        IStyle style;
        IStyle styleExplicitlyAssigned = LogicalStyleModel.getStyle((NodeModel)node);
        IStyle iStyle = style = styleExplicitlyAssigned != null ? styleExplicitlyAssigned : LogicalStyleController.getController().getFirstStyle(node);
        if (MapStyleModel.DEFAULT_STYLE.equals((Object)style)) {
            return false;
        }
        MapModel map = node.getMap();
        MapStyleModel mapStyles = MapStyleModel.getExtension((MapModel)map);
        NodeModel styleNode = mapStyles.getStyleNode(style);
        if (NodeLinks.getSelfConnector((NodeModel)styleNode).isPresent()) {
            this.setConnectorStyle(connector, style);
            return true;
        }
        return false;
    }

    private final class MapLinkChanger
    implements IMapChangeListener {
        private MapLinkChanger() {
        }

        public void mapChanged(MapChangeEvent event) {
        }

        public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
        }

        public void onNodeInserted(NodeModel parent, final NodeModel model, int newIndex) {
            Controller.getCurrentController().getViewController().invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapModel map = model.getMap();
                    MapLinks links = (MapLinks)map.getExtension(MapLinks.class);
                    if (links != null) {
                        MapLinkChanger.this.insertMapLinks(links, model);
                        MapLinkChanger.this.updateMapLinksForTargetTree(links, model);
                    }
                }
            });
        }

        public void onNodeMoved(NodeMoveEvent nodeMoveEvent) {
        }

        public void onPreNodeDelete(NodeDeletionEvent nodeDeletionEvent) {
            NodeModel model = nodeDeletionEvent.node;
            MapModel map = model.getMap();
            MapLinks links = (MapLinks)map.getExtension(MapLinks.class);
            if (links != null) {
                this.deleteMapLinks(links, model, model);
                this.updateMapLinksForTargetTree(links, model);
            }
        }

        private void insertMapLinks(MapLinks links, NodeModel model) {
            List children = model.getChildren();
            for (NodeModel child : children) {
                this.insertMapLinks(links, child);
            }
            this.insertMapLinksForInsertedSourceNode(links, model);
        }

        private void insertMapLinksForInsertedSourceNode(MapLinks links, NodeModel model) {
            NodeLinks nodeLinks = NodeLinks.getLinkExtension((NodeModel)model);
            if (nodeLinks != null) {
                for (NodeLinkModel link : nodeLinks.getLinks()) {
                    links.add(link);
                }
            }
        }

        private void deleteMapLinks(MapLinks links, NodeModel deletionRoot, NodeModel node) {
            List children = node.getChildren();
            for (NodeModel child : children) {
                this.deleteMapLinks(links, deletionRoot, child);
            }
            NodeLinks nodeLinks = NodeLinks.getLinkExtension((NodeModel)node);
            if (nodeLinks != null) {
                nodeLinks.replaceMapLinksForDeletedSourceNode(links, deletionRoot, node);
            }
        }

        private void updateMapLinksForTargetTree(MapLinks links, NodeModel model) {
            List children = model.getChildren();
            for (NodeModel child : children) {
                this.updateMapLinksForTargetTree(links, child);
            }
            String id = model.getID();
            if (id == null) {
                return;
            }
            Set linkModels = links.get(id);
            if (linkModels == null || linkModels.isEmpty()) {
                return;
            }
            for (NodeLinkModel link : linkModels) {
                NodeModel source = link.getSource();
                if (link instanceof HyperTextLinkModel) {
                    Controller.getCurrentModeController().getMapController().delayedNodeRefresh(source, (Object)"icon", null, null);
                    continue;
                }
                if (!(link instanceof ConnectorModel)) continue;
                MLinkController.this.fireNodeConnectorChange((ConnectorModel)link);
            }
        }

        public void onPreNodeMoved(NodeMoveEvent nodeMoveEvent) {
        }
    }

    private static class StyleCopier
    implements IExtensionCopier {
        private StyleCopier() {
        }

        public void copy(Object key, NodeModel from, NodeModel to) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            this.copy(from, to);
        }

        public void copy(NodeModel from, NodeModel to) {
            Boolean formatNodeAsHyperlink = NodeLinks.formatNodeAsHyperlink((NodeModel)from);
            if (formatNodeAsHyperlink != null) {
                NodeLinks.createLinkExtension((NodeModel)to).setFormatNodeAsHyperlink(formatNodeAsHyperlink);
            }
        }

        public void remove(Object key, NodeModel from) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            NodeLinks model = NodeLinks.getLinkExtension((NodeModel)from);
            if (model != null) {
                model.setFormatNodeAsHyperlink(null);
            }
        }

        public void remove(Object key, NodeModel from, NodeModel which) {
            if (NodeLinks.formatNodeAsHyperlink((NodeModel)which) != null) {
                this.remove(key, from);
            }
        }
    }

    private final class MiddleLabelSetter
    implements IActor {
        private final ConnectorModel model;
        private final String oldLabel;
        private final String label;

        private MiddleLabelSetter(ConnectorModel model, String oldLabel, String label) {
            this.model = model;
            this.oldLabel = oldLabel;
            this.label = label;
        }

        public void act() {
            this.model.setMiddleLabel(this.label);
            MLinkController.this.fireNodeConnectorChange(this.model);
        }

        public String getDescription() {
            return "setMiddleLabel";
        }

        public void undo() {
            this.model.setMiddleLabel(this.oldLabel);
            MLinkController.this.fireNodeConnectorChange(this.model);
        }
    }

    private final class SourceLabelSetter
    implements IActor {
        private final ConnectorModel model;
        private final String label;
        private final String oldLabel;

        private SourceLabelSetter(ConnectorModel model, String label, String oldLabel) {
            this.model = model;
            this.label = label;
            this.oldLabel = oldLabel;
        }

        public void act() {
            this.model.setSourceLabel(this.label);
            MLinkController.this.fireNodeConnectorChange(this.model);
        }

        public String getDescription() {
            return "setSourceLabel";
        }

        public void undo() {
            this.model.setSourceLabel(this.oldLabel);
            MLinkController.this.fireNodeConnectorChange(this.model);
        }
    }

    private final class TargetLabelSetter
    implements IActor {
        private final String oldLabel;
        private final String label;
        private final ConnectorModel model;

        private TargetLabelSetter(String oldLabel, String label, ConnectorModel model) {
            this.oldLabel = oldLabel;
            this.label = label;
            this.model = model;
        }

        public void act() {
            this.model.setTargetLabel(this.label);
            MLinkController.this.fireNodeConnectorChange(this.model);
        }

        public String getDescription() {
            return "setTargetLabel";
        }

        public void undo() {
            this.model.setTargetLabel(this.oldLabel);
            MLinkController.this.fireNodeConnectorChange(this.model);
        }
    }

    private final class AddArrowLinkActor
    implements IActor {
        private final ConnectorModel arrowLink;

        private AddArrowLinkActor(ConnectorModel arrowLink) {
            this.arrowLink = arrowLink;
        }

        public void act() {
            NodeModel source = this.arrowLink.getSource();
            NodeLinks nodeLinks = NodeLinks.createLinkExtension((NodeModel)source);
            nodeLinks.addArrowlink((NodeLinkModel)this.arrowLink);
            MLinkController.this.fireNodeConnectorChange(this.arrowLink);
        }

        public String getDescription() {
            return "addLink";
        }

        public void undo() {
            NodeModel source = this.arrowLink.getSource();
            NodeLinks nodeLinks = NodeLinks.getLinkExtension((NodeModel)source);
            nodeLinks.removeArrowlink((NodeLinkModel)this.arrowLink);
            MLinkController.this.fireNodeConnectorChange(this.arrowLink);
        }
    }
}

