/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text.mindmapmode;

import com.jgoodies.common.base.Objects;
import com.lightdev.app.shtm.ActionBuilder;
import com.lightdev.app.shtm.SHTMLPanel;
import com.lightdev.app.shtm.SHTMLPanelImpl;
import com.lightdev.app.shtm.SHTMLWriter;
import com.lightdev.app.shtm.ScaledStyleSheet;
import com.lightdev.app.shtm.UIResources;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.CaseSensitiveFileNameExtensionFilter;
import org.freeplane.core.ui.IEditHandler;
import org.freeplane.core.ui.components.BitmapImagePreview;
import org.freeplane.core.ui.components.JFreeplaneCustomizableFileChooser;
import org.freeplane.core.ui.components.OptionalDontShowMeAgainDialog;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.collection.OptionalReference;
import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.IFormattedObject;
import org.freeplane.features.format.PatternFormat;
import org.freeplane.features.format.ScannerController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.LogicalStyleKeys;
import org.freeplane.features.styles.LogicalStyleModel;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.features.text.DetailModel;
import org.freeplane.features.text.IContentTransformer;
import org.freeplane.features.text.ShortenedTextModel;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.CoreTextEditorHolder;
import org.freeplane.features.text.mindmapmode.DeleteDetailsAction;
import org.freeplane.features.text.mindmapmode.DetailTextEditorHolder;
import org.freeplane.features.text.mindmapmode.EditAction;
import org.freeplane.features.text.mindmapmode.EditDetailsAction;
import org.freeplane.features.text.mindmapmode.EditLongAction;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.EventBuffer;
import org.freeplane.features.text.mindmapmode.IEditBaseCreator;
import org.freeplane.features.text.mindmapmode.IEditorPaneListener;
import org.freeplane.features.text.mindmapmode.JoinNodesAction;
import org.freeplane.features.text.mindmapmode.SHTMLEditLinkAction;
import org.freeplane.features.text.mindmapmode.SHTMLSetLinkByFileChooserAction;
import org.freeplane.features.text.mindmapmode.SetImageByFileChooserAction;
import org.freeplane.features.text.mindmapmode.SourceTextEditorUIConfigurator;
import org.freeplane.features.text.mindmapmode.SplitToWordsAction;
import org.freeplane.features.text.mindmapmode.UsePlainTextAction;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.ViewController;
import org.freeplane.features.url.UrlManager;

public class MTextController
extends TextController {
    private static final String PARSE_DATA_PROPERTY = "parse_data";
    public static final String NODE_TEXT = "NodeText";
    private static Pattern FORMATTING_PATTERN = null;
    private EditNodeBase currentBlockingEditor = null;
    private final Collection<IEditorPaneListener> editorPaneListeners;
    private final Set<String> detailContentTypes;
    private final EventBuffer eventQueue;
    private static final Pattern HTML_HEAD;
    private EditEventDispatcher keyEventDispatcher;
    private Boolean parseData;

    public static MTextController getController() {
        return (MTextController)TextController.getController();
    }

    public MTextController(ModeController modeController) {
        super(modeController);
        modeController.registerExtensionCopier((IExtensionCopier)new ExtensionCopier());
        this.eventQueue = new EventBuffer();
        this.editorPaneListeners = new LinkedList<IEditorPaneListener>();
        this.detailContentTypes = new LinkedHashSet<String>();
        this.detailContentTypes.add("auto");
        this.detailContentTypes.add("html");
        this.createActions();
        ResourceController.getResourceController().addPropertyChangeListener(new IFreeplanePropertyListener(){

            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (MTextController.PARSE_DATA_PROPERTY.equals(propertyName)) {
                    MTextController.this.parseData = null;
                    boolean bl = MTextController.this.parseData();
                }
            }
        });
    }

    private void createActions() {
        final ModeController modeController = Controller.getCurrentModeController();
        modeController.addAction((AFreeplaneAction)new EditAction());
        modeController.addAction((AFreeplaneAction)new UsePlainTextAction());
        modeController.addAction((AFreeplaneAction)new EditLongAction());
        modeController.addAction((AFreeplaneAction)new SetImageByFileChooserAction());
        modeController.addAction((AFreeplaneAction)new EditDetailsAction(false));
        modeController.addAction((AFreeplaneAction)new EditDetailsAction(true));
        modeController.addAction((AFreeplaneAction)new DeleteDetailsAction());
        modeController.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "splitToWordsActions", new EntryVisitor(){

            public void visit(Entry target) {
                String[] nodeNumbersInLine;
                for (String nodeNumberInLineAsString : nodeNumbersInLine = ResourceController.getResourceController().getProperty("SplitToWordsAction.nodeNumbersInLine").split("[^\\d]+")) {
                    try {
                        int nodeNumberInLine = Integer.parseInt(nodeNumberInLineAsString);
                        if (nodeNumberInLine <= 0) continue;
                        SplitToWordsAction action = new SplitToWordsAction(nodeNumberInLine);
                        new EntryAccessor().addChildAction(target, (AFreeplaneAction)action);
                        modeController.addAction((AFreeplaneAction)action);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }

            public boolean shouldSkipChildren(Entry entry) {
                return true;
            }
        });
        modeController.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "joinNodesActions", new EntryVisitor(){

            public void visit(Entry target) {
                String textSeparators = ResourceController.getResourceController().getProperty("JoinNodesAction.textSeparators");
                Pattern JOIN_NODES_ACTION_SEPARATORS = Pattern.compile("\\{\\{.*?\\}\\}");
                Matcher matcher = JOIN_NODES_ACTION_SEPARATORS.matcher(textSeparators);
                if (matcher.find()) {
                    do {
                        String textSeparator = textSeparators.substring(matcher.start() + 2, matcher.end() - 2);
                        this.addAction(modeController, target, textSeparator);
                    } while (matcher.find());
                } else {
                    this.addAction(modeController, target, textSeparators);
                }
            }

            private void addAction(ModeController modeController2, Entry target, String textSeparator) {
                JoinNodesAction action = new JoinNodesAction(textSeparator);
                new EntryAccessor().addChildAction(target, (AFreeplaneAction)action);
                modeController2.addAction((AFreeplaneAction)action);
                if (target.getChildCount() == 1) {
                    target.getChild(0).setAttribute("accelerator", target.getAttribute("accelerator"));
                }
            }

            public boolean shouldSkipChildren(Entry entry) {
                return true;
            }
        });
    }

    public boolean addDetailContentType(String e) {
        return this.detailContentTypes.add(e);
    }

    public String[] getDetailContentTypes() {
        return (String[])this.detailContentTypes.stream().toArray(String[]::new);
    }

    private String[] getContent(String text, int pos) {
        if (pos <= 0) {
            return null;
        }
        String[] strings = new String[2];
        if (HtmlUtils.isHtml((String)text)) {
            HTMLEditorKit kit = new HTMLEditorKit();
            HTMLDocument doc = new HTMLDocument();
            StringReader buf = new StringReader(text);
            try {
                int secondStart;
                int firstStart;
                kit.read(buf, (Document)doc, 0);
                char[] firstText = doc.getText(0, pos).toCharArray();
                int firstLen = pos;
                for (firstStart = 0; firstStart < firstLen && firstText[firstStart] <= ' '; ++firstStart) {
                }
                while (firstStart < firstLen && firstText[firstLen - 1] <= ' ') {
                    --firstLen;
                }
                int secondLen = doc.getLength() - pos;
                if (secondLen <= 0) {
                    return null;
                }
                char[] secondText = doc.getText(pos, secondLen).toCharArray();
                for (secondStart = 0; secondStart < secondLen && secondText[secondStart] <= ' '; ++secondStart) {
                }
                while (secondStart < secondLen && secondText[secondLen - 1] <= ' ') {
                    --secondLen;
                }
                if (firstStart == firstLen || secondStart == secondLen) {
                    return null;
                }
                StringWriter out = new StringWriter();
                new SHTMLWriter((Writer)out, doc, firstStart, firstLen - firstStart).write();
                strings[0] = out.toString();
                out = new StringWriter();
                new SHTMLWriter((Writer)out, doc, pos + secondStart, secondLen - secondStart).write();
                strings[1] = out.toString();
                return strings;
            }
            catch (IOException e) {
                LogUtils.severe((Throwable)e);
            }
            catch (BadLocationException e) {
                LogUtils.severe((Throwable)e);
            }
        } else {
            if (pos >= text.length()) {
                return null;
            }
            strings[0] = text.substring(0, pos);
            strings[1] = text.substring(pos);
        }
        return strings;
    }

    private String addContent(String joinedContent, boolean isHtml, String nodeContent, boolean isHtmlNode, String separator) {
        if (isHtml) {
            String[] joinedContentParts = JoinNodesAction.BODY_END.split(joinedContent, 2);
            joinedContent = joinedContentParts[0];
            if (!isHtmlNode) {
                String[] end = JoinNodesAction.BODY_START.split(joinedContent, 2);
                if (end.length == 1) {
                    end[0] = "<html>";
                }
                nodeContent = end[0] + "<body><p>" + HtmlUtils.toXMLEscapedTextExpandingWhitespace((String)nodeContent) + "</p>";
            }
        }
        if (isHtmlNode & !joinedContent.equals("")) {
            String[] nodeContentParts = JoinNodesAction.BODY_START.split(nodeContent, 2);
            if (nodeContentParts.length == 1) {
                nodeContent = nodeContent.substring(6);
                nodeContentParts[0] = "<html>";
            } else {
                nodeContent = nodeContentParts[1];
            }
            if (!isHtml) {
                joinedContent = nodeContentParts[0] + "<body><p>" + HtmlUtils.toXMLEscapedTextExpandingWhitespace((String)joinedContent) + "</p>";
            }
        }
        if (joinedContent.equals("")) {
            return nodeContent;
        }
        joinedContent = joinedContent + (isHtml ? HtmlUtils.toXMLEscapedTextExpandingWhitespace((String)separator) : separator);
        joinedContent = joinedContent + nodeContent;
        return joinedContent;
    }

    public void joinNodes(List<NodeModel> selectedNodes, String separator) {
        if (selectedNodes.isEmpty()) {
            return;
        }
        NodeModel selectedNode = selectedNodes.get(0);
        for (NodeModel node : selectedNodes) {
            if (node == selectedNode || !node.subtreeContainsCloneOf(selectedNode)) continue;
            UITools.errorMessage((Object)TextUtils.getText((String)"cannot_move_into_child_node"));
            return;
        }
        String joinedContent = "";
        Controller controller = Controller.getCurrentController();
        boolean isHtml = false;
        LinkedHashSet icons = new LinkedHashSet();
        for (NodeModel node : selectedNodes) {
            String nodeContent = node.getText();
            icons.addAll(node.getIcons());
            boolean isHtmlNode = HtmlUtils.isHtml((String)nodeContent);
            joinedContent = this.addContent(joinedContent, isHtml, nodeContent, isHtmlNode, separator);
            if (node != selectedNode) {
                MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
                mapController.moveNodes(node.getChildren(), selectedNode, selectedNode.getChildCount());
                mapController.deleteNode(node);
            }
            isHtml = isHtml || isHtmlNode;
        }
        controller.getSelection().selectAsTheOnlyOneSelected(selectedNode);
        this.setNodeText(selectedNode, joinedContent);
        MIconController iconController = (MIconController)IconController.getController();
        iconController.removeAllIcons(selectedNode);
        for (NamedIcon icon : icons) {
            iconController.addIcon(selectedNode, icon);
        }
    }

    public void setImageByFileChooser() {
        String uriString;
        boolean picturesAmongSelecteds = false;
        ModeController modeController = Controller.getCurrentModeController();
        for (NodeModel node : modeController.getMapController().getSelectedNodes()) {
            String linkString;
            String lowerCase;
            Hyperlink link = NodeLinks.getLink((NodeModel)node);
            if (link == null || !(lowerCase = (linkString = link.toString()).toLowerCase()).endsWith(".png") && !lowerCase.endsWith(".jpg") && !lowerCase.endsWith(".jpeg") && !lowerCase.endsWith(".gif")) continue;
            picturesAmongSelecteds = true;
            String encodedLinkString = HtmlUtils.unicodeToHTMLUnicodeEntity((String)linkString);
            String strText = "<html><img src=\"" + encodedLinkString + "\">";
            ((MLinkController)LinkController.getController()).setLink(node, (URI)null, 0);
            this.setNodeText(node, strText);
        }
        if (picturesAmongSelecteds) {
            return;
        }
        Controller controller = modeController.getController();
        ViewController viewController = controller.getViewController();
        NodeModel selectedNode = modeController.getMapController().getSelectedNode();
        MapModel map = selectedNode.getMap();
        File file = map.getFile();
        if (file == null && LinkController.getLinkType() == 1) {
            JOptionPane.showMessageDialog(viewController.getCurrentRootComponent(), TextUtils.getText((String)"not_saved_for_image_error"), "Freeplane", 2);
            return;
        }
        CaseSensitiveFileNameExtensionFilter filter = new CaseSensitiveFileNameExtensionFilter();
        filter.addExtension("jpg");
        filter.addExtension("jpeg");
        filter.addExtension("png");
        filter.addExtension("gif");
        filter.setDescription(TextUtils.getText((String)"bitmaps"));
        UrlManager urlManager = (UrlManager)modeController.getExtension(UrlManager.class);
        JFreeplaneCustomizableFileChooser chooser = urlManager.getFileChooser();
        chooser.setFileFilter((FileFilter)filter);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setAccessory((JComponent)new BitmapImagePreview((JFileChooser)chooser));
        int returnVal = chooser.showOpenDialog(viewController.getCurrentRootComponent());
        if (returnVal != 0) {
            return;
        }
        File input = chooser.getSelectedFile();
        URI uri = input.toURI();
        if (uri == null) {
            return;
        }
        if (!input.exists()) {
            uri = LinkController.toRelativeURI((File)map.getFile(), (File)input, (int)1);
            if (uri == null || !"http".equals(uri.getScheme())) {
                UITools.errorMessage((Object)TextUtils.format((String)"file_not_found", (Object[])new Object[]{input.toString()}));
                return;
            }
        } else if (LinkController.getLinkType() != 0) {
            uri = LinkController.toLinkTypeDependantURI((File)map.getFile(), (File)input);
        }
        if ((uriString = uri.toString()).startsWith("http:/")) {
            uriString = "http://" + uriString.substring("http:/".length());
        }
        String strText = "<html><img src=\"" + uriString + "\">";
        this.setNodeText(selectedNode, strText);
    }

    public void setGuessedNodeObject(NodeModel node, String newText) {
        if (HtmlUtils.isHtml((String)newText)) {
            this.setNodeObject(node, newText);
        } else {
            Object guessedObject = this.guessObject(newText, NodeStyleModel.getNodeFormat((NodeModel)node));
            if (guessedObject instanceof IFormattedObject) {
                this.setNodeObject(node, ((IFormattedObject)guessedObject).getObject());
            } else {
                this.setNodeObject(node, newText);
            }
        }
    }

    public Object guessObject(Object text, String oldFormat) {
        if (this.parseData() && text instanceof String) {
            if (PatternFormat.getIdentityPatternFormat().getPattern().equals(oldFormat)) {
                return text;
            }
            Object parseResult = ScannerController.getController().parse((String)text);
            if (oldFormat != null) {
                Object formatted = FormatController.format((Object)parseResult, (String)oldFormat, null);
                return formatted == null ? text : formatted;
            }
            return parseResult;
        }
        return text;
    }

    public boolean parseData() {
        if (this.parseData == null) {
            this.parseData = ResourceController.getResourceController().getBooleanProperty(PARSE_DATA_PROPERTY);
        }
        return this.parseData;
    }

    public void setNodeText(NodeModel node, String newText) {
        this.setNodeObject(node, newText);
    }

    public void setNodeObject(final NodeModel node, final Object newObject) {
        if (newObject == null) {
            this.setNodeObject(node, "");
            return;
        }
        final Object oldText = node.getUserObject();
        if (oldText.equals(newObject)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                if (!oldText.equals(newObject)) {
                    node.setUserObject(newObject);
                    Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"node_text", oldText, newObject);
                }
            }

            public String getDescription() {
                return "setNodeText";
            }

            public void undo() {
                if (!oldText.equals(newObject)) {
                    node.setUserObject(oldText);
                    Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"node_text", newObject, oldText);
                }
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    public void splitNode(NodeModel node, int caretPosition, String newText) {
        if (node.isRoot()) {
            return;
        }
        String oldText = node.getText();
        String futureText = newText != null ? newText : oldText;
        String[] strings = this.getContent(futureText, caretPosition);
        if (strings == null) {
            String mayBePlainText = this.makePlainIfNoFormattingFound(futureText);
            if (!Objects.equals((Object)mayBePlainText, (Object)oldText)) {
                this.setNodeObject(node, mayBePlainText);
            }
            return;
        }
        String newUpperContent = this.makePlainIfNoFormattingFound(strings[0]);
        String newLowerContent = this.makePlainIfNoFormattingFound(strings[1]);
        this.setNodeObject(node, newUpperContent);
        NodeModel parent = node.getParentNode();
        ModeController modeController = Controller.getCurrentModeController();
        NodeModel lowerNode = ((MMapController)modeController.getMapController()).addNewNode(parent, parent.getIndex(node) + 1, node.getSide());
        MNodeStyleController nodeStyleController = (MNodeStyleController)NodeStyleController.getController();
        MLogicalStyleController.getController().setStyle(lowerNode, LogicalStyleModel.getStyle((NodeModel)node));
        nodeStyleController.copyStyle(node, lowerNode);
        this.setNodeObject(lowerNode, newLowerContent);
    }

    public boolean useRichTextInEditor(String key) {
        int showResult = OptionalDontShowMeAgainDialog.show((String)("OptionPanel." + key), (String)"edit.decision", (String)key, (OptionalDontShowMeAgainDialog.MessageType)OptionalDontShowMeAgainDialog.MessageType.BOTH_OK_AND_CANCEL_OPTIONS_ARE_STORED);
        return showResult == 0;
    }

    public void editDetails(NodeModel nodeModel, InputEvent e, boolean editInDialog) {
        boolean addsNewDetailsUsingInlineEditor;
        Controller controller = Controller.getCurrentController();
        this.stopInlineEditing();
        DetailTextEditorHolder editorHolder = (DetailTextEditorHolder)nodeModel.getExtension(DetailTextEditorHolder.class);
        if (editorHolder != null) {
            editorHolder.activate();
            return;
        }
        DetailModel detail = DetailModel.getDetail((NodeModel)nodeModel);
        boolean bl = addsNewDetailsUsingInlineEditor = detail == null || detail.getText() == null && !editInDialog;
        if (addsNewDetailsUsingInlineEditor) {
            MTextController textController = MTextController.getController();
            textController.setDetails(nodeModel, "<html>");
        }
        if (detail == null) {
            detail = new DetailModel(false);
        }
        NodeDetailsEditor editControl = new NodeDetailsEditor(addsNewDetailsUsingInlineEditor, nodeModel);
        Window window = SwingUtilities.getWindowAncestor(controller.getMapViewManager().getMapViewComponent());
        EditNodeBase editor = this.createEditor(nodeModel, detail, detail.getTextOr(""), editControl, false, editInDialog, true);
        editor.show(window);
    }

    private void setDetailsHtmlText(NodeModel node, String newText) {
        if (newText != null) {
            String body = this.removeHtmlHead(newText);
            this.setDetails(node, body.replaceFirst("\\s+$", ""));
        } else {
            this.setDetails(node, null);
        }
    }

    public void setDetails(NodeModel node, String newText) {
        if ("".equals(newText)) {
            this.setDetails(node, null);
            return;
        }
        String oldText = DetailModel.getDetailText((NodeModel)node);
        if (oldText == newText || null != oldText && oldText.equals(newText)) {
            return;
        }
        DetailModel oldDetails = DetailModel.getDetail((NodeModel)node);
        DetailModel newDetails = oldDetails == null ? new DetailModel(false) : oldDetails.copy();
        newDetails.setText(newText);
        this.setDetails(node, oldDetails, newDetails, "setDetailText");
    }

    public void setDetailsContentType(NodeModel node, String newContentType) {
        String oldContentType = DetailModel.getDetailContentType((NodeModel)node);
        if (oldContentType == newContentType || null != oldContentType && oldContentType.equals(newContentType)) {
            return;
        }
        DetailModel oldDetails = DetailModel.getDetail((NodeModel)node);
        DetailModel newDetails = oldDetails == null ? new DetailModel(false) : oldDetails.copy();
        newDetails.setContentType(newContentType);
        this.setDetails(node, oldDetails, newDetails, "setDetailContentType");
    }

    private void setDetails(final NodeModel node, final DetailModel oldDetails, final DetailModel newDetails, final String description) {
        IActor actor = new IActor(){

            public void act() {
                this.setDetails(newDetails);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, DetailModel.class, (Object)oldDetails, (Object)newDetails);
            }

            public String getDescription() {
                return description;
            }

            public void undo() {
                this.setDetails(oldDetails);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, DetailModel.class, (Object)newDetails, (Object)oldDetails);
            }

            private void setDetails(DetailModel details) {
                if (details == null || details.isEmpty()) {
                    node.removeExtension(DetailModel.class);
                } else {
                    node.putExtension((IExtension)details);
                }
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    public void setDetailsHidden(final NodeModel node, final boolean isHidden) {
        this.stopInlineEditing();
        DetailModel details = (DetailModel)node.getExtension(DetailModel.class);
        if (details == null || details.isHidden() == isHidden) {
            return;
        }
        IActor actor = new IActor(){

            public boolean isReadonly() {
                return true;
            }

            public void act() {
                this.setHidden(isHidden);
            }

            public String getDescription() {
                return "setDetailsHidden";
            }

            private void setHidden(boolean isHidden2) {
                DetailModel details = DetailModel.createDetailText((NodeModel)node);
                details.setHidden(isHidden2);
                node.addExtension((IExtension)details);
                NodeChangeEvent nodeChangeEvent = new NodeChangeEvent(node, (Object)"DETAILS_HIDDEN", (Object)(!isHidden2 ? 1 : 0), (Object)isHidden2, true, false);
                Controller.getCurrentModeController().getMapController().nodeRefresh(nodeChangeEvent);
            }

            public void undo() {
                this.setHidden(!isHidden);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    public void setIsMinimized(final NodeModel node, final boolean state) {
        ShortenedTextModel details = (ShortenedTextModel)node.getExtension(ShortenedTextModel.class);
        if (details == null && !state || details != null && state) {
            return;
        }
        IActor actor = new IActor(){

            public boolean isReadonly() {
                return true;
            }

            public void act() {
                this.setShortener(state);
            }

            public String getDescription() {
                return "setShortener";
            }

            private void setShortener(boolean state2) {
                if (state2) {
                    ShortenedTextModel details = ShortenedTextModel.createShortenedTextModel((NodeModel)node);
                    node.addExtension((IExtension)details);
                } else {
                    node.removeExtension(ShortenedTextModel.class);
                }
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"SHORTENER", (Object)(!state2 ? 1 : 0), (Object)state2);
            }

            public void undo() {
                this.setShortener(!state);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    public void edit(IEditHandler.FirstAction action, boolean editInDialog) {
        Controller controller = Controller.getCurrentController();
        IMapSelection selection = controller.getSelection();
        if (selection == null) {
            return;
        }
        NodeModel selectedNode = selection.getSelected();
        if (selectedNode == null) {
            return;
        }
        if (IEditHandler.FirstAction.EDIT_CURRENT.equals((Object)action)) {
            this.edit(selectedNode, selectedNode, false, false, editInDialog);
        } else if (!Controller.getCurrentModeController().isBlocked()) {
            int mode = IEditHandler.FirstAction.ADD_CHILD.equals((Object)action) ? 2 : 3;
            ((MMapController)Controller.getCurrentModeController().getMapController()).addNewNode(mode);
        }
    }

    private boolean containsFormatting(String text) {
        if (FORMATTING_PATTERN == null) {
            FORMATTING_PATTERN = Pattern.compile("<(?!/|html>|head|body|p/?>|!--|style type=\"text/css\">)|^(?:<[^<]+>|\\s)*&lt;(?:html|table)&gt;", 2);
        }
        Matcher matcher = FORMATTING_PATTERN.matcher(text);
        return matcher.find();
    }

    public void edit(NodeModel nodeModel, NodeModel prevSelectedModel, boolean isNewNode, boolean parentFolded, boolean editInDialog) {
        this.edit(nodeModel, prevSelectedModel, isNewNode, parentFolded, editInDialog, null);
    }

    public void edit(NodeModel nodeModel, NodeModel prevSelectedModel, boolean isNewNode, boolean parentFolded, boolean editInDialog, KeyEvent initialKeyEvent) {
        if (nodeModel == null || this.currentBlockingEditor != null) {
            return;
        }
        Controller controller = Controller.getCurrentController();
        if (controller.getMap() != nodeModel.getMap()) {
            return;
        }
        IMapViewManager viewController = controller.getMapViewManager();
        JComponent map = viewController.getMapViewComponent();
        ((Component)map).validate();
        ((Component)map).invalidate();
        Component node = viewController.getComponent(nodeModel);
        if (node == null) {
            return;
        }
        node.requestFocus();
        this.stopInlineEditing();
        CoreTextEditorHolder editorHolder = (CoreTextEditorHolder)nodeModel.getExtension(CoreTextEditorHolder.class);
        if (editorHolder != null) {
            editorHolder.activate();
            return;
        }
        if (isNewNode && !this.eventQueue.isActive() && !ResourceController.getResourceController().getBooleanProperty("display_inline_editor_for_all_new_nodes") && !this.isTextFormattingDisabled(nodeModel)) {
            this.keyEventDispatcher = new EditEventDispatcher(Controller.getCurrentModeController(), nodeModel, prevSelectedModel, parentFolded, editInDialog, initialKeyEvent);
            this.keyEventDispatcher.install();
            return;
        }
        NodeTextEditor editControl = new NodeTextEditor(viewController, nodeModel, isNewNode, prevSelectedModel, controller, parentFolded);
        Window window = SwingUtilities.getWindowAncestor(controller.getMapViewManager().getMapViewComponent());
        EditNodeBase editor = this.createEditor(nodeModel, nodeModel, nodeModel.getText(), editControl, isNewNode, editInDialog, true);
        editor.show(window);
    }

    public EditNodeBase createEditor(NodeModel nodeModel, Object nodeProperty, Object content, EditNodeBase.IEditControl editControl, boolean isNewNode, boolean editInDialog, boolean internal) {
        EditNodeBase base = this.createContentSpecificEditor(nodeModel, content, nodeProperty, editControl, editInDialog);
        if (base != null || !internal) {
            return base;
        }
        IEditBaseCreator textFieldCreator = (IEditBaseCreator)Controller.getCurrentController().getMapViewManager();
        return textFieldCreator.createEditor(nodeModel, nodeProperty, content, editControl, editInDialog);
    }

    public EditNodeBase createContentSpecificEditor(NodeModel nodeModel, Object content, Object ee, EditNodeBase.IEditControl editControl, boolean editInDialog) {
        List textTransformers = this.getTextTransformers();
        for (IContentTransformer t : textTransformers) {
            EditNodeBase base;
            if (!(t instanceof IEditBaseCreator) || (base = ((IEditBaseCreator)t).createEditor(nodeModel, ee, content, editControl, editInDialog)) == null) continue;
            return base;
        }
        return null;
    }

    public void stopInlineEditing() {
        if (this.keyEventDispatcher != null) {
            this.keyEventDispatcher.uninstall();
        }
        if (this.currentBlockingEditor != null) {
            this.currentBlockingEditor.closeEdit();
            this.modeController.forceNewTransaction();
            this.currentBlockingEditor = null;
        }
    }

    public void addEditorPaneListener(IEditorPaneListener l) {
        this.editorPaneListeners.add(l);
    }

    public void removeEditorPaneListener(IEditorPaneListener l) {
        this.editorPaneListeners.remove(l);
    }

    private void fireEditorPaneCreated(JEditorPane editor, Object purpose) {
        for (IEditorPaneListener l : this.editorPaneListeners) {
            l.editorPaneCreated(editor, purpose);
        }
    }

    public SHTMLPanel createSHTMLPanel(String purpose) {
        ScaledStyleSheet.FONT_SCALE_FACTOR = UITools.FONT_SCALE_FACTOR;
        SHTMLPanel.setActionBuilder((ActionBuilder)new ActionBuilder(){

            public void initActions(SHTMLPanel panel) {
                panel.addAction("editLink", (Action)((Object)new SHTMLEditLinkAction((SHTMLPanelImpl)panel)));
                panel.addAction("setLinkByFileChooser", (Action)((Object)new SHTMLSetLinkByFileChooserAction((SHTMLPanelImpl)panel)));
            }
        });
        SHTMLPanel shtmlPanel = SHTMLPanel.createSHTMLPanel();
        shtmlPanel.applyComponentOrientation(UITools.getMenuComponent().getComponentOrientation());
        JEditorPane sourceEditorPane = shtmlPanel.getSourceEditorPane();
        sourceEditorPane.setOpaque(true);
        shtmlPanel.getSourceEditorPane().setOpaque(true);
        Font originalFont = sourceEditorPane.getFont();
        Font scaledFont = UITools.scale((Font)originalFont);
        SourceTextEditorUIConfigurator.configureColors(sourceEditorPane);
        sourceEditorPane.setFont(scaledFont);
        shtmlPanel.setOpenHyperlinkHandler(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                try {
                    UrlManager.getController().loadHyperlink(LinkController.createHyperlink((String)pE.getActionCommand()));
                }
                catch (Exception e) {
                    LogUtils.warn((Throwable)e);
                }
            }
        });
        JEditorPane editorPane = shtmlPanel.getEditorPane();
        editorPane.putClientProperty("JEditorPane.honorDisplayProperties", false);
        this.fireEditorPaneCreated(editorPane, purpose);
        return shtmlPanel;
    }

    public JEditorPane createEditorPane(Supplier<JScrollPane> scrollPaneSupplier, NodeModel nodeModel, Object nodeProperty, Object content) {
        List textTransformers = this.getTextTransformers();
        for (IContentTransformer t : textTransformers) {
            JEditorPane pane;
            if (!(t instanceof IEditBaseCreator) || (pane = ((IEditBaseCreator)t).createTextEditorPane(scrollPaneSupplier, nodeModel, nodeProperty, content, false)) == null) continue;
            return pane;
        }
        return null;
    }

    public JEditorPane createEditorPane(Object purpose) {
        JEditorPane editorPane = new JEditorPane(){

            @Override
            public String getSelectedText() {
                String selectedText = super.getSelectedText();
                return selectedText != null ? selectedText.replace('\u00a0', ' ') : null;
            }

            @Override
            protected void paintComponent(Graphics g) {
                try {
                    super.paintComponent(g);
                }
                catch (Exception e) {
                    LogUtils.warn((Throwable)e);
                }
            }
        };
        editorPane.putClientProperty("JEditorPane.honorDisplayProperties", false);
        this.fireEditorPaneCreated(editorPane, purpose);
        return editorPane;
    }

    public EventBuffer getEventQueue() {
        return this.eventQueue;
    }

    private String makePlainIfNoFormattingFound(String text) {
        if (HtmlUtils.isHtml((String)text) && !this.containsFormatting(text = this.removeHtmlHead(text))) {
            text = HtmlUtils.htmlToPlain((String)text);
        }
        return text;
    }

    private String removeHtmlHead(String text) {
        return HTML_HEAD.matcher(text).replaceFirst("");
    }

    public boolean canEdit() {
        return true;
    }

    public void setCurrentBlockingEditor(EditNodeBase currentBlockingEditor) {
        this.currentBlockingEditor = currentBlockingEditor;
    }

    public void unsetCurrentBlockingEditor(EditNodeBase currentBlockingEditor) {
        if (this.currentBlockingEditor == currentBlockingEditor) {
            this.currentBlockingEditor = null;
        }
    }

    static {
        final UIResources defaultResources = SHTMLPanel.getResources();
        SHTMLPanel.setResources((UIResources)new UIResources(){

            public String getString(String key) {
                if (key.equals("approximate_search_threshold")) {
                    return Double.valueOf(StringMatchingStrategy.APPROXIMATE_MATCHING_MINPROB).toString();
                }
                String freeplaneKey = "simplyhtml." + key;
                String resourceString = ResourceController.getResourceController().getText(freeplaneKey, null);
                if (resourceString == null) {
                    resourceString = ResourceController.getResourceController().getProperty(freeplaneKey);
                }
                if (resourceString == null && key.equals("splashImage")) {
                    return defaultResources.getString(key);
                }
                return resourceString;
            }

            public Icon getIcon(String name) {
                String freeplaneKey = "simplyhtml." + name;
                Icon freeplaneIcon = ResourceController.getResourceController().getIcon(freeplaneKey);
                return freeplaneIcon != null ? freeplaneIcon : defaultResources.getIcon(name);
            }
        });
        HTML_HEAD = Pattern.compile("\\s*<head>.*</head>", 32);
    }

    private class EditEventDispatcher
    implements KeyEventDispatcher,
    INodeSelectionListener {
        private final boolean editInDialog;
        private final boolean parentFolded;
        private final NodeModel prevSelectedModel;
        private final NodeModel nodeModel;
        private final ModeController modeController;
        private final KeyEvent initialKeyEvent;

        private EditEventDispatcher(ModeController modeController, NodeModel nodeModel, NodeModel prevSelectedModel, boolean parentFolded, boolean editInDialog, KeyEvent initialKeyEvent) {
            this.modeController = modeController;
            this.editInDialog = editInDialog;
            this.parentFolded = parentFolded;
            this.prevSelectedModel = prevSelectedModel;
            this.nodeModel = nodeModel;
            this.initialKeyEvent = initialKeyEvent;
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            int keyCode = e.getKeyCode();
            switch (keyCode) {
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 157: 
                case 65406: {
                    return false;
                }
            }
            if (e.getID() == 402 || this.isDeadKey(keyCode) || this.isNavigationKey(keyCode)) {
                return false;
            }
            if (this.initialKeyEvent != null && (this.initialKeyEvent.getKeyChar() != '\u0000' && this.initialKeyEvent.getKeyChar() == e.getKeyChar() || this.initialKeyEvent.getKeyCode() == e.getKeyCode())) {
                return false;
            }
            this.uninstall();
            if (this.isMenuEvent(e)) {
                return false;
            }
            MTextController.this.eventQueue.activate(e);
            MTextController.this.edit(this.nodeModel, this.prevSelectedModel, true, this.parentFolded, this.editInDialog);
            return true;
        }

        private boolean isNavigationKey(int keyCode) {
            return keyCode >= 33 && keyCode <= 40;
        }

        private boolean isDeadKey(int keyCode) {
            return (keyCode & 0xFFFFFFF0) == 128;
        }

        private boolean isMenuEvent(KeyEvent e) {
            if (this.editInDialog) {
                return false;
            }
            InputMapUIResource defaultInputMap = (InputMapUIResource)UIManager.getDefaults().get("TextField.focusInputMap");
            if ("paste-from-clipboard".equals(defaultInputMap.get(KeyStroke.getKeyStrokeForEvent(e)))) {
                return false;
            }
            return ResourceController.getResourceController().getAcceleratorManager().canProcessKeyEvent(e);
        }

        public void uninstall() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
            MapController mapController = this.modeController.getMapController();
            mapController.removeNodeSelectionListener((INodeSelectionListener)this);
            MTextController.this.keyEventDispatcher = null;
        }

        public void install() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
            MapController mapController = this.modeController.getMapController();
            mapController.addNodeSelectionListener((INodeSelectionListener)this);
        }

        public void onDeselect(NodeModel node) {
            this.uninstall();
        }

        public void onSelect(NodeModel node) {
            this.uninstall();
        }
    }

    private static class ExtensionCopier
    implements IExtensionCopier {
        private ExtensionCopier() {
        }

        public void copy(Object key, NodeModel from, NodeModel to) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            DetailModel fromDetails = DetailModel.getDetail((NodeModel)from);
            if (fromDetails == null) {
                return;
            }
            String contentType = fromDetails.getContentType();
            if (contentType == null) {
                return;
            }
            DetailModel oldDetails = DetailModel.getDetail((NodeModel)to);
            DetailModel newDetails = oldDetails == null ? new DetailModel(false) : oldDetails.copy();
            newDetails.setContentType(contentType);
            to.putExtension((IExtension)newDetails);
        }

        public void remove(Object key, NodeModel from) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            DetailModel fromDetails = DetailModel.getDetail((NodeModel)from);
            if (fromDetails == null) {
                return;
            }
            String contentType = fromDetails.getContentType();
            if (contentType == null) {
                return;
            }
            DetailModel newDetails = fromDetails.copy();
            newDetails.setContentType(null);
            from.putExtension((IExtension)newDetails);
        }

        public void remove(Object key, NodeModel from, NodeModel which) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            DetailModel whichDetails = DetailModel.getDetail((NodeModel)which);
            if (whichDetails == null || whichDetails.getContentType() == null) {
                return;
            }
            this.remove(key, from);
        }
    }

    private class NodeDetailsEditor
    implements EditNodeBase.IEditControl {
        private final boolean addsNewDetailsUsingInlineEditor;
        private final OptionalReference<NodeModel> nodeModel;

        private NodeDetailsEditor(boolean addsNewDetailsUsingInlineEditor, NodeModel nodeModel) {
            this.addsNewDetailsUsingInlineEditor = addsNewDetailsUsingInlineEditor;
            this.nodeModel = new OptionalReference((Object)nodeModel);
        }

        @Override
        public void cancel() {
            if (this.nodeModel.isPresent() && this.addsNewDetailsUsingInlineEditor) {
                String detailText = DetailModel.getDetailText((NodeModel)((NodeModel)this.nodeModel.get()));
                MModeController modeController = (MModeController)Controller.getCurrentModeController();
                if (detailText != null) {
                    modeController.undo();
                }
                modeController.resetRedo();
            }
        }

        @Override
        public void ok(String newText) {
            this.nodeModel.ifPresent(x -> this.ok((NodeModel)x, newText));
        }

        private void ok(NodeModel nodeModel, String newText) {
            if (HtmlUtils.isEmpty((String)newText)) {
                if (this.addsNewDetailsUsingInlineEditor) {
                    MModeController modeController = (MModeController)Controller.getCurrentModeController();
                    modeController.undo();
                    modeController.resetRedo();
                } else {
                    this.preserveRootNodeLocationOnScreen();
                    MTextController.this.setDetailsHtmlText(nodeModel, null);
                }
            } else {
                this.preserveRootNodeLocationOnScreen();
                MTextController.this.setDetailsHtmlText(nodeModel, newText);
            }
            if (this.addsNewDetailsUsingInlineEditor) {
                // empty if block
            }
        }

        private void preserveRootNodeLocationOnScreen() {
            Controller.getCurrentController().getSelection().preserveRootNodeLocationOnScreen();
        }

        @Override
        public void split(String newText, int position) {
        }

        @Override
        public boolean canSplit() {
            return false;
        }

        @Override
        public EditNodeBase.EditedComponent getEditType() {
            return EditNodeBase.EditedComponent.DETAIL;
        }
    }

    private class NodeTextEditor
    implements EditNodeBase.IEditControl {
        private final IMapViewManager viewController;
        private final OptionalReference<NodeModel> nodeModel;
        private final boolean newNode;
        private final NodeModel prevSelectedModel;
        private final Controller controller;
        private final boolean parentFolded;

        private NodeTextEditor(IMapViewManager viewController, NodeModel nodeModel, boolean newNode, NodeModel prevSelectedModel, Controller controller, boolean parentFolded) {
            this.viewController = viewController;
            this.newNode = newNode;
            this.nodeModel = new OptionalReference((Object)nodeModel);
            this.prevSelectedModel = prevSelectedModel;
            this.controller = controller;
            this.parentFolded = parentFolded;
        }

        @Override
        public void cancel() {
            if (this.newNode) {
                this.nodeModel.ifPresent(this::cancel);
            }
        }

        private void cancel(NodeModel nodeModel) {
            if (nodeModel.getMap().equals(this.controller.getMap())) {
                if (nodeModel.getParentNode() != null) {
                    this.controller.getSelection().selectAsTheOnlyOneSelected(nodeModel);
                    MModeController modeController = (MModeController)Controller.getCurrentModeController();
                    modeController.undo();
                    modeController.resetRedo();
                }
                MapController mapController = Controller.getCurrentModeController().getMapController();
                if (this.parentFolded) {
                    mapController.fold(this.prevSelectedModel);
                }
            }
        }

        @Override
        public void ok(String text) {
            this.nodeModel.ifPresent(x -> this.ok((NodeModel)x, text));
        }

        private void ok(NodeModel nodeModel, String text) {
            String processedText = MTextController.this.makePlainIfNoFormattingFound(text);
            this.preserveRootNodeLocationOnScreen();
            MTextController.this.setGuessedNodeObject(nodeModel, processedText);
        }

        private void preserveRootNodeLocationOnScreen() {
            Controller.getCurrentController().getSelection().preserveRootNodeLocationOnScreen();
        }

        @Override
        public void split(String text, int position) {
            this.nodeModel.ifPresent(x -> this.split((NodeModel)x, text, position));
        }

        private void split(NodeModel nodeModel, String text, int position) {
            String processedText = HtmlUtils.isHtml((String)text) ? MTextController.this.removeHtmlHead(text) : text;
            MTextController.this.splitNode(nodeModel, position, processedText);
            this.viewController.obtainFocusForSelected();
        }

        @Override
        public boolean canSplit() {
            return true;
        }

        @Override
        public EditNodeBase.EditedComponent getEditType() {
            return EditNodeBase.EditedComponent.TEXT;
        }
    }
}

