/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import net.infonode.docking.AbstractTabWindow;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.DockingWindowAdapter;
import net.infonode.docking.DockingWindowListener;
import net.infonode.docking.FloatingWindow;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.ViewSerializer;
import net.infonode.docking.WindowPopupMenuFactory;
import net.infonode.docking.properties.DockingWindowProperties;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.properties.TabWindowProperties;
import net.infonode.docking.properties.WindowTabProperties;
import net.infonode.docking.properties.WindowTabStateProperties;
import net.infonode.docking.theme.ClassicDockingTheme;
import net.infonode.docking.theme.DockingWindowsTheme;
import net.infonode.docking.theme.LookAndFeelDockingTheme;
import net.infonode.docking.title.SimpleDockingWindowTitleProvider;
import net.infonode.docking.util.DockingUtil;
import net.infonode.gui.DynamicUIManager;
import net.infonode.gui.DynamicUIManagerListener;
import net.infonode.gui.icon.button.CloseIcon;
import net.infonode.gui.icon.button.DockIcon;
import net.infonode.gui.icon.button.DropDownIcon;
import net.infonode.gui.icon.button.MaximizeIcon;
import net.infonode.gui.icon.button.MinimizeIcon;
import net.infonode.gui.icon.button.RestoreIcon;
import net.infonode.gui.icon.button.UndockIcon;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.tabbedpanel.TabAreaComponentsProperties;
import net.infonode.tabbedpanel.TabAreaProperties;
import net.infonode.tabbedpanel.TabAreaVisiblePolicy;
import net.infonode.tabbedpanel.TabDropDownListVisiblePolicy;
import net.infonode.tabbedpanel.TabLayoutPolicy;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;
import net.infonode.tabbedpanel.titledtab.TitledTabSizePolicy;
import net.infonode.util.Direction;
import org.apache.commons.codec.binary.Base64;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.FileOpener;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.url.mindmapmode.DroppedMindMapOpener;
import org.freeplane.main.application.ConnectedToMenuView;
import org.freeplane.main.application.IconColorReplacer;
import org.freeplane.main.application.MapViewSerializer;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.ui.DefaultMapMouseListener;

class MapViewDockingWindows
implements IMapViewChangeListener {
    private static final String CUSTOMIZED_TAB_NAME_PROPERTY = "customizedTabName";
    private static final String OPENED_NOW = "openedNow_1.3.04";
    private RootWindow rootWindow = null;
    private final Vector<Component> mapViews;
    private boolean mPaneSelectionUpdate = true;
    private boolean loadingLayoutFromObjectInputStream;
    private boolean initialTabNameLoadingWasDone;
    private byte[] emptyConfigurations;
    private final MapViewSerializer viewSerializer = new MapViewSerializer();
    private DockingWindowsTheme theme;

    public MapViewDockingWindows() {
        this.rootWindow = new RootWindow((ViewSerializer)this.viewSerializer);
        this.configureDefaultDockingWindowProperties();
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream wrapper = new ObjectOutputStream(byteStream);
            this.rootWindow.write(wrapper);
            wrapper.close();
            this.emptyConfigurations = byteStream.toByteArray();
        }
        catch (IOException byteStream) {
            // empty catch block
        }
        this.removeDesktopPaneAccelerators();
        this.mapViews = new Vector();
        FileOpener fileOpener = new FileOpener("mm", (FileOpener.Listener)new DroppedMindMapOpener());
        new DropTarget((Component)this.rootWindow, (DropTargetListener)fileOpener);
        this.rootWindow.addMouseListener((MouseListener)new DefaultMapMouseListener());
        Controller controller = Controller.getCurrentController();
        controller.getMapViewManager().addMapViewChangeListener((IMapViewChangeListener)this);
        this.rootWindow.addListener((DockingWindowListener)new DockingWindowAdapter(){
            private IconColorReplacer iconColorReplacer;

            public void viewFocusChanged(View previouslyFocusedView, View focusedView) {
                JComponent mapViewComponent;
                Component containedMapView;
                if (focusedView != null && (containedMapView = MapViewDockingWindows.getContainedMapView(focusedView)) != (mapViewComponent = Controller.getCurrentController().getMapViewManager().getMapViewComponent())) {
                    MapViewDockingWindows.this.viewSelectionChanged(containedMapView);
                }
            }

            public void windowClosing(DockingWindow window) throws OperationAbortedException {
                for (Component mapViewComponent : MapViewDockingWindows.this.mapViews.toArray(new Component[0])) {
                    if (!SwingUtilities.isDescendingFrom(mapViewComponent, (Component)window) || Controller.getCurrentController().getMapViewManager().close(mapViewComponent)) continue;
                    throw new OperationAbortedException("can not close view");
                }
            }

            public void windowAdded(DockingWindow addedToWindow, DockingWindow addedWindow) {
                Container topLevelAncestor;
                if (addedWindow instanceof TabWindow) {
                    DockingWindowProperties windowProperties = addedWindow.getWindowProperties();
                    windowProperties.setDockEnabled(false);
                    windowProperties.setUndockEnabled(false);
                    if (UITools.getCurrentFrame().isResizable()) {
                        MapViewDockingWindows.this.setTabAreaVisiblePolicy((TabWindow)addedWindow);
                    } else {
                        MapViewDockingWindows.this.setTabAreaPolicy((TabWindow)addedWindow, TabAreaVisiblePolicy.NEVER);
                    }
                } else if (addedWindow instanceof FloatingWindow && (topLevelAncestor = addedWindow.getTopLevelAncestor()) instanceof Window) {
                    if (this.iconColorReplacer == null) {
                        this.iconColorReplacer = new IconColorReplacer(((Window)UITools.getMenuComponent()).getIconImages());
                    }
                    List<Image> iconImages = this.iconColorReplacer.getNextIconImages();
                    ((Window)topLevelAncestor).setIconImages(iconImages);
                }
                this.setTabPolicies(addedWindow);
            }

            private void setTabPolicies(DockingWindow window) {
                if (window instanceof TabWindow) {
                    TabbedPanelProperties tabbedPanelProperties = ((TabWindow)window).getTabWindowProperties().getTabbedPanelProperties();
                    if (!tabbedPanelProperties.getTabLayoutPolicy().equals(TabLayoutPolicy.COMPRESSION)) {
                        tabbedPanelProperties.setTabLayoutPolicy(TabLayoutPolicy.COMPRESSION);
                    }
                    if (!tabbedPanelProperties.getTabDropDownListVisiblePolicy().equals(TabDropDownListVisiblePolicy.MORE_THAN_ONE_TAB)) {
                        tabbedPanelProperties.setTabDropDownListVisiblePolicy(TabDropDownListVisiblePolicy.MORE_THAN_ONE_TAB);
                    }
                }
                for (int i = 0; i < window.getChildWindowCount(); ++i) {
                    this.setTabPolicies(window.getChildWindow(i));
                }
            }

            public void windowRemoved(DockingWindow removedFromWindow, DockingWindow removedWindow) {
                if (removedWindow instanceof TabWindow && removedFromWindow == MapViewDockingWindows.this.rootWindow) {
                    TabAreaProperties tabAreaProperties = ((TabWindow)removedWindow).getTabWindowProperties().getTabbedPanelProperties().getTabAreaProperties();
                    tabAreaProperties.setTabAreaVisiblePolicy(TabAreaVisiblePolicy.ALWAYS);
                }
            }
        });
        new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
            }
        };
        this.addTabsPopupMenu((DockingWindow)this.rootWindow);
    }

    private void addTabsPopupMenu(DockingWindow dockingWindow) {
        dockingWindow.setPopupMenuFactory(new WindowPopupMenuFactory(){

            public JPopupMenu createPopupMenu(final DockingWindow window) {
                if (window.getWindowParent() instanceof RootWindow || window.getWindowParent() instanceof SplitWindow) {
                    return null;
                }
                JPopupMenu menu = new JPopupMenu(window.getTitle());
                JMenuItem menuItem = new JMenuItem(TextUtils.getText((String)"TabPopUpMenu.rename.text", (String)"Rename"));
                menuItem.setToolTipText(TextUtils.getText((String)"TabPopUpMenu.rename.tooltip", (String)"Windows layout changes may reset the tab title."));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JComponent mapView = (JComponent)MapViewDockingWindows.getContainedMapView(window);
                        String customizedTabName = (String)mapView.getClientProperty(MapViewDockingWindows.CUSTOMIZED_TAB_NAME_PROPERTY);
                        customizedTabName = customizedTabName != null ? customizedTabName : mapView.getName();
                        String newName = JOptionPane.showInputDialog(TextUtils.getText((String)"TabPopUpMenu.rename.inputDialog", (String)"Input new temporary name: "), (Object)customizedTabName);
                        if (Objects.equals(newName, "") || newName == null) {
                            mapView.putClientProperty(MapViewDockingWindows.CUSTOMIZED_TAB_NAME_PROPERTY, null);
                        } else {
                            mapView.putClientProperty(MapViewDockingWindows.CUSTOMIZED_TAB_NAME_PROPERTY, newName);
                        }
                        MapViewDockingWindows.this.addTitleProvider(window);
                        MapViewDockingWindows.this.setTitle();
                    }
                });
                menu.add(menuItem);
                return menu;
            }
        });
    }

    private void configureDefaultDockingWindowProperties() {
        final RootWindowProperties rootWindowProperties = this.rootWindow.getRootWindowProperties();
        String lf = UIManager.getLookAndFeel().getID();
        this.theme = lf.endsWith("Aqua") ? this.createClassicTheme() : new LookAndFeelDockingTheme();
        DynamicUIManager.getInstance().addListener(new DynamicUIManagerListener(){

            public void propertiesChanging() {
            }

            public void propertiesChanged() {
            }

            public void lookAndFeelChanging() {
                LookAndFeelDockingTheme newTheme;
                boolean existingDockingThemeMatchesLookAndFeel;
                String lf = UIManager.getLookAndFeel().getID();
                boolean bl = existingDockingThemeMatchesLookAndFeel = lf.endsWith("Aqua") != MapViewDockingWindows.this.theme instanceof LookAndFeelDockingTheme;
                if (existingDockingThemeMatchesLookAndFeel) {
                    return;
                }
                if (MapViewDockingWindows.this.theme instanceof LookAndFeelDockingTheme) {
                    ((LookAndFeelDockingTheme)MapViewDockingWindows.this.theme).dispose();
                    newTheme = MapViewDockingWindows.this.createClassicTheme();
                } else {
                    newTheme = new LookAndFeelDockingTheme();
                }
                rootWindowProperties.replaceSuperObject(MapViewDockingWindows.this.theme.getRootWindowProperties(), newTheme.getRootWindowProperties());
                MapViewDockingWindows.this.theme = (DockingWindowsTheme)newTheme;
            }

            public void lookAndFeelChanged() {
            }
        });
        rootWindowProperties.addSuperObject(this.theme.getRootWindowProperties());
        RootWindowProperties overwrittenProperties = new RootWindowProperties();
        overwrittenProperties.getWindowAreaProperties().setInsets(new Insets(0, 0, 0, 0)).setBorder(BorderFactory.createEmptyBorder());
        overwrittenProperties.getFloatingWindowProperties().setUseFrame(true);
        TabWindowProperties tabWindowProperties = overwrittenProperties.getTabWindowProperties();
        TabbedPanelProperties tabbedPanelProperties = tabWindowProperties.getTabbedPanelProperties();
        tabbedPanelProperties.getContentPanelProperties().getComponentProperties().setInsets(new Insets(0, 0, 0, 0)).setBorder(BorderFactory.createEmptyBorder());
        int buttonSize = Math.round(UITools.FONT_SCALE_FACTOR * 10.0f);
        tabWindowProperties.getMaximizeButtonProperties().setIcon((Icon)new MaximizeIcon(buttonSize));
        tabWindowProperties.getMinimizeButtonProperties().setIcon((Icon)new MinimizeIcon(buttonSize));
        tabWindowProperties.getCloseButtonProperties().setIcon((Icon)new CloseIcon(buttonSize));
        tabWindowProperties.getRestoreButtonProperties().setIcon((Icon)new RestoreIcon(buttonSize));
        tabWindowProperties.getDockButtonProperties().setIcon((Icon)new DockIcon(buttonSize));
        tabWindowProperties.getUndockButtonProperties().setIcon((Icon)new UndockIcon(buttonSize));
        tabbedPanelProperties.setTabLayoutPolicy(TabLayoutPolicy.COMPRESSION);
        tabbedPanelProperties.setTabDropDownListVisiblePolicy(TabDropDownListVisiblePolicy.MORE_THAN_ONE_TAB);
        tabbedPanelProperties.setShadowEnabled(false);
        tabbedPanelProperties.getButtonProperties().getTabDropDownListButtonProperties().setIcon((Icon)new DropDownIcon(buttonSize, Direction.DOWN));
        Font tabFont = UITools.getUIFont();
        WindowTabProperties tabProperties = tabWindowProperties.getTabProperties();
        TitledTabProperties titledTabProperties = tabProperties.getTitledTabProperties();
        titledTabProperties.setSizePolicy(TitledTabSizePolicy.INDIVIDUAL_SIZE);
        ComponentProperties highlightedProperties = titledTabProperties.getHighlightedProperties().getComponentProperties();
        highlightedProperties.setFont(tabFont);
        ComponentProperties normalProperties = titledTabProperties.getNormalProperties().getComponentProperties();
        normalProperties.setFont(tabFont);
        rootWindowProperties.addSuperObject(overwrittenProperties);
        WindowTabStateProperties normalButtonProperties = tabProperties.getNormalButtonProperties();
        normalButtonProperties.getDockButtonProperties().setIcon((Icon)new DockIcon(buttonSize));
        normalButtonProperties.getUndockButtonProperties().setIcon((Icon)new UndockIcon(buttonSize));
        normalButtonProperties.getCloseButtonProperties().setIcon((Icon)new CloseIcon(buttonSize));
        normalButtonProperties.getMinimizeButtonProperties().setIcon((Icon)new MinimizeIcon(buttonSize));
        normalButtonProperties.getRestoreButtonProperties().setIcon((Icon)new RestoreIcon(buttonSize));
    }

    private void removeDesktopPaneAccelerators() {
        InputMap map = new InputMap();
        this.rootWindow.setInputMap(1, map);
    }

    private DockingWindow getLastFocusedChildWindow(DockingWindow parentWindow) {
        DockingWindow lastFocusedChildWindow = parentWindow.getLastFocusedChildWindow();
        if (lastFocusedChildWindow == null) {
            return parentWindow;
        }
        return this.getLastFocusedChildWindow(lastFocusedChildWindow);
    }

    public void afterViewChange(Component pOldMap, Component pNewMap) {
        if (pNewMap == null) {
            return;
        }
        if (this.loadingLayoutFromObjectInputStream) {
            if (this.mapViews.contains(pNewMap)) {
                return;
            }
            this.updateTitle(pNewMap);
        } else {
            for (int i = 0; i < this.mapViews.size(); ++i) {
                if (this.mapViews.get(i) != pNewMap) continue;
                View dockedView = MapViewDockingWindows.getContainingDockedWindow(pNewMap);
                Frame window = JOptionPane.getFrameForComponent((Component)dockedView);
                int frameState = window.getExtendedState();
                if ((frameState & 1) != 0) {
                    window.setExtendedState(frameState & 0xFFFFFFFE);
                }
                if (dockedView.isMinimized()) {
                    dockedView.restore();
                } else {
                    dockedView.restoreFocus();
                }
                this.focusMapViewLater((MapView)pNewMap);
                return;
            }
            this.addDockedWindow(pOldMap, pNewMap);
        }
        this.mapViews.add(pNewMap);
    }

    private String getCustomTitle(DockingWindow window) {
        String windowName = (String)window.getClientProperty((Object)CUSTOMIZED_TAB_NAME_PROPERTY);
        if (windowName == null || window instanceof ConnectedToMenuView) {
            return SimpleDockingWindowTitleProvider.INSTANCE.getTitle(window);
        }
        boolean dirty = this.isAnyChildWindowDirty(window);
        int childWindowsCount = this.getChildWindowsCount(window);
        return windowName + (childWindowsCount > 1 ? " (" + childWindowsCount + ")" : "") + (dirty ? " *" : "");
    }

    private boolean isAnyChildWindowDirty(DockingWindow window) {
        if (window == null) {
            return false;
        }
        if (window instanceof View) {
            return window.getTitle().endsWith("*");
        }
        for (int i = 0; i < window.getChildWindowCount(); ++i) {
            if (!this.isAnyChildWindowDirty(window.getChildWindow(i))) continue;
            return true;
        }
        return false;
    }

    private int getChildWindowsCount(DockingWindow window) {
        int windowCount = 0;
        if (window == null) {
            return 0;
        }
        if (window instanceof View) {
            return 1;
        }
        for (int i = 0; i < window.getChildWindowCount(); ++i) {
            windowCount += this.getChildWindowsCount(window.getChildWindow(i));
        }
        return windowCount;
    }

    private void addTitleProvider(DockingWindow window) {
        window.getWindowProperties().setTitleProvider(this::getCustomTitle);
    }

    private static View getContainingDockedWindow(Component pNewMap) {
        return (View)SwingUtilities.getAncestorOfClass(View.class, pNewMap);
    }

    private void addDockedView(View oldSelected, View newView) {
        View lastFocusedChildWindow;
        Object object = lastFocusedChildWindow = oldSelected != null ? oldSelected : this.getLastFocusedChildWindow((DockingWindow)this.rootWindow);
        if (lastFocusedChildWindow == null) {
            DockingUtil.addWindow((DockingWindow)newView, (RootWindow)this.rootWindow);
        } else {
            Container parent = SwingUtilities.getAncestorOfClass(DockingWindow.class, (Component)lastFocusedChildWindow);
            if (parent instanceof TabWindow) {
                TabWindow tabWindow = (TabWindow)parent;
                tabWindow.addTab((DockingWindow)newView, tabWindow.getChildWindowIndex((DockingWindow)lastFocusedChildWindow) + 1);
            } else {
                DockingUtil.addWindow((DockingWindow)newView, (RootWindow)lastFocusedChildWindow.getRootWindow());
            }
        }
    }

    private static Component getContainedMapView(DockingWindow window) {
        if (window == null) {
            return null;
        }
        if (window instanceof View) {
            return MapViewDockingWindows.getContainedMapView((View)window);
        }
        return window;
    }

    static Component getContainedMapView(View dockedWindow) {
        JScrollPane scrollPane = (JScrollPane)((Container)dockedWindow.getComponent()).getComponent(1);
        Component view = scrollPane.getViewport().getView();
        return view;
    }

    private void addDockedWindow(Component pOldMap, Component pNewMap) {
        View viewFrame = this.viewSerializer.newDockedView(pNewMap, this.createTitle(pNewMap));
        this.addDockedView(pOldMap != null ? MapViewDockingWindows.getContainingDockedWindow(pOldMap) : null, viewFrame);
    }

    public void afterViewClose(Component pOldMapView) {
        for (int i = 0; i < this.mapViews.size(); ++i) {
            if (this.mapViews.get(i) != pOldMapView) continue;
            this.mPaneSelectionUpdate = false;
            MapViewDockingWindows.getContainingDockedWindow(pOldMapView).close();
            this.mapViews.remove(i);
            this.mPaneSelectionUpdate = true;
            this.rootWindow.repaint();
            return;
        }
    }

    private void viewSelectionChanged(Component mapView) {
        if (!this.mPaneSelectionUpdate) {
            return;
        }
        Controller controller = Controller.getCurrentController();
        if (mapView != controller.getMapViewManager().getMapViewComponent()) {
            controller.getMapViewManager().changeToMapView(mapView.getName());
        }
    }

    public JComponent getMapPane() {
        return this.rootWindow;
    }

    public void saveLayout() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            this.rootWindow.write(objectStream);
            objectStream.close();
            String encodedBytes = Base64.encodeBase64String((byte[])byteStream.toByteArray());
            ResourceController.getResourceController().setProperty(OPENED_NOW, encodedBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLayout() {
        String encodedBytes = ResourceController.getResourceController().getProperty(OPENED_NOW, null);
        if (encodedBytes != null) {
            byte[] bytes = Base64.decodeBase64((String)encodedBytes);
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            try {
                this.loadingLayoutFromObjectInputStream = true;
                this.rootWindow.read(new ObjectInputStream(byteStream));
            }
            catch (Exception e) {
                LogUtils.severe((Throwable)e);
                try {
                    this.rootWindow.read(new ObjectInputStream(new ByteArrayInputStream(this.emptyConfigurations)));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            finally {
                this.viewSerializer.removeDummyViews();
                this.loadingLayoutFromObjectInputStream = false;
            }
            this.rootWindow.getWindowBar(Direction.DOWN).setEnabled(false);
            this.initialTabNameLoadingWasDone = false;
            this.setTitle();
        }
    }

    private void loadInitialCustomTabNames() {
        for (Component mapViewComponent : this.mapViews) {
            View containingDockedWindow;
            if (!(mapViewComponent instanceof MapView) || (containingDockedWindow = MapViewDockingWindows.getContainingDockedWindow(mapViewComponent)) == null) continue;
            String oldTitle = containingDockedWindow.getViewProperties().getTitle();
            MapView mapView = (MapView)mapViewComponent;
            if (oldTitle == null || oldTitle.equals("") || oldTitle.equals(mapView.getName())) continue;
            if (oldTitle.endsWith(" *")) {
                oldTitle = oldTitle.substring(0, oldTitle.length() - 2);
            }
            mapView.putClientProperty((Object)CUSTOMIZED_TAB_NAME_PROPERTY, (Object)oldTitle);
        }
        this.initialTabNameLoadingWasDone = true;
    }

    public void focusMapViewLater(final MapView mapView) {
        Timer timer = new Timer(40, new ActionListener(){
            int retryCount = 5;

            @Override
            public void actionPerformed(ActionEvent event) {
                Timer eventTimer = (Timer)event.getSource();
                this.focusMapLater(mapView, eventTimer);
            }

            private void focusMapLater(MapView mapView2, final Timer eventTimer) {
                NodeView selected;
                if (mapView2.isShowing() && Controller.getCurrentController().getMapViewManager().getMapViewComponent() == mapView2 && (selected = mapView2.getSelected()) != null) {
                    final Frame frame = JOptionPane.getFrameForComponent((Component)mapView2);
                    if (frame.isFocused()) {
                        selected.requestFocusInWindow();
                    } else {
                        frame.addWindowFocusListener(new WindowAdapter(){

                            @Override
                            public void windowGainedFocus(WindowEvent e) {
                                frame.removeWindowFocusListener(this);
                                selected.requestFocusInWindow();
                                retryCount = 2;
                                eventTimer.start();
                            }
                        });
                    }
                }
                if (this.retryCount > 1) {
                    --this.retryCount;
                    eventTimer.start();
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public void setTitle() {
        if (this.loadingLayoutFromObjectInputStream) {
            return;
        }
        if (!this.initialTabNameLoadingWasDone) {
            this.loadInitialCustomTabNames();
        }
        for (Component mapViewComponent : this.mapViews) {
            if (!(mapViewComponent instanceof MapView)) continue;
            this.updateTitle(mapViewComponent);
        }
    }

    private void updateTitle(Component mapViewComponent) {
        View containingDockedWindow = MapViewDockingWindows.getContainingDockedWindow(mapViewComponent);
        if (containingDockedWindow != null) {
            String title = this.createTitle(mapViewComponent);
            containingDockedWindow.getViewProperties().setTitle(title);
        }
    }

    private String createTitle(Component mapViewComponent) {
        MapView mapView = (MapView)mapViewComponent;
        String customizedTabName = (String)mapView.getClientProperty((Object)CUSTOMIZED_TAB_NAME_PROPERTY);
        String name = customizedTabName != null ? customizedTabName : mapView.getName();
        String title = mapView.getMap().isSaved() || mapView.getMap().isReadOnly() ? name : name + " *";
        return title;
    }

    public void selectNextMapView() {
        this.selectMap(1);
    }

    public void selectPreviousMapView() {
        this.selectMap(-1);
    }

    private void selectMap(int tabIndexChange) {
        AbstractTabWindow tabWindow;
        Controller controller = Controller.getCurrentController();
        MapView mapView = (MapView)controller.getMapViewManager().getMapViewComponent();
        if (mapView != null && (tabWindow = (AbstractTabWindow)SwingUtilities.getAncestorOfClass(AbstractTabWindow.class, (Component)mapView)) != null) {
            DockingWindow selectedWindow = tabWindow.getSelectedWindow();
            int childWindowIndex = tabWindow.getChildWindowIndex(selectedWindow);
            int childWindowCount = tabWindow.getChildWindowCount();
            int nextWindowIndex = (childWindowIndex + childWindowCount + tabIndexChange) % childWindowCount;
            View nextWindow = (View)tabWindow.getChildWindow(nextWindowIndex);
            Component nextMapView = MapViewDockingWindows.getContainedMapView(nextWindow);
            Controller.getCurrentController().getMapViewManager().changeToMapView(nextMapView);
        }
    }

    private void setTabAreaVisiblePolicy(TabWindow window) {
        this.setTabAreaPolicy(window, window.getWindowParent() == this.rootWindow ? TabAreaVisiblePolicy.MORE_THAN_ONE_TAB : TabAreaVisiblePolicy.ALWAYS);
    }

    private void setTabAreaPolicy(TabWindow window, TabAreaVisiblePolicy tabAreaVisiblePolicy) {
        TabAreaProperties tabAreaProperties = window.getTabWindowProperties().getTabbedPanelProperties().getTabAreaProperties();
        tabAreaProperties.setTabAreaVisiblePolicy(tabAreaVisiblePolicy);
    }

    public void setTabAreaVisiblePolicy(JFrame frame) {
        DockingWindow window = (DockingWindow)(JOptionPane.getFrameForComponent((Component)this.rootWindow) == frame ? this.rootWindow : frame.getContentPane().getComponent(0));
        this.setTabAreaVisiblePolicies(window);
    }

    private void setTabAreaVisiblePolicies(DockingWindow parentWindow) {
        for (int i = 0; i < parentWindow.getChildWindowCount(); ++i) {
            DockingWindow window = parentWindow.getChildWindow(i);
            if (window instanceof TabWindow) {
                this.setTabAreaVisiblePolicy((TabWindow)window);
            }
            if (window instanceof FloatingWindow) continue;
            this.setTabAreaVisiblePolicies(window);
        }
    }

    public void setTabAreaInvisiblePolicy(JFrame frame) {
        DockingWindow window = (DockingWindow)(JOptionPane.getFrameForComponent((Component)this.rootWindow) == frame ? this.rootWindow : frame.getContentPane().getComponent(0));
        this.setTabAreaInvisiblePolicies(window);
    }

    private void setTabAreaInvisiblePolicies(DockingWindow parentWindow) {
        for (int i = 0; i < parentWindow.getChildWindowCount(); ++i) {
            DockingWindow window = parentWindow.getChildWindow(i);
            if (window instanceof TabWindow) {
                this.setTabAreaPolicy((TabWindow)window, TabAreaVisiblePolicy.NEVER);
            }
            if (window instanceof FloatingWindow) continue;
            this.setTabAreaInvisiblePolicies(window);
        }
    }

    public List<? extends Component> getMapViewVector() {
        ArrayList<Component> orderedMapViews = new ArrayList<Component>(this.mapViews.size());
        this.addMapViews(orderedMapViews, (DockingWindow)this.rootWindow);
        return orderedMapViews;
    }

    private void addMapViews(ArrayList<Component> orderedMapViews, DockingWindow window) {
        if (window instanceof View) {
            orderedMapViews.add(MapViewDockingWindows.getContainedMapView((View)window));
        } else {
            for (int windowIndex = 0; windowIndex < window.getChildWindowCount(); ++windowIndex) {
                this.addMapViews(orderedMapViews, window.getChildWindow(windowIndex));
            }
        }
    }

    private ClassicDockingTheme createClassicTheme() {
        ClassicDockingTheme classicDockingTheme = new ClassicDockingTheme();
        RootWindowProperties rootWindowProperties = classicDockingTheme.getRootWindowProperties();
        ComponentProperties windowAreaProperties = rootWindowProperties.getWindowAreaProperties();
        TabbedPanelProperties tabbedPanelProperties = rootWindowProperties.getTabWindowProperties().getTabbedPanelProperties();
        windowAreaProperties.setBackgroundColor(null);
        windowAreaProperties.setForegroundColor(null);
        TabAreaComponentsProperties tabAreaComponentsProperties = tabbedPanelProperties.getTabAreaComponentsProperties();
        tabAreaComponentsProperties.getComponentProperties().setBackgroundColor(null);
        tabAreaComponentsProperties.getComponentProperties().setForegroundColor(null);
        return classicDockingTheme;
    }
}

