/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode.nodelist;

import java.util.List;
import java.util.stream.Collectors;
import org.freeplane.core.util.collection.ListComparator;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.map.NodeModel;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TextAccessor;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TextHolder;

class TagsHolder
extends TextHolder {
    private List<Tag> tags = null;
    private final NodeModel node;
    private boolean showsTagCategories;

    public TagsHolder(final NodeModel node, boolean showsTagCategories) {
        this.node = node;
        this.showsTagCategories = showsTagCategories;
        this.setTextAccessor(new TextAccessor(){

            @Override
            public void setText(String newText) {
            }

            @Override
            public String getText() {
                return TagsHolder.this.getTags().stream().map(Tag::getContent).collect(Collectors.joining("\n"));
            }

            @Override
            public NodeModel getNode() {
                return node;
            }
        });
    }

    private void initialize() {
        if (this.tags != null) {
            return;
        }
        IconController iconController = IconController.getController();
        this.tags = (this.showsTagCategories ? iconController.getTagsWithCategories(this.node) : iconController.getTags(this.node)).stream().filter(tag -> !tag.isEmpty()).collect(Collectors.toList());
    }

    @Override
    public int compareTo(TextHolder compareToObject) {
        return ListComparator.compareLists(this.tags, ((TagsHolder)compareToObject).tags);
    }

    public List<Tag> getTags() {
        this.initialize();
        return this.tags;
    }
}

