/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import de.sciss.syntaxpane.actions.ActionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.components.EmptyIcon;
import org.freeplane.core.ui.components.JRestrictedSizeScrollPane;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.text.mindmapmode.SourceTextEditorUIConfigurator;
import org.freeplane.plugin.script.IFreeplaneScriptErrorHandler;
import org.freeplane.plugin.script.ScriptEditorWindowConfigurationStorage;
import org.freeplane.plugin.script.SignedScriptHandler;

class ScriptEditorPanel
extends JDialog {
    static final String GROOVY_EDITOR_FONT = "groovy_editor_font";
    static final String GROOVY_EDITOR_FONT_SIZE = "groovy_editor_font_size";
    private static final String internalCharset = "UTF-16BE";
    private static final long serialVersionUID = 1L;
    private static final String WINDOW_PREFERENCE_STORAGE_PROPERTY = "plugins.script.ScriptEditorPanel/window_positions";
    private final JSplitPane mCentralPanel;
    private final JSplitPane mCentralUpperPanel;
    private Integer mLastSelected = null;
    private final DefaultListModel mListModel;
    private final AbstractAction mRunAction;
    private final JList mScriptList;
    private final IScriptModel mScriptModel;
    private final JTextArea mScriptResultField;
    private final JTextComponent mScriptTextField;
    private final SignAction mSignAction;
    private final JLabel mStatus;

    public ScriptEditorPanel(IScriptModel pScriptModel, boolean pHasNewScriptFunctionality) {
        super(UITools.getCurrentFrame(), false);
        this.mScriptModel = pScriptModel;
        String scriptTitle = pScriptModel.getTitle();
        this.setTitle(TextUtils.getText((String)"plugins/ScriptEditor/window.title") + (scriptTitle.isEmpty() ? "" : " [" + scriptTitle + "]"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ScriptEditorPanel.this.disposeDialog(true);
            }
        });
        UITools.addEscapeActionToDialog((JDialog)this, (Action)new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScriptEditorPanel.this.disposeDialog(true);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.mListModel = new DefaultListModel();
        this.mScriptList = new JList(this.mListModel);
        this.mScriptList.setSelectionMode(0);
        this.mScriptList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent pEvent) {
                if (pEvent.getValueIsAdjusting()) {
                    return;
                }
                ScriptEditorPanel.this.select(ScriptEditorPanel.this.mScriptList.getSelectedIndex());
            }
        });
        JEditorPane editorPane = new JEditorPane();
        SourceTextEditorUIConfigurator.configureColors((JTextComponent)editorPane);
        this.mScriptTextField = editorPane;
        this.mScriptTextField.setEnabled(false);
        JRestrictedSizeScrollPane scriptScrollPane = new JRestrictedSizeScrollPane((Component)this.mScriptTextField);
        UITools.setScrollbarIncrement((JScrollPane)scriptScrollPane);
        this.mCentralUpperPanel = new JSplitPane(1, this.mScriptList, (Component)scriptScrollPane);
        try {
            editorPane.setContentType("text/groovy");
            String fontName = ResourceController.getResourceController().getProperty(GROOVY_EDITOR_FONT);
            int fontSize = ResourceController.getResourceController().getIntProperty(GROOVY_EDITOR_FONT_SIZE);
            Font font = UITools.scaleUI((Font)new Font(fontName, 0, fontSize));
            editorPane.setFont(font);
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
            editorPane.setContentType("text/plain");
        }
        this.mCentralUpperPanel.setContinuousLayout(true);
        this.mScriptResultField = new JTextArea();
        this.mScriptResultField.setEditable(false);
        this.mScriptResultField.setWrapStyleWord(true);
        JScrollPane resultScrollPane = new JScrollPane(this.mScriptResultField);
        UITools.setScrollbarIncrement((JScrollPane)resultScrollPane);
        this.mCentralPanel = new JSplitPane(0, this.mCentralUpperPanel, resultScrollPane);
        this.mCentralPanel.setDividerLocation(0.8);
        this.mCentralPanel.setContinuousLayout(true);
        contentPane.add((Component)this.mCentralPanel, "Center");
        this.mStatus = new JLabel();
        contentPane.add((Component)this.mStatus, "South");
        this.mScriptTextField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent arg0) {
                int caretPosition = ScriptEditorPanel.this.mScriptTextField.getCaretPosition();
                try {
                    int lineOfOffset = ActionUtils.getLineNumber((JTextComponent)ScriptEditorPanel.this.mScriptTextField, (int)caretPosition);
                    ScriptEditorPanel.this.mStatus.setText("Line: " + (lineOfOffset + 1) + ", Column: " + (caretPosition - ActionUtils.getLineNumber((JTextComponent)ScriptEditorPanel.this.mScriptTextField, (int)lineOfOffset) + 1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.updateFields();
        this.mScriptTextField.repaint();
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu();
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)menu, (String)TextUtils.getRawText((String)"plugins/ScriptEditor.menu_actions"));
        if (pHasNewScriptFunctionality) {
            this.addAction(menu, new NewScriptAction(TextUtils.getRawText((String)"plugins/ScriptEditor.new_script")));
        }
        this.mRunAction = new RunAction(TextUtils.getRawText((String)"plugins/ScriptEditor.run"));
        this.mRunAction.setEnabled(false);
        this.addAction(menu, this.mRunAction);
        this.mSignAction = new SignAction(TextUtils.getRawText((String)"plugins/ScriptEditor.sign"));
        this.mSignAction.setEnabled(false);
        this.addAction(menu, this.mSignAction);
        CancelAction cancelAction = new CancelAction(TextUtils.getRawText((String)"plugins/ScriptEditor.cancel"));
        this.addAction(menu, cancelAction);
        ExitAction exitAction = new ExitAction(TextUtils.getRawText((String)"plugins/ScriptEditor.exit"));
        this.addAction(menu, exitAction);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        ScriptEditorWindowConfigurationStorage storage = this.mScriptModel.decorateDialog(this, WINDOW_PREFERENCE_STORAGE_PROPERTY);
        if (storage != null) {
            this.mCentralUpperPanel.setDividerLocation(storage.getLeftRatio());
            this.mCentralPanel.setDividerLocation(storage.getTopRatio());
        } else {
            this.mCentralUpperPanel.setDividerLocation(100);
            this.mCentralPanel.setDividerLocation(240);
        }
    }

    private void addAction(JMenu menu, AbstractAction action) {
        JMenuItem item = menu.add(action);
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)item, (String)((String)action.getValue("Name")));
        item.setIcon((Icon)new EmptyIcon(16));
    }

    private void disposeDialog(boolean pIsCanceled) {
        int action;
        if (!this.mScriptList.isSelectionEmpty()) {
            this.select(this.mScriptList.getSelectedIndex());
        }
        if (pIsCanceled && this.mScriptModel.isDirty() && ((action = JOptionPane.showConfirmDialog(this, TextUtils.getText((String)"ScriptEditorPanel.changed_cancel"), "Freeplane", 2)) == 2 || action == -1)) {
            return;
        }
        ScriptEditorWindowConfigurationStorage storage = new ScriptEditorWindowConfigurationStorage();
        storage.setLeftRatio(this.mCentralUpperPanel.getDividerLocation());
        storage.setTopRatio(this.mCentralPanel.getDividerLocation());
        this.mScriptModel.storeDialogPositions(this, storage, WINDOW_PREFERENCE_STORAGE_PROPERTY);
        this.setVisible(false);
        this.dispose();
        this.mScriptModel.endDialog(pIsCanceled);
    }

    IFreeplaneScriptErrorHandler getErrorHandler() {
        return new IFreeplaneScriptErrorHandler(){

            @Override
            public void gotoLine(int pLineNumber) {
                ActionUtils.setCaretPosition((JTextComponent)ScriptEditorPanel.this.mScriptTextField, (int)pLineNumber, (int)1);
            }
        };
    }

    PrintStream getPrintStream() {
        try {
            return new PrintStream((OutputStream)new ResultFieldStream(), false, internalCharset);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private void select(int pIndex) {
        this.mScriptTextField.setEnabled(pIndex >= 0);
        this.mRunAction.setEnabled(pIndex >= 0);
        this.mSignAction.setEnabled(pIndex >= 0);
        if (pIndex < 0) {
            this.mScriptTextField.setText("");
            return;
        }
        this.storeCurrent();
        this.mScriptTextField.setText(this.mScriptModel.getScript(pIndex).getScript());
        this.mLastSelected = pIndex;
        if (pIndex >= 0 && this.mScriptList.getSelectedIndex() != pIndex) {
            this.mScriptList.setSelectedIndex(pIndex);
        }
    }

    private void storeCurrent() {
        if (this.mLastSelected != null) {
            int oldIndex = this.mLastSelected;
            this.mScriptModel.setScript(oldIndex, this.mScriptModel.getScript(oldIndex).setScript(this.mScriptTextField.getText()));
        }
    }

    private void updateFields() {
        this.mListModel.clear();
        for (int i = 0; i < this.mScriptModel.getAmountOfScripts(); ++i) {
            ScriptHolder script = this.mScriptModel.getScript(i);
            this.mListModel.addElement(script.getScriptName());
        }
    }

    public static interface IScriptModel {
        public int addNewScript();

        public ScriptEditorWindowConfigurationStorage decorateDialog(ScriptEditorPanel var1, String var2);

        public void endDialog(boolean var1);

        public Object executeScript(int var1, PrintStream var2, IFreeplaneScriptErrorHandler var3);

        public int getAmountOfScripts();

        public ScriptHolder getScript(int var1);

        public boolean isDirty();

        public void setScript(int var1, ScriptHolder var2);

        public void storeDialogPositions(ScriptEditorPanel var1, ScriptEditorWindowConfigurationStorage var2, String var3);

        public String getTitle();
    }

    private final class NewScriptAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private NewScriptAction(String pArg0) {
            super(pArg0);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ScriptEditorPanel.this.storeCurrent();
            ScriptEditorPanel.this.mLastSelected = null;
            int scriptIndex = ScriptEditorPanel.this.mScriptModel.addNewScript();
            ScriptEditorPanel.this.updateFields();
            ScriptEditorPanel.this.select(scriptIndex);
        }
    }

    private final class RunAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private RunAction(String pArg0) {
            super(pArg0);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ScriptEditorPanel.this.storeCurrent();
            if (!ScriptEditorPanel.this.mScriptList.isSelectionEmpty()) {
                ScriptEditorPanel.this.mScriptResultField.setText("");
                Object result = null;
                try {
                    result = ScriptEditorPanel.this.mScriptModel.executeScript(ScriptEditorPanel.this.mScriptList.getSelectedIndex(), ScriptEditorPanel.this.getPrintStream(), ScriptEditorPanel.this.getErrorHandler());
                }
                catch (Throwable e2) {
                    LogUtils.warn((Throwable)e2);
                    Throwable cause = e2.getCause();
                    String causeMessage = "";
                    if (cause != null && cause.getMessage() != null) {
                        causeMessage = cause.getMessage();
                    }
                    String message = e2.getMessage() != null ? e2.getMessage() : "";
                    UITools.errorMessage((Object)(e2.getClass().getName() + ": " + causeMessage + (causeMessage.length() != 0 && message.length() != 0 ? ", " : "") + message));
                    result = message;
                }
                ScriptEditorPanel.this.getPrintStream().print(TextUtils.getText((String)"plugins/ScriptEditor/window.Result") + result);
            }
        }
    }

    private final class SignAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private SignAction(String pArg0) {
            super(pArg0);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ScriptEditorPanel.this.storeCurrent();
            if (!ScriptEditorPanel.this.mScriptList.isSelectionEmpty()) {
                int selectedIndex = ScriptEditorPanel.this.mScriptList.getSelectedIndex();
                ScriptHolder script = ScriptEditorPanel.this.mScriptModel.getScript(selectedIndex);
                String signedScript = new SignedScriptHandler().signScript(script.mScript);
                script.setScript(signedScript);
                ScriptEditorPanel.this.mScriptModel.setScript(selectedIndex, script);
                ScriptEditorPanel.this.mScriptTextField.setText(signedScript);
            }
        }
    }

    private final class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CancelAction(String pArg0) {
            super(pArg0);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ScriptEditorPanel.this.disposeDialog(true);
        }
    }

    private final class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private ExitAction(String pArg0) {
            super(pArg0);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ScriptEditorPanel.this.storeCurrent();
            ScriptEditorPanel.this.disposeDialog(false);
        }
    }

    private final class ResultFieldStream
    extends OutputStream {
        private final byte[] buf = new byte[2];
        private int i = 0;

        private ResultFieldStream() {
        }

        @Override
        public void write(int pByte) throws IOException {
            this.buf[this.i++] = (byte)pByte;
            if (this.i == 2) {
                ScriptEditorPanel.this.mScriptResultField.append(new String(this.buf, ScriptEditorPanel.internalCharset));
                this.i = 0;
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.i == 1) {
                this.write(b[off++]);
                --len;
            }
            if (len <= 0) {
                return;
            }
            int len2 = len & 0xFFFFFFFE;
            ScriptEditorPanel.this.mScriptResultField.append(new String(b, off, len2, ScriptEditorPanel.internalCharset));
            if (len2 != len) {
                this.write(b[len2]);
            }
        }
    }

    public static class ScriptHolder {
        String mScript;
        String mScriptName;

        public ScriptHolder(String pScriptName, String pScript) {
            this.mScript = pScript;
            this.mScriptName = pScriptName;
        }

        public String getScript() {
            return this.mScript;
        }

        public String getScriptName() {
            return this.mScriptName;
        }

        public ScriptHolder setScript(String pScript) {
            this.mScript = pScript;
            return this;
        }

        public ScriptHolder setScriptName(String pScriptName) {
            this.mScriptName = pScriptName;
            return this;
        }
    }
}

