/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.EventQueue;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JFilterableComboBox<V>
extends JComboBox<V> {
    private static final long serialVersionUID = 1L;
    private final Supplier<Collection<V>> itemSupplier;
    private boolean filterIsRunning;
    private BiPredicate<Collection<V>, String> acceptAll;
    private BiPredicate<V, String> acceptItem;

    public JFilterableComboBox(Supplier<Collection<V>> itemSupplier, BiPredicate<Collection<V>, String> acceptAll, BiPredicate<V, String> acceptItem) {
        this.itemSupplier = itemSupplier;
        this.acceptAll = acceptAll;
        this.acceptItem = acceptItem;
        this.updateListItems(true);
        final Timer timer = new Timer(200, x -> this.updateListItems(false));
        timer.setRepeats(false);
        final DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!JFilterableComboBox.this.filterIsRunning) {
                    timer.restart();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!JFilterableComboBox.this.filterIsRunning) {
                    timer.restart();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!JFilterableComboBox.this.filterIsRunning) {
                    timer.restart();
                }
            }
        };
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                JFilterableComboBox.this.updateListItems(false);
                JTextField textField = (JTextField)JFilterableComboBox.this.getEditor().getEditorComponent();
                textField.getDocument().addDocumentListener(documentListener);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                JTextField textField = (JTextField)JFilterableComboBox.this.getEditor().getEditorComponent();
                textField.getDocument().removeDocumentListener(documentListener);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!JFilterableComboBox.this.isPopupVisible()) {
                    EventQueue.invokeLater(this::showPopup);
                }
            }

            private void showPopup() {
                if (JFilterableComboBox.this.isShowing()) {
                    JFilterableComboBox.this.showPopup();
                }
            }
        });
    }

    @Override
    public void configureEditor(ComboBoxEditor anEditor, Object anItem) {
        if (!this.filterIsRunning) {
            super.configureEditor(anEditor, anItem);
        }
    }

    public boolean isFilterRunning() {
        return this.filterIsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateListItems(boolean init) {
        if (this.filterIsRunning) {
            return;
        }
        this.filterIsRunning = true;
        try {
            Stream<V> tagStream;
            String text;
            DefaultComboBoxModel model;
            block8: {
                block7: {
                    model = (DefaultComboBoxModel)this.getModel();
                    model.removeAllElements();
                    JTextField textField = (JTextField)this.getEditor().getEditorComponent();
                    text = textField.getText();
                    Collection<V> items = this.itemSupplier.get();
                    tagStream = items.stream();
                    if (init) break block7;
                    if (!this.acceptAll.test(items, text)) break block8;
                }
                tagStream.forEach(model::addElement);
                return;
            }
            tagStream.filter(item -> this.acceptItem.test(item, text)).forEach(model::addElement);
            return;
        }
        finally {
            this.filterIsRunning = false;
        }
    }
}

