/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.ui.components.TagIcon;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.factory.IconFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.styles.LogicalStyleController;

public class MultipleImageIcon
implements Icon {
    private final int TAG_GAP = new Quantity(2.0, (Enum)LengthUnit.pt).toBaseUnitsRounded();
    private final List<Icon> mIcons = new ArrayList<Icon>();
    private final List<NamedIcon> mUIIcons = new ArrayList<NamedIcon>();
    private final List<TagIcon> mTags = new ArrayList<TagIcon>();

    public void addIcon(NamedIcon uiIcon) {
        Icon icon = uiIcon.getIcon();
        Objects.requireNonNull(icon);
        this.mIcons.add(icon);
        this.mUIIcons.add(uiIcon);
    }

    public void addIcon(NamedIcon uiIcon, Quantity<LengthUnit> iconHeight) {
        Icon icon = uiIcon.getIcon(iconHeight);
        Objects.requireNonNull(icon);
        this.mIcons.add(icon);
        this.mUIIcons.add(uiIcon);
    }

    public void addLinkIcon(Icon icon, NodeModel node, LogicalStyleController.StyleOption option) {
        Objects.requireNonNull(icon);
        Quantity<LengthUnit> iconHeight = IconController.getController().getIconSize(node, option);
        IconFactory iconFactory = IconFactory.getInstance();
        Icon scaledIcon = iconFactory.canScaleIcon(icon) ? iconFactory.getScaledIcon(icon, iconHeight) : icon;
        this.mIcons.add(scaledIcon);
        this.mUIIcons.add(null);
    }

    public void addIcon(Icon icon) {
        Objects.requireNonNull(icon);
        this.mIcons.add(icon);
        this.mUIIcons.add(null);
    }

    public void addTag(TagIcon tag) {
        Objects.requireNonNull(tag);
        this.mTags.add(tag);
    }

    @Override
    public int getIconHeight() {
        int height = this.getGraphicalIconHeight();
        for (Icon icon : this.mTags) {
            height += this.TAG_GAP + icon.getIconHeight();
        }
        return height;
    }

    private int getGraphicalIconHeight() {
        int myY = 0;
        for (Icon icon : this.mIcons) {
            int otherHeight = icon.getIconHeight();
            if (otherHeight <= myY) continue;
            myY = otherHeight;
        }
        return myY;
    }

    @Override
    public int getIconWidth() {
        int width = this.getGraphicalIconWidth();
        for (Icon icon : this.mTags) {
            width = Math.max(width, icon.getIconWidth());
        }
        return width;
    }

    private int getGraphicalIconWidth() {
        int myX = 0;
        for (Icon icon : this.mIcons) {
            myX += icon.getIconWidth();
        }
        return myX;
    }

    public int getImageCount() {
        return this.mIcons.size();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        boolean isLeftToRight = c.getComponentOrientation().isLeftToRight();
        int graphicalIconWidth = isLeftToRight ? this.getGraphicalIconWidth() : 0;
        int iconWidth = isLeftToRight ? this.getIconWidth() : 0;
        int myX = isLeftToRight ? x + iconWidth - graphicalIconWidth : x;
        for (Icon icon : this.mIcons) {
            icon.paintIcon(c, g, myX, y);
            myX += icon.getIconWidth();
        }
        int graphicalIconHeight = this.getGraphicalIconHeight();
        int myY = graphicalIconHeight == 0 ? y : y + this.TAG_GAP + graphicalIconHeight;
        for (Icon icon : this.mTags) {
            int myX2 = isLeftToRight ? x + iconWidth - icon.getIconWidth() : x;
            icon.paintIcon(c, g, myX2, myY);
            myY += this.TAG_GAP + icon.getIconHeight();
        }
    }

    public NamedIcon getUIIconAt(Point coordinate) {
        if (this.mIcons.isEmpty() || coordinate.x < 0 || coordinate.y < 0 || coordinate.y >= this.getGraphicalIconHeight()) {
            return null;
        }
        int iconX = 0;
        for (int iconIndex = 0; iconIndex < this.mIcons.size(); ++iconIndex) {
            if (coordinate.x > (iconX += this.mIcons.get(iconIndex).getIconWidth())) continue;
            return this.mUIIcons.get(iconIndex);
        }
        return null;
    }

    public Tag getTagAt(Point coordinate) {
        if (this.mTags.isEmpty() || coordinate.x < 0 || coordinate.y <= this.getGraphicalIconHeight() || coordinate.x >= this.getIconWidth()) {
            return null;
        }
        int graphicalIconHeight = this.getGraphicalIconHeight();
        int myY = graphicalIconHeight == 0 ? 0 : this.TAG_GAP + graphicalIconHeight;
        for (TagIcon icon : this.mTags) {
            int iconHeight = icon.getIconHeight();
            if (myY <= coordinate.y && coordinate.y < myY + iconHeight) {
                return icon.getTag();
            }
            myY += this.TAG_GAP + iconHeight;
        }
        return null;
    }

    public Rectangle getIconR(Icon icon) {
        int myX = 0;
        for (Icon ico : this.mIcons) {
            if (ico.equals(icon)) {
                return new Rectangle(myX, 0, ico.getIconWidth(), ico.getIconHeight());
            }
            myX += ico.getIconWidth();
        }
        return null;
    }

    public boolean containsIcons() {
        return !this.mIcons.isEmpty() || !this.mTags.isEmpty();
    }
}

