/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewManager;

public class TagIcon
implements Icon {
    private final Tag tag;
    private final Font font;
    private final int width;
    private final int height;

    public TagIcon(Tag tag, Font font) {
        this.tag = tag;
        this.font = font;
        String content = tag.isEmpty() ? "*" : tag.getContent();
        Rectangle2D rect = font.getStringBounds(content, 0, content.length(), new FontRenderContext(new AffineTransform(), true, true));
        double textHeight = rect.getHeight();
        this.width = tag.isEmpty() ? 0 : (int)Math.ceil(rect.getWidth() + textHeight);
        this.height = (int)Math.ceil(textHeight * 1.2);
    }

    @Override
    public void paintIcon(Component c, Graphics prototypeGraphics, int x, int y) {
        if (this.tag.isEmpty()) {
            return;
        }
        Graphics2D g = (Graphics2D)prototypeGraphics.create();
        Color backgroundColor = this.tag.getColor();
        Color textColor = UITools.getTextColorForBackground(backgroundColor);
        g.setColor(backgroundColor);
        int r = (int)(UITools.FONT_SCALE_FACTOR * 10.0f);
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        mapViewManager.setEdgesRenderingHint(g);
        g.fillRoundRect(x, y, this.width, this.height, r, r);
        g.setColor(textColor);
        g.drawRoundRect(x, y, this.width - 1, this.height - 1, r, r);
        g.setFont(this.font);
        mapViewManager.setTextRenderingHint(g);
        g.drawString(this.tag.getContent(), x + this.height / 2, y + this.height * 4 / 5);
        g.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public Tag getTag() {
        return this.tag;
    }
}

