/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter.condition;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.freeplane.core.ui.components.TagIcon;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.svgicons.FixedSizeUIIcon;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.UIIcon;

public class DefaultConditionRenderer
implements ListCellRenderer,
TableCellRenderer {
    private final String noValueText;
    private final boolean renderNamedConditions;

    public DefaultConditionRenderer(String noValueText, boolean renderNamedConditions) {
        this.noValueText = noValueText;
        this.renderNamedConditions = renderNamedConditions;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component cellRendererComponent = this.getCellRendererComponent(value, isSelected);
        if (isSelected) {
            cellRendererComponent.setBackground(list.getSelectionBackground());
            cellRendererComponent.setForeground(list.getSelectionForeground());
        } else {
            cellRendererComponent.setBackground(list.getBackground());
            cellRendererComponent.setForeground(list.getForeground());
        }
        return cellRendererComponent;
    }

    public Component getCellRendererComponent(Object value, boolean isSelected) {
        JComponent component;
        if (value == null) {
            component = new JLabel(this.noValueText);
            component.setOpaque(true);
        } else if (value instanceof UIIcon) {
            JLabel label = new JLabel();
            Font font = label.getFont();
            int fontHeight = label.getFontMetrics(font).getHeight();
            UIIcon uiIcon = (UIIcon)value;
            FixedSizeUIIcon icon = FixedSizeUIIcon.withHeigth(uiIcon.getUrl(), fontHeight, uiIcon.hasStandardSize());
            label.setIcon(icon);
            label.setHorizontalAlignment(0);
            label.setOpaque(false);
            component = label;
        } else if (value instanceof Tag) {
            JLabel label = new JLabel();
            Tag tag = (Tag)value;
            TagIcon icon = new TagIcon(tag, UITools.getUIFont());
            label.setIcon(icon);
            label.setHorizontalAlignment(10);
            label.setOpaque(false);
            component = label;
        } else if (value instanceof ASelectableCondition) {
            ASelectableCondition cond = (ASelectableCondition)value;
            String userName = cond.getUserName();
            if (this.renderNamedConditions || userName == null) {
                component = cond.getListCellRendererComponent();
            } else {
                component = new JLabel(userName);
                component.setToolTipText(cond.createDescription());
                component.setOpaque(true);
            }
        } else {
            component = new JLabel(value.toString());
            component.setOpaque(true);
        }
        component.setAlignmentX(0.0f);
        return component;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cellRendererComponent = this.getCellRendererComponent(value, isSelected);
        if (isSelected) {
            cellRendererComponent.setBackground(table.getSelectionBackground());
            cellRendererComponent.setForeground(table.getSelectionForeground());
        } else {
            cellRendererComponent.setBackground(table.getBackground());
            cellRendererComponent.setForeground(table.getForeground());
        }
        return cellRendererComponent;
    }
}

