/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.mindmapmode.UncategorizedTag;

public interface CategorizedTag
extends Comparable<CategorizedTag> {
    public static final CategorizedTag EMPTY_TAG = new UncategorizedTag(Tag.EMPTY_TAG);

    public Tag tag();

    public List<Tag> categoryTags();

    default public boolean isEmpty() {
        return this.tag().isEmpty();
    }

    default public Tag categorizedTag(String tagCategorySeparator) {
        Tag tag = this.tag();
        String content = this.getContent(tagCategorySeparator);
        return new Tag(content, tag.getColor());
    }

    default public String getContent(String tagCategorySeparator) {
        return this.categoryTags().stream().map(Tag::getContent).collect(Collectors.joining(tagCategorySeparator));
    }

    @Override
    default public int compareTo(CategorizedTag other) {
        List<Tag> categoryTags = this.categoryTags();
        List<Tag> otherTags = other.categoryTags();
        return IntStream.range(0, Math.min(categoryTags.size(), otherTags.size())).map(i -> ((Tag)categoryTags.get(i)).compareTo((Tag)otherTags.get(i))).filter(result -> result != 0).findFirst().orElse(Integer.compare(categoryTags.size(), otherTags.size()));
    }
}

