/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;
import org.freeplane.features.icon.CategorizedTag;
import org.freeplane.features.icon.Tag;

public class CategorizedTagForCategoryNode
implements CategorizedTag {
    private final DefaultMutableTreeNode categoryNode;
    private final Tag registeredTag;

    public CategorizedTagForCategoryNode(DefaultMutableTreeNode categoryNode) {
        this(categoryNode, Optional.empty());
    }

    public CategorizedTagForCategoryNode(DefaultMutableTreeNode categoryNode, Optional<Tag> registeredTag) {
        this.categoryNode = categoryNode;
        this.registeredTag = registeredTag.orElseGet(this::nodeTag).copy();
    }

    @Override
    public Tag tag() {
        return this.registeredTag;
    }

    private Tag nodeTag() {
        Object userObject = this.categoryNode.getUserObject();
        if (userObject instanceof Tag) {
            return (Tag)userObject;
        }
        return Tag.EMPTY_TAG;
    }

    @Override
    public List<Tag> categoryTags() {
        if ((DefaultMutableTreeNode)this.categoryNode.getParent() == null) {
            return Collections.emptyList();
        }
        Object[] userObjectPath = this.categoryNode.getUserObjectPath();
        Stream<Object> nodes = Stream.of(userObjectPath).skip(1L);
        if (userObjectPath.length > 1 && !(userObjectPath[1] instanceof Tag)) {
            nodes = nodes.skip(1L);
        }
        return nodes.map(Tag.class::cast).collect(Collectors.toList());
    }

    public String toString() {
        return "CategorizedTagForCategoryNode [getContent()=" + this.getContent("::") + "]";
    }
}

