/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.collection.ExtendedComboBoxModel;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.DefaultConditionRenderer;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.icon.IconContainedCondition;
import org.freeplane.features.icon.IconExistsCondition;
import org.freeplane.features.icon.IconRegistry;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagCompareCondition;
import org.freeplane.features.icon.TagContainsCondition;
import org.freeplane.features.icon.TagMatchesCondition;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.mode.Controller;
import org.freeplane.n3.nanoxml.XMLElement;

class IconConditionController
implements IElementaryConditionController {
    static final String FILTER_ICON = "filter_icon";
    static final String FILTER_TAG = "filter_tag";
    static final String FILTER_ANY_TAG_CATEGORY = "filter_tag_category";

    @Override
    public boolean canEditValues(Object property, TranslatedObject simpleCond) {
        TranslatedObject o = (TranslatedObject)property;
        return o.objectEquals(FILTER_TAG) || o.objectEquals(FILTER_ANY_TAG_CATEGORY);
    }

    @Override
    public boolean canHandle(Object selectedItem) {
        if (!(selectedItem instanceof TranslatedObject)) {
            return false;
        }
        TranslatedObject namedObject = (TranslatedObject)selectedItem;
        return namedObject.objectEquals(FILTER_ICON) || namedObject.objectEquals(FILTER_TAG) || namedObject.objectEquals(FILTER_ANY_TAG_CATEGORY);
    }

    @Override
    public boolean canSelectValues(Object property, TranslatedObject simpleCond) {
        return !simpleCond.objectEquals("filter_exist");
    }

    @Override
    public ASelectableCondition createCondition(Object selectedItem, TranslatedObject simpleCondition, Object value, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        boolean searchesAcrossAllCategories;
        TranslatedObject namedObject = (TranslatedObject)selectedItem;
        if (namedObject.objectEquals(FILTER_ICON)) {
            if (simpleCondition.objectEquals("filter_contains")) {
                return value instanceof UIIcon ? new IconContainedCondition(((UIIcon)value).getName()) : null;
            }
            if (simpleCondition.objectEquals("filter_exist")) {
                return new IconExistsCondition();
            }
        }
        if ((searchesAcrossAllCategories = namedObject.objectEquals(FILTER_ANY_TAG_CATEGORY)) || namedObject.objectEquals(FILTER_TAG)) {
            String comparedString;
            String string = comparedString = value instanceof Tag ? ((Tag)value).getContent() : value.toString();
            if (simpleCondition.objectEquals("filter_is_equal_to")) {
                return new TagCompareCondition(comparedString, matchCase, 0, true, matchApproximately, ignoreDiacritics, searchesAcrossAllCategories);
            }
            if (simpleCondition.objectEquals("filter_is_not_equal_to")) {
                return new TagCompareCondition(comparedString, matchCase, 0, false, matchApproximately, ignoreDiacritics, searchesAcrossAllCategories);
            }
            if (simpleCondition.objectEquals(">")) {
                return new TagCompareCondition(comparedString, matchCase, 1, true, false, ignoreDiacritics, searchesAcrossAllCategories);
            }
            if (simpleCondition.objectEquals(">=")) {
                return new TagCompareCondition(comparedString, matchCase, -1, false, false, ignoreDiacritics, searchesAcrossAllCategories);
            }
            if (simpleCondition.objectEquals("<")) {
                return new TagCompareCondition(comparedString, matchCase, -1, true, false, ignoreDiacritics, searchesAcrossAllCategories);
            }
            if (simpleCondition.objectEquals("<=")) {
                return new TagCompareCondition(comparedString, matchCase, 1, false, false, ignoreDiacritics, searchesAcrossAllCategories);
            }
            if (simpleCondition.objectEquals("filter_regexp_matches")) {
                return new TagMatchesCondition(comparedString.toString(), matchCase, searchesAcrossAllCategories);
            }
            if (simpleCondition.objectEquals("filter_contains")) {
                return new TagContainsCondition(comparedString, matchCase, matchApproximately, false, ignoreDiacritics, searchesAcrossAllCategories);
            }
            if (simpleCondition.objectEquals("filter_contains_wordwise")) {
                return new TagContainsCondition(comparedString, matchCase, matchApproximately, true, ignoreDiacritics, searchesAcrossAllCategories);
            }
        }
        return null;
    }

    @Override
    public ComboBoxModel getConditionsForProperty(Object property) {
        TranslatedObject namedObject = (TranslatedObject)property;
        if (namedObject.objectEquals(FILTER_ICON)) {
            return new DefaultComboBoxModel<Object>(this.getIconConditionNames());
        }
        if (namedObject.objectEquals(FILTER_TAG) || namedObject.objectEquals(FILTER_ANY_TAG_CATEGORY)) {
            return new DefaultComboBoxModel<Object>(this.getTagConditionNames());
        }
        throw new IllegalArgumentException(String.valueOf(property));
    }

    @Override
    public ListModel getFilteredProperties() {
        DefaultListModel<TranslatedObject> list = new DefaultListModel<TranslatedObject>();
        list.addElement(TextUtils.createTranslatedString(FILTER_ICON));
        list.addElement(TextUtils.createTranslatedString(FILTER_TAG));
        list.addElement(TextUtils.createTranslatedString(FILTER_ANY_TAG_CATEGORY));
        return list;
    }

    public Object[] getIconConditionNames() {
        return new TranslatedObject[]{TextUtils.createTranslatedString("filter_contains"), TextUtils.createTranslatedString("filter_exist")};
    }

    public Object[] getTagConditionNames() {
        return new TranslatedObject[]{TextUtils.createTranslatedString("filter_contains"), TextUtils.createTranslatedString("filter_contains_wordwise"), TextUtils.createTranslatedString("filter_regexp_matches"), TextUtils.createTranslatedString("filter_is_equal_to"), TextUtils.createTranslatedString("filter_is_not_equal_to"), TranslatedObject.literal(">"), TranslatedObject.literal(">="), TranslatedObject.literal("<="), TranslatedObject.literal("<")};
    }

    @Override
    public ComboBoxEditor getValueEditor(Object selectedProperty, TranslatedObject selectedCondition) {
        return null;
    }

    @Override
    public ComboBoxModel getValuesForProperty(Object property, TranslatedObject simpleCond) {
        ExtendedComboBoxModel extendedComboBoxModel = new ExtendedComboBoxModel();
        TranslatedObject namedObject = (TranslatedObject)property;
        IconRegistry iconRegistry = Controller.getCurrentController().getMap().getIconRegistry();
        if (namedObject.objectEquals(FILTER_ICON)) {
            extendedComboBoxModel.setExtensionList(iconRegistry.getIconsAsListModel());
        } else if (namedObject.objectEquals(FILTER_TAG)) {
            extendedComboBoxModel.setExtensionList(iconRegistry.getTagCategories().getTagsAsListModel());
        }
        return extendedComboBoxModel;
    }

    @Override
    public boolean isCaseDependent(Object property, TranslatedObject simpleCond) {
        return false;
    }

    @Override
    public boolean supportsApproximateMatching(Object property, TranslatedObject simpleCond) {
        return false;
    }

    @Override
    public ASelectableCondition loadCondition(XMLElement element) {
        if (element.getName().equalsIgnoreCase("icon_contained_condition")) {
            return IconContainedCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("icon_exists_condition")) {
            return IconExistsCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("tag_compare_condition")) {
            return TagCompareCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("tag_matches_condition")) {
            return TagMatchesCondition.load(element);
        }
        return null;
    }

    @Override
    public ListCellRenderer getValueRenderer(Object selectedProperty, TranslatedObject selectedCondition) {
        return new DefaultConditionRenderer("", true);
    }
}

