/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.awt.Color;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import org.freeplane.core.ui.components.HSLColorConverter;
import org.freeplane.core.util.LineComparator;

public class Tag
implements Comparable<Tag> {
    public static final Tag EMPTY_TAG = new Tag("");
    public static final Tag REMOVED_TAG = new Tag(" removed tag ", Color.BLACK);
    private final String content;
    private Color color;

    public static Color getDefaultColor(String content) {
        if (content.isEmpty()) {
            return Color.BLACK;
        }
        long crc = Tag.computeCRC32(content);
        return HSLColorConverter.generateColorFromLong(crc);
    }

    public Tag(String content) {
        this(content, Tag.getDefaultColor(content));
    }

    public Tag(String content, Color color) {
        this.content = content;
        this.color = color;
    }

    public String getContent() {
        return this.content;
    }

    @Override
    public int compareTo(Tag o) {
        return LineComparator.compareLinesParsingNumbers(this.content, o.content);
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getDefaultColor() {
        return Tag.getDefaultColor(this.content);
    }

    public Tag copy() {
        return new Tag(this.content, this.color);
    }

    public Tag removeInternalCategories(String tagCategorySeparator) {
        if (tagCategorySeparator.isEmpty() || this.isEmpty()) {
            return this;
        }
        int tagIndex = this.getContent().lastIndexOf(tagCategorySeparator);
        return tagIndex == -1 ? this : new Tag(this.getContent().substring(tagIndex + tagCategorySeparator.length()), this.getColor());
    }

    public List<Tag> categoryTags(String tagCategorySeparator) {
        if (tagCategorySeparator.isEmpty() || this.isEmpty()) {
            return Collections.singletonList(this);
        }
        String[] categories = this.getContent().split(Pattern.quote(tagCategorySeparator));
        if (categories == null || categories.length < 2) {
            return Collections.singletonList(this);
        }
        return Stream.of(categories).map(content -> new Tag((String)content, this.color)).collect(Collectors.toList());
    }

    public Tag shortTag(String tagCategorySeparator) {
        if (tagCategorySeparator.isEmpty() || this.isEmpty()) {
            return this;
        }
        int shortTagBegin = this.content.lastIndexOf(tagCategorySeparator);
        if (shortTagBegin < 0) {
            return this;
        }
        return new Tag(this.content.substring(shortTagBegin + tagCategorySeparator.length()), this.color);
    }

    private static long computeCRC32(String input) {
        CRC32 crc = new CRC32();
        crc.update(input.getBytes(StandardCharsets.UTF_8));
        return crc.getValue();
    }

    public int hashCode() {
        return Objects.hash(this.content);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        return Objects.equals(this.content, other.content);
    }

    public String toString() {
        return this.content;
    }

    public Tag updateSeparator(String initialSeparator, String currentSeparator) {
        if (initialSeparator.equals(currentSeparator) || !this.getContent().contains(initialSeparator)) {
            return this;
        }
        return new Tag(this.content.replace(initialSeparator, currentSeparator), this.color);
    }
}

