/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.collection.SortedComboBoxModel;
import org.freeplane.features.icon.CategorizedTag;
import org.freeplane.features.icon.CategorizedTagForCategoryNode;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagReference;
import org.freeplane.features.icon.TreeInverseMap;
import org.freeplane.features.icon.TreeTagChangeListener;
import org.freeplane.features.icon.mindmapmode.UncategorizedTag;

public class TagCategories {
    private final DefaultTreeModel nodes;
    private TreeInverseMap<Tag> nodesByTags;
    private final SortedComboBoxModel<Tag> mapTags;
    private final TreeMap<String, List<TagReference>> tagReferences;
    private boolean categoriesChanged;
    private String categorySeparator;
    private final DefaultMutableTreeNode uncategorizedTagsNode;
    public static final String UNCATEGORIZED_NODE = " uncategorized node ";

    public static Tag readTag(String spec) {
        int colorIndex = spec.length() - 9;
        if (colorIndex > 0 && spec.charAt(colorIndex) == '#') {
            String content = spec.substring(0, colorIndex);
            String colorSpec = spec.substring(colorIndex);
            try {
                return new Tag(content, TagCategories.tagColor(content, colorSpec));
            }
            catch (NumberFormatException e) {
                LogUtils.severe(e);
            }
        }
        return new Tag(spec);
    }

    public TagCategories() {
        this(new DefaultMutableTreeNode(TextUtils.getRawText("tags")), new DefaultMutableTreeNode(TextUtils.getRawText("uncategorized_tags")), ResourceController.getResourceController().getProperty("category_separator"));
    }

    public TagCategories(DefaultMutableTreeNode rootNode, DefaultMutableTreeNode uncategorizedTagsNode, String categorySeparator) {
        this.uncategorizedTagsNode = uncategorizedTagsNode;
        this.categorySeparator = categorySeparator;
        this.mapTags = new SortedComboBoxModel<Tag>(Tag.class);
        rootNode.add(uncategorizedTagsNode);
        this.nodes = new TagCategoryTree(rootNode);
        this.tagReferences = new TreeMap();
        this.nodesByTags = null;
        this.categoriesChanged = false;
    }

    private TagCategories(TagCategories tagCategories) {
        this.mapTags = new SortedComboBoxModel<Tag>(Tag.class);
        DefaultMutableTreeNode rootNode = tagCategories.getRootNode();
        this.categorySeparator = tagCategories.categorySeparator;
        this.tagReferences = new TreeMap();
        tagCategories.tagReferences.entrySet().forEach(e -> this.tagReferences.put((String)e.getKey(), new ArrayList((Collection)e.getValue())));
        DefaultMutableTreeNode rootCopy = this.copySubtree(rootNode);
        this.uncategorizedTagsNode = (DefaultMutableTreeNode)rootCopy.getLastChild();
        this.nodes = new TagCategoryTree(rootCopy);
        this.nodesByTags = null;
        tagCategories.mapTags.forEach(this.mapTags::addIfNotExists);
        this.categoriesChanged = false;
    }

    public String getTagCategorySeparator() {
        return this.categorySeparator;
    }

    public void updateTagCategorySeparator(String newCategorySeparator) {
        String initialCategorySeparator = this.categorySeparator;
        if (!initialCategorySeparator.equals(newCategorySeparator)) {
            Tag[] initialTags;
            this.setTagCategorySeparator(newCategorySeparator);
            for (Tag tag2 : initialTags = (Tag[])this.mapTags.stream().filter(tag -> tag.getContent().contains(initialCategorySeparator)).toArray(Tag[]::new)) {
                String updatedContent = tag2.getContent().replace(initialCategorySeparator, newCategorySeparator);
                Tag updatedTag = new Tag(updatedContent, tag2.getColor());
                this.mapTags.replace(tag2, updatedTag);
                List<TagReference> replacedContentReferences = this.tagReferences.remove(tag2.getContent());
                if (replacedContentReferences == null) continue;
                this.tagReferences.computeIfAbsent(updatedContent, x -> new ArrayList()).addAll(replacedContentReferences);
            }
            for (int i = this.uncategorizedTagsNode.getChildCount() - 1; i >= 0; --i) {
                DefaultMutableTreeNode uncategorizedTagNode = (DefaultMutableTreeNode)this.uncategorizedTagsNode.getChildAt(i);
                Tag tag3 = (Tag)uncategorizedTagNode.getUserObject();
                if (!tag3.getContent().contains(newCategorySeparator)) continue;
                this.uncategorizedTagsNode.remove(i);
                this.mapTags.remove((Object)tag3);
                this.registerTagReference(tag3, true);
            }
            this.categoriesChanged = true;
        }
    }

    public void setTagCategorySeparator(String newCategorySeparator) {
        this.categorySeparator = newCategorySeparator;
    }

    public void writeCategorizedTag(DefaultMutableTreeNode node, StringWriter writer) {
        Object userObject = node.getUserObject();
        if (userObject instanceof Tag) {
            try {
                Tag categorizedTag = new CategorizedTagForCategoryNode(node).categorizedTag(this.categorySeparator);
                TagCategories.writeTag(categorizedTag, writer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void writeTagCategories(DefaultMutableTreeNode node, String indent, Writer writer) throws IOException {
        Object userObject = node.getUserObject();
        if (userObject instanceof Tag) {
            Tag tag = (Tag)userObject;
            writer.append(indent);
            TagCategories.writeTag(tag, writer);
            indent = indent + " ";
        } else if (node.getParent() != null) {
            return;
        }
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            TagCategories.writeTagCategories(childNode, indent, writer);
        }
    }

    public static void writeTag(Tag tag, Writer writer) throws IOException {
        if (!tag.isEmpty()) {
            writer.append(tag.getContent());
            writer.append(ColorUtils.colorToRGBAString(tag.getColor()));
        }
        writer.append(System.lineSeparator());
    }

    public boolean isEmpty() {
        return this.getRootNode().isLeaf();
    }

    public void readTagCategories(DefaultMutableTreeNode target, int firstIndex, Scanner scanner) {
        String prefix;
        DefaultMutableTreeNode lastNode = target;
        int lastIndentation = -1;
        int index = firstIndex;
        LinkedList<String> categorizedContent = new LinkedList<String>();
        String tagCategorySeparator = this.getTagCategorySeparator();
        if (!target.isRoot() && !(prefix = this.categorizedContent((DefaultMutableTreeNode)lastNode.getParent())).isEmpty()) {
            categorizedContent.add(prefix + tagCategorySeparator);
        }
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            int indentation = this.getIndentationLevel(line);
            String lineTags = line.trim();
            int lineTagIndex = 0;
            while (lineTagIndex < lineTags.length()) {
                DefaultMutableTreeNode parent;
                int lineTagEnd = lineTags.indexOf(tagCategorySeparator, lineTagIndex);
                String lineTag = lineTagEnd >= 0 ? lineTags.substring(lineTagIndex, lineTagEnd) : lineTags.substring(lineTagIndex);
                lineTagIndex = lineTagEnd >= 0 ? lineTagEnd + tagCategorySeparator.length() : lineTags.length();
                Tag tag = TagCategories.readTag(lineTag);
                if (target == this.uncategorizedTagsNode) {
                    this.insertUncategorizedTagNodeSorted(tag);
                    continue;
                }
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(tag);
                if (indentation == lastIndentation) {
                    parent = (DefaultMutableTreeNode)lastNode.getParent();
                } else if (indentation > lastIndentation) {
                    parent = lastNode;
                    Object userObject = parent.getUserObject();
                    String categorizedParentContent = (categorizedContent.isEmpty() ? "" : (String)categorizedContent.getLast()) + (userObject instanceof Tag ? ((Tag)userObject).getContent() + tagCategorySeparator : "");
                    categorizedContent.add(categorizedParentContent);
                } else {
                    parent = (DefaultMutableTreeNode)lastNode.getParent();
                    for (int i = 0; i < lastIndentation - indentation; ++i) {
                        parent = (DefaultMutableTreeNode)parent.getParent();
                        categorizedContent.removeLast();
                    }
                }
                parent.insert(newNode, target == parent ? index++ : parent.getChildCount());
                String categorizedTagContent = (String)categorizedContent.getLast() + tag.getContent();
                this.registerTagReference(new Tag(categorizedTagContent, tag.getColor()), !lineTag.equals(tag.getContent()));
                lastNode = newNode;
                lastIndentation = indentation++;
            }
        }
        if (target != this.uncategorizedTagsNode) {
            this.nodes.nodesWereInserted(target, IntStream.range(firstIndex, index).toArray());
        }
    }

    private void insertNode(DefaultMutableTreeNode parent, int index, DefaultMutableTreeNode newChild) {
        parent.insert(newChild, index);
        this.nodes.nodesWereInserted(parent, new int[]{index});
    }

    private int findUncategorizedTagIndex(Tag tag) {
        int low = 0;
        int high = this.uncategorizedTagsNode.getChildCount() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            DefaultMutableTreeNode midNode = (DefaultMutableTreeNode)this.uncategorizedTagsNode.getChildAt(mid);
            Tag midUserObject = (Tag)midNode.getUserObject();
            if (tag.compareTo(midUserObject) == 0) {
                return mid;
            }
            if (tag.compareTo(midUserObject) < 0) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return -(low + 1);
    }

    private void insertUncategorizedTagNodeSorted(Tag tag) {
        int index = this.findUncategorizedTagIndex(tag);
        int insertionPoint = index >= 0 ? index : -index - 1;
        this.insertNode(this.uncategorizedTagsNode, insertionPoint, new DefaultMutableTreeNode(tag));
    }

    private void insertUncategorizedTagNodeSorted(DefaultMutableTreeNode node) {
        int index = this.findUncategorizedTagIndex((Tag)node.getUserObject());
        int insertionPoint = index >= 0 ? index : -index - 1;
        this.insertNode(this.uncategorizedTagsNode, insertionPoint, node);
    }

    private DefaultMutableTreeNode removeUncategorizedTagNode(Tag tag) {
        int index = this.findUncategorizedTagIndex(tag);
        if (index < 0) {
            return null;
        }
        DefaultMutableTreeNode removedNode = (DefaultMutableTreeNode)this.uncategorizedTagsNode.getChildAt(index);
        this.removeNodeFromParent(removedNode);
        return removedNode;
    }

    private int getIndentationLevel(String line) {
        int indentation = 0;
        while (line.charAt(indentation) == ' ') {
            ++indentation;
        }
        return indentation;
    }

    public void load(File tagCategoryFile) {
        try (Scanner scanner = new Scanner(tagCategoryFile);){
            this.load(scanner);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void load(String data) {
        try (Scanner scanner = new Scanner(data);){
            this.load(scanner);
        }
    }

    private void load(Scanner scanner) {
        DefaultMutableTreeNode rootNode = this.getRootNode();
        while (rootNode.getChildCount() > 1) {
            rootNode.remove(0);
        }
        this.readTagCategories(rootNode, 0, scanner);
    }

    public DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.nodes.getRoot();
    }

    public DefaultMutableTreeNode getUncategorizedTagsNode() {
        return this.uncategorizedTagsNode;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.nodes.addTreeModelListener(treeModelListener);
    }

    void removeTreeModelListener(TreeModelListener l) {
        this.nodes.removeTreeModelListener(l);
    }

    public TreeNode[] addChildNode(MutableTreeNode parent) {
        DefaultMutableTreeNode rootNode = this.getRootNode();
        if (parent == null) {
            parent = rootNode;
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(Tag.EMPTY_TAG);
        this.nodes.insertNodeInto(newNode, parent, parent == rootNode ? parent.getChildCount() - 1 : parent.getChildCount());
        return this.nodes.getPathToRoot(newNode);
    }

    public TreeNode[] addSiblingNode(MutableTreeNode node) {
        TreeNode[] nothing = new TreeNode[]{};
        if (node == null) {
            return nothing;
        }
        MutableTreeNode parent = (MutableTreeNode)node.getParent();
        if (parent == null) {
            return nothing;
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(Tag.EMPTY_TAG);
        this.nodes.insertNodeInto(newNode, parent, parent.getIndex(node) + 1);
        return this.nodes.getPathToRoot(newNode);
    }

    public void removeNodeFromParent(MutableTreeNode node) {
        if (node.getParent() != null) {
            this.nodes.removeNodeFromParent(node);
        }
    }

    void save(File tagCategoryFile) {
        try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(tagCategoryFile));){
            TagCategories.writeTagCategories(this.getRootNode(), "", writer);
        }
        catch (IOException e) {
            LogUtils.severe(e);
        }
    }

    public String serialize() {
        try {
            StringWriter writer = new StringWriter();
            TagCategories.writeTagCategories(this.getRootNode(), "", writer);
            String serializedData = writer.toString();
            return serializedData;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void insert(DefaultMutableTreeNode parent, int index, String data) {
        if (parent == null) {
            parent = this.getRootNode();
        }
        try (Scanner st = new Scanner(new StringReader(data));){
            this.readTagCategories(parent, index, st);
        }
    }

    public List<CategorizedTag> categorizedTags() {
        return this.categorizedTags(this.mapTags);
    }

    public List<CategorizedTag> categorizedTags(Iterable<Tag> tags) {
        LinkedList<CategorizedTag> categorizedTags = new LinkedList<CategorizedTag>();
        HashSet<Tag> addedAdhocTags = new HashSet<Tag>();
        for (Tag qualifiedTag : tags) {
            if (qualifiedTag.isEmpty()) {
                categorizedTags.add(CategorizedTag.EMPTY_TAG);
                continue;
            }
            Tag tag = qualifiedTag.shortTag(this.getTagCategorySeparator());
            Set<DefaultMutableTreeNode> tagCategoryNodes = this.getNodes(tag);
            if (tagCategoryNodes.isEmpty()) {
                this.addAdhocTags(categorizedTags, addedAdhocTags, tag);
                continue;
            }
            for (DefaultMutableTreeNode node : tagCategoryNodes) {
                categorizedTags.add(new CategorizedTagForCategoryNode(node, this.getTag(tag)));
            }
        }
        return categorizedTags;
    }

    private Set<DefaultMutableTreeNode> getNodes(Tag tag) {
        if (this.nodesByTags == null) {
            this.nodesByTags = new TreeInverseMap(this.nodes);
            this.nodes.addTreeModelListener(this.nodesByTags);
        }
        return this.nodesByTags.getNodes(tag);
    }

    private void addAdhocTags(LinkedList<CategorizedTag> categorizedTags, Set<Tag> addedAdhocTags, Tag tag) {
        if (addedAdhocTags.add(tag)) {
            String tagContent = tag.getContent();
            int separatorIndex = tagContent.lastIndexOf(this.categorySeparator);
            if (separatorIndex > 0) {
                this.addAdhocTags(categorizedTags, addedAdhocTags, new Tag(tagContent.substring(0, separatorIndex)));
            }
            categorizedTags.add((CategorizedTag)new UncategorizedTag(tag));
        }
    }

    public DefaultTreeModel getNodes() {
        return this.nodes;
    }

    public SortedComboBoxModel<Tag> getTagsAsListModel() {
        return this.mapTags;
    }

    public Tag createTag(String string) {
        return this.createTagReference(string).getTag();
    }

    public TagReference createTagReference(String string) {
        return this.registerTagReference(new Tag(string));
    }

    public TagReference registerTagReference(Tag tag) {
        return this.registerTagReference(tag, false);
    }

    /*
     * Unable to fully structure code
     */
    private TagReference registerTagReference(Tag tag, boolean setColor) {
        block10: {
            block9: {
                block11: {
                    addedElementIndex = this.mapTags.addIfNotExists(tag);
                    if (addedElementIndex < 0) break block10;
                    fullContent = tag.getContent();
                    rootNode = this.getRootNode();
                    if (!fullContent.contains(this.categorySeparator)) break block11;
                    currentNode = rootNode;
                    start = 0;
                    end = fullContent.indexOf(this.categorySeparator);
                    while (true) {
                        found = false;
                        currentTag = end >= 0 ? fullContent.substring(start, end) : fullContent.substring(start);
                        children = currentNode.children();
                        while (children.hasMoreElements() && (userObject = (childNode = (DefaultMutableTreeNode)children.nextElement()).getUserObject()) instanceof Tag) {
                            childTag = (Tag)userObject;
                            if (!childTag.getContent().equals(currentTag)) continue;
                            currentNode = childNode;
                            found = true;
                            break;
                        }
                        if (found) ** GOTO lbl39
                        qualifiedContent = end >= 0 ? fullContent.substring(0, end) : fullContent;
                        prototype = new Tag(qualifiedContent);
                        qualifiedTag = setColor != false && qualifiedContent == fullContent ? tag : this.mapTags.getElement(prototype).orElse(prototype);
                        this.mapTags.addIfNotExists(qualifiedTag);
                        if (currentNode.isRoot() && (uncategorizedTagNode = this.removeUncategorizedTagNode(qualifiedTag)) != null) {
                            this.insertNode(currentNode, currentNode.getChildCount() - 1, uncategorizedTagNode);
                            currentNode = uncategorizedTagNode;
                        } else {
                            color = qualifiedTag.getColor();
                            newNode = new DefaultMutableTreeNode(new Tag(currentTag, color));
                            this.insertNode(currentNode, currentNode.isRoot() != false ? currentNode.getChildCount() - 1 : currentNode.getChildCount(), newNode);
                            currentNode = newNode;
                            this.categoriesChanged = true;
                            tagReference = new TagReference(qualifiedTag);
                            this.tagReferences.computeIfAbsent(qualifiedContent, (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$registerTagReference$4(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(tagReference);
                            if (qualifiedContent == fullContent) {
                                return tagReference;
                            }
lbl39:
                            // 3 sources

                            if (end < 0) break block9;
                        }
                        start = end + this.categorySeparator.length();
                        end = fullContent.indexOf(this.categorySeparator, start);
                    }
                }
                tagFound = false;
                for (i = 0; !tagFound && i < rootNode.getChildCount(); ++i) {
                    tagFound = ((DefaultMutableTreeNode)rootNode.getChildAt(i)).getUserObject().equals(tag);
                }
                if (!tagFound) {
                    this.insertUncategorizedTagNodeSorted(tag);
                }
            }
            tagReference = new TagReference(tag);
            this.tagReferences.computeIfAbsent(tag.getContent(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$registerTagReference$5(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(tagReference);
            return tagReference;
        }
        oldTag = this.mapTags.getElementAt(-addedElementIndex - 1);
        if (setColor) {
            oldTag.setColor(tag.getColor());
        }
        content = oldTag.getContent();
        references = this.tagReferences.get(content);
        return references.get(0);
    }

    public Tag setTagColor(String tagContent, String tagColor) {
        return this.setTagColor(tagContent, TagCategories.tagColor(tagContent, tagColor));
    }

    public static Color tagColor(String tagContent, String tagColor) {
        return Optional.ofNullable(tagColor).map(ColorUtils::stringToColor).orElseGet(() -> Tag.getDefaultColor(tagContent));
    }

    public Tag setTagColor(String tagContent, Color color) {
        Tag tag = this.registerTagReference(new Tag(tagContent, color), true).getTag();
        return tag;
    }

    public Optional<Tag> getTag(Tag required) {
        return this.mapTags.getElement(required);
    }

    public Color getTagColor(Tag required) {
        return this.getTag(required).get().getColor();
    }

    public Tag registerTag(String spec) {
        int colorIndex = spec.length() - 9;
        if (colorIndex > 0 && spec.charAt(colorIndex) == '#') {
            String content = spec.substring(0, colorIndex);
            String colorSpec = spec.substring(colorIndex);
            try {
                return this.setTagColor(content, colorSpec);
            }
            catch (NumberFormatException e) {
                LogUtils.severe(e);
            }
        }
        return this.createTagReference(spec).getTag();
    }

    public Tag registerTag(Tag tag) {
        return this.registerTagReference(tag).getTag();
    }

    public TagCategories copy() {
        TagCategories tagCategories = new TagCategories(this);
        return tagCategories;
    }

    private DefaultMutableTreeNode copySubtree(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(this.copyTag(node));
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            newNode.add(this.copySubtree(child));
        }
        return newNode;
    }

    private Object copyTag(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof Tag) {
            Tag tag = (Tag)userObject;
            return tag.copy();
        }
        return userObject;
    }

    public boolean areCategoriesChanged() {
        return this.categoriesChanged;
    }

    public void fireNodeChanged(DefaultMutableTreeNode node) {
        this.nodes.nodeChanged(node);
    }

    public void replaceReferencedTags(List<String> replacements) {
        block0: for (int i = 0; i < replacements.size(); i += 2) {
            String fromTag = replacements.get(i);
            if (fromTag.isEmpty()) {
                return;
            }
            String toTag = replacements.get(i + 1);
            this.replaceReferencedTags(fromTag, toTag);
            String fromCategory = fromTag + this.categorySeparator;
            SortedMap<String, List<TagReference>> tailMap = this.tagReferences.tailMap(fromCategory);
            if (tailMap.isEmpty()) continue;
            String from = tailMap.firstKey();
            while (from.startsWith(fromCategory)) {
                String to = toTag.equals(UNCATEGORIZED_NODE) ? UNCATEGORIZED_NODE : toTag + from.substring(fromTag.length());
                this.replaceReferencedTags(from, to);
                if (tailMap.isEmpty()) continue block0;
                from = tailMap.firstKey();
            }
        }
    }

    private void replaceReferencedTags(String from, String to) {
        if (to.equals(UNCATEGORIZED_NODE)) {
            int lastSeparatorIndex = from.lastIndexOf(this.categorySeparator);
            if (lastSeparatorIndex >= 0) {
                to = from.substring(lastSeparatorIndex + this.categorySeparator.length());
            } else {
                return;
            }
        }
        List<TagReference> replacedTagReferences = this.tagReferences.remove(from);
        List list = this.tagReferences.computeIfAbsent(to, key -> new ArrayList());
        if (replacedTagReferences != null && !from.isEmpty()) {
            list.addAll(replacedTagReferences);
        }
    }

    public void updateTagReferences() {
        this.tagReferences.values().stream().flatMap(Collection::stream).map(TagReference::getTag).filter(tag -> !this.tagReferences.containsKey(tag.getContent())).forEach(this.mapTags::remove);
        this.tagReferences.getOrDefault("", Collections.emptyList()).forEach(tagReference -> tagReference.setTag(Tag.REMOVED_TAG));
        this.updateTagReferences("", this.getRootNode());
    }

    private void updateTagReferences(String prefix, DefaultMutableTreeNode node) {
        String nextLevelPrefix;
        Object userObject = node.getUserObject();
        if (userObject instanceof Tag) {
            Tag tag = (Tag)userObject;
            String content = tag.getContent();
            String categorizedContent = prefix + content;
            Tag categorizedTag = new Tag(categorizedContent, tag.getColor());
            this.mapTags.addIfNotExists(categorizedTag);
            this.tagReferences.getOrDefault(categorizedContent, Collections.emptyList()).forEach(tagReference -> tagReference.setTag(categorizedTag));
            nextLevelPrefix = categorizedContent + this.getTagCategorySeparator();
        } else {
            nextLevelPrefix = prefix;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.updateTagReferences(nextLevelPrefix, (DefaultMutableTreeNode)node.getChildAt(i));
        }
    }

    public String categorizedContent(DefaultMutableTreeNode node) {
        String tagCategorySeparator = this.getTagCategorySeparator();
        return new CategorizedTagForCategoryNode(node).getContent(tagCategorySeparator);
    }

    public List<Tag> getUncategorizedTags() {
        int tagCount = this.uncategorizedTagsNode.getChildCount();
        ArrayList<Tag> tags = new ArrayList<Tag>(tagCount);
        for (int i = 0; i < tagCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.uncategorizedTagsNode.getChildAt(i);
            tags.add((Tag)child.getUserObject());
        }
        return tags;
    }

    public void removeTag(Tag tag) {
        this.mapTags.remove((Object)tag);
    }

    public void removeTagsAndCategories(String removed) {
        if (removed.isEmpty()) {
            return;
        }
        int index = this.mapTags.getIndexOf(new Tag(removed, Color.BLACK));
        if (index >= 0) {
            String removedCategory = removed + this.categorySeparator;
            do {
                this.mapTags.remove(index);
            } while (this.mapTags.getSize() > index && this.mapTags.getElementAt(index).getContent().startsWith(removedCategory));
        }
    }

    public Tag createTag(DefaultMutableTreeNode currentNode, String text) {
        Tag tag = this.createTag(currentNode, text, null);
        if (tag.getColor() == null) {
            tag.setColor(Tag.getDefaultColor(tag.getContent()));
        }
        return tag;
    }

    public Tag createTag(DefaultMutableTreeNode currentNode, String text, Color color) {
        String categories = this.categorizedContent((DefaultMutableTreeNode)currentNode.getParent());
        String categorizedContent = categories.isEmpty() ? text : categories + this.categorySeparator + text;
        Tag tag = new Tag(categorizedContent, color);
        Optional<Tag> knownTag = this.mapTags.getElement(tag);
        if (knownTag.isPresent()) {
            return knownTag.get();
        }
        this.mapTags.add(tag);
        TagReference tagReference = new TagReference(tag);
        this.tagReferences.computeIfAbsent(tag.getContent(), x -> new ArrayList()).add(tagReference);
        return tag;
    }

    public void registerTagReferenceIfUnknown(Tag tag) {
        if (!this.tagReferences.containsKey(tag.getContent())) {
            this.registerTagReference(tag);
        }
    }

    private static /* synthetic */ List lambda$registerTagReference$5(String x) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$registerTagReference$4(String x) {
        return new ArrayList();
    }

    private class TagCategoryTree
    extends DefaultTreeModel {
        private TagCategoryTree(TreeNode root) {
            super(root);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object oldValue = node.getUserObject();
            if (node.getParent() == TagCategories.this.uncategorizedTagsNode) {
                TagCategories.this.removeUncategorizedTagNode((Tag)oldValue);
                node.setUserObject(newValue);
                TagCategories.this.insertUncategorizedTagNodeSorted(node);
            } else {
                for (TreeModelListener listener : this.getTreeModelListeners()) {
                    if (!(listener instanceof TreeTagChangeListener)) continue;
                    ((TreeTagChangeListener)((Object)listener)).valueForPathChanged(path, (Tag)newValue);
                }
                super.valueForPathChanged(path, newValue);
            }
        }
    }
}

