/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import org.freeplane.core.io.xml.TreeXmlReader;
import org.freeplane.core.io.xml.TreeXmlWriter;
import org.freeplane.core.util.LineComparator;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.CompareConditionAdapter;
import org.freeplane.features.icon.TagCondition;
import org.freeplane.n3.nanoxml.XMLElement;

public class TagCompareCondition
extends TagCondition {
    static final String NAME = "tag_compare_condition";
    static final String COMPARATION_RESULT = "COMPARATION_RESULT";
    static final String SUCCEED = "SUCCEED";
    static final String VALUE = "VALUE";
    private final int comparationResult;
    private final boolean succeed;
    private final String conditionContent;

    static ASelectableCondition load(XMLElement element) {
        return new TagCompareCondition(element.getAttribute(VALUE, null), TreeXmlReader.xmlToBoolean(element.getAttribute("MATCH_CASE", null)), Integer.parseInt(element.getAttribute(COMPARATION_RESULT, null)), TreeXmlReader.xmlToBoolean(element.getAttribute(SUCCEED, null)), TreeXmlReader.xmlToBoolean(element.getAttribute("MATCH_APPROXIMATELY", null)), Boolean.valueOf(element.getAttribute("IGNORE_DIACRITICS", null)), Boolean.valueOf(element.getAttribute("SEARCH_ACROSS_ALL_CATEGORIES", null)));
    }

    public TagCompareCondition(String content, boolean matchCase, int comparationResult, boolean succeed, boolean matchApproximately, boolean ignoreDiacritics, boolean searchesAcrossAllCategories) {
        super(content, matchCase, matchApproximately, false, ignoreDiacritics, searchesAcrossAllCategories);
        this.conditionContent = content;
        this.comparationResult = comparationResult;
        this.succeed = succeed;
    }

    public boolean isEqualityCondition() {
        return this.comparationResult == 0;
    }

    @Override
    protected boolean checkText(String comparedContent) {
        return this.succeed == (LineComparator.compareLinesParsingNumbers(comparedContent, this.conditionContent) == this.comparationResult);
    }

    @Override
    protected String createDescription() {
        String simpleCondition = CompareConditionAdapter.createComparisonDescription(this.comparationResult, this.succeed);
        return this.createDescription(TextUtils.getText("filter_tag"), simpleCondition, this.conditionContent);
    }

    @Override
    public void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(VALUE, this.conditionContent);
        child.setAttribute(COMPARATION_RESULT, Integer.toString(this.comparationResult));
        child.setAttribute(SUCCEED, TreeXmlWriter.BooleanToXml(this.succeed));
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected Object conditionValue() {
        return this.conditionContent;
    }
}

