/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.icon.CategorizedTag;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagCondition;
import org.freeplane.n3.nanoxml.XMLElement;

public class TagContainsCondition
extends TagCondition {
    private static final String NAME = "tag_contains_condition";
    static final String VALUE = "VALUE";
    private final String value;
    private final String comparedValue;
    private final StringMatchingStrategy stringMatchingStrategy;

    static ASelectableCondition load(XMLElement element) {
        return new TagContainsCondition(element.getAttribute(VALUE, null), Boolean.valueOf(element.getAttribute("MATCH_CASE", null)), Boolean.valueOf(element.getAttribute("MATCH_APPROXIMATELY", null)), Boolean.valueOf(element.getAttribute("MATCH_WORDWISE", null)), Boolean.valueOf(element.getAttribute("IGNORE_DIACRITICS", null)), Boolean.valueOf(element.getAttribute("SEARCH_ACROSS_ALL_CATEGORIES", null)));
    }

    public TagContainsCondition(String value, boolean matchCase, boolean matchApproximately, boolean matchWordwise, boolean ignoreDiacritics, boolean searchesAcrossAllCategories) {
        super(value, matchCase, matchApproximately, matchWordwise, ignoreDiacritics, searchesAcrossAllCategories);
        this.value = value;
        this.comparedValue = value;
        this.stringMatchingStrategy = matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : StringMatchingStrategy.EXACT_STRING_MATCHING_STRATEGY;
    }

    @Override
    protected boolean checkTag(Tag tag, String tagCategorySeparator) {
        return this.checkText(tag.getContent());
    }

    @Override
    protected boolean checkTag(CategorizedTag categorizedTag, String tagCategorySeparator) {
        return this.checkText(categorizedTag.getContent(tagCategorySeparator));
    }

    @Override
    protected boolean checkText(String text) {
        return this.stringMatchingStrategy.matches(this.normalizedValue(), this.normalize(text), this.substringMatchType());
    }

    @Override
    protected String createDescription() {
        String simpleCondition = TextUtils.getText("filter_contains");
        return this.createDescription(TextUtils.getText("filter_tag"), simpleCondition, this.value);
    }

    @Override
    public void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(VALUE, this.value);
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected String conditionValue() {
        return this.comparedValue;
    }
}

