/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.util.regex.Pattern;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.icon.TagCondition;
import org.freeplane.n3.nanoxml.XMLElement;

public class TagMatchesCondition
extends TagCondition {
    static final String NAME = "tag_matches_condition";
    static final String VALUE = "VALUE";
    private final String value;
    private final Pattern searchPattern;

    static ASelectableCondition load(XMLElement element) {
        return new TagMatchesCondition(element.getAttribute(VALUE, null), Boolean.valueOf(element.getAttribute("MATCH_CASE", null)), Boolean.valueOf(element.getAttribute("SEARCH_ACROSS_ALL_CATEGORIES", null)));
    }

    public TagMatchesCondition(String value, boolean matchCase, boolean searchesAcrossAllCategories) {
        super(value, matchCase, false, false, false, searchesAcrossAllCategories);
        this.value = value;
        int flags = 32;
        if (!matchCase) {
            flags |= 0x42;
        }
        this.searchPattern = Pattern.compile(value, flags);
    }

    @Override
    protected boolean checkText(String text) {
        return this.searchPattern.matcher(text).find();
    }

    @Override
    protected String createDescription() {
        String simpleCondition = TextUtils.getText("filter_regexp_matches");
        return ConditionFactory.createDescription(TextUtils.getText("filter_tag"), simpleCondition, this.value, this.isMatchCase(), false, false);
    }

    @Override
    public void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(VALUE, this.value);
    }

    @Override
    protected String getName() {
        return NAME;
    }

    private boolean isMatchCase() {
        return (this.searchPattern.flags() & 2) == 0;
    }
}

