/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;

public class IconListComponent
extends JComponent {
    private static final long serialVersionUID = 1L;
    private List<? extends Icon> icons;
    private int maximumWidth;
    private int horizontalAlignment;

    public IconListComponent() {
        this(Collections.emptyList());
    }

    public IconListComponent(List<? extends Icon> icons) {
        this.icons = icons;
        this.maximumWidth = Integer.MAX_VALUE;
        this.horizontalAlignment = 2;
    }

    public List<? extends Icon> getIcons() {
        return this.icons;
    }

    public void setIcons(List<? extends Icon> icons) {
        this.icons = icons;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Object newRenderingHintFM;
        if (!this.useFractionalMetrics()) {
            this.paintIcons(g, 1.0f);
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Object oldRenderingHintFM = g2.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS);
        if (oldRenderingHintFM != (newRenderingHintFM = RenderingHints.VALUE_FRACTIONALMETRICS_ON)) {
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, newRenderingHintFM);
        }
        AffineTransform transform = g2.getTransform();
        float factor = 0.97f;
        float zoom = this.getZoom() * 0.97f;
        g2.scale(zoom, zoom);
        this.paintIcons(g2, zoom);
        g2.setTransform(transform);
        if (oldRenderingHintFM != newRenderingHintFM) {
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, oldRenderingHintFM != null ? oldRenderingHintFM : RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT);
        }
    }

    public void setHorizontalAlignment(int alignment) {
        if (alignment == this.horizontalAlignment) {
            return;
        }
        int oldValue = this.horizontalAlignment;
        this.horizontalAlignment = alignment;
        this.firePropertyChange("horizontalAlignment", oldValue, this.horizontalAlignment);
        this.repaint();
    }

    private void paintIcons(Graphics g, float zoom) {
        super.paintComponent(g);
        int x = 0;
        int y = 0;
        int rowHeight = 0;
        int totalRowWidth = 0;
        ArrayList<Icon> rowIcons = new ArrayList<Icon>(this.icons.size());
        int width = (int)((float)this.getWidth() / zoom);
        for (Icon icon : this.icons) {
            int iconWidth = icon.getIconWidth();
            if (x > 0 && x + iconWidth > width) {
                int dx = width - totalRowWidth;
                this.drawIconsRow(g, rowIcons, dx, y, width);
                x = 0;
                y += rowHeight;
                rowHeight = 0;
                rowIcons.clear();
                totalRowWidth = 0;
            }
            rowIcons.add(icon);
            x += iconWidth;
            totalRowWidth += iconWidth;
            rowHeight = Math.max(rowHeight, icon.getIconHeight());
        }
        if (!rowIcons.isEmpty()) {
            int dx = width - totalRowWidth;
            this.drawIconsRow(g, rowIcons, dx, y, width);
        }
    }

    private void drawIconsRow(Graphics g, List<Icon> rowIcons, int dx, int y, int width) {
        boolean isLeftToRight = this.getComponentOrientation().isLeftToRight();
        int x = this.horizontalAlignment == 0 ? dx / 2 : (this.horizontalAlignment == 4 ? (isLeftToRight ? dx : 0) : (isLeftToRight ? 0 : dx));
        for (Icon icon : rowIcons) {
            int paintX = isLeftToRight ? x : width - x - icon.getIconWidth();
            int paintY = y;
            icon.paintIcon(this, g, paintX, paintY);
            x += icon.getIconWidth();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            Dimension preferredSize = super.getPreferredSize();
            return preferredSize;
        }
        float zoom = this.getZoom();
        int width = (int)((double)((float)this.maximumWidth / zoom) + 0.5);
        int height = 0;
        int maximumRowWidth = 0;
        int rowWidth = 0;
        int rowHeight = 0;
        for (Icon icon : this.icons) {
            if (rowWidth > 0 && rowWidth + icon.getIconWidth() > width) {
                height += rowHeight;
                maximumRowWidth = Math.max(rowWidth, maximumRowWidth);
                rowWidth = 0;
                rowHeight = 0;
            }
            rowWidth += icon.getIconWidth();
            rowHeight = Math.max(rowHeight, icon.getIconHeight());
        }
        maximumRowWidth = Math.max(rowWidth, maximumRowWidth);
        return new Dimension((int)((double)((float)maximumRowWidth * zoom) + 0.5), (int)((double)((float)(height += rowHeight) * zoom) + 0.5));
    }

    protected float getZoom() {
        float zoom = this.getMap().getZoom();
        return zoom;
    }

    protected MapView getMap() {
        return this.getNodeView().getMap();
    }

    protected NodeView getNodeView() {
        return (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, this);
    }

    protected boolean useFractionalMetrics() {
        MapView map = this.getMap();
        if (map.isPrinting()) {
            return true;
        }
        float zoom = map.getZoom();
        return 1.0f != zoom;
    }

    public void setMaximumWidth(int maximumWidth) {
        this.maximumWidth = maximumWidth;
    }
}

