/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.FocusManager;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.freeplane.core.extension.Configurable;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.JComboBoxFactory;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.svgicons.GraphicsHints;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapLifeCycleListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.view.swing.map.ClickableImageCreator;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MapViewChangeObserverCompound;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.ZoomInAction;
import org.freeplane.view.swing.map.ZoomOutAction;

public class MapViewController
implements IMapViewManager,
IMapViewChangeListener,
IFreeplanePropertyListener,
IMapLifeCycleListener {
    private static final Color TRANSPARENT = new Color(0, true);
    private String lastModeName;
    private MapView selectedMapView;
    MapViewChangeObserverCompound mapViewChangeListeners = new MapViewChangeObserverCompound();
    private final Vector<MapView> mapViewVector = new Vector();
    private float zoom;
    private boolean setZoomComboBoxRun;
    private final Controller controller;
    private final String userDefinedZoom;
    private final ZoomInAction zoomIn;
    private final DefaultComboBoxModel zoomModel;
    private final ZoomOutAction zoomOut;
    private static final String[] zooms = ResourceController.getResourceController().getArrayProperty("predefined_zoom_levels", ", *");
    private boolean antialiasAll = false;
    private boolean antialiasEdges = false;

    public MapViewController(Controller controller) {
        this.controller = controller;
        controller.setMapViewManager(this);
        controller.addMapLifeCycleListener(this);
        this.addMapViewChangeListener(this);
        this.zoomIn = new ZoomInAction(this);
        controller.addAction(this.zoomIn);
        this.zoomOut = new ZoomOutAction(this);
        controller.addAction(this.zoomOut);
        this.userDefinedZoom = TextUtils.getText("user_defined_zoom");
        this.zoomModel = new DefaultComboBoxModel<String>(this.getZooms());
        this.zoomModel.addElement(this.userDefinedZoom);
        ResourceController resourceController = ResourceController.getResourceController();
        resourceController.addPropertyChangeListener(this);
        this.zoomModel.setSelectedItem("100%");
        this.zoomModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (!MapViewController.this.setZoomComboBoxRun && e.getIndex0() == -1) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MapViewController.this.setZoomByItem(MapViewController.this.zoomModel.getSelectedItem());
                        }
                    });
                }
            }
        });
        String antialiasProperty = resourceController.getProperty("antialias");
        this.changeAntialias(antialiasProperty);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusedWindow", this::focusSelectedNode);
    }

    protected Controller getController() {
        return this.controller;
    }

    private void focusSelectedNode(PropertyChangeEvent evt) {
        Window newWindow = (Window)evt.getNewValue();
        if (newWindow == null) {
            return;
        }
        this.focusSelectedNode(newWindow, 2);
    }

    private void focusSelectedNode(Window newWindow, int counter) {
        if (counter > 0) {
            SwingUtilities.invokeLater(() -> this.focusSelectedNode(newWindow, counter - 1));
            return;
        }
        MapView mapView = this.getMapView();
        if (mapView == null || SwingUtilities.getWindowAncestor(mapView) != newWindow) {
            return;
        }
        NodeView selectedNode = mapView.getSelected();
        if (selectedNode == null) {
            return;
        }
        Component focusOwner = newWindow.getFocusOwner();
        if (focusOwner == null) {
            return;
        }
        Container nodeView = SwingUtilities.getAncestorOfClass(NodeView.class, focusOwner);
        if (nodeView != null && nodeView != selectedNode) {
            selectedNode.requestFocusInWindow();
        }
    }

    @Override
    public void addMapSelectionListener(IMapSelectionListener pListener) {
        this.mapViewChangeListeners.addListener(pListener);
    }

    @Override
    public void addMapViewChangeListener(IMapViewChangeListener pListener) {
        this.mapViewChangeListeners.addListener(pListener);
    }

    private void addToOrChangeInMapViews(String key, MapView newOrChangedMapView) {
        String extension = "";
        int count = 1;
        List<String> mapKeys = this.getMapKeys();
        while (mapKeys.contains(key + extension)) {
            extension = "<" + ++count + ">";
        }
        newOrChangedMapView.setName(key + extension);
        newOrChangedMapView.setName(key + extension);
        if (!this.mapViewVector.contains(newOrChangedMapView)) {
            int index = this.selectedMapView != null ? this.mapViewVector.indexOf(this.selectedMapView) + 1 : this.mapViewVector.size();
            this.mapViewVector.add(index, newOrChangedMapView);
        }
    }

    @Override
    public void changeToMap(MapModel map) {
        if (this.selectedMapView != null && this.selectedMapView.getMap().equals(map)) {
            return;
        }
        for (MapView view : this.mapViewVector) {
            if (!view.getMap().equals(map)) continue;
            this.changeToMapView(view);
        }
    }

    @Override
    public boolean changeToMapView(Component newMapViewComponent) {
        MapView newMapView = (MapView)newMapViewComponent;
        MapView oldMapView = this.selectedMapView;
        if (newMapView == oldMapView) {
            return true;
        }
        this.mapViewChangeListeners.beforeMapViewChange(oldMapView, newMapView);
        this.selectedMapView = newMapView;
        if (oldMapView != null) {
            oldMapView.repaint();
        }
        if (newMapView != null) {
            newMapView.revalidateSelecteds();
            ModeController modeController = newMapView.getModeController();
            this.lastModeName = modeController.getModeName();
            float mapViewZoom = newMapView.getZoom();
            if (this.zoom != mapViewZoom) {
                this.setZoom(mapViewZoom);
            }
            modeController.getController().selectMode(modeController);
            newMapView.repaint();
        }
        this.mapViewChangeListeners.afterMapViewChange(oldMapView, newMapView);
        return true;
    }

    @Override
    public boolean changeToMapView(String mapViewDisplayName) {
        MapView mapViewCandidate = null;
        for (MapView mapView : this.mapViewVector) {
            String mapViewName = mapView.getName();
            if (mapViewDisplayName != mapViewName && (mapViewDisplayName == null || !mapViewDisplayName.equals(mapViewName))) continue;
            mapViewCandidate = mapView;
            break;
        }
        if (mapViewCandidate == null) {
            throw new IllegalArgumentException("Map mapView " + mapViewDisplayName + " not found.");
        }
        return this.changeToMapView(mapViewCandidate);
    }

    @Override
    public boolean changeToMode(String modeName) {
        if (modeName.equals(this.lastModeName)) {
            return true;
        }
        MapView mapViewCandidate = null;
        for (MapView mapView : this.mapViewVector) {
            if (!modeName.equals(mapView.getModeController().getModeName())) continue;
            mapViewCandidate = mapView;
            break;
        }
        MapView oldMapView = this.selectedMapView;
        boolean changed = this.changeToMapView(mapViewCandidate);
        if (changed) {
            this.lastModeName = modeName;
            if (oldMapView == this.selectedMapView) {
                this.mapViewChangeListeners.afterMapViewChange(oldMapView, this.selectedMapView);
            }
        }
        return changed;
    }

    @Override
    public String checkIfFileIsAlreadyOpened(URL urlToCheck) throws MalformedURLException {
        for (MapView mapView : this.mapViewVector) {
            URL mapViewUrl;
            if (this.getMap(mapView) == null || !this.sameFile(urlToCheck, mapViewUrl = this.getMap(mapView).getURL())) continue;
            return mapView.getName();
        }
        return null;
    }

    @Override
    public boolean close() {
        MapView mapView = this.getMapView();
        return this.close(mapView);
    }

    @Override
    public void closeWithoutSaving() {
        MapView mapView = this.getMapView();
        this.closeWithoutSaving(mapView);
    }

    @Override
    public boolean close(Component mapViewComponent) {
        return this.close(mapViewComponent, false);
    }

    public boolean closeWithoutSaving(Component mapViewComponent) {
        return this.close(mapViewComponent, true);
    }

    private boolean close(Component mapViewComponent, boolean forceCloseWithoutSaving) {
        if (mapViewComponent == null) {
            return false;
        }
        MapView mapView = (MapView)mapViewComponent;
        MapModel map = mapView.getMap();
        int viewCount = this.getViews(map).size();
        if (viewCount == 1) {
            MapController mapController = mapView.getModeController().getMapController();
            if (forceCloseWithoutSaving || this.saveModifiedIfNotCancelled(map)) {
                mapController.closeWithoutSaving(map);
                return true;
            }
            return false;
        }
        map.removeMapChangeListener(mapView);
        this.remove(mapView);
        mapView.getRoot().remove();
        return true;
    }

    private void remove(MapView mapView) {
        int index = this.mapViewVector.indexOf(mapView);
        ResourceController.getResourceController().removePropertyChangeListener(mapView);
        this.mapViewVector.remove(mapView);
        if (this.mapViewVector.isEmpty()) {
            this.changeToMapView((Component)null);
        } else if (mapView == this.selectedMapView) {
            if (index > this.mapViewVector.size()) {
                index = this.mapViewVector.size();
            } else if (index <= 0) {
                index = 1;
            }
            this.changeToMapView(this.mapViewVector.get(index - 1));
        }
        this.mapViewChangeListeners.afterMapViewClose(mapView);
    }

    @Override
    public String createHtmlMap() {
        MapModel model = this.getMap();
        ClickableImageCreator creator = new ClickableImageCreator(model.getRootNode(), this.getMapView().getModeController(), "FM$1FM");
        return creator.generateHtml();
    }

    @Override
    public RenderedImage createImage(int dpi) {
        MapView view = this.getMapView();
        if (view == null) {
            return null;
        }
        view.preparePrinting();
        Rectangle innerBounds = view.getInnerBounds();
        return this.createImage(dpi, innerBounds);
    }

    @Override
    public RenderedImage createImage(Dimension slideSize, NodeModel placedNode, IMapSelection.NodePosition placedNodePosition, int dpi) {
        MapView view = this.getMapView();
        if (view == null) {
            return null;
        }
        NodeView placedNodeView = view.getNodeView(placedNode);
        if (placedNodeView == null) {
            return this.createImage(dpi);
        }
        view.preparePrinting();
        JComponent content = placedNodeView.getContent();
        Point contentLocation = new Point();
        UITools.convertPointToAncestor((Component)content, contentLocation, view);
        Rectangle printedGraphicsBounds = new Rectangle(contentLocation.x + content.getWidth() / 2 - slideSize.width / 2, contentLocation.y + content.getHeight() / 2 - slideSize.height / 2, slideSize.width, slideSize.height);
        int distanceToMargin = (slideSize.width - content.getWidth()) / 2 - 10;
        if (placedNodePosition == IMapSelection.NodePosition.LEFT) {
            printedGraphicsBounds.x += distanceToMargin;
        }
        if (placedNodePosition == IMapSelection.NodePosition.RIGHT) {
            printedGraphicsBounds.x -= distanceToMargin;
        }
        return this.createImage(dpi, printedGraphicsBounds);
    }

    public RenderedImage createImage(int dpi, Rectangle printedArea) {
        MapView view = this.getMapView();
        view.preparePrinting();
        BufferedImage myImage = this.printToImage(dpi, view, printedArea);
        view.endPrinting();
        return myImage;
    }

    private BufferedImage printToImage(int dpi, MapView view, Rectangle innerBounds) {
        double scaleFactor = (double)dpi / (double)(UITools.FONT_SCALE_FACTOR * 72.0f);
        double scaledWidth = (double)innerBounds.width * scaleFactor;
        double scaledHeight = (double)innerBounds.height * scaleFactor;
        if (scaledWidth * scaledHeight > 2.147483647E9) {
            UITools.errorMessage(TextUtils.getText("out_of_memory"));
            return null;
        }
        int imageWidth = (int)Math.ceil(scaledWidth);
        int imageHeight = (int)Math.ceil(scaledHeight);
        BufferedImage myImage = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics2D g = (Graphics2D)myImage.getGraphics();
        g.scale(scaleFactor, scaleFactor);
        g.translate(-innerBounds.x, -innerBounds.y);
        g.setRenderingHint(GraphicsHints.CACHE_ICONS, Boolean.TRUE);
        view.print(g);
        return myImage;
    }

    @Override
    public Color getBackgroundColor(NodeModel node) {
        MapView mapView = this.getMapView();
        if (mapView == null) {
            return null;
        }
        NodeView nodeView = mapView.getNodeView(node);
        if (nodeView == null) {
            return null;
        }
        return nodeView.getTextBackground();
    }

    @Override
    public Component getComponent(NodeModel node) {
        if (this.selectedMapView == null) {
            return null;
        }
        NodeView nodeView = this.selectedMapView.getNodeView(node);
        if (nodeView == null) {
            return null;
        }
        return nodeView.getMainView();
    }

    @Override
    public boolean isFoldedOnCurrentView(NodeModel node) {
        if (this.selectedMapView == null) {
            return node.isFolded();
        }
        NodeView nodeView = this.selectedMapView.getNodeView(node);
        if (nodeView == null) {
            return node.isFolded();
        }
        return nodeView.isFolded();
    }

    @Override
    public void displayOnCurrentView(NodeModel node) {
        if (this.selectedMapView != null) {
            this.selectedMapView.display(node);
        }
    }

    @Override
    public void setFoldedOnCurrentView(NodeModel node, boolean folded) {
        if (this.selectedMapView == null || !node.hasChildren()) {
            return;
        }
        NodeView nodeView = this.selectedMapView.getNodeView(node);
        if (nodeView == null) {
            return;
        }
        nodeView.setFolded(folded);
    }

    @Override
    public Font getFont(NodeModel node) {
        MapView mapView = this.getMapView();
        if (mapView == null) {
            return null;
        }
        NodeView nodeView = mapView.getNodeView(node);
        if (nodeView == null) {
            return null;
        }
        return nodeView.getMainView().getFont();
    }

    @Override
    public List<String> getMapKeys() {
        LinkedList<String> returnValue = new LinkedList<String>();
        for (MapView mapView : this.mapViewVector) {
            returnValue.add(mapView.getName());
        }
        return Collections.unmodifiableList(returnValue);
    }

    @Override
    public Map<String, MapModel> getMaps() {
        HashMap<String, MapModel> returnValue = new HashMap<String, MapModel>(this.mapViewVector.size());
        for (MapView mapView : this.mapViewVector) {
            returnValue.put(mapView.getName(), this.getMap(mapView));
        }
        return Collections.unmodifiableMap(returnValue);
    }

    @Override
    public IMapSelection getMapSelection() {
        MapView mapView = this.getMapView();
        return mapView == null ? null : mapView.getMapSelection();
    }

    public MapView getMapView() {
        return this.selectedMapView;
    }

    @Override
    public JComponent getMapViewComponent() {
        return this.getMapView();
    }

    @Override
    public Configurable getMapViewConfiguration() {
        return this.getMapView();
    }

    public List<MapView> getMapViewVector() {
        return Collections.unmodifiableList(this.mapViewVector);
    }

    @Override
    public ModeController getModeController(Component mapView) {
        return ((MapView)mapView).getModeController();
    }

    @Override
    public MapModel getMap() {
        MapView mapView = this.getMapView();
        return mapView == null ? null : this.getMap(mapView);
    }

    @Override
    public MapModel getMap(Component mapView) {
        return ((MapView)mapView).getMap();
    }

    private MapModel getMap(MapView mapView) {
        return mapView == null ? null : mapView.getMap();
    }

    @Override
    public Component getSelectedComponent() {
        MapView mapView = this.getMapView();
        return mapView == null ? null : mapView.getSelected().getMainView();
    }

    public int getViewNumber() {
        return this.mapViewVector.size();
    }

    @Override
    public float getZoom() {
        return this.zoom;
    }

    @Override
    public void newMapView(MapModel map, ModeController modeController) {
        MapView mapView = new MapView(map, modeController);
        this.addToOrChangeInMapViews(mapView.getName(), mapView);
        ResourceController.getResourceController().addPropertyChangeListener(mapView);
        this.mapViewChangeListeners.mapViewCreated(this.selectedMapView, mapView);
        this.changeToMapView(mapView);
    }

    public void nextMapView() {
        int size = this.mapViewVector.size();
        int index = this.getMapView() != null ? this.mapViewVector.indexOf(this.getMapView()) : size - 1;
        if (index + 1 < size && index >= 0) {
            this.changeToMapView(this.mapViewVector.get(index + 1));
        } else if (size > 0) {
            this.changeToMapView(this.mapViewVector.get(0));
        }
    }

    public void previousMapView() {
        int size = this.mapViewVector.size();
        int index = this.getMapView() != null ? this.mapViewVector.indexOf(this.getMapView()) : 0;
        if (index > 0) {
            this.changeToMapView(this.mapViewVector.get(index - 1));
        } else if (size > 0) {
            this.changeToMapView(this.mapViewVector.get(size - 1));
        }
    }

    @Override
    public void removeMapSelectionListener(IMapSelectionListener pListener) {
        this.mapViewChangeListeners.removeListener(pListener);
    }

    @Override
    public void removeMapViewChangeListener(IMapViewChangeListener pListener) {
        this.mapViewChangeListeners.removeListener(pListener);
    }

    private boolean sameFile(URL urlToCheck, URL mapViewUrl) {
        if (mapViewUrl == null) {
            return false;
        }
        if (urlToCheck.getProtocol().equals("file") && mapViewUrl.getProtocol().equals("file")) {
            return new File(urlToCheck.getFile()).equals(new File(mapViewUrl.getFile()));
        }
        return urlToCheck.sameFile(mapViewUrl);
    }

    @Override
    public void scrollNodeToVisible(NodeModel node) {
        NodeView nodeView = this.selectedMapView.getNodeView(node);
        if (nodeView != null) {
            this.selectedMapView.scrollNodeToVisible(nodeView);
        }
    }

    @Override
    public void setZoom(float zoom) {
        this.zoom = zoom;
        MapView mapView = this.getMapView();
        if (mapView == null) {
            return;
        }
        MapModel map = mapView.getMap();
        MapStyle mapStyle = mapView.getModeController().getExtension(MapStyle.class);
        if (mapView.getZoom() != zoom) {
            mapView.setZoom(zoom);
        }
        if (mapStyle.getZoom(map) == zoom) {
            return;
        }
        mapStyle.setZoom(map, zoom);
        this.setZoomComboBox(zoom);
        Object[] messageArguments = new Object[]{String.valueOf(zoom * 100.0f)};
        String stringResult = TextUtils.format("user_defined_zoom_status_bar", messageArguments);
        this.controller.getViewController().out(stringResult);
    }

    @Override
    public boolean tryToChangeToMapView(String mapView) {
        if (mapView != null && this.getMapKeys().contains(mapView)) {
            this.changeToMapView(mapView);
            return true;
        }
        return false;
    }

    @Override
    public boolean tryToChangeToMapView(URL url) throws MalformedURLException {
        MapModel currentMap = this.getMap();
        if (currentMap != null && url.equals(currentMap.getURL())) {
            return true;
        }
        String mapExtensionKey = this.checkIfFileIsAlreadyOpened(url);
        if (mapExtensionKey != null) {
            this.tryToChangeToMapView(mapExtensionKey);
            return true;
        }
        return false;
    }

    @Override
    public void updateMapViewName() {
        MapView r = this.getMapView();
        String name = r.getMap().getTitle();
        this.addToOrChangeInMapViews(name, this.getMapView());
        this.changeToMapView(this.getMapView());
        this.setMapTitles();
    }

    @Override
    public boolean isLeftTreeSupported(Component mapViewComponent) {
        return ((MapView)mapViewComponent).getLayoutType() != MapViewLayout.OUTLINE;
    }

    @Override
    public Map<String, MapModel> getMaps(String modename) {
        HashMap<String, MapModel> returnValue = new HashMap<String, MapModel>(this.mapViewVector.size());
        for (MapView mapView : this.mapViewVector) {
            if (!mapView.getModeController().getModeName().equals(modename)) continue;
            returnValue.put(mapView.getName(), this.getMap(mapView));
        }
        return Collections.unmodifiableMap(returnValue);
    }

    @Override
    public List<Component> getViews(MapModel map) {
        LinkedList<Component> list = new LinkedList<Component>();
        for (MapView view : this.mapViewVector) {
            if (!view.getMap().equals(map)) continue;
            list.add(view);
        }
        return list;
    }

    @Override
    public void afterViewChange(Component oldMap, Component pNewMap) {
        ModeController oldModeController;
        Controller controller = Controller.getCurrentController();
        ModeController newModeController = oldModeController = controller.getModeController();
        if (pNewMap != null) {
            IMapSelection mapSelection = this.getMapSelection();
            NodeModel selected = mapSelection.getSelected();
            mapSelection.scrollNodeToVisible(selected);
            this.setZoomComboBox(this.getZoom());
            this.obtainFocusForSelected();
            newModeController = this.getModeController(pNewMap);
            if (newModeController != oldModeController) {
                controller.selectMode(newModeController);
            }
        }
        this.setMapTitles();
        controller.getViewController().viewNumberChanged(this.getViewNumber());
        if (pNewMap != null) {
            newModeController.setVisible(true);
        }
    }

    @Override
    public void afterViewCreated(Component oldView, Component newView) {
        this.updateMapList();
    }

    @Override
    public void afterViewClose(Component oldView) {
        ModeController newModeController = this.getModeController(oldView);
        newModeController.getUserInputListenerFactory().updateMapList();
    }

    @Override
    public void beforeViewChange(Component oldMap, Component newMap) {
        Controller controller = Controller.getCurrentController();
        ModeController modeController = controller.getModeController();
        if (oldMap != null) {
            modeController.setVisible(false);
        }
    }

    private void setZoomByItem(Object item) {
        float zoomValue;
        if (((String)item).equals(this.userDefinedZoom)) {
            float zoom = this.getZoom();
            int zoomInt = Math.round(100.0f * zoom);
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(zoomInt, 1, 3200, 1);
            JSpinner spinner = new JSpinner(spinnerNumberModel);
            int option = JOptionPane.showConfirmDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), spinner, TextUtils.getText("enter_zoom"), 2);
            zoomValue = option == 0 ? spinnerNumberModel.getNumber().floatValue() / 100.0f : zoom;
        } else {
            zoomValue = this.getZoomValue(item);
        }
        this.setZoom(zoomValue);
    }

    private float getCurrentZoomIndex() {
        int selectedIndex = this.zoomModel.getIndexOf(this.zoomModel.getSelectedItem());
        int itemCount = this.zoomModel.getSize();
        if (selectedIndex != -1) {
            return selectedIndex;
        }
        float userZoom = this.getZoom();
        for (int i = 0; i < itemCount - 1; ++i) {
            if (!(userZoom < this.getZoomValue(this.zoomModel.getElementAt(i)))) continue;
            return (float)i - 0.5f;
        }
        return (float)itemCount - 1.5f;
    }

    public String getItemForZoom(float f) {
        return Math.round(f * 100.0f) + "%";
    }

    private void setZoomComboBox(float f) {
        this.setZoomComboBoxRun = true;
        try {
            String toBeFound = this.getItemForZoom(f);
            this.zoomModel.setSelectedItem(toBeFound);
        }
        finally {
            this.setZoomComboBoxRun = false;
        }
    }

    public void zoomIn() {
        float currentZoomIndex = this.getCurrentZoomIndex();
        if (currentZoomIndex < (float)(this.zoomModel.getSize() - 2)) {
            this.setZoomByItem(this.zoomModel.getElementAt((int)(currentZoomIndex + 1.0f)));
        }
    }

    public void zoomOut() {
        float currentZoomIndex = this.getCurrentZoomIndex();
        if (currentZoomIndex > 0.0f) {
            this.setZoomByItem(this.zoomModel.getElementAt((int)(currentZoomIndex - 0.5f)));
        }
    }

    @Override
    public JComboBox createZoomBox() {
        JComboBox zoomBox = JComboBoxFactory.create(this.zoomModel);
        zoomBox.setPrototypeDisplayValue("1000%");
        return zoomBox;
    }

    public String[] getZooms() {
        return zooms;
    }

    private float getZoomValue(Object item) {
        String dirty = (String)item;
        String cleaned = dirty.substring(0, dirty.length() - 1);
        float zoomValue = (float)Integer.parseInt(cleaned, 10) / 100.0f;
        return zoomValue;
    }

    @Override
    public void obtainFocusForSelected() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component selectedComponent;
                if (MapViewController.this.getMapView() != null && (selectedComponent = MapViewController.this.getSelectedComponent()) != null) {
                    selectedComponent.requestFocus();
                }
            }
        });
    }

    private boolean getAntialiasAll() {
        return this.antialiasAll;
    }

    private boolean getAntialiasEdges() {
        return this.antialiasEdges;
    }

    public void setAntialiasAll(boolean antialiasAll) {
        this.antialiasAll = antialiasAll;
    }

    public void setAntialiasEdges(boolean antialiasEdges) {
        this.antialiasEdges = antialiasEdges;
    }

    @Override
    public Object setEdgesRenderingHint(Graphics2D g) {
        Object renderingHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (this.getAntialiasEdges()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        return renderingHint;
    }

    @Override
    public void setTextRenderingHint(Graphics2D g) {
        if (this.getAntialiasAll()) {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    private void changeAntialias(String command) {
        JComponent mapView;
        if (command == null) {
            return;
        }
        if (command.equals("antialias_none")) {
            this.setAntialiasEdges(false);
            this.setAntialiasAll(false);
        }
        if (command.equals("antialias_edges")) {
            this.setAntialiasEdges(true);
            this.setAntialiasAll(false);
        }
        if (command.equals("antialias_all")) {
            this.setAntialiasEdges(true);
            this.setAntialiasAll(true);
        }
        if ((mapView = this.getMapViewComponent()) != null) {
            mapView.repaint();
        }
    }

    @Override
    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        if (propertyName.equals("view_mode") || propertyName.equals("workspaceTitle")) {
            this.setFrameTitle();
            return;
        }
        if (propertyName.equals("antialias")) {
            this.changeAntialias(newValue);
            return;
        }
    }

    @Override
    public void setMapTitles() {
        this.setFrameTitle();
        this.updateMapList();
    }

    private void updateMapList() {
        ModeController modeController = Controller.getCurrentModeController();
        if (modeController != null) {
            modeController.getUserInputListenerFactory().updateMapList();
        }
    }

    private void setFrameTitle() {
        ModeController modeController = Controller.getCurrentModeController();
        if (modeController != null) {
            String frameTitle;
            Object[] messageArguments = new Object[]{TextUtils.getText("mode_" + modeController.getModeName())};
            MessageFormat formatter = new MessageFormat(TextUtils.getText("mode_title"));
            String modeName = formatter.format(messageArguments);
            String viewName = "";
            MapModel model = this.getMap();
            String workspaceTitle = ResourceController.getResourceController().getProperty("workspaceTitle");
            if (model != null) {
                viewName = this.getMapViewComponent().getName();
                frameTitle = (workspaceTitle.isEmpty() ? "" : workspaceTitle + " - ") + viewName + (model.isSaved() || model.isReadOnly() ? "" : "*") + " - " + modeName + (modeController.isEditingLocked() ? this.format("OptionPanel.view_mode.true") : (model.isReadOnly() ? this.format("read_only") : ""));
                File file = model.getFile();
                if (file != null) {
                    frameTitle = frameTitle + " " + file.getAbsolutePath();
                }
            } else {
                frameTitle = (workspaceTitle.isEmpty() ? "" : workspaceTitle + " - ") + modeName;
            }
            this.controller.getViewController().setTitle(frameTitle);
        } else {
            this.controller.getViewController().setTitle("");
        }
    }

    private String format(String propertyName) {
        return " (" + TextUtils.getText(propertyName) + ")";
    }

    @Override
    public void onRemove(MapModel map) {
        List<Component> views = this.getViews(map);
        for (Component view : views) {
            this.remove((MapView)view);
        }
    }

    @Override
    public void onQuitApplication() {
        ResourceController.getResourceController().setProperty("antialiasEdges", this.antialiasEdges ? "true" : "false");
        ResourceController.getResourceController().setProperty("antialiasAll", this.antialiasAll ? "true" : "false");
    }

    @Override
    public void moveFocusFromDescendantToSelection(Component ancestor) {
        Component selectedComponent;
        boolean toolbarLostFocus;
        Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
        boolean bl = toolbarLostFocus = focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, ancestor);
        if (toolbarLostFocus && (selectedComponent = this.getSelectedComponent()) != null) {
            selectedComponent.requestFocus();
        }
    }

    @Override
    public boolean isChildHidden(NodeModel node) {
        if (this.selectedMapView == null) {
            return false;
        }
        NodeModel parentNode = node.getParentNode();
        if (parentNode == null) {
            return false;
        }
        NodeView nodeView = this.selectedMapView.getNodeView(parentNode);
        if (nodeView == null) {
            return false;
        }
        return nodeView.isChildHidden(node);
    }

    @Override
    public boolean hasHiddenChildren(NodeModel node) {
        if (this.selectedMapView == null) {
            return false;
        }
        NodeView nodeView = this.selectedMapView.getNodeView(node);
        if (nodeView == null) {
            return false;
        }
        return nodeView.hasHiddenChildren();
    }

    @Override
    public int getHiddenChildCount(NodeModel node) {
        if (this.selectedMapView == null) {
            return 0;
        }
        NodeView nodeView = this.selectedMapView.getNodeView(node);
        if (nodeView == null) {
            return 0;
        }
        return nodeView.getHiddenChildCount();
    }

    @Override
    public boolean unfoldHiddenChildren(NodeModel node) {
        if (this.selectedMapView == null) {
            return false;
        }
        NodeView nodeView = this.selectedMapView.getNodeView(node);
        if (nodeView == null) {
            return false;
        }
        return nodeView.unfoldHiddenChildren();
    }

    @Override
    public void hideChildren(NodeModel node) {
        if (this.selectedMapView == null) {
            return;
        }
        NodeView nodeView = this.selectedMapView.getNodeView(node);
        if (nodeView == null) {
            return;
        }
        nodeView.hideChildren(node);
    }

    @Override
    public boolean showHiddenNode(NodeModel node) {
        if (this.selectedMapView == null) {
            return false;
        }
        NodeModel parentNode = node.getParentNode();
        if (parentNode == null) {
            return false;
        }
        NodeView nodeView = this.selectedMapView.getNodeView(parentNode);
        if (nodeView == null) {
            return false;
        }
        return nodeView.showHiddenNode(node);
    }

    @Override
    public boolean isSpotlightEnabled() {
        return this.selectedMapView != null && this.selectedMapView.isSpotlightEnabled();
    }

    @Override
    public void setViewRoot(NodeModel node) {
        this.changeToMap(node.getMap());
        if (this.selectedMapView == null) {
            return;
        }
        this.selectedMapView.setRootNode(node);
    }

    @Override
    public void usePreviousViewRoot() {
        if (this.selectedMapView == null) {
            return;
        }
        this.selectedMapView.usePreviousViewRoot();
    }

    @Override
    public void setLayout(Component mapComponent, MapViewLayout newLayoutType) {
        MapView map = (MapView)mapComponent;
        MapViewLayout oldLayoutType = map.getLayoutType();
        map.setLayoutType(newLayoutType);
        ModeController modeController = map.getModeController();
        MapStyle mapStyle = modeController.getExtension(MapStyle.class);
        mapStyle.setMapViewLayout(map.getMap(), newLayoutType);
        map.getMapSelection().preserveNodeLocationOnScreen(map.getSelected().getNode(), 0.5f, 0.5f);
        modeController.getMapController().fireMapChanged(new MapChangeEvent(this, map.getMap(), "MAP_LAYOUT", (Object)oldLayoutType, (Object)newLayoutType));
        NodeView root = map.getRoot();
        this.invalidateAll(root);
        root.revalidate();
    }

    private void invalidateAll(Component c) {
        c.invalidate();
        if (!(c instanceof Container)) {
            return;
        }
        Container c2 = (Container)c;
        for (int i = 0; i < c2.getComponentCount(); ++i) {
            this.invalidateAll(c2.getComponent(i));
        }
    }

    @Override
    public void setMap(Component view, MapModel newMap) {
        if (!(view instanceof MapView)) {
            return;
        }
        MapView mapView = (MapView)view;
        MapModel oldMap = mapView.getMap();
        if (newMap == oldMap) {
            return;
        }
        this.mapViewChangeListeners.beforeMapChange(oldMap, newMap);
        mapView.setMap(newMap);
        mapView.selectAsTheOnlyOneSelected(mapView.getRoot());
        this.mapViewChangeListeners.afterMapChange(oldMap, newMap);
    }
}

