/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.IMouseWheelEventHandler;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.MapView;

public class DefaultMouseWheelListener
implements MouseWheelListener {
    private static final String ZOOM_AROUND_SELECTED_NODE_PROPERTY = "zoomAroundSelectedNode";
    private static final int ZOOM_MASK = 2;

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        MapView mapView = (MapView)e.getSource();
        ModeController mController = mapView.getModeController();
        if (mController.isBlocked() || Controller.getCurrentController().getMap() != mapView.getMap()) {
            return;
        }
        Set<IMouseWheelEventHandler> registeredMouseWheelEventHandler = mController.getUserInputListenerFactory().getMouseWheelEventHandlers();
        for (IMouseWheelEventHandler handler : registeredMouseWheelEventHandler) {
            boolean result = handler.handleMouseWheelEvent(e);
            if (!result) continue;
            return;
        }
        if ((e.getModifiers() & 2) != 0) {
            float newZoom = mapView.calculateNewZoom(e);
            if (newZoom != ((MapView)e.getComponent()).getZoom()) {
                if (!ResourceController.getResourceController().getBooleanProperty(ZOOM_AROUND_SELECTED_NODE_PROPERTY)) {
                    mapView.setZoom(newZoom, e.getPoint());
                }
                Controller.getCurrentController().getMapViewManager().setZoom(newZoom);
            }
        } else {
            JScrollPane scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, mapView);
            Point location = new Point(e.getX(), e.getY());
            UITools.convertPointToAncestor((Component)mapView, location, scrollPane);
            MouseWheelEvent mapWheelEvent = new MouseWheelEvent(scrollPane, e.getID(), e.getWhen(), e.getModifiers() | e.getModifiersEx(), location.x, location.y, e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), e.getWheelRotation());
            if (scrollPane != null) {
                for (MouseWheelListener l : scrollPane.getMouseWheelListeners()) {
                    l.mouseWheelMoved(mapWheelEvent);
                }
            }
        }
    }
}

