/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.FocusManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.Compat;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.ui.MovedMouseEventFilter;

public class NodeSelector {
    private static final String SELECTION_METHOD_DIRECT = "selection_method_direct";
    private static final String SELECTION_METHOD_BY_CLICK = "selection_method_by_click";
    private static final String TIME_FOR_DELAYED_SELECTION = "time_for_delayed_selection";
    private static final String SELECTION_METHOD = "selection_method";
    private static boolean mouseWasMoved;
    private final MovedMouseEventFilter windowMouseTracker = new MovedMouseEventFilter();
    private Rectangle controlRegionForDelayedSelection;
    private Timer timerForDelayedSelection;

    public void createTimer(MouseEvent e) {
        if (!mouseWasMoved) {
            return;
        }
        if (this.controlRegionForDelayedSelection != null && this.controlRegionForDelayedSelection.contains(e.getPoint())) {
            return;
        }
        if (!this.isInside(e)) {
            return;
        }
        this.stopTimerForDelayedSelection();
        Window focusedWindow = FocusManager.getCurrentManager().getFocusedWindow();
        if (focusedWindow == null) {
            return;
        }
        if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() instanceof JTextComponent) {
            return;
        }
        this.controlRegionForDelayedSelection = this.getControlRegion(e.getPoint());
        String selectionMethod = ResourceController.getResourceController().getProperty(SELECTION_METHOD);
        if (selectionMethod.equals(SELECTION_METHOD_BY_CLICK)) {
            return;
        }
        if (selectionMethod.equals(SELECTION_METHOD_DIRECT)) {
            new TimeDelayedSelection(e).actionPerformed(new ActionEvent(this, 0, ""));
            return;
        }
        int timeForDelayedSelection = ResourceController.getResourceController().getIntProperty(TIME_FOR_DELAYED_SELECTION, 0);
        this.timerForDelayedSelection = new Timer(timeForDelayedSelection, new TimeDelayedSelection(e));
        this.timerForDelayedSelection.setRepeats(false);
        this.timerForDelayedSelection.start();
    }

    protected boolean isInside(MouseEvent e) {
        return new Rectangle(0, 0, e.getComponent().getWidth(), e.getComponent().getHeight()).contains(e.getPoint());
    }

    public void stopTimerForDelayedSelection() {
        if (this.timerForDelayedSelection != null) {
            this.timerForDelayedSelection.stop();
        }
        this.timerForDelayedSelection = null;
        this.controlRegionForDelayedSelection = null;
    }

    protected Rectangle getControlRegion(Point2D p) {
        int side = 8;
        return new Rectangle((int)(p.getX() - 4.0), (int)(p.getY() - 4.0), 8, 8);
    }

    public boolean shouldSelectOnClick(MouseEvent e) {
        if (this.isInside(e)) {
            NodeView nodeView = this.getRelatedNodeView(e);
            return !nodeView.isSelected() || Controller.getCurrentController().getSelection().size() != 1;
        }
        return false;
    }

    public void extendSelection(MouseEvent e, boolean scrollNodeTree) {
        Controller controller = Controller.getCurrentController();
        NodeView nodeView = this.getRelatedNodeView(e);
        NodeModel newlySelectedNode = nodeView.getNode();
        boolean extend = Compat.isMacOsX() ? e.isMetaDown() : e.isControlDown();
        boolean range = e.isShiftDown();
        IMapSelection selection = controller.getSelection();
        if (range && !extend) {
            selection.selectContinuous(newlySelectedNode);
        } else if (extend && !range) {
            selection.toggleSelected(newlySelectedNode);
        }
        if (extend == range) {
            if (!selection.isSelected(newlySelectedNode) || selection.size() != 1 || !(FocusManager.getCurrentManager().getFocusOwner() instanceof MainView)) {
                selection.selectAsTheOnlyOneSelected(newlySelectedNode);
                e.consume();
            }
            if (!extend && scrollNodeTree && !newlySelectedNode.isFolded()) {
                controller.getModeController().getMapController().scrollNodeTreeAfterSelect(newlySelectedNode);
                e.consume();
            }
        }
    }

    public void selectSingleNode(MouseEvent e) {
        NodeView nodeV = this.getRelatedNodeView(e);
        Controller controller = Controller.getCurrentController();
        if (!((MapView)controller.getMapViewManager().getMapViewComponent()).isSelected(nodeV)) {
            controller.getSelection().selectAsTheOnlyOneSelected(nodeV.getNode());
        }
    }

    public NodeView getRelatedNodeView(MouseEvent e) {
        return (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, e.getComponent());
    }

    public boolean isRelevant(MouseEvent e) {
        return this.windowMouseTracker.isRelevant(e);
    }

    public void trackWindowForComponent(Component c) {
        this.windowMouseTracker.trackWindowForComponent(c);
    }

    static {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){
            int lastX = -1;
            int lastY = -1;

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)event;
                    int x = mouseEvent.getXOnScreen();
                    int y = mouseEvent.getYOnScreen();
                    mouseWasMoved = this.lastX != x || this.lastY != y;
                    this.lastX = x;
                    this.lastY = y;
                }
            }
        }, 131120L);
        mouseWasMoved = false;
    }

    protected class TimeDelayedSelection
    implements ActionListener {
        private final MouseEvent mouseEvent;

        TimeDelayedSelection(MouseEvent e) {
            this.mouseEvent = e;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.mouseEvent.getModifiers() != 0) {
                return;
            }
            try {
                Controller controller = Controller.getCurrentController();
                ModeController modeController = controller.getModeController();
                if (!modeController.isBlocked() && controller.getSelection().size() <= 1) {
                    NodeView nodeV = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, this.mouseEvent.getComponent());
                    MapView map = nodeV.getMap();
                    if (nodeV.isDisplayable() && nodeV.getNode().hasVisibleContent(map.getFilter())) {
                        map.select();
                        NodeModel node = nodeV.getNode();
                        controller.getSelection().selectAsTheOnlyOneSelected(node);
                        modeController.getMapController().scrollNodeTreeAfterSelect(node);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

