/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.svg;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.freeplane.features.export.mindmapmode.IExportEngine;
import org.freeplane.plugin.svg.GradientExtensionHandler;
import org.freeplane.view.swing.map.MapView;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

abstract class ExportVectorGraphic
implements IExportEngine {
    ExportVectorGraphic() {
    }

    protected SVGGraphics2D createSVGGraphics2D(MapView view) {
        DOMImplementation impl = GenericDOMImplementation.getDOMImplementation();
        String namespaceURI = "http://www.w3.org/2000/svg";
        Document domFactory = impl.createDocument("http://www.w3.org/2000/svg", "svg", null);
        SVGGeneratorContext ctx = this.createGeneratorContext(domFactory);
        SVGGeneratorContext.GraphicContextDefaults defaults = new SVGGeneratorContext.GraphicContextDefaults();
        defaults.setFont(new Font("Arial", 0, 12));
        ctx.setGraphicContextDefaults(defaults);
        ctx.setExtensionHandler((ExtensionHandler)new GradientExtensionHandler());
        ctx.setPrecision(12);
        SVGGraphics2D g2d = new SVGGraphics2D(ctx, false);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        view.preparePrinting();
        Rectangle innerBounds = view.getInnerBounds();
        g2d.setSVGCanvasSize(new Dimension(innerBounds.width, innerBounds.height));
        g2d.translate(-innerBounds.x, -innerBounds.y);
        view.print((Graphics)g2d);
        view.endPrinting();
        return g2d;
    }

    protected SVGGeneratorContext createGeneratorContext(Document domFactory) {
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)domFactory);
        return ctx;
    }
}

