/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterRegistry;
import io.sf.carte.echosvg.svggen.DefaultCachedImageHandler;
import io.sf.carte.echosvg.svggen.ImageCacher;
import io.sf.carte.echosvg.svggen.SVGGraphics2DIOException;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;

public class CachedImageHandlerPNGEncoder
extends DefaultCachedImageHandler {
    public static final String CACHED_PNG_PREFIX = "pngImage";
    public static final String CACHED_PNG_SUFFIX = ".png";
    protected String refPrefix = "";

    public CachedImageHandlerPNGEncoder(String string, String string2) throws SVGGraphics2DIOException {
        this.refPrefix = string2 + "/";
        this.setImageCacher(new ImageCacher.External(string, CACHED_PNG_PREFIX, CACHED_PNG_SUFFIX));
    }

    @Override
    public void encodeImage(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor("image/png");
        imageWriter.writeImage((RenderedImage)bufferedImage, outputStream);
    }

    @Override
    public BufferedImage buildBufferedImage(Dimension dimension, ColorModel colorModel) {
        BufferedImage bufferedImage;
        if (colorModel == null || colorModel.getColorSpace().isCS_sRGB()) {
            bufferedImage = new BufferedImage(dimension.width, dimension.height, this.getDefaultBufferedImageType());
        } else {
            WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(dimension.width, dimension.height);
            bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
        }
        return bufferedImage;
    }

    @Override
    protected int getDefaultBufferedImageType() {
        return 2;
    }

    @Override
    public String getRefPrefix() {
        return this.refPrefix;
    }
}

