/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.GraphicContext;
import io.sf.carte.echosvg.ext.awt.g2d.TransformStackElement;
import io.sf.carte.echosvg.svggen.DOMTreeManager;
import io.sf.carte.echosvg.svggen.ErrorConstants;
import io.sf.carte.echosvg.svggen.SVGAttribute;
import io.sf.carte.echosvg.svggen.SVGAttributeMap;
import io.sf.carte.echosvg.svggen.SVGGraphicContext;
import io.sf.carte.echosvg.svggen.SVGGraphics2DRuntimeException;
import io.sf.carte.echosvg.svggen.SVGSyntax;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class DOMGroupManager
implements SVGSyntax,
ErrorConstants {
    public static final short DRAW = 1;
    public static final short FILL = 16;
    private GraphicContext gc;
    private DOMTreeManager domTreeManager;
    private SVGGraphicContext groupGC;
    private Element currentGroup;

    public DOMGroupManager(GraphicContext graphicContext, DOMTreeManager dOMTreeManager) {
        if (graphicContext == null) {
            throw new SVGGraphics2DRuntimeException("gc should not be null");
        }
        if (dOMTreeManager == null) {
            throw new SVGGraphics2DRuntimeException("domTreeManager should not be null");
        }
        this.gc = graphicContext;
        this.domTreeManager = dOMTreeManager;
        this.recycleCurrentGroup();
        this.groupGC = dOMTreeManager.getGraphicContextConverter().toSVG(graphicContext);
    }

    void recycleCurrentGroup() {
        this.currentGroup = this.domTreeManager.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "g");
    }

    public void addElement(Element element) {
        this.addElement(element, (short)17);
    }

    public void addElement(Element element, short s) {
        this.addElement(element, s, null);
    }

    void addElement(Element element, short s, SVGGraphicContext sVGGraphicContext) {
        if (!this.currentGroup.hasChildNodes()) {
            this.currentGroup.appendChild(element);
            this.groupGC = sVGGraphicContext == null ? this.domTreeManager.getGraphicContextConverter().toSVG(this.gc) : sVGGraphicContext;
            SVGGraphicContext sVGGraphicContext2 = DOMGroupManager.processDeltaGC(this.groupGC, this.domTreeManager.defaultGC);
            this.domTreeManager.getStyleHandler().setStyle(this.currentGroup, sVGGraphicContext2.getGroupContext(), this.domTreeManager.getGeneratorContext());
            if ((s & 1) == 0) {
                sVGGraphicContext2.getGraphicElementContext().put("stroke", "none");
            }
            if ((s & 0x10) == 0) {
                sVGGraphicContext2.getGraphicElementContext().put("fill", "none");
            }
            this.domTreeManager.getStyleHandler().setStyle(element, sVGGraphicContext2.getGraphicElementContext(), this.domTreeManager.getGeneratorContext());
            this.setTransform(this.currentGroup, sVGGraphicContext2.getTransformStack());
            this.domTreeManager.appendGroup(this.currentGroup, this);
        } else if (this.gc.isTransformStackValid()) {
            if (sVGGraphicContext == null) {
                sVGGraphicContext = this.domTreeManager.getGraphicContextConverter().toSVG(this.gc);
            }
            SVGGraphicContext sVGGraphicContext3 = DOMGroupManager.processDeltaGC(sVGGraphicContext, this.groupGC);
            this.trimContextForElement(sVGGraphicContext3, element);
            if (this.countOverrides(sVGGraphicContext3) <= this.domTreeManager.maxGCOverrides) {
                this.currentGroup.appendChild(element);
                if ((s & 1) == 0) {
                    sVGGraphicContext3.getContext().put("stroke", "none");
                }
                if ((s & 0x10) == 0) {
                    sVGGraphicContext3.getContext().put("fill", "none");
                }
                this.domTreeManager.getStyleHandler().setStyle(element, sVGGraphicContext3.getContext(), this.domTreeManager.getGeneratorContext());
                this.setTransform(element, sVGGraphicContext3.getTransformStack());
            } else {
                this.currentGroup = this.domTreeManager.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "g");
                this.addElement(element, s);
            }
        } else {
            this.currentGroup = this.domTreeManager.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "g");
            this.gc.validateTransformStack();
            this.addElement(element, s);
        }
    }

    protected int countOverrides(SVGGraphicContext sVGGraphicContext) {
        return sVGGraphicContext.getGroupContext().size();
    }

    protected void trimContextForElement(SVGGraphicContext sVGGraphicContext, Element element) {
        String string = element.getTagName();
        Map<String, String> map = sVGGraphicContext.getGroupContext();
        if (string != null) {
            for (String string2 : map.keySet()) {
                SVGAttribute sVGAttribute = SVGAttributeMap.get(string2);
                if (sVGAttribute == null || sVGAttribute.appliesTo(string)) continue;
                map.remove(string2);
            }
        }
    }

    protected void setTransform(Element element, TransformStackElement[] transformStackElementArray) {
        String string = this.domTreeManager.getGraphicContextConverter().toSVG(transformStackElementArray).trim();
        if (string.length() > 0) {
            element.setAttributeNS(null, "transform", string);
        }
    }

    static SVGGraphicContext processDeltaGC(SVGGraphicContext sVGGraphicContext, SVGGraphicContext sVGGraphicContext2) {
        Map<String, String> map = DOMGroupManager.processDeltaMap(sVGGraphicContext.getGroupContext(), sVGGraphicContext2.getGroupContext());
        Map<String, String> map2 = sVGGraphicContext.getGraphicElementContext();
        TransformStackElement[] transformStackElementArray = sVGGraphicContext.getTransformStack();
        TransformStackElement[] transformStackElementArray2 = sVGGraphicContext2.getTransformStack();
        int n = transformStackElementArray.length - transformStackElementArray2.length;
        TransformStackElement[] transformStackElementArray3 = new TransformStackElement[n];
        System.arraycopy(transformStackElementArray, transformStackElementArray2.length, transformStackElementArray3, 0, n);
        SVGGraphicContext sVGGraphicContext3 = new SVGGraphicContext(map, map2, transformStackElementArray3);
        return sVGGraphicContext3;
    }

    static Map<String, String> processDeltaMap(Map<String, String> map, Map<String, String> map2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : map.keySet()) {
            String string2;
            String string3 = map.get(string);
            if (string3.equals(string2 = map2.get(string))) continue;
            hashMap.put(string, string3);
        }
        return hashMap;
    }
}

