/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.GraphicContext;
import io.sf.carte.echosvg.svggen.DOMGroupManager;
import io.sf.carte.echosvg.svggen.ErrorConstants;
import io.sf.carte.echosvg.svggen.ExtensionHandler;
import io.sf.carte.echosvg.svggen.SVGBufferedImageOp;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGGraphicContext;
import io.sf.carte.echosvg.svggen.SVGGraphicContextConverter;
import io.sf.carte.echosvg.svggen.SVGGraphics2DRuntimeException;
import io.sf.carte.echosvg.svggen.SVGSyntax;
import io.sf.carte.echosvg.svggen.StyleHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DOMTreeManager
implements SVGSyntax,
ErrorConstants {
    int maxGCOverrides;
    private final List<DOMGroupManager> groupManagers = Collections.synchronizedList(new ArrayList());
    private List<Element> genericDefSet = new LinkedList<Element>();
    SVGGraphicContext defaultGC;
    private Element topLevelGroup;
    private SVGGraphicContextConverter gcConverter;
    private SVGGeneratorContext generatorContext;
    private SVGBufferedImageOp filterConverter;
    private List<Element> otherDefs;

    public DOMTreeManager(GraphicContext graphicContext, SVGGeneratorContext sVGGeneratorContext, int n) {
        if (graphicContext == null) {
            throw new SVGGraphics2DRuntimeException("gc should not be null");
        }
        if (n <= 0) {
            throw new SVGGraphics2DRuntimeException("maxGcOverrides should be greater than zero");
        }
        if (sVGGeneratorContext == null) {
            throw new SVGGraphics2DRuntimeException("generatorContext should not be null");
        }
        this.generatorContext = sVGGeneratorContext;
        this.maxGCOverrides = n;
        this.recycleTopLevelGroup();
        this.defaultGC = this.gcConverter.toSVG(graphicContext);
    }

    public void addGroupManager(DOMGroupManager dOMGroupManager) {
        if (dOMGroupManager != null) {
            this.groupManagers.add(dOMGroupManager);
        }
    }

    public void removeGroupManager(DOMGroupManager dOMGroupManager) {
        if (dOMGroupManager != null) {
            this.groupManagers.remove(dOMGroupManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendGroup(Element element, DOMGroupManager dOMGroupManager) {
        this.topLevelGroup.appendChild(element);
        List<DOMGroupManager> list = this.groupManagers;
        synchronized (list) {
            for (DOMGroupManager dOMGroupManager2 : this.groupManagers) {
                if (dOMGroupManager2 == dOMGroupManager) continue;
                dOMGroupManager2.recycleCurrentGroup();
            }
        }
    }

    protected void recycleTopLevelGroup() {
        this.recycleTopLevelGroup(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleTopLevelGroup(boolean bl) {
        List<DOMGroupManager> list = this.groupManagers;
        synchronized (list) {
            for (DOMGroupManager dOMGroupManager : this.groupManagers) {
                dOMGroupManager.recycleCurrentGroup();
            }
        }
        this.topLevelGroup = this.generatorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "g");
        if (bl) {
            this.filterConverter = new SVGBufferedImageOp(this.generatorContext);
            this.gcConverter = new SVGGraphicContextConverter(this.generatorContext);
        }
    }

    public void setTopLevelGroup(Element element) {
        if (element == null) {
            throw new SVGGraphics2DRuntimeException("topLevelGroup should not be null");
        }
        if (!"g".equalsIgnoreCase(element.getTagName())) {
            throw new SVGGraphics2DRuntimeException("topLevelGroup should be a group <g>");
        }
        this.recycleTopLevelGroup(false);
        this.topLevelGroup = element;
    }

    public Element getRoot() {
        return this.getRoot(null);
    }

    public Element getRoot(Element element) {
        Element element2 = element;
        if (element2 == null) {
            element2 = this.generatorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "svg");
        }
        if (this.gcConverter.getCompositeConverter().getAlphaCompositeConverter().requiresBackgroundAccess()) {
            element2.setAttributeNS(null, "enable-background", "new");
        }
        if (this.generatorContext.getComment() != null) {
            Comment comment = this.generatorContext.getDOMFactory().createComment(this.generatorContext.getComment());
            element2.appendChild(comment);
        }
        this.applyDefaultRenderingStyle(element2);
        element2.appendChild(this.getGenericDefinitions());
        element2.appendChild(this.getTopLevelGroup());
        return element2;
    }

    public void applyDefaultRenderingStyle(Element element) {
        Map<String, String> map = this.defaultGC.getGroupContext();
        this.generatorContext.getStyleHandler().setStyle(element, map, this.generatorContext);
    }

    public Element getGenericDefinitions() {
        Element element = this.generatorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "defs");
        for (Element element2 : this.genericDefSet) {
            element.appendChild(element2);
        }
        element.setAttributeNS(null, "id", "genericDefs");
        return element;
    }

    public ExtensionHandler getExtensionHandler() {
        return this.generatorContext.getExtensionHandler();
    }

    void setExtensionHandler(ExtensionHandler extensionHandler) {
        this.generatorContext.setExtensionHandler(extensionHandler);
    }

    public List<Element> getDefinitionSet() {
        List<Element> list = this.gcConverter.getDefinitionSet();
        list.removeAll(this.genericDefSet);
        list.addAll(this.filterConverter.getDefinitionSet());
        if (this.otherDefs != null) {
            list.addAll(this.otherDefs);
            this.otherDefs = null;
        }
        this.filterConverter = new SVGBufferedImageOp(this.generatorContext);
        this.gcConverter = new SVGGraphicContextConverter(this.generatorContext);
        return list;
    }

    public void addOtherDef(Element element) {
        if (this.otherDefs == null) {
            this.otherDefs = new LinkedList<Element>();
        }
        this.otherDefs.add(element);
    }

    public Element getTopLevelGroup() {
        boolean bl = true;
        return this.getTopLevelGroup(bl);
    }

    public Element getTopLevelGroup(boolean bl) {
        List<Element> list;
        Element element = this.topLevelGroup;
        if (bl && (list = this.getDefinitionSet()).size() > 0) {
            Element element2 = null;
            NodeList nodeList = element.getElementsByTagName("defs");
            if (nodeList.getLength() > 0) {
                element2 = (Element)nodeList.item(0);
            }
            if (element2 == null) {
                element2 = this.generatorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "defs");
                element2.setAttributeNS(null, "id", this.generatorContext.getIDGenerator().generateID("defs"));
                element.insertBefore(element2, element.getFirstChild());
            }
            for (Element element3 : list) {
                element2.appendChild(element3);
            }
        }
        this.recycleTopLevelGroup(false);
        return element;
    }

    public SVGBufferedImageOp getFilterConverter() {
        return this.filterConverter;
    }

    public SVGGraphicContextConverter getGraphicContextConverter() {
        return this.gcConverter;
    }

    SVGGeneratorContext getGeneratorContext() {
        return this.generatorContext;
    }

    Document getDOMFactory() {
        return this.generatorContext.getDOMFactory();
    }

    StyleHandler getStyleHandler() {
        return this.generatorContext.getStyleHandler();
    }
}

