/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterParams;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterRegistry;
import io.sf.carte.echosvg.svggen.DefaultImageHandler;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGGraphics2DIOException;
import io.sf.carte.echosvg.svggen.SVGGraphics2DRuntimeException;
import io.sf.carte.echosvg.util.Base64EncoderStream;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Element;

public class ImageHandlerBase64Encoder
extends DefaultImageHandler {
    @Override
    public void handleHREF(Image image, Element element, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
        if (image == null) {
            throw new SVGGraphics2DRuntimeException("image should not be null");
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n == 0 || n2 == 0) {
            this.handleEmptyImage(element);
        } else if (image instanceof RenderedImage) {
            this.handleHREF((RenderedImage)((Object)image), element, sVGGeneratorContext);
        } else {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            this.handleHREF(bufferedImage, element, sVGGeneratorContext);
        }
    }

    @Override
    public void handleHREF(RenderableImage renderableImage, Element element, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
        if (renderableImage == null) {
            throw new SVGGraphics2DRuntimeException("image should not be null");
        }
        RenderedImage renderedImage = renderableImage.createDefaultRendering();
        if (renderedImage == null) {
            this.handleEmptyImage(element);
        } else {
            this.handleHREF(renderedImage, element, sVGGeneratorContext);
        }
    }

    protected void handleEmptyImage(Element element) {
        element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "data:image/png;base64,");
        element.setAttributeNS(null, "width", "0");
        element.setAttributeNS(null, "height", "0");
    }

    @Override
    public void handleHREF(RenderedImage renderedImage, Element element, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        Base64EncoderStream base64EncoderStream = new Base64EncoderStream((OutputStream)byteArrayOutputStream);
        try {
            this.encodeImage(renderedImage, (OutputStream)base64EncoderStream, sVGGeneratorContext.getCompressionLevel());
            base64EncoderStream.close();
        }
        catch (IOException iOException) {
            throw new SVGGraphics2DIOException("unexpected exception", iOException);
        }
        element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "data:image/png;base64," + byteArrayOutputStream.toString());
    }

    public void encodeImage(RenderedImage renderedImage, OutputStream outputStream) throws SVGGraphics2DIOException {
        this.encodeImage(renderedImage, outputStream, null);
    }

    public void encodeImage(RenderedImage renderedImage, OutputStream outputStream, Integer n) throws SVGGraphics2DIOException {
        try {
            ImageWriterParams imageWriterParams = null;
            if (n != null) {
                imageWriterParams = new ImageWriterParams();
                imageWriterParams.setCompressionLevel(n.intValue());
            }
            ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor("image/png");
            imageWriter.writeImage(renderedImage, outputStream, imageWriterParams);
        }
        catch (IOException iOException) {
            throw new SVGGraphics2DIOException("unexpected exception");
        }
    }

    public BufferedImage buildBufferedImage(Dimension dimension, ColorModel colorModel) {
        BufferedImage bufferedImage;
        if (colorModel == null || colorModel.getColorSpace().isCS_sRGB()) {
            bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
        } else {
            WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(dimension.width, dimension.height);
            bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
        }
        return bufferedImage;
    }
}

