/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterParams;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterRegistry;
import io.sf.carte.echosvg.svggen.AbstractImageHandlerEncoder;
import io.sf.carte.echosvg.svggen.SVGGraphics2DIOException;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ImageHandlerJPEGEncoder
extends AbstractImageHandlerEncoder {
    public ImageHandlerJPEGEncoder(String string, String string2) throws SVGGraphics2DIOException {
        super(string, string2);
    }

    @Override
    public final String getSuffix() {
        return ".jpg";
    }

    @Override
    public final String getPrefix() {
        return "jpegImage";
    }

    @Override
    public void encodeImage(BufferedImage bufferedImage, File file) throws SVGGraphics2DIOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor("image/jpeg");
            ImageWriterParams imageWriterParams = new ImageWriterParams();
            imageWriterParams.setJPEGQuality(1.0f, false);
            imageWriter.writeImage((RenderedImage)bufferedImage, (OutputStream)fileOutputStream, imageWriterParams);
        }
        catch (IOException iOException) {
            throw new SVGGraphics2DIOException("could not write image File " + file.getName());
        }
    }

    @Override
    public BufferedImage buildBufferedImage(Dimension dimension, ColorModel colorModel) {
        return new BufferedImage(dimension.width, dimension.height, 1);
    }
}

