/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.GraphicContext;
import io.sf.carte.echosvg.svggen.AbstractSVGConverter;
import io.sf.carte.echosvg.svggen.ClipKey;
import io.sf.carte.echosvg.svggen.SVGClipDescriptor;
import io.sf.carte.echosvg.svggen.SVGDescriptor;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGShape;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import org.w3c.dom.Element;

public class SVGClip
extends AbstractSVGConverter {
    public static final Shape ORIGIN = new Line2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
    public static final SVGClipDescriptor NO_CLIP = new SVGClipDescriptor("none", null);
    private SVGShape shapeConverter;

    public SVGClip(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
        this.shapeConverter = new SVGShape(sVGGeneratorContext);
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        Shape shape = graphicContext.getClip();
        SVGClipDescriptor sVGClipDescriptor = null;
        if (shape != null) {
            StringBuilder stringBuilder = new StringBuilder("url(");
            GeneralPath generalPath = new GeneralPath(shape);
            ClipKey clipKey = new ClipKey(generalPath, this.getGeneratorContext());
            sVGClipDescriptor = (SVGClipDescriptor)this.descMap.get(clipKey);
            if (sVGClipDescriptor == null) {
                Element element = this.clipToSVG(shape);
                if (element == null) {
                    sVGClipDescriptor = NO_CLIP;
                } else {
                    stringBuilder.append("#");
                    stringBuilder.append(element.getAttributeNS(null, "id"));
                    stringBuilder.append(")");
                    sVGClipDescriptor = new SVGClipDescriptor(stringBuilder.toString(), element);
                    this.descMap.put(clipKey, sVGClipDescriptor);
                    this.defSet.add(element);
                }
            }
        } else {
            sVGClipDescriptor = NO_CLIP;
        }
        return sVGClipDescriptor;
    }

    private Element clipToSVG(Shape shape) {
        Element element = this.getGeneratorContext().getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "clipPath");
        element.setAttributeNS(null, "clipPathUnits", "userSpaceOnUse");
        element.setAttributeNS(null, "id", this.getGeneratorContext().getIDGenerator().generateID("clipPath"));
        Element element2 = this.shapeConverter.toSVG(shape);
        if (element2 != null) {
            element.appendChild(element2);
            return element;
        }
        element.appendChild(this.shapeConverter.toSVG(ORIGIN));
        return element;
    }
}

