/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.svggen.AbstractSVGFilterConverter;
import io.sf.carte.echosvg.svggen.SVGFilterDescriptor;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import java.awt.Rectangle;
import java.awt.image.BufferedImageOp;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGConvolveOp
extends AbstractSVGFilterConverter {
    public SVGConvolveOp(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    @Override
    public SVGFilterDescriptor toSVG(BufferedImageOp bufferedImageOp, Rectangle rectangle) {
        if (bufferedImageOp instanceof ConvolveOp) {
            return this.toSVG((ConvolveOp)bufferedImageOp);
        }
        return null;
    }

    public SVGFilterDescriptor toSVG(ConvolveOp convolveOp) {
        SVGFilterDescriptor sVGFilterDescriptor = (SVGFilterDescriptor)this.descMap.get(convolveOp);
        Document document = this.generatorContext.getDOMFactory();
        if (sVGFilterDescriptor == null) {
            Kernel kernel = convolveOp.getKernel();
            Element element = document.createElementNS("http://www.w3.org/2000/svg", "filter");
            Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "feConvolveMatrix");
            element2.setAttributeNS(null, "order", kernel.getWidth() + " " + kernel.getHeight());
            float[] fArray = kernel.getKernelData(null);
            StringBuilder stringBuilder = new StringBuilder(fArray.length * 8);
            for (float f : fArray) {
                stringBuilder.append(this.doubleString(f));
                stringBuilder.append(" ");
            }
            element2.setAttributeNS(null, "kernelMatrix", stringBuilder.toString().trim());
            element.appendChild(element2);
            element.setAttributeNS(null, "id", this.generatorContext.getIDGenerator().generateID("convolve"));
            if (convolveOp.getEdgeCondition() == 1) {
                element2.setAttributeNS(null, "edgeMode", "duplicate");
            } else {
                element2.setAttributeNS(null, "edgeMode", "none");
            }
            Object object = new StringBuilder("url(");
            ((StringBuilder)object).append("#");
            ((StringBuilder)object).append(element.getAttributeNS(null, "id"));
            ((StringBuilder)object).append(")");
            sVGFilterDescriptor = new SVGFilterDescriptor(((StringBuilder)object).toString(), element);
            this.defSet.add(element);
            this.descMap.put(convolveOp, sVGFilterDescriptor);
        }
        return sVGFilterDescriptor;
    }
}

