/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.svggen.SVGGraphics2DIOException;
import io.sf.carte.echosvg.svggen.SVGGraphics2DRuntimeException;
import io.sf.carte.echosvg.util.SVGConstants;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class XmlWriter
implements SVGConstants {
    private static String EOL;
    private static final String TAG_END = "/>";
    private static final String TAG_START = "</";
    private static final char[] SPACES;
    private static final int SPACES_LEN;

    XmlWriter() {
    }

    private static void writeXml(Attr attr, IndentWriter indentWriter, boolean bl) throws IOException {
        String string = attr.getName();
        indentWriter.write(string);
        indentWriter.write("=\"");
        XmlWriter.writeChildrenXml(attr, indentWriter, bl);
        indentWriter.write(34);
    }

    private static void writeChildrenXml(Attr attr, IndentWriter indentWriter, boolean bl) throws IOException {
        int n;
        char[] cArray = attr.getValue().toCharArray();
        if (cArray == null) {
            return;
        }
        int n2 = cArray.length;
        int n3 = 0;
        block6: for (n = 0; n < n2; ++n) {
            char c = cArray[n];
            switch (c) {
                case '<': {
                    indentWriter.write(cArray, n3, n - n3);
                    n3 = n + 1;
                    indentWriter.write("&lt;");
                    continue block6;
                }
                case '>': {
                    indentWriter.write(cArray, n3, n - n3);
                    n3 = n + 1;
                    indentWriter.write("&gt;");
                    continue block6;
                }
                case '&': {
                    indentWriter.write(cArray, n3, n - n3);
                    n3 = n + 1;
                    indentWriter.write("&amp;");
                    continue block6;
                }
                case '\"': {
                    indentWriter.write(cArray, n3, n - n3);
                    n3 = n + 1;
                    indentWriter.write("&quot;");
                    continue block6;
                }
                default: {
                    if (!bl || c <= '\u007f') continue block6;
                    indentWriter.write(cArray, n3, n - n3);
                    String string = "0000" + Integer.toHexString(c);
                    indentWriter.write("&#x" + string.substring(string.length() - 4) + ";");
                    n3 = n + 1;
                }
            }
        }
        indentWriter.write(cArray, n3, n - n3);
    }

    private static void writeXml(Comment comment, IndentWriter indentWriter, boolean bl) throws IOException {
        int n;
        char[] cArray = comment.getData().toCharArray();
        if (cArray == null) {
            indentWriter.write("<!---->");
            return;
        }
        indentWriter.write("<!--");
        boolean bl2 = false;
        int n2 = cArray.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            char c = cArray[n];
            if (c == '-') {
                if (bl2) {
                    indentWriter.write(cArray, n3, n - n3);
                    n3 = n;
                    indentWriter.write(32);
                }
                bl2 = true;
                continue;
            }
            bl2 = false;
        }
        indentWriter.write(cArray, n3, n - n3);
        if (bl2) {
            indentWriter.write(32);
        }
        indentWriter.write("-->");
    }

    private static void writeXml(Text text, IndentWriter indentWriter, boolean bl) throws IOException {
        XmlWriter.writeXml(text, indentWriter, false, bl);
    }

    private static void writeXml(Text text, IndentWriter indentWriter, boolean bl, boolean bl2) throws IOException {
        char c;
        int n;
        char[] cArray = text.getData().toCharArray();
        if (cArray == null) {
            System.err.println("Null text data??");
            return;
        }
        int n2 = cArray.length;
        int n3 = 0;
        if (bl) {
            block12: for (n = 0; n < n2; ++n) {
                c = cArray[n];
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block12;
                    }
                }
            }
            n3 = n;
        }
        block13: while (n < n2) {
            c = cArray[n];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (!bl) break;
                    int n4 = n++;
                    block14: while (n < n2) {
                        switch (cArray[n]) {
                            case '\t': 
                            case '\n': 
                            case '\r': 
                            case ' ': {
                                ++n;
                                continue block14;
                            }
                        }
                    }
                    if (n != n2) continue block13;
                    indentWriter.write(cArray, n3, n4 - n3);
                    return;
                }
                case '<': {
                    indentWriter.write(cArray, n3, n - n3);
                    n3 = n + 1;
                    indentWriter.write("&lt;");
                    break;
                }
                case '>': {
                    indentWriter.write(cArray, n3, n - n3);
                    n3 = n + 1;
                    indentWriter.write("&gt;");
                    break;
                }
                case '&': {
                    indentWriter.write(cArray, n3, n - n3);
                    n3 = n + 1;
                    indentWriter.write("&amp;");
                    break;
                }
                default: {
                    if (!bl2 || c <= '\u007f') break;
                    indentWriter.write(cArray, n3, n - n3);
                    String string = "0000" + Integer.toHexString(c);
                    indentWriter.write("&#x" + string.substring(string.length() - 4) + ";");
                    n3 = n + 1;
                }
            }
            ++n;
        }
        indentWriter.write(cArray, n3, n - n3);
    }

    private static void writeXml(CDATASection cDATASection, IndentWriter indentWriter, boolean bl) throws IOException {
        char[] cArray = cDATASection.getData().toCharArray();
        if (cArray == null) {
            indentWriter.write("<![CDATA[]]>");
            return;
        }
        indentWriter.write("<![CDATA[");
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            if (c == ']' && n3 + 2 < cArray.length && cArray[n3 + 1] == ']' && cArray[n3 + 2] == '>') {
                indentWriter.write(cArray, n2, n3 - n2);
                n2 = n3 + 1;
                indentWriter.write("]]]]><![CDATA[>");
                continue;
            }
            ++n3;
        }
        indentWriter.write(cArray, n2, n3 - n2);
        indentWriter.write("]]>");
    }

    private static void writeXml(Element element, IndentWriter indentWriter, boolean bl) throws IOException, SVGGraphics2DIOException {
        int n;
        indentWriter.write(TAG_START, 0, 1);
        indentWriter.write(element.getTagName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                indentWriter.write(32);
                XmlWriter.writeXml(attr, indentWriter, bl);
            }
        }
        int n2 = n = element.getParentNode().getLastChild() == element ? 1 : 0;
        if (!element.hasChildNodes()) {
            if (n != 0) {
                indentWriter.setIndentLevel(indentWriter.getIndentLevel() - 2);
            }
            indentWriter.printIndent();
            indentWriter.write(TAG_END, 0, 2);
            return;
        }
        Node node = element.getFirstChild();
        indentWriter.printIndent();
        indentWriter.write(TAG_END, 1, 1);
        if (node.getNodeType() != 3 || element.getLastChild() != node) {
            indentWriter.setIndentLevel(indentWriter.getIndentLevel() + 2);
        }
        XmlWriter.writeChildrenXml(element, indentWriter, bl);
        indentWriter.write(TAG_START, 0, 2);
        indentWriter.write(element.getTagName());
        if (n != 0) {
            indentWriter.setIndentLevel(indentWriter.getIndentLevel() - 2);
        }
        indentWriter.printIndent();
        indentWriter.write(TAG_END, 1, 1);
    }

    private static void writeChildrenXml(Element element, IndentWriter indentWriter, boolean bl) throws IOException, SVGGraphics2DIOException {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            XmlWriter.writeXml(node, (Writer)indentWriter, bl);
        }
    }

    private static void writeDocumentHeader(IndentWriter indentWriter) throws IOException {
        String string = null;
        if (indentWriter.getProxied() instanceof OutputStreamWriter) {
            OutputStreamWriter outputStreamWriter = (OutputStreamWriter)indentWriter.getProxied();
            string = XmlWriter.java2std(outputStreamWriter.getEncoding());
        }
        indentWriter.write("<?xml version=\"1.0\"");
        if (string != null) {
            indentWriter.write(" encoding=\"");
            indentWriter.write(string);
            indentWriter.write(34);
        }
        indentWriter.write("?>");
        indentWriter.write(EOL);
        indentWriter.write("<!DOCTYPE svg PUBLIC '");
        indentWriter.write("-//W3C//DTD SVG 1.0//EN");
        indentWriter.write("'");
        indentWriter.write(EOL);
        indentWriter.write("          '");
        indentWriter.write("http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd");
        indentWriter.write("'");
        indentWriter.write(">");
        indentWriter.write(EOL);
    }

    private static void writeXml(Document document, IndentWriter indentWriter, boolean bl) throws IOException, SVGGraphics2DIOException {
        XmlWriter.writeDocumentHeader(indentWriter);
        NodeList nodeList = document.getChildNodes();
        XmlWriter.writeXml(nodeList, indentWriter, bl);
    }

    private static void writeXml(NodeList nodeList, IndentWriter indentWriter, boolean bl) throws IOException, SVGGraphics2DIOException {
        int n = nodeList.getLength();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            XmlWriter.writeXml(node, (Writer)indentWriter, bl);
            indentWriter.write(EOL);
        }
    }

    static String java2std(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("ISO8859_")) {
            return "ISO-8859-" + string.substring(8);
        }
        if (string.startsWith("8859_")) {
            return "ISO-8859-" + string.substring(5);
        }
        if ("ASCII7".equalsIgnoreCase(string) || "ASCII".equalsIgnoreCase(string)) {
            return "US-ASCII";
        }
        if ("UTF8".equalsIgnoreCase(string)) {
            return "UTF-8";
        }
        if (string.startsWith("Unicode")) {
            return "UTF-16";
        }
        if ("SJIS".equalsIgnoreCase(string)) {
            return "Shift_JIS";
        }
        if ("JIS".equalsIgnoreCase(string)) {
            return "ISO-2022-JP";
        }
        if ("EUCJIS".equalsIgnoreCase(string)) {
            return "EUC-JP";
        }
        return "UTF-8";
    }

    public static void writeXml(Node node, Writer writer, boolean bl) throws SVGGraphics2DIOException {
        try {
            IndentWriter indentWriter = null;
            indentWriter = writer instanceof IndentWriter ? (IndentWriter)writer : new IndentWriter(writer);
            switch (node.getNodeType()) {
                case 2: {
                    XmlWriter.writeXml((Attr)node, indentWriter, bl);
                    break;
                }
                case 8: {
                    XmlWriter.writeXml((Comment)node, indentWriter, bl);
                    break;
                }
                case 3: {
                    XmlWriter.writeXml((Text)node, indentWriter, bl);
                    break;
                }
                case 4: {
                    XmlWriter.writeXml((CDATASection)node, indentWriter, bl);
                    break;
                }
                case 9: {
                    XmlWriter.writeXml((Document)node, indentWriter, bl);
                    break;
                }
                case 11: {
                    XmlWriter.writeDocumentHeader(indentWriter);
                    NodeList nodeList = node.getChildNodes();
                    XmlWriter.writeXml(nodeList, indentWriter, bl);
                    break;
                }
                case 1: {
                    XmlWriter.writeXml((Element)node, indentWriter, bl);
                    break;
                }
                default: {
                    throw new SVGGraphics2DRuntimeException("Unable to write node of type " + node.getClass().getName());
                }
            }
        }
        catch (IOException iOException) {
            throw new SVGGraphics2DIOException(iOException);
        }
    }

    static {
        String string;
        SPACES = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
        SPACES_LEN = SPACES.length;
        try {
            string = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException securityException) {
            string = "\n";
        }
        EOL = string;
    }

    static class IndentWriter
    extends Writer {
        protected Writer proxied;
        protected int indentLevel;
        protected int column;

        public IndentWriter(Writer writer) {
            if (writer == null) {
                throw new SVGGraphics2DRuntimeException("proxy should not be null");
            }
            this.proxied = writer;
        }

        public void setIndentLevel(int n) {
            this.indentLevel = n;
        }

        public int getIndentLevel() {
            return this.indentLevel;
        }

        public void printIndent() throws IOException {
            this.proxied.write(EOL);
            for (int i = this.indentLevel; i > 0; i -= SPACES_LEN) {
                if (i > SPACES_LEN) {
                    this.proxied.write(SPACES, 0, SPACES_LEN);
                    continue;
                }
                this.proxied.write(SPACES, 0, i);
                break;
            }
            this.column = this.indentLevel;
        }

        public Writer getProxied() {
            return this.proxied;
        }

        public int getColumn() {
            return this.column;
        }

        @Override
        public void write(int n) throws IOException {
            ++this.column;
            this.proxied.write(n);
        }

        @Override
        public void write(char[] cArray) throws IOException {
            this.column += cArray.length;
            this.proxied.write(cArray);
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            this.column += n2;
            this.proxied.write(cArray, n, n2);
        }

        @Override
        public void write(String string) throws IOException {
            this.column += string.length();
            this.proxied.write(string);
        }

        @Override
        public void write(String string, int n, int n2) throws IOException {
            this.column += n2;
            this.proxied.write(string, n, n2);
        }

        @Override
        public void flush() throws IOException {
            this.proxied.flush();
        }

        @Override
        public void close() throws IOException {
            this.column = -1;
            this.proxied.close();
        }
    }
}

