/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen.font;

import io.sf.carte.echosvg.svggen.font.Glyph;
import io.sf.carte.echosvg.svggen.font.table.CmapTable;
import io.sf.carte.echosvg.svggen.font.table.GlyfTable;
import io.sf.carte.echosvg.svggen.font.table.HeadTable;
import io.sf.carte.echosvg.svggen.font.table.HheaTable;
import io.sf.carte.echosvg.svggen.font.table.HmtxTable;
import io.sf.carte.echosvg.svggen.font.table.LocaTable;
import io.sf.carte.echosvg.svggen.font.table.MaxpTable;
import io.sf.carte.echosvg.svggen.font.table.NameTable;
import io.sf.carte.echosvg.svggen.font.table.Os2Table;
import io.sf.carte.echosvg.svggen.font.table.PostTable;
import io.sf.carte.echosvg.svggen.font.table.Table;
import io.sf.carte.echosvg.svggen.font.table.TableDirectory;
import io.sf.carte.echosvg.svggen.font.table.TableFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Font {
    private String path;
    private TableDirectory tableDirectory = null;
    private Table[] tables;
    private Os2Table os2;
    private CmapTable cmap;
    private GlyfTable glyf;
    private HeadTable head;
    private HheaTable hhea;
    private HmtxTable hmtx;
    private LocaTable loca;
    private MaxpTable maxp;
    private NameTable name;
    private PostTable post;

    public Table getTable(int n) {
        for (Table table : this.tables) {
            if (table == null || table.getType() != n) continue;
            return table;
        }
        return null;
    }

    public Os2Table getOS2Table() {
        return this.os2;
    }

    public CmapTable getCmapTable() {
        return this.cmap;
    }

    public HeadTable getHeadTable() {
        return this.head;
    }

    public HheaTable getHheaTable() {
        return this.hhea;
    }

    public HmtxTable getHmtxTable() {
        return this.hmtx;
    }

    public LocaTable getLocaTable() {
        return this.loca;
    }

    public MaxpTable getMaxpTable() {
        return this.maxp;
    }

    public NameTable getNameTable() {
        return this.name;
    }

    public PostTable getPostTable() {
        return this.post;
    }

    public int getAscent() {
        return this.hhea.getAscender();
    }

    public int getDescent() {
        return this.hhea.getDescender();
    }

    public int getNumGlyphs() {
        return this.maxp.getNumGlyphs();
    }

    public Glyph getGlyph(int n) {
        return this.glyf.getDescription(n) != null ? new Glyph(this.glyf.getDescription(n), this.hmtx.getLeftSideBearing(n), this.hmtx.getAdvanceWidth(n)) : null;
    }

    public String getPath() {
        return this.path;
    }

    public TableDirectory getTableDirectory() {
        return this.tableDirectory;
    }

    protected void read(String string) {
        this.path = string;
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            this.tableDirectory = new TableDirectory(randomAccessFile);
            this.tables = new Table[this.tableDirectory.getNumTables()];
            for (int i = 0; i < this.tableDirectory.getNumTables(); ++i) {
                this.tables[i] = TableFactory.create(this.tableDirectory.getEntry(i), randomAccessFile);
            }
            randomAccessFile.close();
            this.os2 = (Os2Table)this.getTable(1330851634);
            this.cmap = (CmapTable)this.getTable(1668112752);
            this.glyf = (GlyfTable)this.getTable(1735162214);
            this.head = (HeadTable)this.getTable(1751474532);
            this.hhea = (HheaTable)this.getTable(1751672161);
            this.hmtx = (HmtxTable)this.getTable(1752003704);
            this.loca = (LocaTable)this.getTable(1819239265);
            this.maxp = (MaxpTable)this.getTable(1835104368);
            this.name = (NameTable)this.getTable(1851878757);
            this.post = (PostTable)this.getTable(1886352244);
            this.hmtx.init(this.hhea.getNumberOfHMetrics(), this.maxp.getNumGlyphs() - this.hhea.getNumberOfHMetrics());
            this.loca.init(this.maxp.getNumGlyphs(), this.head.getIndexToLocFormat() == 0);
            this.glyf.init(this.maxp.getNumGlyphs(), this.loca);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static Font create() {
        return new Font();
    }

    public static Font create(String string) {
        Font font = new Font();
        font.read(string);
        return font;
    }
}

