/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen.font.table;

import io.sf.carte.echosvg.svggen.font.table.DirectoryEntry;
import io.sf.carte.echosvg.svggen.font.table.GlyfCompositeDescript;
import io.sf.carte.echosvg.svggen.font.table.GlyfDescript;
import io.sf.carte.echosvg.svggen.font.table.GlyfSimpleDescript;
import io.sf.carte.echosvg.svggen.font.table.LocaTable;
import io.sf.carte.echosvg.svggen.font.table.Table;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class GlyfTable
implements Table {
    private byte[] buf = null;
    private GlyfDescript[] descript;

    protected GlyfTable(DirectoryEntry directoryEntry, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(directoryEntry.getOffset());
        this.buf = new byte[directoryEntry.getLength()];
        randomAccessFile.read(this.buf);
    }

    public void init(int n, LocaTable locaTable) {
        int n2;
        if (this.buf == null) {
            return;
        }
        this.descript = new GlyfDescript[n];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buf);
        for (n2 = 0; n2 < n; ++n2) {
            int n3 = locaTable.getOffset(n2 + 1) - locaTable.getOffset(n2);
            if (n3 <= 0) continue;
            byteArrayInputStream.reset();
            byteArrayInputStream.skip(locaTable.getOffset(n2));
            short s = (short)(byteArrayInputStream.read() << 8 | byteArrayInputStream.read());
            this.descript[n2] = s >= 0 ? new GlyfSimpleDescript(this, s, byteArrayInputStream) : new GlyfCompositeDescript(this, byteArrayInputStream);
        }
        this.buf = null;
        for (n2 = 0; n2 < n; ++n2) {
            if (this.descript[n2] == null) continue;
            this.descript[n2].resolve();
        }
    }

    public GlyfDescript getDescription(int n) {
        return this.descript[n];
    }

    @Override
    public int getType() {
        return 1735162214;
    }
}

