/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.dom;

import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.echosvg.css.engine.CSSContext;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.ShorthandManager;
import io.sf.carte.echosvg.css.engine.value.ValueManager;
import io.sf.carte.echosvg.dom.AbstractDOMImplementation;
import io.sf.carte.echosvg.dom.AbstractDocument;
import io.sf.carte.echosvg.dom.AbstractStylableDocument;
import io.sf.carte.echosvg.dom.DomExtension;
import io.sf.carte.echosvg.dom.GenericDocumentType;
import io.sf.carte.echosvg.dom.GenericElement;
import io.sf.carte.echosvg.dom.GenericElementNS;
import io.sf.carte.echosvg.dom.StyleSheetFactory;
import io.sf.carte.echosvg.dom.util.DOMUtilities;
import io.sf.carte.echosvg.util.DoublyIndexedTable;
import io.sf.carte.echosvg.xml.XMLUtilities;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.ServiceLoader;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.css.DOMImplementationCSS;
import org.w3c.dom.css.ViewCSS;

public abstract class ExtensibleDOMImplementation
extends AbstractDOMImplementation
implements DOMImplementationCSS,
StyleSheetFactory {
    private static final long serialVersionUID = 1L;
    protected DoublyIndexedTable<String, String> customFactories;
    protected List<ValueManager> customValueManagers;
    protected List<ShorthandManager> customShorthandManagers;
    protected static List<DomExtension> extensions = null;

    public ExtensibleDOMImplementation() {
        for (DomExtension domExtension : ExtensibleDOMImplementation.getDomExtensions()) {
            domExtension.registerTags(this);
        }
    }

    public void registerCustomElementFactory(String string, String string2, ElementFactory elementFactory) {
        if (this.customFactories == null) {
            this.customFactories = new DoublyIndexedTable();
        }
        this.customFactories.put((Object)string, (Object)string2, (Object)elementFactory);
    }

    public void registerCustomCSSValueManager(ValueManager valueManager) {
        if (this.customValueManagers == null) {
            this.customValueManagers = new LinkedList<ValueManager>();
        }
        this.customValueManagers.add(valueManager);
    }

    public void registerCustomCSSShorthandManager(ShorthandManager shorthandManager) {
        if (this.customShorthandManagers == null) {
            this.customShorthandManagers = new LinkedList<ShorthandManager>();
        }
        this.customShorthandManagers.add(shorthandManager);
    }

    public CSSEngine createCSSEngine(AbstractStylableDocument abstractStylableDocument, CSSContext cSSContext) {
        ShorthandManager[] shorthandManagerArray;
        ValueManager[] valueManagerArray;
        CSSParser cSSParser = new CSSParser();
        if (this.customValueManagers == null) {
            valueManagerArray = new ValueManager[]{};
        } else {
            valueManagerArray = new ValueManager[this.customValueManagers.size()];
            shorthandManagerArray = this.customValueManagers.iterator();
            int n = 0;
            while (shorthandManagerArray.hasNext()) {
                valueManagerArray[n++] = (ValueManager)shorthandManagerArray.next();
            }
        }
        if (this.customShorthandManagers == null) {
            shorthandManagerArray = new ShorthandManager[]{};
        } else {
            shorthandManagerArray = new ShorthandManager[this.customShorthandManagers.size()];
            Iterator<ShorthandManager> iterator = this.customShorthandManagers.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                shorthandManagerArray[n++] = iterator.next();
            }
        }
        CSSEngine cSSEngine = this.createCSSEngine(abstractStylableDocument, cSSContext, (Parser)cSSParser, valueManagerArray, shorthandManagerArray);
        abstractStylableDocument.setCSSEngine(cSSEngine);
        return cSSEngine;
    }

    public abstract CSSEngine createCSSEngine(AbstractStylableDocument var1, CSSContext var2, Parser var3, ValueManager[] var4, ShorthandManager[] var5);

    public abstract ViewCSS createViewCSS(AbstractStylableDocument var1);

    public Element createElementNS(AbstractDocument abstractDocument, String string, String string2) {
        String string3;
        ElementFactory elementFactory;
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string == null) {
            return new GenericElement(string2.intern(), abstractDocument);
        }
        if (this.customFactories != null && (elementFactory = (ElementFactory)this.customFactories.get((Object)string, (Object)(string3 = DOMUtilities.getLocalName(string2)))) != null) {
            return elementFactory.create(DOMUtilities.getPrefix(string2), abstractDocument);
        }
        return new GenericElementNS(string.intern(), string2.intern(), abstractDocument);
    }

    @Override
    public DocumentType createDocumentType(String string, String string2, String string3) {
        int n;
        if (string == null) {
            string = "";
        }
        if (((n = XMLUtilities.testXMLQName((String)string)) & 1) == 0) {
            throw new DOMException(5, this.formatMessage("xml.name", new Object[]{string}));
        }
        if ((n & 2) == 0) {
            throw new DOMException(5, this.formatMessage("invalid.qname", new Object[]{string}));
        }
        return new GenericDocumentType(string, string2, string3);
    }

    protected static synchronized List<DomExtension> getDomExtensions() {
        if (extensions != null) {
            return extensions;
        }
        extensions = new LinkedList<DomExtension>();
        ServiceLoader<DomExtension> serviceLoader = ServiceLoader.load(DomExtension.class);
        block0: for (DomExtension domExtension : serviceLoader) {
            DomExtension domExtension2;
            float f = domExtension.getPriority();
            ListIterator<DomExtension> listIterator = extensions.listIterator();
            do {
                if (listIterator.hasNext()) continue;
                listIterator.add(domExtension);
                continue block0;
            } while (!((domExtension2 = listIterator.next()).getPriority() > f));
            listIterator.previous();
            listIterator.add(domExtension);
        }
        return extensions;
    }

    public static interface ElementFactory {
        public Element create(String var1, Document var2);
    }
}

