/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder.util;

import io.sf.carte.doc.agent.DeviceFactory;
import io.sf.carte.doc.dom.CSSDOMImplementation;
import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.XMLDocumentBuilder;
import io.sf.carte.doc.style.css.BoxValues;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSComputedProperties;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.CSSStyleDeclaration;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleFormattingFactory;
import io.sf.carte.doc.style.css.awt.AWTHelper;
import io.sf.carte.doc.style.css.nsac.ArgumentCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorSelector;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ConditionalSelector;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.AbstractCSSCanvas;
import io.sf.carte.doc.style.css.om.AbstractStyleDatabase;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.RGBStyleFormattingFactory;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.xml.dtd.DefaultEntityResolver;
import io.sf.carte.echosvg.anim.dom.SVG12DOMImplementation;
import io.sf.carte.echosvg.anim.dom.SVGDOMImplementation;
import io.sf.carte.echosvg.transcoder.DefaultErrorHandler;
import io.sf.carte.echosvg.transcoder.ErrorHandler;
import io.sf.carte.echosvg.transcoder.SVGAbstractTranscoder;
import io.sf.carte.echosvg.transcoder.Transcoder;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderInput;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.TranscodingHints;
import io.sf.carte.echosvg.transcoder.image.ImageTranscoder;
import io.sf.carte.echosvg.transcoder.image.PNGTranscoder;
import io.sf.carte.echosvg.util.ParsedURL;
import io.sf.carte.util.agent.AgentUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class CSSTranscodingHelper {
    private static final Set<String> noStyle;
    private final Transcoder transcoder;
    private boolean darkMode = false;
    private static final CSSTypedValue darkmodeInitialColor;
    private boolean htmlEmbed = false;
    private XMLReader xmlReader = null;

    public CSSTranscodingHelper() {
        this(new PNGTranscoder());
    }

    public CSSTranscodingHelper(Transcoder transcoder) {
        this.transcoder = transcoder;
    }

    public void setDarkMode(boolean bl) {
        this.darkMode = bl;
    }

    public void setHTMLEmbedding(boolean bl) {
        this.htmlEmbed = bl;
    }

    public Transcoder getTranscoder() {
        return this.transcoder;
    }

    public void setXMLReader(XMLReader xMLReader) {
        this.xmlReader = xMLReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void transcode(TranscoderInput transcoderInput, TranscoderOutput transcoderOutput, String string) throws TranscoderException, IOException {
        Object object;
        XMLReader xMLReader = this.xmlReader;
        XMLReader xMLReader2 = transcoderInput.getXMLReader();
        if (xMLReader2 != null) {
            this.xmlReader = transcoderInput.getXMLReader();
        }
        try {
            object = transcoderInput.getDocument();
            if (object != null) {
                if (object.getDocumentURI() == null) {
                    object.setDocumentURI(transcoderInput.getURI());
                }
                this.transcodeDocument((Document)object, transcoderOutput, string);
                return;
            }
        }
        finally {
            if (xMLReader2 != null) {
                this.xmlReader = xMLReader;
            }
        }
        object = transcoderInput.getReader();
        try {
            if (object != null) {
                this.transcode((Reader)object, transcoderInput.getURI(), transcoderOutput, string);
                return;
            }
        }
        finally {
            if (xMLReader2 != null) {
                this.xmlReader = xMLReader;
            }
            if (object != null) {
                try {
                    ((Reader)object).close();
                }
                catch (IOException iOException) {}
            }
        }
        InputStream inputStream = transcoderInput.getInputStream();
        try {
            if (inputStream != null) {
                InputStreamReader inputStreamReader = transcoderInput.getEncoding() != null ? new InputStreamReader(inputStream, transcoderInput.getEncoding()) : new InputStreamReader(inputStream);
                this.transcode(inputStreamReader, transcoderInput.getURI(), transcoderOutput, string);
                return;
            }
        }
        finally {
            if (xMLReader2 != null) {
                this.xmlReader = xMLReader;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            if (transcoderInput.getURI() == null) {
                throw new IllegalArgumentException("No inputs found.");
            }
            this.transcode(null, transcoderInput.getURI(), transcoderOutput, string);
        }
        finally {
            if (xMLReader2 != null) {
                this.xmlReader = xMLReader;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transcode(TranscoderInput transcoderInput, TranscoderOutput transcoderOutput) throws TranscoderException, IOException {
        XMLReader xMLReader = this.xmlReader;
        XMLReader xMLReader2 = transcoderInput.getXMLReader();
        if (xMLReader2 != null) {
            this.xmlReader = transcoderInput.getXMLReader();
        }
        try {
            Document document = transcoderInput.getDocument();
            if (document != null) {
                if (document.getDocumentURI() == null) {
                    document.setDocumentURI(transcoderInput.getURI());
                }
                this.transcodeDocument(document, transcoderOutput, null);
                return;
            }
            Reader reader = transcoderInput.getReader();
            if (reader != null) {
                this.transcode(reader, transcoderInput.getURI(), transcoderOutput, null);
                return;
            }
            InputStream inputStream = transcoderInput.getInputStream();
            if (inputStream != null) {
                InputStreamReader inputStreamReader = transcoderInput.getEncoding() != null ? new InputStreamReader(inputStream, transcoderInput.getEncoding()) : new InputStreamReader(inputStream);
                this.transcode(inputStreamReader, transcoderInput.getURI(), transcoderOutput, null);
                return;
            }
            if (transcoderInput.getURI() == null) {
                throw new IllegalArgumentException("No inputs found.");
            }
            this.transcode(null, transcoderInput.getURI(), transcoderOutput, null);
        }
        finally {
            if (xMLReader2 != null) {
                this.xmlReader = xMLReader;
            }
        }
    }

    public void transcode(Reader reader, String string, OutputStream outputStream) throws TranscoderException, IOException {
        TranscoderOutput transcoderOutput = new TranscoderOutput(outputStream);
        this.transcode(reader, string, transcoderOutput, null);
    }

    public void transcode(Reader reader, String string, TranscoderOutput transcoderOutput, String string2) throws TranscoderException, IOException {
        DOMDocument dOMDocument;
        CSSDOMImplementation cSSDOMImplementation = this.createCSSDOMImplementation();
        XMLDocumentBuilder xMLDocumentBuilder = new XMLDocumentBuilder((DOMImplementation)cSSDOMImplementation);
        xMLDocumentBuilder.setEntityResolver((EntityResolver)new DefaultEntityResolver());
        xMLDocumentBuilder.getSAXParserFactory().setXIncludeAware(true);
        xMLDocumentBuilder.setXMLReader(this.xmlReader);
        if (this.htmlEmbed || string2 != null || string != null && string.endsWith(".html")) {
            xMLDocumentBuilder.setHTMLProcessing(true);
        }
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string);
        try {
            dOMDocument = (DOMDocument)xMLDocumentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new TranscoderException(sAXException);
        }
        this.transcodeDOMDocument(dOMDocument, transcoderOutput, string2);
    }

    private CSSDOMImplementation createCSSDOMImplementation() {
        CSSDOMImplementation cSSDOMImplementation = new CSSDOMImplementation();
        cSSDOMImplementation.setStyleFormattingFactory((StyleFormattingFactory)new RGBStyleFormattingFactory());
        return cSSDOMImplementation;
    }

    public void transcodeDocument(Document document, TranscoderOutput transcoderOutput, String string) throws TranscoderException, IOException {
        DOMDocument dOMDocument;
        if (document instanceof DOMDocument) {
            dOMDocument = (DOMDocument)document;
        } else {
            String string2;
            Element element = document.getDocumentElement();
            if (element == null) {
                throw new IllegalArgumentException("The document has no document element.");
            }
            DocumentType documentType = document.getDoctype();
            CSSDOMImplementation cSSDOMImplementation = this.createCSSDOMImplementation();
            DocumentType documentType2 = null;
            if (documentType != null && (string2 = documentType.getName()) != null) {
                documentType2 = cSSDOMImplementation.createDocumentType(string2, documentType.getPublicId(), documentType.getSystemId());
            }
            dOMDocument = this.isHTMLDocument(element, documentType) ? cSSDOMImplementation.createDocument(null, null, documentType2) : cSSDOMImplementation.createDocument("", null, documentType2);
            dOMDocument.setDocumentURI(document.getDocumentURI());
            Node node = dOMDocument.importNode((Node)element, true);
            dOMDocument.appendChild(node);
        }
        this.transcodeDOMDocument(dOMDocument, transcoderOutput, string);
    }

    private boolean isHTMLDocument(Element element, DocumentType documentType) {
        String string = element.getTagName();
        return "html".equalsIgnoreCase(string) || "html".equalsIgnoreCase(element.getLocalName()) || documentType != null && "html".equalsIgnoreCase(documentType.getName());
    }

    private void transcodeDOMDocument(DOMDocument dOMDocument, TranscoderOutput transcoderOutput, String string) throws TranscoderException, IOException {
        Object object;
        Object object2;
        String string2;
        DocumentType documentType = null;
        DOMElement dOMElement = null;
        if (string == null) {
            string = (String)this.transcoder.getTranscodingHints().get(SVGAbstractTranscoder.KEY_SVG_SELECTOR);
        }
        if (string != null && (string = string.trim()).length() != 0) {
            dOMElement = dOMDocument.querySelector(string);
        }
        if (dOMElement == null) {
            dOMElement = dOMDocument.getDocumentElement();
            documentType = dOMDocument.getDoctype();
        }
        if (!"svg".equals(dOMElement.getLocalName())) {
            documentType = null;
            if (string == null) {
                dOMElement = dOMDocument.getElementsByTagNameNS("*", "svg").item(0);
                if (dOMElement == null) {
                    String string3 = "Document contains no <svg> elements.";
                    throw new TranscoderException(string3);
                }
            } else {
                string = string.replaceAll("\\p{Cc}", "*CTRL*");
                String string4 = "Element selected by '" + string + "' is not a <svg>.";
                throw new TranscoderException(string4);
            }
        }
        boolean bl = (string2 = dOMElement.getAttribute("version")).length() == 0 ? documentType == null || !"-//W3C//DTD SVG 1.0//EN".equals(documentType.getPublicId()) : string2.indexOf(50) != -1;
        DOMImplementation dOMImplementation = !bl ? SVGDOMImplementation.getDOMImplementation() : SVG12DOMImplementation.getDOMImplementation();
        DocumentType documentType2 = null;
        if (documentType != null) {
            documentType2 = dOMImplementation.createDocumentType(documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
        }
        Document document = dOMImplementation.createDocument("http://www.w3.org/2000/svg", null, documentType2);
        document.setDocumentURI(dOMDocument.getDocumentURI());
        String string5 = (String)this.transcoder.getTranscodingHints().get(SVGAbstractTranscoder.KEY_ALTERNATE_STYLESHEET);
        String string6 = (String)this.transcoder.getTranscodingHints().get(SVGAbstractTranscoder.KEY_USER_STYLESHEET_URI);
        String string7 = (String)this.transcoder.getTranscodingHints().get(SVGAbstractTranscoder.KEY_MEDIA);
        if (string7 == null || (string7 = string7.trim()).length() == 0) {
            string7 = "medium";
        }
        try {
            dOMDocument.setTargetMedium(string7);
        }
        catch (CSSMediaException cSSMediaException) {
            // empty catch block
        }
        MyDeviceFactory myDeviceFactory = new MyDeviceFactory();
        myDeviceFactory.setHints(dOMElement);
        dOMDocument.getImplementation().setDeviceFactory((DeviceFactory)myDeviceFactory);
        if (string6 != null) {
            object2 = new ParsedURL(string6);
            object = object2.openStream();
            try {
                String string8 = object2.getContentType();
                String string9 = object2.getContentEncoding();
                Reader reader = AgentUtil.inputStreamToReader((InputStream)object, (String)string8, (String)string9, (Charset)StandardCharsets.UTF_8);
                dOMDocument.getImplementation().setUserStyleSheet(object2.getPostConnectionURL(), reader);
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        if (string5 != null && (string5 = string5.trim()).length() != 0) {
            dOMDocument.setSelectedStyleSheetSet(string5);
        }
        CSSTranscodingHelper.copyWithComputedStyles((DOMNode)dOMElement, document, document);
        object2 = (MyDeviceFactory.MyCanvas)dOMDocument.getCanvas();
        ((MyDeviceFactory.MyCanvas)((Object)object2)).dispose();
        if (this.transcoder.getErrorHandler() == null) {
            object = new DefaultErrorHandler();
            this.transcoder.setErrorHandler((ErrorHandler)object);
        }
        object = new TranscoderInput(document);
        this.transcoder.transcode((TranscoderInput)object, transcoderOutput);
        if (transcoderOutput.getDocument() == null) {
            transcoderOutput.setDocument(document);
        }
    }

    private static void copyWithComputedStyles(DOMNode dOMNode, Document document, Node node) {
        Node node2;
        if (dOMNode.getNodeType() == 1) {
            if ("foreignObject".equals(dOMNode.getLocalName())) {
                DOMElement dOMElement = (DOMElement)dOMNode;
                Element element = document.createElementNS("http://www.w3.org/2000/svg", "flowRoot");
                node.appendChild(element);
                element.setAttributeNS("http://www.w3.org/XML/1998/namespace", "space", "preserve");
                CSSTranscodingHelper.replaceForeignSubtree(dOMElement, document, element);
                return;
            }
            node2 = CSSTranscodingHelper.importElement((DOMElement)dOMNode, document);
        } else {
            node2 = document.importNode((Node)dOMNode, false);
        }
        node.appendChild(node2);
        if (dOMNode.hasChildNodes()) {
            for (DOMNode dOMNode2 : dOMNode.getChildNodes()) {
                CSSTranscodingHelper.copyWithComputedStyles(dOMNode2, document, node2);
            }
        }
    }

    private static Element importElement(DOMElement dOMElement, Document document) {
        Element element;
        String string = dOMElement.getLocalName();
        if (noStyle.contains(string)) {
            element = (Element)document.importNode((Node)dOMElement, false);
        } else {
            element = (Element)document.importNode((Node)dOMElement, false);
            CSSTranscodingHelper.fillStyleAttribute(dOMElement, element);
        }
        return element;
    }

    private static void fillStyleAttribute(DOMElement dOMElement, Element element) {
        ComputedCSSStyle computedCSSStyle = dOMElement.getComputedStyle(null);
        if (computedCSSStyle.getLength() != 0) {
            element.setAttribute("style", computedCSSStyle.getMinifiedCssText());
        }
    }

    private static void replaceForeignSubtree(DOMElement dOMElement, Document document, Element element) {
        if (dOMElement.getChildElementCount() > 1) {
            return;
        }
        document.getDocumentElement().setAttribute("version", "1.2");
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "flowDiv");
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "flowRegion");
        element.appendChild(element3);
        element.appendChild(element2);
        DOMElement dOMElement2 = dOMElement.getFirstElementChild();
        if ("http://www.w3.org/2000/svg".equals(dOMElement2.getNamespaceURI())) {
            Element element4 = CSSTranscodingHelper.importElement(dOMElement2, document);
            element.appendChild(element4);
        } else {
            boolean bl;
            ComputedCSSStyle computedCSSStyle = dOMElement2.getComputedStyle(null);
            String string = computedCSSStyle.getDisplay();
            boolean bl2 = bl = "block".equals(string) || "inline-block".equals(string);
            if (bl) {
                BoxValues boxValues = computedCSSStyle.getBoxValues((short)3);
                if ((double)boxValues.getWidth() > 1.0E-4) {
                    boxValues.fillBoxValues((CSSStyleDeclaration)computedCSSStyle);
                }
                Element element5 = document.createElementNS("http://www.w3.org/2000/svg", "rect");
                CSSTranscodingHelper.copyAttributes(dOMElement, element5);
                element5.setAttribute("visibility", "hidden");
                element3.appendChild(element5);
                element5.setAttribute("style", computedCSSStyle.getMinifiedCssText());
                CSSTranscodingHelper.replaceElement(dOMElement2, document, element2, element2);
            }
        }
    }

    private static void copyAttributes(DOMElement dOMElement, Element element) {
        for (Attr attr : dOMElement.getAttributes()) {
            element.setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getValue());
        }
    }

    private static void replaceElement(DOMElement dOMElement, Document document, Element element, Element element2) {
        ComputedCSSStyle computedCSSStyle = dOMElement.getComputedStyle(null);
        String string = computedCSSStyle.getDisplay();
        boolean bl = "block".equals(string) || "inline-block".equals(string);
        String string2 = bl ? "flowPara" : "flowSpan";
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", string2);
        if (computedCSSStyle.getLength() != 0) {
            element3.setAttribute("style", computedCSSStyle.getMinifiedCssText());
        }
        element2.appendChild(element3);
        if (dOMElement.getFirstElementChild() == null) {
            String string3 = dOMElement.getTextContent();
            String string4 = dOMElement.getAttributeNS("http://www.w3.org/XML/1998/namespace", "space");
            if (!"preserve".equalsIgnoreCase(string4)) {
                string3 = string3.trim();
            }
            if (string3.length() == 0) {
                return;
            }
            Text text = document.createTextNode(string3);
            element3.appendChild(text);
        } else {
            for (DOMNode dOMNode : dOMElement) {
                if (dOMNode.getNodeType() == 1) {
                    CSSTranscodingHelper.replaceElement((DOMElement)dOMNode, document, element, element3);
                    continue;
                }
                Text text = document.createTextNode(dOMNode.getNodeValue());
                element3.appendChild(text);
            }
        }
    }

    static {
        String[] stringArray = new String[]{"style", "script", "base", "link", "head", "title", "meta"};
        noStyle = new HashSet<String>(stringArray.length);
        Collections.addAll(noStyle, stringArray);
        darkmodeInitialColor = (CSSTypedValue)new ValueFactory().parseProperty("#fff");
    }

    private class MyDeviceFactory
    implements DeviceFactory {
        private MyStyleDatabase sdb = new MyStyleDatabase();
        private float height = 0.0f;
        private float width = 0.0f;

        private MyDeviceFactory() {
        }

        public StyleDatabase getStyleDatabase(String string) {
            return this.sdb;
        }

        void setHints(DOMElement dOMElement) {
            Object object;
            TranscodingHints transcodingHints = CSSTranscodingHelper.this.getTranscoder().getTranscodingHints();
            Float f = (Float)transcodingHints.get(SVGAbstractTranscoder.KEY_WIDTH);
            if (f != null) {
                this.width = f.floatValue();
            } else {
                object = dOMElement.getAttribute("width");
                if (((String)object).length() != 0) {
                    try {
                        this.width = Float.parseFloat((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.width == 0.0f) {
                    this.width = 595.0f;
                }
            }
            object = (Float)transcodingHints.get(SVGAbstractTranscoder.KEY_HEIGHT);
            if (object != null) {
                this.height = ((Float)object).floatValue();
            } else {
                String string = dOMElement.getAttribute("height");
                if (string.length() != 0) {
                    try {
                        this.height = Float.parseFloat(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.height == 0.0f) {
                    this.height = 842.0f;
                }
            }
        }

        public CSSCanvas createCanvas(String string, CSSDocument cSSDocument) {
            MyCanvas myCanvas;
            if (CSSTranscodingHelper.this.transcoder instanceof ImageTranscoder) {
                BufferedImage bufferedImage = ((ImageTranscoder)CSSTranscodingHelper.this.transcoder).createImage(Math.round(this.width), Math.round(this.height));
                Graphics2D graphics2D = bufferedImage.createGraphics();
                myCanvas = new Graphics2DCanvas(cSSDocument, graphics2D);
            } else {
                myCanvas = new MyCanvas(cSSDocument);
            }
            return myCanvas;
        }

        private class Graphics2DCanvas
        extends MyCanvas {
            final Graphics2D graphics2d;

            protected Graphics2DCanvas(CSSDocument cSSDocument, Graphics2D graphics2D) {
                super(cSSDocument);
                this.graphics2d = graphics2D;
            }

            public int stringWidth(String string, CSSComputedProperties cSSComputedProperties) {
                Font font = AWTHelper.createFont((CSSComputedProperties)cSSComputedProperties);
                FontMetrics fontMetrics = this.graphics2d.getFontMetrics(font);
                return fontMetrics.stringWidth(string);
            }

            @Override
            void dispose() {
                this.graphics2d.dispose();
            }
        }

        private class MyCanvas
        extends AbstractCSSCanvas {
            protected MyCanvas(CSSDocument cSSDocument) {
                super(cSSDocument);
            }

            public StyleDatabase getStyleDatabase() {
                return MyDeviceFactory.this.sdb;
            }

            protected String getOverflowBlock() {
                return "none";
            }

            protected String getOverflowInline() {
                return "none";
            }

            protected String getPointerAccuracy() {
                return "none";
            }

            protected String getPrefersColorScheme() {
                return CSSTranscodingHelper.this.darkMode ? "dark" : "light";
            }

            protected float getResolution() {
                return Float.POSITIVE_INFINITY;
            }

            void dispose() {
            }
        }

        private class MyStyleDatabase
        extends AbstractStyleDatabase {
            private static final long serialVersionUID = 1L;
            private final List<String> fonts = this.getAvailableFontList();

            private MyStyleDatabase() {
            }

            private List<String> getAvailableFontList() {
                return Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
            }

            public String getDefaultGenericFontFamily(String string) {
                return string;
            }

            public boolean isFontFaceName(String string) {
                return false;
            }

            public int getColorDepth() {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
                int n = 255;
                if (graphicsConfiguration != null) {
                    int[] nArray = graphicsConfiguration.getColorModel().getComponentSize();
                    for (int i = 0; i < 3; ++i) {
                        if (n <= nArray[i]) continue;
                        n = nArray[i];
                    }
                }
                return n;
            }

            public float getDeviceHeight() {
                return MyDeviceFactory.this.height;
            }

            public float getDeviceWidth() {
                return MyDeviceFactory.this.width;
            }

            protected boolean isFontFamilyAvailable(String string) {
                return this.fonts.contains(string);
            }

            public CSSTypedValue getInitialColor() {
                return CSSTranscodingHelper.this.darkMode ? darkmodeInitialColor : super.getInitialColor();
            }

            public boolean supports(String string, CSSValue cSSValue) {
                if ("color".equalsIgnoreCase(string) || "background-color".equalsIgnoreCase(string)) {
                    return this.supportsColor(cSSValue);
                }
                return cSSValue.getCssValueType() == CSSValue.CssType.TYPED && this.isSupportedType((CSSTypedValue)cSSValue);
            }

            private boolean supportsColor(CSSValue cSSValue) {
                switch (cSSValue.getPrimitiveType()) {
                    case COLOR: 
                    case COLOR_MIX: {
                        return true;
                    }
                    case IDENT: {
                        return ColorIdentifiers.getInstance().isColorIdentifier(cSSValue.getCssText().toLowerCase(Locale.ROOT));
                    }
                }
                return false;
            }

            private boolean isSupportedType(CSSTypedValue cSSTypedValue) {
                short s = cSSTypedValue.getUnitType();
                return s >= 3 && s <= 21 || CSSUnit.isAngleUnitType((short)s) || CSSUnit.isTimeUnitType((short)s);
            }

            public boolean supports(SelectorList selectorList) {
                for (Selector selector : selectorList) {
                    if (this.supports(selector)) continue;
                    return false;
                }
                return true;
            }

            private boolean supports(Selector selector) {
                if (selector != null) {
                    switch (selector.getSelectorType()) {
                        case CHILD: 
                        case DESCENDANT: 
                        case DIRECT_ADJACENT: 
                        case SUBSEQUENT_SIBLING: {
                            CombinatorSelector combinatorSelector = (CombinatorSelector)selector;
                            return this.supports(combinatorSelector.getSelector()) && this.supports((Selector)combinatorSelector.getSecondSelector());
                        }
                        case CONDITIONAL: {
                            ConditionalSelector conditionalSelector = (ConditionalSelector)selector;
                            return this.supports((Selector)conditionalSelector.getSimpleSelector()) && this.supports(conditionalSelector.getCondition());
                        }
                        case COLUMN_COMBINATOR: {
                            return false;
                        }
                    }
                }
                return true;
            }

            private boolean supports(Condition condition) {
                switch (condition.getConditionType()) {
                    case AND: {
                        CombinatorCondition combinatorCondition = (CombinatorCondition)condition;
                        return this.supports(combinatorCondition.getFirstCondition()) && this.supports(combinatorCondition.getSecondCondition());
                    }
                    case SELECTOR_ARGUMENT: {
                        ArgumentCondition argumentCondition = (ArgumentCondition)condition;
                        SelectorList selectorList = argumentCondition.getSelectors();
                        return selectorList == null || this.supports(selectorList);
                    }
                }
                return true;
            }
        }
    }
}

