/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder.wmf.tosvg;

import io.sf.carte.echosvg.ext.awt.geom.Polygon2D;
import io.sf.carte.echosvg.ext.awt.geom.Polyline2D;
import io.sf.carte.echosvg.transcoder.wmf.tosvg.AbstractWMFReader;
import io.sf.carte.echosvg.transcoder.wmf.tosvg.GdiObject;
import io.sf.carte.echosvg.transcoder.wmf.tosvg.WMFFont;
import io.sf.carte.echosvg.transcoder.wmf.tosvg.WMFUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class WMFHeaderProperties
extends AbstractWMFReader {
    private static final Integer INTEGER_0 = 0;
    protected DataInputStream stream;
    private int _bleft;
    private int _bright;
    private int _btop;
    private int _bbottom;
    private int _bwidth;
    private int _bheight;
    private int _ileft;
    private int _iright;
    private int _itop;
    private int _ibottom;
    private float scale = 1.0f;
    private int startX = 0;
    private int startY = 0;
    private int currentHorizAlign = 0;
    private int currentVertAlign = 0;
    private WMFFont wf = null;
    private static final FontRenderContext fontCtx = new FontRenderContext(new AffineTransform(), false, true);
    private transient boolean firstEffectivePaint = true;
    public static final int PEN = 1;
    public static final int BRUSH = 2;
    public static final int FONT = 3;
    public static final int NULL_PEN = 4;
    public static final int NULL_BRUSH = 5;
    public static final int PALETTE = 6;
    public static final int OBJ_BITMAP = 7;
    public static final int OBJ_REGION = 8;

    public WMFHeaderProperties(File file) throws IOException {
        this.reset();
        this.stream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        this.read(this.stream);
        this.stream.close();
    }

    public WMFHeaderProperties() {
    }

    public void closeResource() {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setFile(File file) throws IOException {
        this.stream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        this.read(this.stream);
        this.stream.close();
    }

    @Override
    public void reset() {
        this.left = 0;
        this.right = 0;
        this.top = 1000;
        this.bottom = 1000;
        this.inch = 84;
        this._bleft = -1;
        this._bright = -1;
        this._btop = -1;
        this._bbottom = -1;
        this._ileft = -1;
        this._iright = -1;
        this._itop = -1;
        this._ibottom = -1;
        this._bwidth = -1;
        this._bheight = -1;
        this.vpW = -1;
        this.vpH = -1;
        this.vpX = 0;
        this.vpY = 0;
        this.startX = 0;
        this.startY = 0;
        this.scaleXY = 1.0f;
        this.firstEffectivePaint = true;
    }

    public DataInputStream getStream() {
        return this.stream;
    }

    @Override
    protected boolean readRecords(DataInputStream dataInputStream) throws IOException {
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        block34: while (n > 0) {
            n2 = this.readInt(dataInputStream);
            n2 -= 3;
            n = this.readShort(dataInputStream);
            if (n <= 0) break;
            switch (n) {
                case 259: {
                    int n6 = this.readShort(dataInputStream);
                    if (n6 != 8) continue block34;
                    this.isotropic = false;
                    continue block34;
                }
                case 523: {
                    this.vpY = this.readShort(dataInputStream);
                    this.vpX = this.readShort(dataInputStream);
                    continue block34;
                }
                case 524: {
                    this.vpH = this.readShort(dataInputStream);
                    this.vpW = this.readShort(dataInputStream);
                    if (!this.isotropic) {
                        this.scaleXY = (float)this.vpW / (float)this.vpH;
                    }
                    this.vpW = (int)((float)this.vpW * this.scaleXY);
                    continue block34;
                }
                case 762: {
                    int n6 = 0;
                    short s = this.readShort(dataInputStream);
                    this.readInt(dataInputStream);
                    int n7 = this.readInt(dataInputStream);
                    int n8 = n7 & 0xFF;
                    int n9 = (n7 & 0xFF00) >> 8;
                    int n10 = (n7 & 0xFF0000) >> 16;
                    Color color = new Color(n8, n9, n10);
                    if (n2 == 6) {
                        this.readShort(dataInputStream);
                    }
                    if (s == 5) {
                        n6 = this.addObjectAt(4, color, n6);
                        continue block34;
                    }
                    n6 = this.addObjectAt(1, color, n6);
                    continue block34;
                }
                case 764: {
                    int n6 = 0;
                    short s = this.readShort(dataInputStream);
                    int n11 = this.readInt(dataInputStream);
                    int n12 = n11 & 0xFF;
                    int n13 = (n11 & 0xFF00) >> 8;
                    int n14 = (n11 & 0xFF0000) >> 16;
                    Color color = new Color(n12, n13, n14);
                    this.readShort(dataInputStream);
                    if (s == 5) {
                        n6 = this.addObjectAt(5, color, n6);
                        continue block34;
                    }
                    n6 = this.addObjectAt(2, color, n6);
                    continue block34;
                }
                case 302: {
                    int n6 = this.readShort(dataInputStream);
                    if (n2 > 1) {
                        for (int i = 1; i < n2; ++i) {
                            this.readShort(dataInputStream);
                        }
                    }
                    this.currentHorizAlign = WMFUtilities.getHorizontalAlignment(n6);
                    this.currentVertAlign = WMFUtilities.getVerticalAlignment(n6);
                    continue block34;
                }
                case 2610: {
                    int n15;
                    short s = this.readShort(dataInputStream);
                    int n16 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    int n17 = this.readShort(dataInputStream);
                    short s2 = this.readShort(dataInputStream);
                    int n18 = 4;
                    boolean bl = false;
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = 0;
                    int n22 = 0;
                    if ((s2 & 4) != 0) {
                        n19 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                        n20 = this.readShort(dataInputStream);
                        n21 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                        n22 = this.readShort(dataInputStream);
                        n18 += 4;
                        bl = true;
                    }
                    byte[] byArray = new byte[n17];
                    for (n15 = 0; n15 < n17; ++n15) {
                        byArray[n15] = dataInputStream.readByte();
                    }
                    String string = WMFUtilities.decodeString(this.wf, byArray);
                    n18 += (n17 + 1) / 2;
                    if (n17 % 2 != 0) {
                        dataInputStream.readByte();
                    }
                    if (n18 < n2) {
                        for (int i = n18; i < n2; ++i) {
                            this.readShort(dataInputStream);
                        }
                    }
                    TextLayout textLayout = new TextLayout(string, this.wf.font, fontCtx);
                    int n23 = (int)textLayout.getBounds().getWidth();
                    n16 = (int)textLayout.getBounds().getX();
                    int n24 = (int)this.getVerticalAlignmentValue(textLayout, this.currentVertAlign);
                    this.resizeBounds(n16, s);
                    this.resizeBounds(n16 + n23, s + n24);
                    this.firstEffectivePaint = false;
                    continue block34;
                }
                case 1313: 
                case 1583: {
                    int n25 = this.readShort(dataInputStream);
                    int n26 = 1;
                    byte[] byArray = new byte[n25];
                    for (int i = 0; i < n25; ++i) {
                        byArray[i] = dataInputStream.readByte();
                    }
                    String string = WMFUtilities.decodeString(this.wf, byArray);
                    if (n25 % 2 != 0) {
                        dataInputStream.readByte();
                    }
                    n26 += (n25 + 1) / 2;
                    short s = this.readShort(dataInputStream);
                    int n27 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    if ((n26 += 2) < n2) {
                        for (int i = n26; i < n2; ++i) {
                            this.readShort(dataInputStream);
                        }
                    }
                    TextLayout textLayout = new TextLayout(string, this.wf.font, fontCtx);
                    int n20 = (int)textLayout.getBounds().getWidth();
                    n27 = (int)textLayout.getBounds().getX();
                    int n21 = (int)this.getVerticalAlignmentValue(textLayout, this.currentVertAlign);
                    this.resizeBounds(n27, s);
                    this.resizeBounds(n27 + n20, s + n21);
                    continue block34;
                }
                case 763: {
                    int n28;
                    short s = this.readShort(dataInputStream);
                    float f = (int)(this.scaleY * (float)s);
                    short s3 = this.readShort(dataInputStream);
                    short s4 = this.readShort(dataInputStream);
                    short s5 = this.readShort(dataInputStream);
                    short s6 = this.readShort(dataInputStream);
                    byte by = dataInputStream.readByte();
                    int n20 = dataInputStream.readByte();
                    int n21 = dataInputStream.readByte();
                    int n22 = dataInputStream.readByte() & 0xFF;
                    byte by2 = dataInputStream.readByte();
                    byte by3 = dataInputStream.readByte();
                    int n15 = dataInputStream.readByte();
                    byte by4 = dataInputStream.readByte();
                    int n29 = by > 0 ? 2 : 0;
                    n29 |= s6 > 400 ? 1 : 0;
                    int n23 = 2 * (n2 - 9);
                    byte[] byArray = new byte[n23];
                    for (int i = 0; i < n23; ++i) {
                        byArray[i] = dataInputStream.readByte();
                    }
                    String string = new String(byArray);
                    for (n28 = 0; n28 < string.length() && (Character.isLetterOrDigit(string.charAt(n28)) || Character.isWhitespace(string.charAt(n28))); ++n28) {
                    }
                    string = n28 > 0 ? string.substring(0, n28) : "System";
                    if (f < 0.0f) {
                        f = -f;
                    }
                    int n30 = 0;
                    Font font = new Font(string, n29, (int)f);
                    font = font.deriveFont(f);
                    WMFFont wMFFont = new WMFFont(font, n22, n20, n21, by, s6, s5, s4);
                    n30 = this.addObjectAt(3, wMFFont, n30);
                    continue block34;
                }
                case 1791: {
                    int n31 = 0;
                    for (int i = 0; i < n2; ++i) {
                        this.readShort(dataInputStream);
                    }
                    n31 = this.addObjectAt(6, INTEGER_0, 0);
                    continue block34;
                }
                case 247: {
                    int n32 = 0;
                    for (int i = 0; i < n2; ++i) {
                        this.readShort(dataInputStream);
                    }
                    n32 = this.addObjectAt(8, INTEGER_0, 0);
                    continue block34;
                }
                case 301: {
                    int n33 = this.readShort(dataInputStream);
                    if ((n33 & Integer.MIN_VALUE) != 0) continue block34;
                    GdiObject gdiObject = this.getObject(n33);
                    if (!gdiObject.used) continue block34;
                    switch (gdiObject.type) {
                        case 1: {
                            n4 = n33;
                            break;
                        }
                        case 2: {
                            n3 = n33;
                            break;
                        }
                        case 3: {
                            this.wf = (WMFFont)gdiObject.obj;
                            n5 = n33;
                            break;
                        }
                        case 4: {
                            n4 = -1;
                            break;
                        }
                        case 5: {
                            n3 = -1;
                        }
                    }
                    continue block34;
                }
                case 496: {
                    int n33 = this.readShort(dataInputStream);
                    GdiObject gdiObject = this.getObject(n33);
                    if (n33 == n3) {
                        n3 = -1;
                    } else if (n33 == n4) {
                        n4 = -1;
                    } else if (n33 == n5) {
                        n5 = -1;
                    }
                    gdiObject.clear();
                    continue block34;
                }
                case 531: {
                    short s = this.readShort(dataInputStream);
                    int n34 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    if (n4 >= 0) {
                        this.resizeBounds(this.startX, this.startY);
                        this.resizeBounds(n34, s);
                        this.firstEffectivePaint = false;
                    }
                    this.startX = n34;
                    this.startY = s;
                    continue block34;
                }
                case 532: {
                    this.startY = this.readShort(dataInputStream);
                    this.startX = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    continue block34;
                }
                case 1336: {
                    int n35;
                    int n20;
                    int n36 = this.readShort(dataInputStream);
                    int[] nArray = new int[n36];
                    int n37 = 0;
                    for (n35 = 0; n35 < n36; ++n35) {
                        nArray[n35] = this.readShort(dataInputStream);
                        n37 += nArray[n35];
                    }
                    n35 = n36 + 1;
                    for (int i = 0; i < n36; ++i) {
                        for (int j = 0; j < nArray[i]; ++j) {
                            int n38 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                            n20 = this.readShort(dataInputStream);
                            if (n3 < 0 && n4 < 0) continue;
                            this.resizeBounds(n38, n20);
                        }
                    }
                    this.firstEffectivePaint = false;
                    continue block34;
                }
                case 804: {
                    int n39 = this.readShort(dataInputStream);
                    float[] fArray = new float[n39 + 1];
                    float[] fArray2 = new float[n39 + 1];
                    for (int i = 0; i < n39; ++i) {
                        fArray[i] = (float)this.readShort(dataInputStream) * this.scaleXY;
                        fArray2[i] = this.readShort(dataInputStream);
                    }
                    fArray[n39] = fArray[0];
                    fArray2[n39] = fArray2[0];
                    Polygon2D polygon2D = new Polygon2D(fArray, fArray2, n39);
                    this.paint(n3, n4, (Shape)polygon2D);
                    continue block34;
                }
                case 805: {
                    int n40 = this.readShort(dataInputStream);
                    float[] fArray = new float[n40];
                    float[] fArray3 = new float[n40];
                    for (int i = 0; i < n40; ++i) {
                        fArray[i] = (float)this.readShort(dataInputStream) * this.scaleXY;
                        fArray3[i] = this.readShort(dataInputStream);
                    }
                    Polyline2D polyline2D = new Polyline2D(fArray, fArray3, n40);
                    this.paintWithPen(n4, (Shape)polyline2D);
                    continue block34;
                }
                case 1046: 
                case 1048: 
                case 1051: {
                    short s = this.readShort(dataInputStream);
                    int n41 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    short s7 = this.readShort(dataInputStream);
                    int n42 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    Rectangle2D.Float float_ = new Rectangle2D.Float(n42, s7, n41 - n42, s - s7);
                    this.paint(n3, n4, float_);
                    continue block34;
                }
                case 1564: {
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    short s = this.readShort(dataInputStream);
                    int n43 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    short s8 = this.readShort(dataInputStream);
                    int n44 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    Rectangle2D.Float float_ = new Rectangle2D.Float(n44, s8, n43 - n44, s - s8);
                    this.paint(n3, n4, float_);
                    continue block34;
                }
                case 2071: 
                case 2074: 
                case 2096: {
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    short s = this.readShort(dataInputStream);
                    int n45 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    short s9 = this.readShort(dataInputStream);
                    int n46 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    Rectangle2D.Float float_ = new Rectangle2D.Float(n46, s9, n45 - n46, s - s9);
                    this.paint(n3, n4, float_);
                    continue block34;
                }
                case 1565: {
                    this.readInt(dataInputStream);
                    short s = this.readShort(dataInputStream);
                    int n47 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    int n48 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    short s10 = this.readShort(dataInputStream);
                    if (n4 >= 0) {
                        this.resizeBounds(n48, s10);
                    }
                    if (n4 < 0) continue block34;
                    this.resizeBounds(n48 + n47, s10 + s);
                    continue block34;
                }
                case 2881: {
                    dataInputStream.readInt();
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    float f = this.readShort(dataInputStream);
                    float f2 = (float)this.readShort(dataInputStream) * this.scaleXY;
                    float f3 = (float)this.readShort(dataInputStream) * this.getVpWFactor() * (float)this.inch / 96.0f;
                    float f4 = (float)this.readShort(dataInputStream) * this.getVpWFactor() * (float)this.inch / 96.0f * this.scaleXY;
                    f2 = f2 * this.getVpWFactor() * (float)this.inch / 96.0f;
                    f = f * this.getVpHFactor() * (float)this.inch / 96.0f;
                    this.resizeImageBounds((int)f4, (int)f3);
                    this.resizeImageBounds((int)(f4 + f2), (int)(f3 + f));
                    int n49 = 2 * n2 - 20;
                    for (int i = 0; i < n49; ++i) {
                        dataInputStream.readByte();
                    }
                    continue block34;
                }
                case 3907: {
                    dataInputStream.readInt();
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    float f = this.readShort(dataInputStream);
                    float f5 = (float)this.readShort(dataInputStream) * this.scaleXY;
                    float f6 = (float)this.readShort(dataInputStream) * this.getVpHFactor() * (float)this.inch / 96.0f;
                    float f7 = (float)this.readShort(dataInputStream) * this.getVpHFactor() * (float)this.inch / 96.0f * this.scaleXY;
                    f5 = f5 * this.getVpWFactor() * (float)this.inch / 96.0f;
                    f = f * this.getVpHFactor() * (float)this.inch / 96.0f;
                    this.resizeImageBounds((int)f7, (int)f6);
                    this.resizeImageBounds((int)(f7 + f5), (int)(f6 + f));
                    int n50 = 2 * n2 - 22;
                    byte[] byArray = new byte[n50];
                    for (int i = 0; i < n50; ++i) {
                        byArray[i] = dataInputStream.readByte();
                    }
                    continue block34;
                }
                case 2368: {
                    dataInputStream.readInt();
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    float f = (float)this.readShort(dataInputStream) * (float)this.inch / 96.0f * this.getVpHFactor();
                    float f8 = (float)this.readShort(dataInputStream) * (float)this.inch / 96.0f * this.getVpWFactor() * this.scaleXY;
                    float f9 = (float)this.inch / 96.0f * this.getVpHFactor() * (float)this.readShort(dataInputStream);
                    float f10 = (float)this.inch / 96.0f * this.getVpWFactor() * (float)this.readShort(dataInputStream) * this.scaleXY;
                    this.resizeImageBounds((int)f10, (int)f9);
                    this.resizeImageBounds((int)(f10 + f8), (int)(f9 + f));
                    continue block34;
                }
            }
            for (int i = 0; i < n2; ++i) {
                this.readShort(dataInputStream);
            }
        }
        if (!this.isAldus) {
            this.width = this.vpW;
            this.height = this.vpH;
            this.right = this.vpX;
            this.left = this.vpX + this.vpW;
            this.top = this.vpY;
            this.bottom = this.vpY + this.vpH;
        }
        this.resetBounds();
        return true;
    }

    public int getWidthBoundsPixels() {
        return this._bwidth;
    }

    public int getHeightBoundsPixels() {
        return this._bheight;
    }

    public int getWidthBoundsUnits() {
        return (int)((float)this.inch * (float)this._bwidth / 96.0f);
    }

    public int getHeightBoundsUnits() {
        return (int)((float)this.inch * (float)this._bheight / 96.0f);
    }

    public int getXOffset() {
        return this._bleft;
    }

    public int getYOffset() {
        return this._btop;
    }

    private void resetBounds() {
        this.scale = (float)this.getWidthPixels() / (float)this.vpW;
        if (this._bright != -1) {
            this._bright = (int)(this.scale * (float)(this.vpX + this._bright));
            this._bleft = (int)(this.scale * (float)(this.vpX + this._bleft));
            this._bbottom = (int)(this.scale * (float)(this.vpY + this._bbottom));
            this._btop = (int)(this.scale * (float)(this.vpY + this._btop));
        }
        if (this._iright != -1) {
            this._iright = (int)((float)this._iright * (float)this.getWidthPixels() / (float)this.width);
            this._ileft = (int)((float)this._ileft * (float)this.getWidthPixels() / (float)this.width);
            this._ibottom = (int)((float)this._ibottom * (float)this.getWidthPixels() / (float)this.width);
            this._itop = (int)((float)this._itop * (float)this.getWidthPixels() / (float)this.width);
            if (this._bright == -1 || this._iright > this._bright) {
                this._bright = this._iright;
            }
            if (this._bleft == -1 || this._ileft < this._bleft) {
                this._bleft = this._ileft;
            }
            if (this._btop == -1 || this._itop < this._btop) {
                this._btop = this._itop;
            }
            if (this._bbottom == -1 || this._ibottom > this._bbottom) {
                this._bbottom = this._ibottom;
            }
        }
        if (this._bleft != -1 && this._bright != -1) {
            this._bwidth = this._bright - this._bleft;
        }
        if (this._btop != -1 && this._bbottom != -1) {
            this._bheight = this._bbottom - this._btop;
        }
    }

    private void resizeBounds(int n, int n2) {
        if (this._bleft == -1) {
            this._bleft = n;
        } else if (n < this._bleft) {
            this._bleft = n;
        }
        if (this._bright == -1) {
            this._bright = n;
        } else if (n > this._bright) {
            this._bright = n;
        }
        if (this._btop == -1) {
            this._btop = n2;
        } else if (n2 < this._btop) {
            this._btop = n2;
        }
        if (this._bbottom == -1) {
            this._bbottom = n2;
        } else if (n2 > this._bbottom) {
            this._bbottom = n2;
        }
    }

    private void resizeImageBounds(int n, int n2) {
        if (this._ileft == -1) {
            this._ileft = n;
        } else if (n < this._ileft) {
            this._ileft = n;
        }
        if (this._iright == -1) {
            this._iright = n;
        } else if (n > this._iright) {
            this._iright = n;
        }
        if (this._itop == -1) {
            this._itop = n2;
        } else if (n2 < this._itop) {
            this._itop = n2;
        }
        if (this._ibottom == -1) {
            this._ibottom = n2;
        } else if (n2 > this._ibottom) {
            this._ibottom = n2;
        }
    }

    private Color getColorFromObject(int n) {
        Object var2_2 = null;
        if (n >= 0) {
            GdiObject gdiObject = this.getObject(n);
            return (Color)gdiObject.obj;
        }
        return null;
    }

    private void paint(int n, int n2, Shape shape) {
        if (n >= 0 || n2 >= 0) {
            Color color = n >= 0 ? this.getColorFromObject(n) : this.getColorFromObject(n2);
            if (!this.firstEffectivePaint || !color.equals(Color.white)) {
                Rectangle rectangle = shape.getBounds();
                this.resizeBounds((int)rectangle.getMinX(), (int)rectangle.getMinY());
                this.resizeBounds((int)rectangle.getMaxX(), (int)rectangle.getMaxY());
                this.firstEffectivePaint = false;
            }
        }
    }

    private void paintWithPen(int n, Shape shape) {
        if (n >= 0) {
            Color color = this.getColorFromObject(n);
            if (!this.firstEffectivePaint || !color.equals(Color.white)) {
                Rectangle rectangle = shape.getBounds();
                this.resizeBounds((int)rectangle.getMinX(), (int)rectangle.getMinY());
                this.resizeBounds((int)rectangle.getMaxX(), (int)rectangle.getMaxY());
                this.firstEffectivePaint = false;
            }
        }
    }

    private float getVerticalAlignmentValue(TextLayout textLayout, int n) {
        if (n == 24) {
            return -textLayout.getAscent();
        }
        if (n == 0) {
            return textLayout.getAscent() + textLayout.getDescent();
        }
        return 0.0f;
    }
}

