/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder.wmf.tosvg;

import io.sf.carte.echosvg.transcoder.wmf.tosvg.WMFFont;
import java.io.UnsupportedEncodingException;

public class WMFUtilities {
    public static String decodeString(WMFFont wMFFont, byte[] byArray) {
        try {
            switch (wMFFont.charset) {
                case 0: {
                    return new String(byArray, "ISO-8859-1");
                }
                case 1: {
                    return new String(byArray, "US-ASCII");
                }
                case 128: {
                    return new String(byArray, "Shift_JIS");
                }
                case 129: {
                    return new String(byArray, "cp949");
                }
                case 130: {
                    return new String(byArray, "x-Johab");
                }
                case 134: {
                    return new String(byArray, "GB2312");
                }
                case 136: {
                    return new String(byArray, "Big5");
                }
                case 161: {
                    return new String(byArray, "windows-1253");
                }
                case 162: {
                    return new String(byArray, "cp1254");
                }
                case 163: {
                    return new String(byArray, "cp1258");
                }
                case 177: {
                    return new String(byArray, "windows-1255");
                }
                case 178: {
                    return new String(byArray, "windows-1256");
                }
                case 204: {
                    return new String(byArray, "windows-1251");
                }
                case 222: {
                    return new String(byArray, "cp874");
                }
                case 238: {
                    return new String(byArray, "cp1250");
                }
                case 255: {
                    return new String(byArray, "cp437");
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new String(byArray);
    }

    public static int getHorizontalAlignment(int n) {
        int n2 = n;
        n2 %= 24;
        if ((n2 %= 8) >= 6) {
            return 6;
        }
        if (n2 >= 2) {
            return 2;
        }
        return 0;
    }

    public static int getVerticalAlignment(int n) {
        int n2 = n;
        if (n2 / 24 != 0) {
            return 24;
        }
        if ((n2 %= 24) / 8 != 0) {
            return 8;
        }
        return 0;
    }
}

