/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.util.gui.resource;

import io.sf.carte.echosvg.util.gui.resource.ActionMap;
import io.sf.carte.echosvg.util.gui.resource.JComponentModifier;
import io.sf.carte.echosvg.util.gui.resource.MissingListenerException;
import io.sf.carte.echosvg.util.resources.ResourceFormatException;
import io.sf.carte.echosvg.util.resources.ResourceManager;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class MenuFactory
extends ResourceManager {
    private static final String TYPE_MENU = "MENU";
    private static final String TYPE_ITEM = "ITEM";
    private static final String TYPE_RADIO = "RADIO";
    private static final String TYPE_CHECK = "CHECK";
    private static final String SEPARATOR = "-";
    private static final String TYPE_SUFFIX = ".type";
    private static final String TEXT_SUFFIX = ".text";
    private static final String MNEMONIC_SUFFIX = ".mnemonic";
    private static final String ACCELERATOR_SUFFIX = ".accelerator";
    private static final String ACTION_SUFFIX = ".action";
    private static final String SELECTED_SUFFIX = ".selected";
    private static final String ENABLED_SUFFIX = ".enabled";
    private static final String ICON_SUFFIX = ".icon";
    private ActionMap actions;
    private ButtonGroup buttonGroup;

    public MenuFactory(ResourceBundle resourceBundle, ActionMap actionMap) {
        super(resourceBundle);
        this.actions = actionMap;
        this.buttonGroup = null;
    }

    public JMenuBar createJMenuBar(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        return this.createJMenuBar(string, null);
    }

    public JMenuBar createJMenuBar(String string, String string2) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenuBar jMenuBar = new JMenuBar();
        List<String> list = this.getSpecializedStringList(string, string2);
        for (String string3 : list) {
            jMenuBar.add(this.createJMenuComponent(string3, string2));
        }
        return jMenuBar;
    }

    protected String getSpecializedString(String string, String string2) {
        String string3;
        try {
            string3 = this.getString(string + '.' + string2);
        }
        catch (MissingResourceException missingResourceException) {
            string3 = this.getString(string);
        }
        return string3;
    }

    protected List<String> getSpecializedStringList(String string, String string2) {
        List list;
        try {
            list = this.getStringList(string + '.' + string2);
        }
        catch (MissingResourceException missingResourceException) {
            list = this.getStringList(string);
        }
        return list;
    }

    protected boolean getSpecializedBoolean(String string, String string2) {
        boolean bl;
        try {
            bl = this.getBoolean(string + '.' + string2);
        }
        catch (MissingResourceException missingResourceException) {
            bl = this.getBoolean(string);
        }
        return bl;
    }

    protected JComponent createJMenuComponent(String string, String string2) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        if (string.equals(SEPARATOR)) {
            this.buttonGroup = null;
            return new JSeparator();
        }
        String string3 = this.getSpecializedString(string + TYPE_SUFFIX, string2);
        JMenuItem jMenuItem = null;
        if (string3.equals(TYPE_RADIO)) {
            if (this.buttonGroup == null) {
                this.buttonGroup = new ButtonGroup();
            }
        } else {
            this.buttonGroup = null;
        }
        if (string3.equals(TYPE_MENU)) {
            jMenuItem = this.createJMenu(string, string2);
        } else if (string3.equals(TYPE_ITEM)) {
            jMenuItem = this.createJMenuItem(string, string2);
        } else if (string3.equals(TYPE_RADIO)) {
            jMenuItem = this.createJRadioButtonMenuItem(string, string2);
            this.buttonGroup.add(jMenuItem);
        } else if (string3.equals(TYPE_CHECK)) {
            jMenuItem = this.createJCheckBoxMenuItem(string, string2);
        } else {
            throw new ResourceFormatException("Malformed resource", this.bundle.getClass().getName(), string + TYPE_SUFFIX);
        }
        return jMenuItem;
    }

    public JMenu createJMenu(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        return this.createJMenu(string, null);
    }

    public JMenu createJMenu(String string, String string2) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenu jMenu = new JMenu(this.getSpecializedString(string + TEXT_SUFFIX, string2));
        this.initializeJMenuItem(jMenu, string, string2);
        List<String> list = this.getSpecializedStringList(string, string2);
        for (String string3 : list) {
            jMenu.add(this.createJMenuComponent(string3, string2));
        }
        return jMenu;
    }

    public JMenuItem createJMenuItem(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        return this.createJMenuItem(string, null);
    }

    public JMenuItem createJMenuItem(String string, String string2) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenuItem jMenuItem = new JMenuItem(this.getSpecializedString(string + TEXT_SUFFIX, string2));
        this.initializeJMenuItem(jMenuItem, string, string2);
        return jMenuItem;
    }

    public JRadioButtonMenuItem createJRadioButtonMenuItem(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        return this.createJRadioButtonMenuItem(string, null);
    }

    public JRadioButtonMenuItem createJRadioButtonMenuItem(String string, String string2) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.getSpecializedString(string + TEXT_SUFFIX, string2));
        this.initializeJMenuItem(jRadioButtonMenuItem, string, string2);
        try {
            jRadioButtonMenuItem.setSelected(this.getSpecializedBoolean(string + SELECTED_SUFFIX, string2));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return jRadioButtonMenuItem;
    }

    public JCheckBoxMenuItem createJCheckBoxMenuItem(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        return this.createJCheckBoxMenuItem(string, null);
    }

    public JCheckBoxMenuItem createJCheckBoxMenuItem(String string, String string2) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.getSpecializedString(string + TEXT_SUFFIX, string2));
        this.initializeJMenuItem(jCheckBoxMenuItem, string, string2);
        try {
            jCheckBoxMenuItem.setSelected(this.getSpecializedBoolean(string + SELECTED_SUFFIX, string2));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return jCheckBoxMenuItem;
    }

    protected void initializeJMenuItem(JMenuItem jMenuItem, String string, String string2) throws ResourceFormatException, MissingListenerException {
        block15: {
            Serializable serializable;
            Object object;
            try {
                object = this.actions.getAction(this.getSpecializedString(string + ACTION_SUFFIX, string2));
                if (object == null) {
                    throw new MissingListenerException("", "Action", string + ACTION_SUFFIX);
                }
                jMenuItem.setAction((Action)object);
                jMenuItem.setText(this.getSpecializedString(string + TEXT_SUFFIX, string2));
                if (object instanceof JComponentModifier) {
                    ((JComponentModifier)object).addJComponent(jMenuItem);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                object = this.getSpecializedString(string + ICON_SUFFIX, string2);
                serializable = this.actions.getClass().getResource((String)object);
                if (serializable != null) {
                    jMenuItem.setIcon(new ImageIcon((URL)serializable));
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                object = this.getSpecializedString(string + MNEMONIC_SUFFIX, string2);
                if (((String)object).length() != 1) {
                    throw new ResourceFormatException("Malformed mnemonic", this.bundle.getClass().getName(), string + MNEMONIC_SUFFIX);
                }
                jMenuItem.setMnemonic(((String)object).charAt(0));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                if (jMenuItem instanceof JMenu) break block15;
                object = this.getSpecializedString(string + ACCELERATOR_SUFFIX, string2);
                serializable = KeyStroke.getKeyStroke((String)object);
                if (serializable != null) {
                    jMenuItem.setAccelerator((KeyStroke)serializable);
                    break block15;
                }
                throw new ResourceFormatException("Malformed accelerator", this.bundle.getClass().getName(), string + ACCELERATOR_SUFFIX);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        try {
            jMenuItem.setEnabled(this.getSpecializedBoolean(string + ENABLED_SUFFIX, string2));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

