/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.util.gui.xmleditor;

import io.sf.carte.echosvg.util.gui.xmleditor.XMLEditorKit;
import java.awt.Color;
import javax.swing.JEditorPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Element;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class XMLTextEditor
extends JEditorPane {
    private static final long serialVersionUID = 1L;
    protected UndoManager undoManager;

    public XMLTextEditor() {
        XMLEditorKit xMLEditorKit = new XMLEditorKit();
        this.setEditorKitForContentType("text/xml", xMLEditorKit);
        this.setContentType("text/xml");
        this.setBackground(Color.white);
        this.undoManager = new UndoManager();
        UndoableEditListener undoableEditListener = new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                XMLTextEditor.this.undoManager.addEdit(undoableEditEvent.getEdit());
            }
        };
        this.getDocument().addUndoableEditListener(undoableEditListener);
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.undoManager.discardAllEdits();
    }

    public void undo() {
        try {
            this.undoManager.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    public void redo() {
        try {
            this.undoManager.redo();
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    public void gotoLine(int n) {
        Element element = this.getDocument().getDefaultRootElement().getElement(n);
        if (element == null) {
            return;
        }
        int n2 = element.getStartOffset();
        this.setCaretPosition(n2);
    }
}

