/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.apps.svgpp;

import io.sf.carte.echosvg.i18n.LocalizableSupport;
import io.sf.carte.echosvg.transcoder.Transcoder;
import io.sf.carte.echosvg.transcoder.TranscoderInput;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.svg2svg.SVGTranscoder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class Main {
    public static final String BUNDLE_CLASSNAME = "io.sf.carte.echosvg.apps.svgpp.resources.Messages";
    protected static LocalizableSupport localizableSupport = new LocalizableSupport("io.sf.carte.echosvg.apps.svgpp.resources.Messages", Main.class.getClassLoader());
    protected String[] arguments;
    protected int index;
    protected Map<String, OptionHandler> handlers = new HashMap<String, OptionHandler>();
    protected Transcoder transcoder;

    public static void main(String[] stringArray) {
        new Main(stringArray).run();
    }

    public Main(String[] stringArray) {
        this.handlers.put("-doctype", new DoctypeHandler());
        this.handlers.put("-doc-width", new DocWidthHandler());
        this.handlers.put("-newline", new NewlineHandler());
        this.handlers.put("-public-id", new PublicIdHandler());
        this.handlers.put("-no-format", new NoFormatHandler());
        this.handlers.put("-system-id", new SystemIdHandler());
        this.handlers.put("-tab-width", new TabWidthHandler());
        this.handlers.put("-xml-decl", new XMLDeclHandler());
        this.transcoder = new SVGTranscoder();
        this.arguments = stringArray;
    }

    public void run() {
        if (this.arguments.length == 0) {
            this.printUsage();
            return;
        }
        try {
            OptionHandler optionHandler;
            while ((optionHandler = this.handlers.get(this.arguments[this.index])) != null) {
                optionHandler.handleOption();
            }
            optionHandler = new TranscoderInput((Reader)new FileReader(this.arguments[this.index++]));
            TranscoderOutput transcoderOutput = this.index < this.arguments.length ? new TranscoderOutput((Writer)new FileWriter(this.arguments[this.index])) : new TranscoderOutput((Writer)new OutputStreamWriter(System.out));
            this.transcoder.transcode((TranscoderInput)optionHandler, transcoderOutput);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printUsage();
        }
    }

    protected void printUsage() {
        this.printHeader();
        System.out.println(localizableSupport.formatMessage("syntax", null));
        System.out.println();
        System.out.println(localizableSupport.formatMessage("options", null));
        for (String string : this.handlers.keySet()) {
            System.out.println(this.handlers.get(string).getDescription());
        }
    }

    protected void printHeader() {
        System.out.println(localizableSupport.formatMessage("header", null));
    }

    protected class DocWidthHandler
    implements OptionHandler {
        protected DocWidthHandler() {
        }

        @Override
        public void handleOption() {
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_DOCUMENT_WIDTH, (Object)Integer.valueOf(Main.this.arguments[Main.this.index++]));
        }

        @Override
        public String getDescription() {
            return localizableSupport.formatMessage("doc-width.description", null);
        }
    }

    protected class DoctypeHandler
    implements OptionHandler {
        protected final Map<String, Object> values = new HashMap<String, Object>(6);

        protected DoctypeHandler() {
            this.values.put("remove", SVGTranscoder.VALUE_DOCTYPE_REMOVE);
            this.values.put("change", SVGTranscoder.VALUE_DOCTYPE_CHANGE);
        }

        @Override
        public void handleOption() {
            Object object;
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            if ((object = this.values.get(Main.this.arguments[Main.this.index++])) == null) {
                throw new IllegalArgumentException();
            }
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_DOCTYPE, object);
        }

        @Override
        public String getDescription() {
            return localizableSupport.formatMessage("doctype.description", null);
        }
    }

    protected class NewlineHandler
    implements OptionHandler {
        protected final Map<String, Object> values = new HashMap<String, Object>(6);

        protected NewlineHandler() {
            this.values.put("cr", SVGTranscoder.VALUE_NEWLINE_CR);
            this.values.put("cr-lf", SVGTranscoder.VALUE_NEWLINE_CR_LF);
            this.values.put("lf", SVGTranscoder.VALUE_NEWLINE_LF);
        }

        @Override
        public void handleOption() {
            Object object;
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            if ((object = this.values.get(Main.this.arguments[Main.this.index++])) == null) {
                throw new IllegalArgumentException();
            }
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_NEWLINE, object);
        }

        @Override
        public String getDescription() {
            return localizableSupport.formatMessage("newline.description", null);
        }
    }

    protected class NoFormatHandler
    implements OptionHandler {
        protected NoFormatHandler() {
        }

        @Override
        public void handleOption() {
            ++Main.this.index;
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_FORMAT, (Object)Boolean.FALSE);
        }

        @Override
        public String getDescription() {
            return localizableSupport.formatMessage("no-format.description", null);
        }
    }

    protected static interface OptionHandler {
        public void handleOption();

        public String getDescription();
    }

    protected class PublicIdHandler
    implements OptionHandler {
        protected PublicIdHandler() {
        }

        @Override
        public void handleOption() {
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            String string = Main.this.arguments[Main.this.index++];
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_PUBLIC_ID, (Object)string);
        }

        @Override
        public String getDescription() {
            return localizableSupport.formatMessage("public-id.description", null);
        }
    }

    protected class SystemIdHandler
    implements OptionHandler {
        protected SystemIdHandler() {
        }

        @Override
        public void handleOption() {
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            String string = Main.this.arguments[Main.this.index++];
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_SYSTEM_ID, (Object)string);
        }

        @Override
        public String getDescription() {
            return localizableSupport.formatMessage("system-id.description", null);
        }
    }

    protected class TabWidthHandler
    implements OptionHandler {
        protected TabWidthHandler() {
        }

        @Override
        public void handleOption() {
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_TABULATION_WIDTH, (Object)Integer.valueOf(Main.this.arguments[Main.this.index++]));
        }

        @Override
        public String getDescription() {
            return localizableSupport.formatMessage("tab-width.description", null);
        }
    }

    protected class XMLDeclHandler
    implements OptionHandler {
        protected XMLDeclHandler() {
        }

        @Override
        public void handleOption() {
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            String string = Main.this.arguments[Main.this.index++];
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_XML_DECLARATION, (Object)string);
        }

        @Override
        public String getDescription() {
            return localizableSupport.formatMessage("xml-decl.description", null);
        }
    }
}

