/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.value.Messages;
import io.sf.carte.echosvg.util.ParsedURL;
import org.w3c.dom.DOMException;

public abstract class AbstractValueFactory {
    public abstract String getPropertyName();

    protected static String resolveURI(ParsedURL parsedURL, String string) {
        return new ParsedURL(parsedURL, string).toString();
    }

    protected DOMException createInvalidIdentifierDOMException(String string) {
        Object[] objectArray = new Object[]{this.getPropertyName(), string};
        String string2 = Messages.formatMessage("invalid.identifier", objectArray);
        return new DOMException(12, string2);
    }

    protected DOMException createInvalidLexicalUnitDOMException(LexicalUnit.LexicalType lexicalType) {
        Object[] objectArray = new Object[]{this.getPropertyName(), lexicalType.toString()};
        String string = Messages.formatMessage("invalid.lexical.unit", objectArray);
        return new DOMException(9, string);
    }

    protected DOMException createInvalidFloatTypeDOMException(short s) {
        Object[] objectArray = new Object[]{this.getPropertyName(), (int)s};
        String string = Messages.formatMessage("invalid.float.type", objectArray);
        return new DOMException(15, string);
    }

    protected DOMException createInvalidFloatValueDOMException(float f) {
        Object[] objectArray = new Object[]{this.getPropertyName(), Float.valueOf(f)};
        String string = Messages.formatMessage("invalid.float.value", objectArray);
        return new DOMException(15, string);
    }

    protected DOMException createInvalidStringTypeDOMException(short s) {
        Object[] objectArray = new Object[]{this.getPropertyName(), (int)s};
        String string = Messages.formatMessage("invalid.string.type", objectArray);
        return new DOMException(15, string);
    }

    protected DOMException createMalformedLexicalUnitDOMException() {
        Object[] objectArray = new Object[]{this.getPropertyName()};
        String string = Messages.formatMessage("malformed.lexical.unit", objectArray);
        return new DOMException(15, string);
    }

    protected DOMException createDOMException() {
        Object[] objectArray = new Object[]{this.getPropertyName()};
        String string = Messages.formatMessage("invalid.access", objectArray);
        return new DOMException(9, string);
    }
}

