/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSContext;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import org.w3c.dom.DOMException;

public abstract class LengthManager
extends AbstractValueManager {
    static final double SQRT2 = Math.sqrt(2.0);
    protected static final int HORIZONTAL_ORIENTATION = 0;
    protected static final int VERTICAL_ORIENTATION = 1;
    protected static final int BOTH_ORIENTATION = 2;

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case DIMENSION: {
                Value value = LengthManager.createLength(lexicalUnit);
                if (value == null) break;
                return value;
            }
            case INTEGER: {
                return new FloatValue(1, lexicalUnit.getIntegerValue());
            }
            case REAL: {
                return new FloatValue(1, lexicalUnit.getFloatValue());
            }
            case PERCENTAGE: {
                return new FloatValue(2, lexicalUnit.getFloatValue());
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    static Value createLength(LexicalUnit lexicalUnit) {
        if (CSSUnit.isLengthUnitType((short)lexicalUnit.getCssUnit())) {
            short s;
            switch (lexicalUnit.getCssUnit()) {
                case 3: {
                    s = 5;
                    break;
                }
                case 4: {
                    s = 8;
                    break;
                }
                case 5: {
                    s = 10;
                    break;
                }
                case 6: {
                    s = 9;
                    break;
                }
                case 7: {
                    s = 6;
                    break;
                }
                case 8: {
                    s = 7;
                    break;
                }
                case 20: {
                    s = 3;
                    break;
                }
                case 21: {
                    s = 4;
                    break;
                }
                default: {
                    return null;
                }
            }
            return new FloatValue(s, lexicalUnit.getFloatValue());
        }
        return null;
    }

    @Override
    public Value createFloatValue(short s, float f) throws DOMException {
        switch (s) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return new FloatValue(s, f);
            }
        }
        throw this.createInvalidFloatTypeDOMException(s);
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value.getCssValueType() != 1) {
            return value;
        }
        switch (value.getPrimitiveType()) {
            case 1: 
            case 5: {
                return value;
            }
            case 7: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f = value.getFloatValue();
                return new FloatValue(1, f / cSSContext.getPixelUnitToMillimeter());
            }
            case 6: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f = value.getFloatValue();
                return new FloatValue(1, f * 10.0f / cSSContext.getPixelUnitToMillimeter());
            }
            case 8: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f = value.getFloatValue();
                return new FloatValue(1, f * 25.4f / cSSContext.getPixelUnitToMillimeter());
            }
            case 9: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f = value.getFloatValue();
                return new FloatValue(1, f * 25.4f / (72.0f * cSSContext.getPixelUnitToMillimeter()));
            }
            case 10: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f = value.getFloatValue();
                return new FloatValue(1, f * 25.4f / (6.0f * cSSContext.getPixelUnitToMillimeter()));
            }
            case 3: {
                styleMap.putFontSizeRelative(n, true);
                float f = value.getFloatValue();
                int n2 = cSSEngine.getFontSizeIndex();
                float f2 = cSSEngine.getComputedStyle(cSSStylableElement, string, n2).getFloatValue();
                return new FloatValue(1, f * f2);
            }
            case 4: {
                styleMap.putFontSizeRelative(n, true);
                float f = value.getFloatValue();
                int n3 = cSSEngine.getFontSizeIndex();
                float f3 = cSSEngine.getComputedStyle(cSSStylableElement, string, n3).getFloatValue();
                return new FloatValue(1, f * f3 * 0.5f);
            }
            case 2: {
                float f;
                CSSContext cSSContext = cSSEngine.getCSSContext();
                switch (this.getOrientation()) {
                    case 0: {
                        styleMap.putBlockWidthRelative(n, true);
                        f = value.getFloatValue() * cSSContext.getBlockWidth(cSSStylableElement) / 100.0f;
                        break;
                    }
                    case 1: {
                        styleMap.putBlockHeightRelative(n, true);
                        f = value.getFloatValue() * cSSContext.getBlockHeight(cSSStylableElement) / 100.0f;
                        break;
                    }
                    default: {
                        styleMap.putBlockWidthRelative(n, true);
                        styleMap.putBlockHeightRelative(n, true);
                        double d = cSSContext.getBlockWidth(cSSStylableElement);
                        double d2 = cSSContext.getBlockHeight(cSSStylableElement);
                        f = (float)((double)value.getFloatValue() * (Math.sqrt(d * d + d2 * d2) / SQRT2) / 100.0);
                    }
                }
                return new FloatValue(1, f);
            }
        }
        return value;
    }

    protected abstract int getOrientation();
}

